/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dexing;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dexing.DexWorkAction;
import com.android.build.gradle.internal.dexing.DexWorkActionKt;
import com.android.build.gradle.internal.dexing.DexWorkActionParams;
import com.android.build.gradle.internal.dexing.IncrementalDexSpec;
import com.android.build.gradle.internal.tasks.DexArchiveBuilderTaskDelegate;
import com.android.builder.dexing.ClassBucket;
import com.android.builder.dexing.DependencyGraphUpdater;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.builder.dexing.DexParameters;
import com.android.builder.dexing.MutableDependencyGraph;
import com.android.builder.dexing.r8.ClassFileProviderFactory;
import com.android.ide.common.blame.MessageReceiver;
import com.android.utils.FileUtils;
import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001aT\u0010\n\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0015H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\u001a\u001a\u00020\u000f\u001a\u001c\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019\"\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"launchProcessing", "", "dexWorkActionParams", "Lcom/android/build/gradle/internal/dexing/DexWorkActionParams;", "receiver", "Lcom/android/ide/common/blame/MessageReceiver;", "processIncrementally", "dexArchiveBuilder", "Lcom/android/builder/dexing/DexArchiveBuilder;", "processNonIncrementally", "process", "inputClassFiles", "Lcom/android/builder/dexing/ClassBucket;", "inputFilter", "Lkotlin/Function2;", "Ljava/io/File;", "", "", "dexOutputPath", "globalSyntheticsOutput", "desugarGraphUpdater", "Lcom/android/builder/dexing/DependencyGraphUpdater;", "getDexArchiveBuilder", "messageReceiver", "readDesugarGraph", "Lcom/android/builder/dexing/MutableDependencyGraph;", "desugarGraphFile", "writeDesugarGraph", "desugarGraph", "loggerWrapper", "Lcom/android/build/gradle/internal/LoggerWrapper;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nDexWorkAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DexWorkAction.kt\ncom/android/build/gradle/internal/dexing/DexWorkActionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1869#2,2:235\n1869#2,2:237\n*S KotlinDebug\n*F\n+ 1 DexWorkAction.kt\ncom/android/build/gradle/internal/dexing/DexWorkActionKt\n*L\n106#1:235,2\n174#1:237,2\n*E\n"})
public final class DexWorkActionKt {
    @NotNull
    private static final LoggerWrapper loggerWrapper;

    public static final void launchProcessing(@NotNull DexWorkActionParams dexWorkActionParams, @NotNull MessageReceiver receiver2) {
        Intrinsics.checkNotNullParameter((Object)dexWorkActionParams, (String)"dexWorkActionParams");
        Intrinsics.checkNotNullParameter((Object)receiver2, (String)"receiver");
        DexArchiveBuilder dexArchiveBuilder = DexWorkActionKt.getDexArchiveBuilder(dexWorkActionParams, receiver2);
        if (((IncrementalDexSpec)dexWorkActionParams.getDexSpec().get()).isIncremental()) {
            DexWorkActionKt.processIncrementally(dexArchiveBuilder, dexWorkActionParams);
        } else {
            DexWorkActionKt.processNonIncrementally(dexArchiveBuilder, dexWorkActionParams);
        }
    }

    private static final void processIncrementally(DexArchiveBuilder dexArchiveBuilder, DexWorkActionParams dexWorkActionParams) {
        block7: {
            MutableDependencyGraph<File> desugarGraph;
            Object object;
            MutableDependencyGraph<File> mutableDependencyGraph;
            IncrementalDexSpec $this$processIncrementally_u24lambda_u244 = (IncrementalDexSpec)dexWorkActionParams.getDexSpec().get();
            boolean bl = false;
            File file = $this$processIncrementally_u24lambda_u244.getDesugarGraphFile();
            if (file != null) {
                MutableDependencyGraph<File> mutableDependencyGraph2;
                File it = file;
                boolean bl2 = false;
                try {
                    mutableDependencyGraph2 = DexWorkActionKt.readDesugarGraph($this$processIncrementally_u24lambda_u244.getDesugarGraphFile());
                }
                catch (Exception e) {
                    loggerWrapper.warning("Failed to read desugaring graph. Cause: " + e.getClass().getSimpleName() + ", message: " + e.getMessage() + ".\nFall back to non-incremental mode.", new Object[0]);
                    DexWorkActionKt.processNonIncrementally(dexArchiveBuilder, dexWorkActionParams);
                    return;
                }
                mutableDependencyGraph = mutableDependencyGraph2;
            } else {
                mutableDependencyGraph = null;
            }
            if ((object = (desugarGraph = mutableDependencyGraph)) == null || (object = object.getAllDependents((Collection)$this$processIncrementally_u24lambda_u244.getChangedFiles())) == null) {
                object = SetsKt.emptySet();
            }
            MutableDependencyGraph<File> unchangedButImpactedFiles = object;
            Set changedOrImpactedFiles = SetsKt.plus($this$processIncrementally_u24lambda_u244.getChangedFiles(), (Iterable)((Iterable)unchangedButImpactedFiles));
            MutableDependencyGraph<File> mutableDependencyGraph3 = desugarGraph;
            if (mutableDependencyGraph3 != null) {
                MutableDependencyGraph<File> graph = mutableDependencyGraph3;
                boolean bl3 = false;
                Iterable $this$forEach$iv = changedOrImpactedFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl4 = false;
                    graph.removeNode((Object)it);
                }
            }
            Function2 filter2 = (Function2)new Function2<File, String, Boolean>((Set<? extends File>)changedOrImpactedFiles){
                final /* synthetic */ Set<File> $changedOrImpactedFiles;
                {
                    this.$changedOrImpactedFiles = $changedOrImpactedFiles;
                    super(2);
                }

                public final Boolean invoke(File rootPath, String relativePath) {
                    Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
                    Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                    return this.$changedOrImpactedFiles.contains(rootPath) || this.$changedOrImpactedFiles.contains(FilesKt.resolve((File)rootPath, (String)relativePath));
                }
            };
            DexWorkActionKt.process(dexArchiveBuilder, $this$processIncrementally_u24lambda_u244.getInputClassFiles(), (Function2<? super File, ? super String, Boolean>)filter2, $this$processIncrementally_u24lambda_u244.getDexOutputPath(), $this$processIncrementally_u24lambda_u244.getGlobalSyntheticsOutput(), (DependencyGraphUpdater<File>)((DependencyGraphUpdater)desugarGraph));
            File file2 = $this$processIncrementally_u24lambda_u244.getDesugarGraphFile();
            if (file2 == null) break block7;
            File it = file2;
            boolean bl5 = false;
            MutableDependencyGraph<File> mutableDependencyGraph4 = desugarGraph;
            Intrinsics.checkNotNull(mutableDependencyGraph4);
            DexWorkActionKt.writeDesugarGraph(it, mutableDependencyGraph4);
        }
    }

    private static final void processNonIncrementally(DexArchiveBuilder dexArchiveBuilder, DexWorkActionParams dexWorkActionParams) {
        block2: {
            MutableDependencyGraph mutableDependencyGraph;
            File it;
            IncrementalDexSpec $this$processNonIncrementally_u24lambda_u247 = (IncrementalDexSpec)dexWorkActionParams.getDexSpec().get();
            boolean bl = false;
            File file = $this$processNonIncrementally_u24lambda_u247.getDesugarGraphFile();
            if (file != null) {
                it = file;
                boolean bl2 = false;
                mutableDependencyGraph = new MutableDependencyGraph();
            } else {
                mutableDependencyGraph = null;
            }
            MutableDependencyGraph desugarGraph = mutableDependencyGraph;
            DexWorkActionKt.process(dexArchiveBuilder, $this$processNonIncrementally_u24lambda_u247.getInputClassFiles(), (Function2<? super File, ? super String, Boolean>)((Function2)processNonIncrementally.1.1.INSTANCE), $this$processNonIncrementally_u24lambda_u247.getDexOutputPath(), $this$processNonIncrementally_u24lambda_u247.getGlobalSyntheticsOutput(), (DependencyGraphUpdater<File>)((DependencyGraphUpdater)desugarGraph));
            File file2 = $this$processNonIncrementally_u24lambda_u247.getDesugarGraphFile();
            if (file2 == null) break block2;
            it = file2;
            boolean bl3 = false;
            FileUtils.mkdirs((File)it.getParentFile());
            MutableDependencyGraph mutableDependencyGraph2 = desugarGraph;
            Intrinsics.checkNotNull((Object)mutableDependencyGraph2);
            DexWorkActionKt.writeDesugarGraph(it, (MutableDependencyGraph<File>)mutableDependencyGraph2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void process(DexArchiveBuilder dexArchiveBuilder, ClassBucket inputClassFiles, Function2<? super File, ? super String, Boolean> inputFilter2, File dexOutputPath, File globalSyntheticsOutput, DependencyGraphUpdater<File> desugarGraphUpdater) {
        List inputRoots = inputClassFiles.getBucketGroup().getRoots();
        Object $this$forEach$iv = inputRoots;
        boolean $i$f$forEach = false;
        Unit unit = $this$forEach$iv.iterator();
        while (unit.hasNext()) {
            Object element$iv = unit.next();
            File it = (File)element$iv;
            boolean bl = false;
            loggerWrapper.verbose("Dexing '" + it.getPath() + "' to '" + dexOutputPath.getPath() + "'", new Object[0]);
        }
        try {
            $this$forEach$iv = (Closeable)Closer.create();
            Throwable throwable = null;
            try {
                Closer closer = (Closer)$this$forEach$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)closer);
                AutoCloseable autoCloseable = inputClassFiles.getClassFiles(inputFilter2, closer);
                Throwable throwable2 = null;
                try {
                    Stream it = (Stream)autoCloseable;
                    boolean bl2 = false;
                    Path path = dexOutputPath.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                    File file = globalSyntheticsOutput;
                    dexArchiveBuilder.convert(it, path, file != null ? file.toPath() : null, desugarGraphUpdater);
                    Unit unit2 = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$forEach$iv, (Throwable)throwable);
            }
        }
        catch (DexArchiveBuilderException ex) {
            throw new DexArchiveBuilderException("Failed to process: " + CollectionsKt.joinToString$default((Iterable)inputRoots, (CharSequence)", ", null, null, (int)0, null, (Function1)process.3.INSTANCE, (int)30, null), (Throwable)ex);
        }
    }

    private static final DexArchiveBuilder getDexArchiveBuilder(DexWorkActionParams dexWorkActionParams, MessageReceiver messageReceiver) {
        DexArchiveBuilder dexArchiveBuilder = null;
        DexWorkActionParams $this$getDexArchiveBuilder_u24lambda_u2411 = dexWorkActionParams;
        boolean bl = false;
        IncrementalDexSpec dexSpec = (IncrementalDexSpec)$this$getDexArchiveBuilder_u24lambda_u2411.getDexSpec().get();
        dexArchiveBuilder = DexArchiveBuilder.Companion.createD8DexBuilder(new DexParameters(dexSpec.getDexParams().getMinSdkVersion(), dexSpec.getDexParams().getDebuggable(), dexSpec.getDexParams().getDexPerClass(), dexSpec.getDexParams().getWithDesugaring(), (ClassFileProviderFactory)DexArchiveBuilderTaskDelegate.Companion.getSharedState$gradle_core().getService(dexSpec.getDexParams().getDesugarBootclasspath()).getService(), (ClassFileProviderFactory)DexArchiveBuilderTaskDelegate.Companion.getSharedState$gradle_core().getService(dexSpec.getDexParams().getDesugarClasspath()).getService(), dexSpec.getDexParams().getCoreLibDesugarConfig(), dexSpec.getDexParams().getEnableApiModeling(), messageReceiver));
        return dexArchiveBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final MutableDependencyGraph<File> readDesugarGraph(@NotNull File desugarGraphFile) {
        MutableDependencyGraph mutableDependencyGraph;
        Intrinsics.checkNotNullParameter((Object)desugarGraphFile, (String)"desugarGraphFile");
        Closeable closeable = new FileInputStream(desugarGraphFile);
        int n = 8192;
        closeable = new ObjectInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
        Throwable throwable = null;
        try {
            ObjectInputStream it = (ObjectInputStream)closeable;
            boolean bl = false;
            Object object = it.readObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.builder.dexing.MutableDependencyGraph<java.io.File>");
            mutableDependencyGraph = (MutableDependencyGraph)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return mutableDependencyGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeDesugarGraph(@NotNull File desugarGraphFile, @NotNull MutableDependencyGraph<File> desugarGraph) {
        Intrinsics.checkNotNullParameter((Object)desugarGraphFile, (String)"desugarGraphFile");
        Intrinsics.checkNotNullParameter(desugarGraph, (String)"desugarGraph");
        Closeable closeable = new FileOutputStream(desugarGraphFile);
        int n = 8192;
        closeable = new ObjectOutputStream(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n));
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl = false;
            it.writeObject(desugarGraph);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(DexWorkAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(...)");
        DexWorkActionKt.loggerWrapper = loggerWrapper;
    }
}

