/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.instrumentation;

import com.android.build.gradle.internal.instrumentation.ClassesDataSourceCache;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000eJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/instrumentation/ClassesDataCache;", "Ljava/io/Closeable;", "<init>", "()V", "sourcesCacheMap", "", "", "Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache;", "getSourceFileKey", "file", "Ljava/io/File;", "getSourceCaches", "", "sources", "", "Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache$SourceType;", "close", "", "JarCache", "DirCache", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nClassesDataCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassesDataCache.kt\ncom/android/build/gradle/internal/instrumentation/ClassesDataCache\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n536#2:103\n521#2,6:104\n126#3:110\n153#3,3:111\n1869#4,2:114\n*S KotlinDebug\n*F\n+ 1 ClassesDataCache.kt\ncom/android/build/gradle/internal/instrumentation/ClassesDataCache\n*L\n41#1:103\n41#1:104,6\n43#1:110\n43#1:111,3\n57#1:114,2\n*E\n"})
public final class ClassesDataCache
implements Closeable {
    @NotNull
    private final Map<Object, ClassesDataSourceCache> sourcesCacheMap = new LinkedHashMap();

    private final Object getSourceFileKey(File file) {
        Object object = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).fileKey();
        if (object == null) {
            String string = file.getCanonicalPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<ClassesDataSourceCache> getSourceCaches(@NotNull Map<File, ? extends ClassesDataSourceCache.SourceType> sources2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(sources2, (String)"sources");
        Map<File, ? extends ClassesDataSourceCache.SourceType> $this$filter$iv = sources2;
        boolean $i$f$filter = false;
        Map<File, ? extends ClassesDataSourceCache.SourceType> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!((File)it.getKey()).exists()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map requested = destination$iv$iv;
        ClassesDataCache classesDataCache = this;
        synchronized (classesDataCache) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Map $this$map$iv = requested;
            boolean $i$f$map = false;
            Map $i$f$filterTo2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator3.next();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                File sourceFile = (File)entry2.getKey();
                ClassesDataSourceCache.SourceType sourceType = (ClassesDataSourceCache.SourceType)((Object)entry2.getValue());
                Object key = this.getSourceFileKey(sourceFile);
                collection.add(this.sourcesCacheMap.computeIfAbsent(key, new Function(sourceFile, sourceType){
                    final /* synthetic */ File $sourceFile;
                    final /* synthetic */ ClassesDataSourceCache.SourceType $sourceType;
                    {
                        this.$sourceFile = $sourceFile;
                        this.$sourceType = $sourceType;
                    }

                    public final ClassesDataSourceCache apply(Object it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        String string = this.$sourceFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        return StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null) ? (ClassesDataSourceCache)new JarCache(this.$sourceFile, this.$sourceType) : (ClassesDataSourceCache)new DirCache(this.$sourceFile, this.$sourceType);
                    }
                }));
            }
            List list = (List)destination$iv$iv2;
            return list;
        }
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = this.sourcesCacheMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassesDataSourceCache p0 = (ClassesDataSourceCache)element$iv;
            boolean bl = false;
            p0.close();
        }
        this.sourcesCacheMap.clear();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/instrumentation/ClassesDataCache$DirCache;", "Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache;", "dir", "Ljava/io/File;", "sourceType", "Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache$SourceType;", "<init>", "(Ljava/io/File;Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache$SourceType;)V", "maybeLoadClassData", "Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache$ClassData;", "className", "", "gradle-core"})
    private static final class DirCache
    extends ClassesDataSourceCache {
        @NotNull
        private final File dir;

        public DirCache(@NotNull File dir, @NotNull ClassesDataSourceCache.SourceType sourceType) {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
            super(sourceType);
            this.dir = dir;
        }

        @Override
        @Nullable
        public synchronized ClassesDataSourceCache.ClassData maybeLoadClassData(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            String classFileName = className + ".class";
            File classFile = FilesKt.resolve((File)this.dir, (String)classFileName);
            if (classFile.exists()) {
                InputStream inputStream = new FileInputStream(classFile);
                int n = 8192;
                return this.loadClassData(className, inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n));
            }
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/instrumentation/ClassesDataCache$JarCache;", "Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache;", "file", "Ljava/io/File;", "sourceType", "Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache$SourceType;", "<init>", "(Ljava/io/File;Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache$SourceType;)V", "jarFile", "Ljava/util/jar/JarFile;", "close", "", "maybeLoadClassData", "Lcom/android/build/gradle/internal/instrumentation/ClassesDataSourceCache$ClassData;", "className", "", "gradle-core"})
    private static final class JarCache
    extends ClassesDataSourceCache {
        @NotNull
        private final JarFile jarFile;

        public JarCache(@NotNull File file, @NotNull ClassesDataSourceCache.SourceType sourceType) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
            super(sourceType);
            this.jarFile = new JarFile(file);
        }

        @Override
        public void close() {
            super.close();
            this.jarFile.close();
        }

        @Override
        @Nullable
        public synchronized ClassesDataSourceCache.ClassData maybeLoadClassData(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            String classFileName = className + ".class";
            ZipEntry zipEntry = this.jarFile.getEntry(classFileName);
            if (zipEntry != null) {
                ZipEntry entry2 = zipEntry;
                boolean bl = false;
                InputStream inputStream = this.jarFile.getInputStream(entry2);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                InputStream inputStream2 = inputStream;
                int n = 8192;
                return this.loadClassData(className, inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n));
            }
            return null;
        }
    }
}

