/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.manifest;

import com.android.build.gradle.internal.manifest.ManifestData;
import com.android.builder.errors.IssueReporter;
import com.android.utils.XmlUtils;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0003H\u0002\"\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"parseManifest", "Lcom/android/build/gradle/internal/manifest/ManifestData;", "manifestFileContent", "", "manifestFilePath", "manifestFileRequired", "", "manifestParsingAllowedProvider", "Lorg/gradle/api/provider/Provider;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "PARSER_FACTORY", "Ljavax/xml/parsers/SAXParserFactory;", "kotlin.jvm.PlatformType", "toAndroidTarget", "Lcom/android/build/gradle/internal/manifest/ManifestData$AndroidTarget;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nManifestData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManifestData.kt\ncom/android/build/gradle/internal/manifest/ManifestDataKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,354:1\n11228#2:355\n11563#2,3:356\n774#3:359\n865#3,2:360\n*S KotlinDebug\n*F\n+ 1 ManifestData.kt\ncom/android/build/gradle/internal/manifest/ManifestDataKt\n*L\n196#1:355\n196#1:356,3\n196#1:359\n196#1:360,2\n*E\n"})
public final class ManifestDataKt {
    private static final SAXParserFactory PARSER_FACTORY;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ManifestData parseManifest(@NotNull String manifestFileContent, @NotNull String manifestFilePath, boolean manifestFileRequired, @Nullable Provider<Boolean> manifestParsingAllowedProvider, @NotNull IssueReporter issueReporter2) {
        boolean manifestParsingAllowed;
        Intrinsics.checkNotNullParameter((Object)manifestFileContent, (String)"manifestFileContent");
        Intrinsics.checkNotNullParameter((Object)manifestFilePath, (String)"manifestFilePath");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Object object = manifestParsingAllowedProvider;
        boolean bl = object != null && (object = (Boolean)object.get()) != null ? (Boolean)object : (manifestParsingAllowed = true);
        if (!manifestParsingAllowed) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapTo$iv$iv;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            Object $this$map$iv = stackTraceElementArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.toString());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(!StringsKt.startsWith$default((String)it, (String)"com.android.build.gradle.internal.manifest.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it, (String)"org.gradle.", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List stackTrace = ((List)destination$iv$iv).subList(1, 10);
            String stackTraceString = CollectionsKt.joinToString$default((Iterable)stackTrace, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.MANIFEST_PARSED_DURING_CONFIGURATION, (String)("The manifest is being parsed during configuration. Please either remove android.disableConfigurationManifestParsing from build.gradle or remove any build configuration rules that read the android manifest file.\n" + stackTraceString), null, null, (int)12, null);
        }
        ManifestData data = new ManifestData(null, null, null, null, null, null, null, null, null, null, null, null, null, 8191, null);
        if (((CharSequence)manifestFileContent).length() == 0) {
            if (manifestFileRequired) {
                IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.MISSING_ANDROID_MANIFEST, (String)("Manifest file does not exist: " + manifestFilePath), null, null, (int)12, null);
                data.setPackageName("fake.package.name.for.sync");
            }
            return data;
        }
        DefaultHandler handler2 = new DefaultHandler(data){
            final /* synthetic */ ManifestData $data;
            {
                this.$data = $data;
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes2) throws SAXException {
                Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
                Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
                Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
                CharSequence charSequence = uri;
                if (charSequence == null || charSequence.length() == 0) {
                    if (Intrinsics.areEqual((Object)"manifest", (Object)localName)) {
                        this.$data.setSplit(attributes2.getValue("", "split"));
                        this.$data.setPackageName(attributes2.getValue("", "package"));
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "versionCode");
                        this.$data.setVersionCode(charSequence != null ? Integer.valueOf(Integer.parseInt((String)charSequence)) : null);
                        this.$data.setVersionName(attributes2.getValue("http://schemas.android.com/apk/res/android", "versionName"));
                    } else if (Intrinsics.areEqual((Object)"instrumentation", (Object)localName)) {
                        this.$data.setTestLabel(attributes2.getValue("http://schemas.android.com/apk/res/android", "label"));
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "functionalTest");
                        this.$data.setFunctionalTest(charSequence != null ? Boolean.valueOf(Boolean.parseBoolean((String)charSequence)) : null);
                        this.$data.setInstrumentationRunner(attributes2.getValue("http://schemas.android.com/apk/res/android", "name"));
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "handleProfiling");
                        this.$data.setHandleProfiling(charSequence != null ? Boolean.valueOf(Boolean.parseBoolean((String)charSequence)) : null);
                    } else if (Intrinsics.areEqual((Object)"uses-sdk", (Object)localName)) {
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "minSdkVersion");
                        this.$data.setMinSdkVersion(charSequence != null ? ManifestDataKt.access$toAndroidTarget((String)charSequence) : null);
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "targetSdkVersion");
                        this.$data.setTargetSdkVersion(charSequence != null ? ManifestDataKt.access$toAndroidTarget((String)charSequence) : null);
                    } else if (Intrinsics.areEqual((Object)"application", (Object)localName)) {
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "extractNativeLibs");
                        this.$data.setExtractNativeLibs(charSequence != null ? Boolean.valueOf(Boolean.parseBoolean((String)charSequence)) : null);
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "useEmbeddedDex");
                        this.$data.setUseEmbeddedDex(charSequence != null ? Boolean.valueOf(Boolean.parseBoolean((String)charSequence)) : null);
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "isolatedSplits");
                        this.$data.setIsolatedSplits(charSequence != null ? Boolean.valueOf(Boolean.parseBoolean((String)charSequence)) : null);
                    }
                }
            }
        };
        try {
            SAXParser saxParser = XmlUtils.createSaxParser((SAXParserFactory)PARSER_FACTORY);
            saxParser.parse(new InputSource(new StringReader(manifestFileContent)), handler2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    public static /* synthetic */ ManifestData parseManifest$default(String string, String string2, boolean bl, Provider provider2, IssueReporter issueReporter2, int n, Object object) {
        if ((n & 8) != 0) {
            provider2 = null;
        }
        return ManifestDataKt.parseManifest(string, string2, bl, (Provider<Boolean>)provider2, issueReporter2);
    }

    private static final ManifestData.AndroidTarget toAndroidTarget(String $this$toAndroidTarget) {
        ManifestData.AndroidTarget androidTarget;
        try {
            Integer apiLevel = Integer.valueOf($this$toAndroidTarget);
            androidTarget = new ManifestData.AndroidTarget(apiLevel, null);
        }
        catch (NumberFormatException ignored) {
            androidTarget = new ManifestData.AndroidTarget(null, $this$toAndroidTarget);
        }
        return androidTarget;
    }

    public static final /* synthetic */ ManifestData.AndroidTarget access$toAndroidTarget(String $receiver) {
        return ManifestDataKt.toAndroidTarget($receiver);
    }

    static {
        SAXParserFactory sAXParserFactory;
        SAXParserFactory it = sAXParserFactory = SAXParserFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", null);
        boolean bl = false;
        XmlUtils.configureSaxFactory((SAXParserFactory)it, (boolean)true, (boolean)false);
        PARSER_FACTORY = sAXParserFactory;
    }
}

