/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.services;

import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.internal.services.BuiltInKotlinServices;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.utils.GradleEnvironmentProvider;
import com.android.build.gradle.internal.utils.GradleEnvironmentProviderImpl;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.errors.IssueReporter;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.services.BuildServiceRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J7\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\r\"\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lcom/android/build/gradle/internal/services/BaseServicesImpl;", "Lcom/android/build/gradle/internal/services/BaseServices;", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "<init>", "(Lcom/android/build/gradle/internal/services/ProjectServices;)V", "getProjectServices", "()Lcom/android/build/gradle/internal/services/ProjectServices;", "newInstance", "T", "type", "Ljava/lang/Class;", "args", "", "", "(Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/Object;", "file", "Ljava/io/File;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "getIssueReporter", "()Lcom/android/builder/errors/IssueReporter;", "deprecationReporter", "Lcom/android/build/gradle/internal/errors/DeprecationReporter;", "getDeprecationReporter", "()Lcom/android/build/gradle/internal/errors/DeprecationReporter;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "getProjectOptions", "()Lcom/android/build/gradle/options/ProjectOptions;", "buildServiceRegistry", "Lorg/gradle/api/services/BuildServiceRegistry;", "getBuildServiceRegistry", "()Lorg/gradle/api/services/BuildServiceRegistry;", "gradleEnvironmentProvider", "Lcom/android/build/gradle/internal/utils/GradleEnvironmentProvider;", "getGradleEnvironmentProvider", "()Lcom/android/build/gradle/internal/utils/GradleEnvironmentProvider;", "projectInfo", "Lcom/android/build/gradle/internal/scope/ProjectInfo;", "getProjectInfo", "()Lcom/android/build/gradle/internal/scope/ProjectInfo;", "builtInKotlinServices", "Lcom/android/build/gradle/internal/services/BuiltInKotlinServices;", "getBuiltInKotlinServices", "()Lcom/android/build/gradle/internal/services/BuiltInKotlinServices;", "gradle-core"})
public class BaseServicesImpl
implements BaseServices {
    @NotNull
    private final ProjectServices projectServices;
    @NotNull
    private final GradleEnvironmentProvider gradleEnvironmentProvider;

    public BaseServicesImpl(@NotNull ProjectServices projectServices2) {
        Intrinsics.checkNotNullParameter((Object)projectServices2, (String)"projectServices");
        this.projectServices = projectServices2;
        this.gradleEnvironmentProvider = new GradleEnvironmentProviderImpl(this.projectServices.getProviderFactory());
    }

    @NotNull
    protected final ProjectServices getProjectServices() {
        return this.projectServices;
    }

    @Override
    public final <T> T newInstance(@NotNull Class<T> type, Object ... args) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return (T)this.projectServices.getObjectFactory().newInstance(type, Arrays.copyOf(args, args.length));
    }

    @Override
    @NotNull
    public final File file(@NotNull Object file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (File)this.projectServices.getFileResolver().invoke(file);
    }

    @Override
    @NotNull
    public final IssueReporter getIssueReporter() {
        return this.projectServices.getIssueReporter();
    }

    @Override
    @NotNull
    public final DeprecationReporter getDeprecationReporter() {
        return this.projectServices.getDeprecationReporter();
    }

    @Override
    @NotNull
    public final ProjectOptions getProjectOptions() {
        return this.projectServices.getProjectOptions();
    }

    @Override
    @NotNull
    public final BuildServiceRegistry getBuildServiceRegistry() {
        return this.projectServices.getBuildServiceRegistry();
    }

    @Override
    @NotNull
    public final GradleEnvironmentProvider getGradleEnvironmentProvider() {
        return this.gradleEnvironmentProvider;
    }

    @Override
    @NotNull
    public final ProjectInfo getProjectInfo() {
        return this.projectServices.getProjectInfo();
    }

    @Override
    @NotNull
    public final BuiltInKotlinServices getBuiltInKotlinServices() {
        return this.projectServices.getBuiltInKotlinServices();
    }
}

