/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.android.zipflinger.ZipArchive;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u001a0\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u001a0\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\u00012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a8\u0006\u000e"}, d2={"getDeviceSpec", "Lcom/android/bundle/Devices$DeviceSpec;", "device", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "getApkFiles", "", "Ljava/nio/file/Path;", "apkBundle", "moduleName", "", "apkBundles", "", "deviceSpec", "extractApkFilesBypassingBundleTool", "gradle-core"})
@JvmName(name="BundleInstallUtils")
@SourceDebugExtension(value={"SMAP\nBundleInstallUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundleInstallUtils.kt\ncom/android/build/gradle/internal/tasks/BundleInstallUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1#2:93\n1374#3:94\n1460#3,5:95\n*S KotlinDebug\n*F\n+ 1 BundleInstallUtils.kt\ncom/android/build/gradle/internal/tasks/BundleInstallUtils\n*L\n65#1:94\n65#1:95,5\n*E\n"})
public final class BundleInstallUtils {
    @NotNull
    public static final Devices.DeviceSpec getDeviceSpec(@NotNull DeviceConfigProvider device) {
        Devices.DeviceSpec.Builder builder;
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Devices.DeviceSpec.Builder spec = builder = Devices.DeviceSpec.newBuilder();
        boolean bl = false;
        Object object = device.getApiLevel();
        int it = ((Number)object).intValue();
        boolean bl2 = false;
        Object object2 = it > 0 ? object : null;
        if (object2 != null) {
            it = ((Number)object2).intValue();
            boolean bl3 = false;
            spec.setSdkVersion(it);
        }
        String string = device.getApiCodeName();
        if (string != null) {
            String it2 = string;
            boolean bl4 = false;
            spec.setCodename(it2);
        }
        Object it3 = object = device.getAbis();
        boolean bl5 = false;
        Intrinsics.checkNotNull((Object)it3);
        Object object3 = !((Collection)it3).isEmpty() ? object : null;
        if (object3 != null) {
            it3 = object3;
            boolean bl6 = false;
            spec.addAllSupportedAbis((Iterable)it3);
        }
        object = device.getDensity();
        int it2 = ((Number)object).intValue();
        boolean bl7 = false;
        Object object4 = it2 > 0 ? object : null;
        if (object4 != null) {
            it2 = ((Number)object4).intValue();
            boolean bl8 = false;
            spec.setScreenDensity(it2);
        }
        Set set = device.getLanguageSplits();
        if (set != null) {
            Set it4 = set;
            boolean bl9 = false;
            spec.addAllSupportedLocales((Iterable)it4);
        }
        Devices.DeviceSpec deviceSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)deviceSpec, (String)"build(...)");
        return deviceSpec;
    }

    @NotNull
    public static final List<Path> getApkFiles(@NotNull Path apkBundle, @NotNull DeviceConfigProvider device, @Nullable String moduleName) {
        Intrinsics.checkNotNullParameter((Object)apkBundle, (String)"apkBundle");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return BundleInstallUtils.getApkFiles((Collection<? extends Path>)SetsKt.setOf((Object)apkBundle), device, moduleName);
    }

    public static /* synthetic */ List getApkFiles$default(Path path, DeviceConfigProvider deviceConfigProvider, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return BundleInstallUtils.getApkFiles(path, deviceConfigProvider, string);
    }

    @NotNull
    public static final List<Path> getApkFiles(@NotNull Collection<? extends Path> apkBundles, @NotNull DeviceConfigProvider device, @Nullable String moduleName) {
        Intrinsics.checkNotNullParameter(apkBundles, (String)"apkBundles");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Devices.DeviceSpec deviceSpec = BundleInstallUtils.getDeviceSpec(device);
        return BundleInstallUtils.getApkFiles(apkBundles, deviceSpec, moduleName);
    }

    public static /* synthetic */ List getApkFiles$default(Collection collection, DeviceConfigProvider deviceConfigProvider, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return BundleInstallUtils.getApkFiles((Collection<? extends Path>)collection, deviceConfigProvider, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Path> getApkFiles(@NotNull Collection<? extends Path> apkBundles, @NotNull Devices.DeviceSpec deviceSpec, @Nullable String moduleName) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(apkBundles, (String)"apkBundles");
        Intrinsics.checkNotNullParameter((Object)deviceSpec, (String)"deviceSpec");
        Path path = Files.createTempDirectory("apkSelect", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        Path tempFolder = path;
        Iterable $this$flatMap$iv = apkBundles;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Path apkBundle = (Path)element$iv$iv;
            boolean bl = false;
            ExtractApksCommand.Builder command = ExtractApksCommand.builder().setApksArchivePath(apkBundle).setDeviceSpec(deviceSpec);
            if (!Files.isDirectory(apkBundle, new LinkOption[0])) {
                command.setOutputDirectory(tempFolder);
            }
            if (moduleName != null) {
                String it;
                boolean bl2 = false;
                command.setModules(ImmutableSet.of((Object)it));
            }
            ImmutableList immutableList = command.build().execute();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"execute(...)");
            Iterable list$iv$iv = (Iterable)immutableList;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List apkPaths = (List)destination$iv$iv;
        return apkPaths;
    }

    public static /* synthetic */ List getApkFiles$default(Collection collection, Devices.DeviceSpec deviceSpec, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return BundleInstallUtils.getApkFiles((Collection<? extends Path>)collection, deviceSpec, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> extractApkFilesBypassingBundleTool(@NotNull Path apkBundle) {
        Intrinsics.checkNotNullParameter((Object)apkBundle, (String)"apkBundle");
        Path path = Files.createTempDirectory(PathsKt.getNameWithoutExtension((Path)apkBundle), new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        Path tempFolder = path;
        Path outputFile = tempFolder.resolve("extracted-apk.apk");
        Closeable closeable = (Closeable)new ZipArchive(apkBundle);
        Throwable throwable = null;
        try {
            long l;
            ZipArchive it = (ZipArchive)closeable;
            boolean bl = false;
            Closeable closeable2 = it.getInputStream("standalones/standalone.apk");
            Throwable throwable2 = null;
            try {
                InputStream inputStream = (InputStream)closeable2;
                boolean bl2 = false;
                l = Files.copy(inputStream, outputFile, new CopyOption[0]);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return CollectionsKt.listOf((Object)outputFile);
    }
}

