/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dsl.NdkOptions;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataRunnable;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataTask;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataWorkAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataWorkAction$Parameters;", "<init>", "()V", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getLogger", "()Lcom/android/build/gradle/internal/LoggerWrapper;", "run", "", "Parameters", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nExtractNativeDebugMetadataTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractNativeDebugMetadataTask.kt\ncom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataWorkAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,362:1\n1491#2:363\n1516#2,3:364\n1519#2,3:374\n1869#2,2:377\n382#3,7:367\n*S KotlinDebug\n*F\n+ 1 ExtractNativeDebugMetadataTask.kt\ncom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataWorkAction\n*L\n285#1:363\n285#1:364,3\n285#1:374,3\n285#1:377,2\n285#1:367,7\n*E\n"})
public abstract class ExtractNativeDebugMetadataWorkAction
extends ProfileAwareWorkAction<Parameters> {
    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    private final LoggerWrapper getLogger() {
        return new LoggerWrapper(Logging.getLogger(ExtractNativeDebugMetadataTask.class));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void $this$groupByTo$iv$iv;
        Object outputFile;
        File outputDir = (File)((Parameters)this.getParameters()).getOutputDir().getAsFile().get();
        FileUtils.cleanOutputDir((File)outputDir);
        File inputDir = (File)((Parameters)this.getParameters()).getInputDir().getAsFile().get();
        File strippedNativeLibs = (File)((Parameters)this.getParameters()).getStrippedNativeLibs().getAsFile().get();
        List allRequests = new ArrayList();
        for (File inputFile : FileUtils.getAllFiles((File)inputDir)) {
            String string = inputFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith((String)string, (String)".so", (boolean)true)) continue;
            File strippedNativeLib = new File(strippedNativeLibs, ((Object)inputDir.toPath().relativize(inputFile.toPath())).toString());
            if (inputFile.length() == strippedNativeLib.length()) {
                this.getLogger().info("Unable to extract native debug metadata from " + inputFile.getAbsolutePath() + " because the native debug metadata has already been stripped.", new Object[0]);
                continue;
            }
            outputFile = null;
            List objcopyArgs = null;
            NdkOptions.DebugSymbolLevel debugSymbolLevel = (NdkOptions.DebugSymbolLevel)((Object)((Parameters)this.getParameters()).getDebugSymbolLevel().get());
            switch (debugSymbolLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[debugSymbolLevel.ordinal()]) {
                case 1: {
                    outputFile = new File(outputDir, inputFile.getParentFile().getName() + "/" + inputFile.getName() + ".dbg");
                    objcopyArgs = CollectionsKt.listOf((Object)"--only-keep-debug");
                    break;
                }
                case 2: {
                    outputFile = new File(outputDir, inputFile.getParentFile().getName() + "/" + inputFile.getName() + ".sym");
                    objcopyArgs = CollectionsKt.listOf((Object)"--strip-debug");
                    break;
                }
                case 3: {
                    throw new RuntimeException("NativeDebugMetadataMode.NONE not supported in " + this.getClass().getName());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            File objcopyExecutable = (File)((Map)((Parameters)this.getParameters()).getObjcopyExecutableMap().get()).get(inputFile.getParentFile().getName());
            if (objcopyExecutable == null) {
                this.getLogger().warning("Unable to extract native debug metadata from " + inputFile.getAbsolutePath() + " because unable to locate the objcopy executable for the " + inputFile.getParentFile().getName() + " ABI.", new Object[0]);
                continue;
            }
            Intrinsics.checkNotNull((Object)inputFile);
            allRequests.add(new ExtractNativeDebugMetadataRunnable.SingleRequest(inputFile, (File)outputFile, objcopyExecutable, objcopyArgs));
        }
        int ord = 0;
        Iterable $this$groupBy$iv = allRequests;
        boolean $i$f$groupBy = false;
        outputFile = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ExtractNativeDebugMetadataRunnable.SingleRequest it = (ExtractNativeDebugMetadataRunnable.SingleRequest)element$iv$iv;
            boolean bl = false;
            int n = ord;
            ord = n + 1;
            Object object2 = ((Parameters)this.getParameters()).getMaxWorkerCount().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            Integer key$iv$iv = n % ((Number)object2).intValue();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List requests = (List)element$iv;
            boolean bl = false;
            if (!(!((Collection)requests).isEmpty())) continue;
            this.getWorkerExecutor().noIsolation().submit(ExtractNativeDebugMetadataRunnable.class, new Action(this, requests){
                final /* synthetic */ ExtractNativeDebugMetadataWorkAction this$0;
                final /* synthetic */ List<ExtractNativeDebugMetadataRunnable.SingleRequest> $requests;
                {
                    this.this$0 = $receiver;
                    this.$requests = $requests;
                }

                public final void execute(ExtractNativeDebugMetadataRunnable.Params it) {
                    WorkParameters workParameters = this.this$0.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)workParameters, (String)"getParameters(...)");
                    it.initializeFromProfileAwareWorkAction((ProfileAwareWorkAction.Parameters)workParameters);
                    it.getRequests().set((Iterable)this.$requests);
                }
            });
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001e\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataWorkAction$Parameters;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "<init>", "()V", "inputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "strippedNativeLibs", "getStrippedNativeLibs", "outputDir", "getOutputDir", "objcopyExecutableMap", "Lorg/gradle/api/provider/MapProperty;", "", "Ljava/io/File;", "getObjcopyExecutableMap", "()Lorg/gradle/api/provider/MapProperty;", "debugSymbolLevel", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/dsl/NdkOptions$DebugSymbolLevel;", "getDebugSymbolLevel", "()Lorg/gradle/api/provider/Property;", "maxWorkerCount", "", "getMaxWorkerCount", "gradle-core"})
    public static abstract class Parameters
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract DirectoryProperty getInputDir();

        @NotNull
        public abstract DirectoryProperty getStrippedNativeLibs();

        @NotNull
        public abstract DirectoryProperty getOutputDir();

        @NotNull
        public abstract MapProperty<String, File> getObjcopyExecutableMap();

        @NotNull
        public abstract Property<NdkOptions.DebugSymbolLevel> getDebugSymbolLevel();

        @NotNull
        public abstract Property<Integer> getMaxWorkerCount();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NdkOptions.DebugSymbolLevel.values().length];
            try {
                nArray[NdkOptions.DebugSymbolLevel.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NdkOptions.DebugSymbolLevel.SYMBOL_TABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NdkOptions.DebugSymbolLevel.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

