/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.mlkit.codegen;

import com.android.build.gradle.internal.tasks.mlkit.codegen.ClassNames;
import com.android.tools.mlkit.MlNames;
import com.android.tools.mlkit.TensorInfo;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000f\u001a\u0019\u0010\u0010\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011\u00a2\u0006\u0002\u0010\u0012\u001a#\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u001c"}, d2={"getParameterType", "Lcom/squareup/javapoet/TypeName;", "tensorInfo", "Lcom/android/tools/mlkit/TensorInfo;", "getGroupClassParameterType", "getIdentifierFromFileName", "", "name", "getProcessorName", "getProcessedTypeName", "getProcessorBuilderName", "getFloatArrayString", "array", "", "getIntArrayString", "", "getObjectArrayString", "", "([Ljava/lang/String;)Ljava/lang/String;", "getArrayString", "type", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getDataType", "Lcom/android/tools/mlkit/TensorInfo$DataType;", "getOutputParameterType", "getOutputParameterTypeName", "getImageHeightFieldName", "getImageWidthFieldName", "gradle-core"})
@JvmName(name="CodeUtils")
@SourceDebugExtension(value={"SMAP\nCodeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeUtils.kt\ncom/android/build/gradle/internal/tasks/mlkit/codegen/CodeUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,124:1\n11278#2:125\n11613#2,3:126\n11258#2:133\n11593#2,3:134\n37#3:129\n36#3,3:130\n37#3:137\n36#3,3:138\n*S KotlinDebug\n*F\n+ 1 CodeUtils.kt\ncom/android/build/gradle/internal/tasks/mlkit/codegen/CodeUtils\n*L\n68#1:125\n68#1:126,3\n72#1:133\n72#1:134,3\n68#1:129\n68#1:130,3\n72#1:137\n72#1:138,3\n*E\n"})
public final class CodeUtils {
    @NotNull
    public static final TypeName getParameterType(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkNotNullParameter((Object)tensorInfo, (String)"tensorInfo");
        return tensorInfo.isRGBImage() ? (TypeName)ClassNames.TENSOR_IMAGE : (TypeName)ClassNames.TENSOR_BUFFER;
    }

    @NotNull
    public static final TypeName getGroupClassParameterType(@NotNull TensorInfo tensorInfo) {
        TypeName typeName;
        Intrinsics.checkNotNullParameter((Object)tensorInfo, (String)"tensorInfo");
        if (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_VALUE_LABELS) {
            typeName = (TypeName)ClassNames.STRING;
        } else if (tensorInfo.getContentType() == TensorInfo.ContentType.BOUNDING_BOX) {
            typeName = (TypeName)ClassNames.RECT_F;
        } else if (tensorInfo.getDataType() == TensorInfo.DataType.FLOAT32) {
            TypeName typeName2 = TypeName.FLOAT;
            Intrinsics.checkNotNull((Object)typeName2);
            typeName = typeName2;
        } else if (tensorInfo.getDataType() == TensorInfo.DataType.UINT8) {
            TypeName typeName3 = TypeName.INT;
            Intrinsics.checkNotNull((Object)typeName3);
            typeName = typeName3;
        } else {
            typeName = (TypeName)ClassNames.TENSOR_BUFFER;
        }
        return typeName;
    }

    @NotNull
    public static final String getIdentifierFromFileName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CharSequence charSequence = name;
        Regex regex = new Regex("\\..*");
        String string = "";
        String string2 = MlNames.computeIdentifierName(regex.replace(charSequence, string));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"computeIdentifierName(...)");
        return string2;
    }

    @NotNull
    public static final String getProcessorName(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkNotNullParameter((Object)tensorInfo, (String)"tensorInfo");
        return tensorInfo.getSource() == TensorInfo.Source.INPUT ? tensorInfo.getIdentifierName() + "Processor" : tensorInfo.getIdentifierName() + "PostProcessor";
    }

    @NotNull
    public static final String getProcessedTypeName(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkNotNullParameter((Object)tensorInfo, (String)"tensorInfo");
        return "processed" + tensorInfo.getIdentifierName();
    }

    @NotNull
    public static final String getProcessorBuilderName(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkNotNullParameter((Object)tensorInfo, (String)"tensorInfo");
        return CodeUtils.getProcessorName(tensorInfo) + "Builder";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getFloatArrayString(@NotNull float[] array) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        float[] fArray = array;
        String string = "float";
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((float)it + "f");
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return CodeUtils.getArrayString(string, thisCollection$iv.toArray(new String[0]));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getIntArrayString(@NotNull int[] array) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int[] nArray = array;
        String string = "int";
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(String.valueOf((int)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return CodeUtils.getArrayString(string, thisCollection$iv.toArray(new String[0]));
    }

    @NotNull
    public static final String getObjectArrayString(@NotNull String[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return CodeUtils.getArrayString("Object", array);
    }

    private static final String getArrayString(String type, String[] array) {
        StringBuilder builder = new StringBuilder();
        String string = "new %s[] {";
        Object[] objectArray = new Object[]{type};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        builder.append(string2);
        for (String dim : array) {
            builder.append(dim).append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("}");
        String string3 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    @NotNull
    public static final String getDataType(@NotNull TensorInfo.DataType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return type.toString();
    }

    @NotNull
    public static final TypeName getOutputParameterType(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkNotNullParameter((Object)tensorInfo, (String)"tensorInfo");
        return tensorInfo.isRGBImage() ? (TypeName)ClassNames.TENSOR_IMAGE : (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_AXIS_LABELS ? ClassNames.CATEGORY_LIST : (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_VALUE_LABELS ? ClassNames.STRING_LIST : (tensorInfo.getContentType() == TensorInfo.ContentType.BOUNDING_BOX ? ClassNames.RECTF_LIST : (TypeName)ClassNames.TENSOR_BUFFER)));
    }

    @NotNull
    public static final String getOutputParameterTypeName(@NotNull TensorInfo tensorInfo) {
        String string;
        Intrinsics.checkNotNullParameter((Object)tensorInfo, (String)"tensorInfo");
        if (tensorInfo.isRGBImage()) {
            String string2 = ClassNames.TENSOR_IMAGE.simpleName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"simpleName(...)");
        } else if (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_AXIS_LABELS) {
            string = "CategoryList";
        } else if (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_VALUE_LABELS) {
            string = "StringList";
        } else if (tensorInfo.getContentType() == TensorInfo.ContentType.BOUNDING_BOX) {
            string = "RectFList";
        } else {
            String string3 = ClassNames.TENSOR_BUFFER.simpleName();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"simpleName(...)");
        }
        return string;
    }

    @NotNull
    public static final String getImageHeightFieldName(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkNotNullParameter((Object)tensorInfo, (String)"tensorInfo");
        return tensorInfo.getIdentifierName() + "Height";
    }

    @NotNull
    public static final String getImageWidthFieldName(@NotNull TensorInfo tensorInfo) {
        Intrinsics.checkNotNullParameter((Object)tensorInfo, (String)"tensorInfo");
        return tensorInfo.getIdentifierName() + "Width";
    }
}

