/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.androidtest.instrument;

import com.android.build.gradle.internal.testing.androidtest.instrument.TestTimingData;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/testing/androidtest/instrument/TestTimeTracker;", "", "now", "Lkotlin/Function0;", "Ljava/time/Instant;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "hasStarted", "Ljava/util/concurrent/atomic/AtomicBoolean;", "hasEnded", "startTime", "", "endTime", "testTimingData", "Lcom/android/build/gradle/internal/testing/androidtest/instrument/TestTimingData;", "getTestTimingData", "()Lcom/android/build/gradle/internal/testing/androidtest/instrument/TestTimingData;", "testStart", "", "testEnd", "Companion", "gradle-core"})
public final class TestTimeTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Instant> now;
    @NotNull
    private final AtomicBoolean hasStarted;
    @NotNull
    private final AtomicBoolean hasEnded;
    private long startTime;
    private long endTime;
    private static final Logger logger = Logging.getLogger(TestTimeTracker.class);

    public TestTimeTracker(@NotNull Function0<Instant> now) {
        Intrinsics.checkNotNullParameter(now, (String)"now");
        this.now = now;
        this.hasStarted = new AtomicBoolean(false);
        this.hasEnded = new AtomicBoolean(false);
        this.startTime = -1L;
        this.endTime = -1L;
    }

    public /* synthetic */ TestTimeTracker(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        this((Function0<Instant>)function0);
    }

    @NotNull
    public final TestTimingData getTestTimingData() {
        if (!this.hasStarted.get()) {
            boolean $i$a$-require-TestTimeTracker$testTimingData$32 = false;
            String $i$a$-require-TestTimeTracker$testTimingData$32 = "Called TestTimeTracker.testTimingData before TestTimeTracker.testStart()";
            throw new IllegalArgumentException($i$a$-require-TestTimeTracker$testTimingData$32.toString());
        }
        if (!this.hasEnded.get()) {
            boolean bl = false;
            String string = "Called TestTimeTracker.testTimingData before TestTimeTracker.testEnd()";
            throw new IllegalArgumentException(string.toString());
        }
        return new TestTimingData(this.startTime, this.endTime);
    }

    public final void testStart() {
        this.startTime = ((Instant)this.now.invoke()).toEpochMilli();
        if (!this.hasStarted.compareAndSet(false, true)) {
            boolean bl = false;
            String string = "Called TestTimeTracker.testStart() twice";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void testEnd() {
        if (!this.hasStarted.get()) {
            logger.warn("TestTimeTracker.testEnd() was called before TestTimeTracker.testStart(). The test may not\nhave run. Check the test logs for details.");
            this.testStart();
        }
        this.endTime = ((Instant)this.now.invoke()).toEpochMilli();
        if (!this.hasEnded.compareAndSet(false, true)) {
            boolean bl = false;
            String string = "Called TestTimeTracker.testEnd() twice";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public TestTimeTracker() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/testing/androidtest/instrument/TestTimeTracker$Companion;", "", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

