/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.ApkInstallGroup;
import com.android.build.api.variant.ApkOutput;
import com.android.build.api.variant.DeviceSpec;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.component.TestVariantCreationConfig;
import com.android.build.gradle.internal.component.features.NativeBuildCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.testing.TestData;
import com.android.build.gradle.internal.utils.ApkSources;
import com.android.build.gradle.internal.utils.DefaultDeviceApkOutput;
import com.android.build.gradle.internal.utils.DeviceApkOutput;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.TaskInputs;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/utils/TestApkOutput;", "Lcom/android/build/api/variant/ApkOutput;", "variant", "Lcom/android/build/gradle/internal/component/TestVariantCreationConfig;", "deviceSpec", "Lcom/android/build/api/variant/DeviceSpec;", "<init>", "(Lcom/android/build/gradle/internal/component/TestVariantCreationConfig;Lcom/android/build/api/variant/DeviceSpec;)V", "getDeviceSpec", "()Lcom/android/build/api/variant/DeviceSpec;", "testingApk", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "apkSources", "Lcom/android/build/gradle/internal/utils/ApkSources;", "deviceApkOutput", "Lcom/android/build/gradle/internal/utils/DeviceApkOutput;", "apkInstallGroups", "", "Lcom/android/build/api/variant/ApkInstallGroup;", "getApkInstallGroups", "()Ljava/util/List;", "setTaskInputs", "", "inputs", "Lorg/gradle/api/tasks/TaskInputs;", "fetchTestingApk", "getApkSources", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nTestApkOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestApkOutput.kt\ncom/android/build/gradle/internal/utils/TestApkOutput\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,76:1\n37#2:77\n36#2,3:78\n*S KotlinDebug\n*F\n+ 1 TestApkOutput.kt\ncom/android/build/gradle/internal/utils/TestApkOutput\n*L\n52#1:77\n52#1:78,3\n*E\n"})
public final class TestApkOutput
implements ApkOutput {
    @NotNull
    private final DeviceSpec deviceSpec;
    @NotNull
    private final Provider<Directory> testingApk;
    @NotNull
    private final ApkSources apkSources;
    @NotNull
    private final DeviceApkOutput deviceApkOutput;

    public TestApkOutput(@NotNull TestVariantCreationConfig variant, @NotNull DeviceSpec deviceSpec) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)deviceSpec, (String)"deviceSpec");
        this.deviceSpec = deviceSpec;
        this.apkSources = this.getApkSources(variant);
        NativeBuildCreationConfig nativeBuildCreationConfig2 = variant.getNativeBuildCreationConfig();
        this.deviceApkOutput = new DefaultDeviceApkOutput(this.apkSources, nativeBuildCreationConfig2 != null ? nativeBuildCreationConfig2.getSupportedAbis() : null, VariantApiExtensionsKt.toSharedAndroidVersion(variant.getMinSdk()), variant.getBaseName(), variant.getServices().getProjectInfo().getPath(), null, 32, null);
        this.testingApk = variant.getArtifacts().get((SingleArtifact)SingleArtifact.APK.INSTANCE);
    }

    @NotNull
    public final DeviceSpec getDeviceSpec() {
        return this.deviceSpec;
    }

    @NotNull
    public List<ApkInstallGroup> getApkInstallGroups() {
        return CollectionsKt.plus((Collection)this.deviceApkOutput.getApks(this.deviceSpec), (Object)this.fetchTestingApk());
    }

    public final void setTaskInputs(@NotNull TaskInputs inputs) {
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        Set apkInputs = SetsKt.plus(DefaultDeviceApkOutput.Companion.getApkInputs(this.apkSources, this.deviceSpec), this.testingApk);
        Collection $this$toTypedArray$iv = apkInputs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        inputs.files(Arrays.copyOf(objectArray, objectArray.length)).withNormalizer(ClasspathNormalizer.class);
    }

    private final ApkInstallGroup fetchTestingApk() {
        List testingApks2 = CollectionsKt.listOf((Object)new RegularFile(this){
            final /* synthetic */ TestApkOutput this$0;
            {
                this.this$0 = $receiver;
            }

            public final File getAsFile() {
                Object object = TestApkOutput.access$getTestingApk$p(this.this$0).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                return TestData.Companion.getTestingApk((Directory)object);
            }
        });
        return new DefaultDeviceApkOutput.DefaultApkInstallGroup(testingApks2, "Testing Apk");
    }

    private final ApkSources getApkSources(TestVariantCreationConfig variant) {
        FileCollection privacySandboxSdksApksFiles = VariantDependencies.getArtifactFileCollection$default(variant.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.PROVIDED_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_EXTRACTED_SDK_APKS, null, 8, null);
        return new ApkSources(variant.getTestedApks(), privacySandboxSdksApksFiles, variant.getUsesSdkLibrarySplitForLocalDeployment(), variant.getPrivacySandboxCompatApks(), null, 16, null);
    }

    public static final /* synthetic */ Provider access$getTestingApk$p(TestApkOutput $this) {
        return $this.testingApk;
    }
}

