/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.variant.ComponentIdentity;
import com.android.build.api.variant.VariantBuilder;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.ApplicationVariantImpl;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.core.dsl.VariantDslInfo;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.plugins.DslContainerProvider;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.internal.services.VariantServices;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.builder.errors.IssueReporter;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007B\u000f\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J8\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u001e\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0 H\u0016J(\u0010%\u001a\u00020\u001a2\u001e\u0010&\u001a\u001a\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0'H\u0016J(\u0010(\u001a\u00020\u001a2\u001e\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0 H\u0002R\u001e\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lcom/android/build/gradle/internal/variant/AbstractAppVariantFactory;", "VariantBuilderT", "Lcom/android/build/api/variant/VariantBuilder;", "VariantDslInfoT", "Lcom/android/build/gradle/internal/core/dsl/VariantDslInfo;", "VariantT", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "Lcom/android/build/gradle/internal/variant/BaseVariantFactory;", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "<init>", "(Lcom/android/build/gradle/internal/services/DslServices;)V", "createVariantData", "Lcom/android/build/gradle/internal/variant/BaseVariantData;", "componentIdentity", "Lcom/android/build/api/variant/ComponentIdentity;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "services", "Lcom/android/build/gradle/internal/services/VariantServices;", "variantImplementationClass", "Ljava/lang/Class;", "Lcom/android/build/gradle/internal/api/BaseVariantImpl;", "getVariantImplementationClass", "()Ljava/lang/Class;", "preVariantCallback", "", "project", "Lorg/gradle/api/Project;", "dslExtension", "Lcom/android/build/api/dsl/CommonExtension;", "model", "Lcom/android/build/gradle/internal/variant/VariantInputModel;", "Lcom/android/build/gradle/internal/dsl/DefaultConfig;", "Lcom/android/build/gradle/internal/dsl/BuildType;", "Lcom/android/build/gradle/internal/dsl/ProductFlavor;", "Lcom/android/build/gradle/internal/dsl/SigningConfig;", "createDefaultComponents", "dslContainers", "Lcom/android/build/gradle/internal/plugins/DslContainerProvider;", "validateVersionCodes", "gradle-core"})
public abstract class AbstractAppVariantFactory<VariantBuilderT extends VariantBuilder, VariantDslInfoT extends VariantDslInfo, VariantT extends VariantCreationConfig>
extends BaseVariantFactory<VariantBuilderT, VariantDslInfoT, VariantT> {
    public AbstractAppVariantFactory(@NotNull DslServices dslServices2) {
        Intrinsics.checkNotNullParameter((Object)dslServices2, (String)"dslServices");
        super(dslServices2);
    }

    @Override
    @NotNull
    public BaseVariantData createVariantData(@NotNull ComponentIdentity componentIdentity, @NotNull ArtifactsImpl artifacts2, @NotNull VariantServices services) {
        Intrinsics.checkNotNullParameter((Object)componentIdentity, (String)"componentIdentity");
        Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        return new ApplicationVariantData(componentIdentity, artifacts2, services);
    }

    @Override
    @NotNull
    public Class<? extends BaseVariantImpl> getVariantImplementationClass() {
        return ApplicationVariantImpl.class;
    }

    @Override
    public void preVariantCallback(@NotNull Project project, @NotNull CommonExtension dslExtension, @NotNull VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dslExtension, (String)"dslExtension");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        super.preVariantCallback(project, dslExtension, model);
        this.validateVersionCodes(model);
        if (!this.getComponentType().isDynamicFeature()) {
            return;
        }
        IssueReporter issueReporter2 = this.dslServices.getIssueReporter();
        for (BuildTypeData<BuildType> buildType : model.getBuildTypes().values()) {
            if (!buildType.getBuildType().isMinifyEnabled()) continue;
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                            Dynamic feature modules cannot set minifyEnabled to true. minifyEnabled is set to true in build type '" + buildType.getBuildType().getName() + "'.\n                            To enable minification for a dynamic feature module, set minifyEnabled to true in the base module.\n                            ")), null, null, (int)12, null);
        }
        String message2 = "Signing configuration should not be declared in build types of dynamic-feature. Dynamic-features use the signing configuration declared in the application module.";
        for (BuildTypeData<BuildType> buildTypeData : model.getBuildTypes().values()) {
            if (buildTypeData.getBuildType().getSigningConfig() == null) continue;
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.SIGNING_CONFIG_DECLARED_IN_DYNAMIC_FEATURE, (String)message2, null, null, (int)12, null);
        }
        message2 = "Signing configuration should not be declared in product flavors of dynamic-feature. Dynamic-features use the signing configuration declared in the application module.";
        for (ProductFlavorData productFlavorData : model.getProductFlavors().values()) {
            if (((ProductFlavor)productFlavorData.getProductFlavor()).getSigningConfig() == null) continue;
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.SIGNING_CONFIG_DECLARED_IN_DYNAMIC_FEATURE, (String)message2, null, null, (int)12, null);
        }
        message2 = "abiFilters should not be declared in dynamic-features. Dynamic-features use the abiFilters declared in the application module.";
        if (!model.getDefaultConfigData().getDefaultConfig().getNdkConfig().getAbiFilters().isEmpty()) {
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message2, null, null, (int)12, null);
        }
        for (BuildTypeData buildTypeData : model.getBuildTypes().values()) {
            Set<String> set = ((BuildType)buildTypeData.getBuildType()).getNdkConfig().getAbiFilters();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-abiFilters>(...)");
            if (!(!((Collection)set).isEmpty())) continue;
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message2, null, null, (int)12, null);
        }
        for (ProductFlavorData productFlavorData : model.getProductFlavors().values()) {
            Set<String> set = ((ProductFlavor)productFlavorData.getProductFlavor()).getNdkConfig().getAbiFilters();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getAbiFilters(...)");
            if (!(!((Collection)set).isEmpty())) continue;
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message2, null, null, (int)12, null);
        }
    }

    @Override
    public void createDefaultComponents(@NotNull DslContainerProvider<DefaultConfig, BuildType, ProductFlavor, SigningConfig> dslContainers) {
        Intrinsics.checkNotNullParameter(dslContainers, (String)"dslContainers");
        dslContainers.getSigningConfigContainer().create("debug");
        dslContainers.getBuildTypeContainer().create("debug");
        dslContainers.getBuildTypeContainer().create("release");
    }

    private final void validateVersionCodes(VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> model) {
        IssueReporter issueReporter2 = this.dslServices.getIssueReporter();
        Integer versionCode2 = model.getDefaultConfigData().getDefaultConfig().getVersionCode();
        if (versionCode2 != null && versionCode2 < 1) {
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                        android.defaultConfig.versionCode is set to " + versionCode2 + ", but it should be a positive integer.\n                        See https://developer.android.com/studio/publish/versioning#appversioning for more information.\n                        ")), null, null, (int)12, null);
            return;
        }
        for (ProductFlavorData<ProductFlavor> flavorData : model.getProductFlavors().values()) {
            Integer flavorVersionCode = flavorData.getProductFlavor().getVersionCode();
            if (flavorVersionCode == null || flavorVersionCode > 0) {
                return;
            }
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)("versionCode is set to " + flavorVersionCode + " in product flavor " + flavorData.getProductFlavor().getName() + ", but it should be a positive integer. See https://developer.android.com/studio/publish/versioning#appversioning for more information."), null, null, (int)12, null);
        }
    }
}

