/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\bJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/tasks/ClassFinder;", "", "classesArtifactCollection", "Lorg/gradle/api/artifacts/ArtifactCollection;", "<init>", "(Lorg/gradle/api/artifacts/ArtifactCollection;)V", "classToDependency", "", "", "getClassToDependency", "()Ljava/util/Map;", "classToDependency$delegate", "Lkotlin/Lazy;", "getClassDependencyMap", "find", "className", "findClassesInDependency", "", "dependencyId", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nDependenciesAnalyzerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependenciesAnalyzerUtils.kt\ncom/android/build/gradle/tasks/ClassFinder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,307:1\n504#2,7:308\n*S KotlinDebug\n*F\n+ 1 DependenciesAnalyzerUtils.kt\ncom/android/build/gradle/tasks/ClassFinder\n*L\n147#1:308,7\n*E\n"})
public final class ClassFinder {
    @NotNull
    private final ArtifactCollection classesArtifactCollection;
    @NotNull
    private final Lazy classToDependency$delegate;

    public ClassFinder(@NotNull ArtifactCollection classesArtifactCollection) {
        Intrinsics.checkNotNullParameter((Object)classesArtifactCollection, (String)"classesArtifactCollection");
        this.classesArtifactCollection = classesArtifactCollection;
        this.classToDependency$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends String>>((Object)this){

            public final Map<String, String> invoke() {
                return ClassFinder.access$getClassDependencyMap((ClassFinder)this.receiver);
            }
        }));
    }

    private final Map<String, String> getClassToDependency() {
        Lazy lazy = this.classToDependency$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<String, String> getClassDependencyMap() {
        Map map = new LinkedHashMap();
        for (ResolvedArtifactResult artifact : this.classesArtifactCollection) {
            File file = artifact.getFile();
            if (!Intrinsics.areEqual((Object)file.getName(), (Object)"classes.txt")) {
                throw new IllegalArgumentException(file.getName() + " should have name classes.txt.");
            }
            Intrinsics.checkNotNull((Object)file);
            FilesKt.forEachLine$default((File)file, null, (Function1)((Function1)new Function1<String, Unit>((Map<String, String>)map, artifact){
                final /* synthetic */ Map<String, String> $map;
                final /* synthetic */ ResolvedArtifactResult $artifact;
                {
                    this.$map = $map;
                    this.$artifact = $artifact;
                    super(1);
                }

                public final void invoke(String artifactFileLine) {
                    Intrinsics.checkNotNullParameter((Object)artifactFileLine, (String)"artifactFileLine");
                    this.$map.put(artifactFileLine, this.$artifact.getId().getComponentIdentifier().getDisplayName());
                }
            }), (int)1, null);
        }
        return map;
    }

    @Nullable
    public final String find(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return this.getClassToDependency().get(className);
    }

    @NotNull
    public final Set<String> findClassesInDependency(@NotNull String dependencyId) {
        Intrinsics.checkNotNullParameter((Object)dependencyId, (String)"dependencyId");
        Map<String, String> $this$filterValues$iv = this.getClassToDependency();
        boolean $i$f$filterValues = false;
        LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry$iv : $this$filterValues$iv.entrySet()) {
            String it = entry$iv.getValue();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)dependencyId)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return ((Map)result$iv).keySet();
    }

    public static final /* synthetic */ Map access$getClassDependencyMap(ClassFinder $this) {
        return $this.getClassDependencyMap();
    }
}

