/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.external.gnumake.NativeBuildConfigValueBuilder;
import com.android.build.gradle.internal.cxx.configure.BuildSystemCommandLineKt;
import com.android.build.gradle.internal.cxx.configure.NdkBuildProperty;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessCommand;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessKt;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessType;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.NdkBuildExternalNativeJsonGenerator;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.common.base.Charsets;
import com.google.gson.GsonBuilder;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001b*\b\u0012\u0004\u0012\u00020\u00120\u001bH\u0002R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/tasks/NdkBuildExternalNativeJsonGenerator;", "Lcom/android/build/gradle/tasks/ExternalNativeJsonGenerator;", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "variantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "<init>", "(Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;)V", "getProcessBuilder", "Lcom/android/build/gradle/internal/cxx/process/ExecuteProcessCommand;", "executeProcess", "", "ops", "Lorg/gradle/process/ExecOperations;", "parseDryRunOutput", "stdout", "Ljava/io/File;", "ndkBuild", "", "getNdkBuild", "()Ljava/lang/String;", "applicationMk", "getApplicationMk", "()Ljava/io/File;", "makeFile", "getMakeFile", "removeJobsFlagIfPresent", "", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nNdkBuildExternalNativeJsonGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NdkBuildExternalNativeJsonGenerator.kt\ncom/android/build/gradle/tasks/NdkBuildExternalNativeJsonGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1#2:202\n*E\n"})
public final class NdkBuildExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    public NdkBuildExternalNativeJsonGenerator(@NotNull CxxAbiModel abi, @Nullable GradleBuildVariant.Builder variantBuilder) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        super(abi, variantBuilder);
        GradleBuildVariant.Builder builder = variantBuilder;
        if (builder != null) {
            builder.setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.NDK_BUILD);
        }
        if (abi.getVariant().getModule().getMakeFile().isDirectory()) {
            Object[] objectArray = new Object[]{abi.getVariant().getModule().getMakeFile()};
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.INVALID_EXTERNAL_NATIVE_BUILD_CONFIG, "Gradle project ndkBuild.path %s is a folder. Only files (like Android.mk) are allowed.", objectArray);
        } else if (!abi.getVariant().getModule().getMakeFile().exists()) {
            Object[] objectArray = new Object[]{abi.getVariant().getModule().getMakeFile()};
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.INVALID_EXTERNAL_NATIVE_BUILD_CONFIG, "Gradle project ndkBuild.path is %s but that file doesn't exist", objectArray);
        }
    }

    @Override
    @NotNull
    public ExecuteProcessCommand getProcessBuilder(@NotNull CxxAbiModel abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        Object[] objectArray = new String[]{NdkBuildProperty.APP_SHORT_COMMANDS + "=false", NdkBuildProperty.LOCAL_SHORT_COMMANDS + "=false", "-B", "-n"};
        return ExecuteProcessKt.createExecuteProcessCommand(this.getNdkBuild()).addArgs(CollectionsKt.plus((Collection)abi.getConfigurationArguments(), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
    }

    @Override
    public void executeProcess(@NotNull ExecOperations ops, @NotNull CxxAbiModel abi) {
        Intrinsics.checkNotNullParameter((Object)ops, (String)"ops");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        ExecuteProcessType executeProcessType = ExecuteProcessType.CONFIGURE_PROCESS;
        ExecuteProcessCommand executeProcessCommand = this.getProcessBuilder(abi);
        ExecuteProcessKt.executeProcess$default(abi, executeProcessType, executeProcessCommand, ops, null, executeProcess.1.INSTANCE, (Function1)new Function1<File, Unit>(this, abi){
            final /* synthetic */ NdkBuildExternalNativeJsonGenerator this$0;
            final /* synthetic */ CxxAbiModel $abi;
            {
                this.this$0 = $receiver;
                this.$abi = $abi;
                super(1);
            }

            public final void invoke(File stdout) {
                Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
                NdkBuildExternalNativeJsonGenerator.access$parseDryRunOutput(this.this$0, this.$abi, stdout);
            }
        }, 8, null);
    }

    private final void parseDryRunOutput(CxxAbiModel abi, File stdout) {
        LoggingEnvironmentKt.infoln("parse and convert ndk-build output to build configuration JSON", new Object[0]);
        String buildOutput = FilesKt.readText$default((File)stdout, null, (int)1, null);
        List commandLine = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.getNdkBuild()), (Iterable)abi.getConfigurationArguments());
        NativeBuildConfigValueBuilder builder = new NativeBuildConfigValueBuilder(this.getMakeFile(), abi.getVariant().getModule().getModuleRootFolder(), CxxAbiModelKt.getCompileCommandsJsonBinFile(abi), null, 8, null).setCommands(commandLine, CollectionsKt.plus((Collection)this.removeJobsFlagIfPresent(commandLine), (Iterable)CollectionsKt.listOf((Object)"clean")), abi.getVariant().getVariantName(), buildOutput);
        builder.setSkipProcessingCompilerFlags(true);
        NativeBuildConfigValue buildConfig = builder.build();
        File file = this.getApplicationMk();
        if (file != null) {
            File it = file;
            boolean bl = false;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)it.getAbsolutePath(), (String)"getAbsolutePath(...)");
            LoggingEnvironmentKt.infoln("found application make file %s", objectArray);
            Collection<File> collection = buildConfig.buildFiles;
            Intrinsics.checkNotNull(collection);
            collection.add(it);
        }
        String actualResult = new GsonBuilder().registerTypeAdapter((Type)((Object)File.class), (Object)new PlainFileGsonTypeAdaptor()).setPrettyPrinting().create().toJson((Object)buildConfig);
        Path path = CxxAbiModelKt.getJsonFile(abi).toPath();
        Intrinsics.checkNotNull((Object)actualResult);
        String string = actualResult;
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Files.write(path, byArray, new OpenOption[0]);
    }

    private final String getNdkBuild() {
        String string;
        Object tool = "ndk-build";
        if (ExternalNativeJsonGenerator.isWindows()) {
            tool = (String)tool + ".cmd";
        }
        File toolFile = new File(this.getAbi().getVariant().getModule().getNdkFolder().getPath(), (String)tool);
        try {
            string = toolFile.getCanonicalPath();
            Intrinsics.checkNotNull((Object)string);
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{e};
            LoggingEnvironmentKt.warnln("Attempted to get ndkFolder canonical path and failed: %s\nFalling back to absolute path.", objectArray);
            String string2 = toolFile.getAbsolutePath();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    private final File getApplicationMk() {
        File file;
        File it = file = new File(this.getMakeFile().getParent(), "Application.mk");
        boolean bl = false;
        return it.exists() ? file : null;
    }

    private final File getMakeFile() {
        return this.getAbi().getVariant().getModule().getMakeFile().isDirectory() ? new File(this.getAbi().getVariant().getModule().getMakeFile(), "Android.mk") : this.getAbi().getVariant().getModule().getMakeFile();
    }

    private final List<String> removeJobsFlagIfPresent(List<String> $this$removeJobsFlagIfPresent) {
        return BuildSystemCommandLineKt.toStringList(BuildSystemCommandLineKt.removeNdkBuildJobs(BuildSystemCommandLineKt.toNdkBuildArguments($this$removeJobsFlagIfPresent)));
    }

    public static final /* synthetic */ void access$parseDryRunOutput(NdkBuildExternalNativeJsonGenerator $this, CxxAbiModel abi, File stdout) {
        $this.parseDryRunOutput(abi, stdout);
    }
}

