/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.NdkHandlerInput;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.features.ShadersCreationConfig;
import com.android.build.gradle.internal.cxx.configure.GradleLocalPropertiesKt;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.internal.compiler.DirectoryWalker;
import com.android.builder.internal.compiler.ShaderProcessor;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Inject;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.process.ExecOperations;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.SHADER, secondaryTaskCategories={TaskCategory.COMPILATION})
public abstract class ShaderCompile
extends NonIncrementalTask {
    private static final PatternSet PATTERN_SET = new PatternSet().include(new String[]{"**/*.vert"}).include(new String[]{"**/*.tesc"}).include(new String[]{"**/*.tese"}).include(new String[]{"**/*.geom"}).include(new String[]{"**/*.frag"}).include(new String[]{"**/*.comp"});
    private List<String> defaultArgs = ImmutableList.of();
    private Map<String, List<String>> scopedArgs = ImmutableMap.of();
    private final int maxWorkerCount = this.getProject().getGradle().getStartParameter().getMaxWorkerCount();

    @Input
    public abstract Property<Revision> getBuildToolInfoRevisionProvider();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    public abstract DirectoryProperty getShaderCompilerDirectory();

    @Internal
    public abstract Property<SdkComponentsBuildService> getSdkBuildService();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getSourceDir();

    @Nested
    public abstract NdkHandlerInput getNdkHandlerInput();

    @InputFiles
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    public FileTree getSourceFiles() {
        return this.getSourceDir().getAsFileTree().matching((PatternFilterable)PATTERN_SET);
    }

    @Override
    protected void doTaskAction() throws IOException {
        File destinationDir = ((Directory)this.getOutputDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)destinationDir);
        ArrayList processingRequests = new ArrayList();
        DirectoryWalker.FileAction collector2 = (root, file) -> processingRequests.add(new ProcessingRequest(root.toFile(), file.toFile()));
        DirectoryWalker.builder().root(((File)this.getSourceDir().getAsFile().get()).toPath()).extensions(new String[]{"vert", "tesc", "tese", "geom", "frag", "comp"}).action(collector2).build().walk();
        if (!processingRequests.isEmpty()) {
            Directory shaderCompilerDirectory = (Directory)this.getShaderCompilerDirectory().getOrNull();
            File glslcLocation = ShaderProcessor.getGlslcLocation((File)((SdkComponentsBuildService)this.getSdkBuildService().get()).versionedNdkHandler(this.getNdkHandlerInput()).getNdkPlatform().getOrThrow().getNdkDirectory(), (File)(shaderCompilerDirectory != null ? shaderCompilerDirectory.getAsFile() : null));
            HashMap<Integer, List> buckets = new HashMap<Integer, List>();
            int ord = 0;
            for (ProcessingRequest processingRequest : processingRequests) {
                int bucketId = ord++ % this.maxWorkerCount;
                List bucket = buckets.getOrDefault(bucketId, new ArrayList());
                bucket.add(processingRequest);
                buckets.put(bucketId, bucket);
            }
            for (List bucket : buckets.values()) {
                if (bucket.isEmpty()) continue;
                this.getWorkerExecutor().noIsolation().submit(WorkAction.class, params -> {
                    params.initializeFromBaseTask(this);
                    params.getSourceFolder().set((Provider)this.getSourceDir());
                    params.getOutputFolder().set(this.getOutputDir().dir("shaders"));
                    params.getDefaultArgs().set(this.defaultArgs);
                    params.getScopedArgs().set(this.scopedArgs);
                    params.getGlslcLocation().set((Object)glslcLocation);
                    params.getRequests().set((Iterable)bucket);
                });
            }
        }
    }

    @OutputDirectory
    public abstract DirectoryProperty getOutputDir();

    @Input
    public List<String> getDefaultArgs() {
        return this.defaultArgs;
    }

    public void setDefaultArgs(List<String> defaultArgs) {
        this.defaultArgs = ImmutableList.copyOf(defaultArgs);
    }

    @Input
    public Map<String, List<String>> getScopedArgs() {
        return this.scopedArgs;
    }

    public void setScopedArgs(Map<String, List<String>> scopedArgs) {
        this.scopedArgs = ImmutableMap.copyOf(scopedArgs);
    }

    public static class ProcessingRequest
    implements Serializable {
        public final File root;
        public final File file;

        public ProcessingRequest(File root, File file) {
            this.root = root;
            this.file = file;
        }
    }

    public static abstract class WorkAction
    extends ProfileAwareWorkAction<Params> {
        @Inject
        public ExecOperations getExecOperations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void run() {
            for (ProcessingRequest processingRequest : (List)((Params)this.getParameters()).getRequests().get()) {
                new ShaderProcessor.ShaderProcessorRunnable(new ShaderProcessor.ShaderProcessorParams((File)((Params)this.getParameters()).getSourceFolder().getAsFile().get(), (File)((Params)this.getParameters()).getOutputFolder().getAsFile().get(), (List)((Params)this.getParameters()).getDefaultArgs().get(), (Map)((Params)this.getParameters()).getScopedArgs().get(), (ProcessExecutor)new GradleProcessExecutor(arg_0 -> ((ExecOperations)this.getExecOperations()).exec(arg_0)), (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)LoggerWrapper.getLogger(WorkAction.class)), processingRequest.root.toPath(), processingRequest.file.toPath(), (File)((Params)this.getParameters()).getGlslcLocation().get())).run();
            }
        }

        public static abstract class Params
        extends ProfileAwareWorkAction.Parameters {
            public abstract DirectoryProperty getSourceFolder();

            public abstract DirectoryProperty getOutputFolder();

            public abstract Property<File> getGlslcLocation();

            public abstract ListProperty<String> getDefaultArgs();

            public abstract MapProperty<String, List<String>> getScopedArgs();

            public abstract ListProperty<ProcessingRequest> getRequests();
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<ShaderCompile, ConsumableCreationConfig> {
        public CreationAction(ConsumableCreationConfig creationConfig) {
            super(creationConfig);
        }

        @Override
        public String getName() {
            return this.computeTaskName("compile", "Shaders");
        }

        @Override
        public Class<ShaderCompile> getType() {
            return ShaderCompile.class;
        }

        @Override
        public void handleProvider(TaskProvider<ShaderCompile> taskProvider) {
            super.handleProvider(taskProvider);
            ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, ShaderCompile::getOutputDir).withName("out").on(InternalArtifactType.SHADER_ASSETS.INSTANCE);
        }

        @Override
        public void configure(ShaderCompile task) {
            super.configure(task);
            HasConfigurableValuesKt.setDisallowChanges(task.getSdkBuildService(), BuildServicesKt.getBuildService(((ConsumableCreationConfig)this.creationConfig).getServices().getBuildServiceRegistry(), SdkComponentsBuildService.class));
            HasConfigurableValuesKt.setDisallowChanges(task.getBuildToolInfoRevisionProvider(), ((ConsumableCreationConfig)this.creationConfig).getGlobal().getBuildToolsRevision());
            Properties properties = GradleLocalPropertiesKt.gradleLocalProperties(task.getProject().getRootDir(), task.getProject().getProviders());
            String shadeCompilerPath = properties.getProperty("glslc.dir");
            if (shadeCompilerPath != null) {
                DirectoryProperty directoryProperty = task.getProject().getObjects().directoryProperty();
                directoryProperty.set(new File(shadeCompilerPath));
                HasConfigurableValuesKt.setDisallowChanges(task.getShaderCompilerDirectory(), directoryProperty);
                task.getOutputs().doNotCacheIf("User wants to use custom shader compiler", t -> false);
            } else {
                this.validateCustomShaderIsSet();
                task.getShaderCompilerDirectory().disallowChanges();
            }
            ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.MERGED_SHADERS.INSTANCE, task.getSourceDir());
            ShadersCreationConfig shadersCreationConfig2 = Objects.requireNonNull(((ConsumableCreationConfig)this.creationConfig).getShadersCreationConfig());
            task.setDefaultArgs(shadersCreationConfig2.getDefaultGlslcArgs());
            task.setScopedArgs(shadersCreationConfig2.getScopedGlslcArgs());
            SdkComponentsKt.initialize(task.getNdkHandlerInput(), this.creationConfig);
        }

        private void validateCustomShaderIsSet() {
            boolean failOnShaderProperty = ((ConsumableCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.CUSTOM_SHADER_PATH_REQUIRED);
            if (failOnShaderProperty) {
                throw new IllegalStateException("Property `glslc.dir` must be set for AGP to define custom shader.");
            }
        }
    }
}

