/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.transform.bytecode;

import com.android.tools.build.jetifier.core.type.JavaType;
import com.android.tools.build.jetifier.core.type.TypesMap;
import com.android.tools.build.jetifier.core.utils.Log;
import com.android.tools.build.jetifier.processor.transform.TransformationContext;
import com.android.tools.build.jetifier.processor.transform.bytecode.CoreRemapper;
import com.android.tools.build.jetifier.processor.transform.bytecode.asm.CustomRemapper;
import java.io.File;
import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/bytecode/CoreRemapperImpl;", "Lcom/android/tools/build/jetifier/processor/transform/bytecode/CoreRemapper;", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "visitor", "Lorg/objectweb/asm/ClassVisitor;", "(Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;Lorg/objectweb/asm/ClassVisitor;)V", "<set-?>", "", "changesDone", "getChangesDone", "()Z", "setChangesDone", "(Z)V", "classRemapper", "Lorg/objectweb/asm/commons/ClassRemapper;", "getClassRemapper", "()Lorg/objectweb/asm/commons/ClassRemapper;", "typesMap", "Lcom/android/tools/build/jetifier/core/type/TypesMap;", "rewritePath", "Ljava/nio/file/Path;", "path", "rewriteString", "", "value", "rewriteType", "Lcom/android/tools/build/jetifier/core/type/JavaType;", "type", "Companion", "jetifier-processor"})
public final class CoreRemapperImpl
implements CoreRemapper {
    private final TypesMap typesMap;
    private boolean changesDone;
    @NotNull
    private final ClassRemapper classRemapper;
    private final TransformationContext context;
    @NotNull
    public static final String TAG = "CoreRemapperImpl";
    @NotNull
    private static final Set<JavaType> AMBIGUOUS_STRINGS;
    public static final Companion Companion;

    public final boolean getChangesDone() {
        return this.changesDone;
    }

    private final void setChangesDone(boolean bl) {
        this.changesDone = bl;
    }

    @NotNull
    public final ClassRemapper getClassRemapper() {
        return this.classRemapper;
    }

    @Override
    @NotNull
    public JavaType rewriteType(@NotNull JavaType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        JavaType result = this.context.getTypeRewriter().rewriteType(type);
        if (result != null) {
            this.changesDone = this.changesDone || Intrinsics.areEqual((Object)result, (Object)type) ^ true;
            return result;
        }
        this.context.reportNoMappingFoundFailure(TAG, type);
        return type;
    }

    @Override
    @NotNull
    public String rewriteString(@NotNull String value) {
        JavaType rewrittenType;
        JavaType subTypeResult;
        JavaType type;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        boolean hasDotSeparators = StringsKt.contains$default((CharSequence)value, (CharSequence)".", (boolean)false, (int)2, null);
        boolean hasSlashSeparators = StringsKt.contains$default((CharSequence)value, (CharSequence)"/", (boolean)false, (int)2, null);
        if (hasDotSeparators && hasSlashSeparators) {
            return value;
        }
        JavaType javaType = type = hasDotSeparators ? JavaType.Companion.fromDotVersion(value) : new JavaType(value);
        if (!this.context.getConfig().isEligibleForRewrite(type)) {
            return value;
        }
        if (!this.context.getAllowAmbiguousPackages() && AMBIGUOUS_STRINGS.contains(type)) {
            throw (Throwable)new IllegalArgumentException("The given artifact contains a string literal with" + " a package reference '" + value + "' that cannot be safely rewritten. Libraries " + "using reflection such as annotation processors need to be updated manually " + "to add support for androidx.");
        }
        JavaType mappedType = this.context.getConfig().getTypesMap().mapType(type);
        if (mappedType != null) {
            this.changesDone = this.changesDone || Intrinsics.areEqual((Object)mappedType, (Object)type) ^ true;
            Log.INSTANCE.i(TAG, "Map string: '%s' -> '%s'", new Object[]{type, mappedType});
            return hasDotSeparators ? mappedType.toDotNotation() : mappedType.getFullName();
        }
        if (StringsKt.contains$default((CharSequence)value, (CharSequence)".", (boolean)false, (int)2, null) && (subTypeResult = this.context.getConfig().getTypesMap().mapType(type.getParentType())) != null) {
            String result = subTypeResult.toDotNotation() + '.' + StringsKt.substringAfterLast$default((String)value, (char)'.', null, (int)2, null);
            Log.INSTANCE.i(TAG, "Map string: '%s' -> '%s' via type fallback", new Object[]{value, result});
            return result;
        }
        if (this.context.getUseFallbackIfTypeIsMissing() && (rewrittenType = this.context.getConfig().getRulesMap().rewriteType(type)) != null) {
            Log.INSTANCE.i(TAG, "Map string: '%s' -> '%s' via fallback", new Object[]{value, rewrittenType});
            return hasDotSeparators ? rewrittenType.toDotNotation() : rewrittenType.getFullName();
        }
        Log.INSTANCE.i(TAG, "Found string '%s' but failed to rewrite", new Object[]{value});
        return value;
    }

    @NotNull
    public final Path rewritePath(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"path.toFile()");
        String string = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path.toFile().path");
        String owner = StringsKt.removeSuffix((String)StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null), (CharSequence)".class");
        JavaType type = new JavaType(owner);
        JavaType result = this.context.getTypeRewriter().rewriteType(type);
        if (result == null) {
            this.context.reportNoMappingFoundFailure("PathRewrite", type);
            return path;
        }
        if (Intrinsics.areEqual((Object)result, (Object)type) ^ true) {
            this.changesDone = true;
            Path path2 = path.getFileSystem().getPath(result.getFullName() + ".class", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path.fileSystem.getPath(\u2026sult.fullName + \".class\")");
            return path2;
        }
        return path;
    }

    public CoreRemapperImpl(@NotNull TransformationContext context, @NotNull ClassVisitor visitor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        this.context = context;
        this.typesMap = this.context.getConfig().getTypesMap();
        this.classRemapper = new ClassRemapper(visitor, (Remapper)new CustomRemapper(this));
    }

    static {
        Companion = new Companion(null);
        AMBIGUOUS_STRINGS = SetsKt.setOf((Object[])new JavaType[]{JavaType.Companion.fromDotVersion("android.support.v4"), JavaType.Companion.fromDotVersion("android.support.v4.content"), JavaType.Companion.fromDotVersion("android.support.v4.widget"), JavaType.Companion.fromDotVersion("android.support.v4.view"), JavaType.Companion.fromDotVersion("android.support.v4.media"), JavaType.Companion.fromDotVersion("android.support.v13"), JavaType.Companion.fromDotVersion("android.support.v13.view"), JavaType.Companion.fromDotVersion("android.support.v13.app"), JavaType.Companion.fromDotVersion("android.support.design.widget")});
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/bytecode/CoreRemapperImpl$Companion;", "", "()V", "AMBIGUOUS_STRINGS", "", "Lcom/android/tools/build/jetifier/core/type/JavaType;", "getAMBIGUOUS_STRINGS", "()Ljava/util/Set;", "TAG", "", "jetifier-processor"})
    public static final class Companion {
        @NotNull
        public final Set<JavaType> getAMBIGUOUS_STRINGS() {
            return AMBIGUOUS_STRINGS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

