/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.transform.metainf;

import com.android.tools.build.jetifier.core.pom.PomDependency;
import com.android.tools.build.jetifier.core.pom.PomRewriteRule;
import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.transform.TransformationContext;
import com.android.tools.build.jetifier.processor.transform.Transformer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/metainf/MetaInfTransformer;", "Lcom/android/tools/build/jetifier/processor/transform/Transformer;", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "(Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;)V", "canTransform", "", "file", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "runTransform", "", "Companion", "jetifier-processor"})
public final class MetaInfTransformer
implements Transformer {
    private final TransformationContext context;
    @NotNull
    public static final String META_INF_DIR = "meta-inf";
    @NotNull
    public static final String VERSION_FILE_SUFFIX = ".version";
    @NotNull
    private static final Set<String> FILES_TO_IGNORE;
    public static final Companion Companion;

    @Override
    public boolean canTransform(@NotNull ArchiveFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.context.getRewritingSupportLib() && StringsKt.contains((CharSequence)((Object)file.getRelativePath()).toString(), (CharSequence)META_INF_DIR, (boolean)true) && StringsKt.endsWith((String)file.getFileName(), (String)VERSION_FILE_SUFFIX, (boolean)true);
    }

    @Override
    public void runTransform(@NotNull ArchiveFile file) {
        Path newPath;
        Object v1;
        Object element$iv3;
        PomDependency dependency;
        Object it;
        block13: {
            List tokens;
            block15: {
                block14: {
                    boolean bl;
                    block12: {
                        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                        if (FILES_TO_IGNORE.contains(file.getFileName())) {
                            return;
                        }
                        tokens = StringsKt.split$default((CharSequence)StringsKt.removeSuffix((String)file.getFileName(), (CharSequence)VERSION_FILE_SUFFIX), (String[])new String[]{"_"}, (boolean)false, (int)0, (int)6, null);
                        if (tokens.size() != 2) break block14;
                        Iterable $receiver$iv = tokens;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $receiver$iv) {
                                it = (String)element$iv2;
                                CharSequence charSequence = (CharSequence)it;
                                if (!(charSequence == null || charSequence.length() == 0)) continue;
                                bl = true;
                                break block12;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block15;
                }
                return;
            }
            dependency = new PomDependency((String)tokens.get(0), (String)tokens.get(1), null, null, null, null, null, null, 252, null);
            Iterable $receiver$iv = this.context.getConfig().getPomRewriteRules();
            for (Object element$iv3 : $receiver$iv) {
                PomRewriteRule it2 = (PomRewriteRule)element$iv3;
                if (!it2.matches(dependency)) continue;
                v1 = element$iv3;
                break block13;
            }
            v1 = null;
        }
        PomRewriteRule rule = v1;
        if (rule == null) {
            throw (Throwable)new IllegalArgumentException("Unsupported version file '" + file.getRelativePath() + '\'');
        }
        PomDependency result = rule.getTo().rewrite(dependency, this.context.getVersions());
        String string = result.getVersion();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        it = string;
        ArchiveFile archiveFile = file;
        element$iv3 = Charsets.UTF_8;
        Object object = it;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = ((String)object).getBytes((Charset)element$iv3);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        archiveFile.setNewData(byArray2);
        String dirPath = StringsKt.removeSuffix((String)((Object)file.getRelativePath()).toString(), (CharSequence)file.getFileName());
        String newFileName = result.getGroupId() + "_" + result.getArtifactId() + VERSION_FILE_SUFFIX;
        Path path = newPath = Paths.get(dirPath, newFileName);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"newPath");
        file.updateRelativePath(path);
    }

    public MetaInfTransformer(@NotNull TransformationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    static {
        Companion = new Companion(null);
        FILES_TO_IGNORE = SetsKt.setOf((Object[])new String[]{"androidx.car_car-cluster.version", "androidx.car_car-moderator.version", "androidx.activity_activity-ktx.version", "androidx.dynamicanimation_dynamicanimation-ktx.version"});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/metainf/MetaInfTransformer$Companion;", "", "()V", "FILES_TO_IGNORE", "", "", "getFILES_TO_IGNORE", "()Ljava/util/Set;", "META_INF_DIR", "VERSION_FILE_SUFFIX", "jetifier-processor"})
    public static final class Companion {
        @NotNull
        public final Set<String> getFILES_TO_IGNORE() {
            return FILES_TO_IGNORE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

