/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor;

import com.android.tools.build.jetifier.core.PackageMap;
import com.android.tools.build.jetifier.core.config.Config;
import com.android.tools.build.jetifier.core.pom.DependencyVersions;
import com.android.tools.build.jetifier.core.pom.DependencyVersionsMap;
import com.android.tools.build.jetifier.core.pom.PomDependency;
import com.android.tools.build.jetifier.core.pom.PomRewriteRule;
import com.android.tools.build.jetifier.core.proguard.ProGuardTypesMap;
import com.android.tools.build.jetifier.core.rule.RewriteRulesMap;
import com.android.tools.build.jetifier.core.type.TypesMap;
import com.android.tools.build.jetifier.core.utils.Log;
import com.android.tools.build.jetifier.processor.AndroidXRefScanner;
import com.android.tools.build.jetifier.processor.AnnotationFilesMerger;
import com.android.tools.build.jetifier.processor.FileMapping;
import com.android.tools.build.jetifier.processor.Processor;
import com.android.tools.build.jetifier.processor.SignatureFilesFoundJetifierException;
import com.android.tools.build.jetifier.processor.TransformationResult;
import com.android.tools.build.jetifier.processor.archive.Archive;
import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.archive.ArchiveItem;
import com.android.tools.build.jetifier.processor.archive.ArchiveItemVisitor;
import com.android.tools.build.jetifier.processor.archive.FileSearchResult;
import com.android.tools.build.jetifier.processor.com.android.tools.build.jetifier.processor.transform.java.JavaTransformer;
import com.android.tools.build.jetifier.processor.transform.TransformationContext;
import com.android.tools.build.jetifier.processor.transform.Transformer;
import com.android.tools.build.jetifier.processor.transform.bytecode.ByteCodeTransformer;
import com.android.tools.build.jetifier.processor.transform.metainf.MetaInfTransformer;
import com.android.tools.build.jetifier.processor.transform.pom.PomDocument;
import com.android.tools.build.jetifier.processor.transform.pom.PomScanner;
import com.android.tools.build.jetifier.processor.transform.proguard.ProGuardTransformer;
import com.android.tools.build.jetifier.processor.transform.resource.XmlResourcesTransformer;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u0001:\u00010B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001e\u001a\u00020\u0013J\u0016\u0010\u001f\u001a\u00020 2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J&\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\b\b\u0002\u0010%\u001a\u00020\bH\u0007J(\u0010&\u001a\u00020'2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\b\b\u0002\u0010%\u001a\u00020\b2\b\b\u0002\u0010(\u001a\u00020\bJ\u0010\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u000fH\u0002J\u0016\u0010+\u001a\u00020 2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\"0\u0005H\u0002J\u0010\u0010-\u001a\u00020 2\u0006\u0010*\u001a\u00020\u000fH\u0016J\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/build/jetifier/processor/Processor;", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveItemVisitor;", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "transformers", "", "Lcom/android/tools/build/jetifier/processor/transform/Transformer;", "stripSignatureFiles", "", "(Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;Ljava/util/List;Z)V", "newDependenciesRegex", "Lkotlin/text/Regex;", "oldDependenciesRegex", "filterOutLibrariesWithAndroidX", "", "Lcom/android/tools/build/jetifier/processor/archive/Archive;", "libraries", "getDependenciesMap", "", "", "filterOutBaseLibrary", "isNewDependencyFile", "aarOrJarFile", "Ljava/io/File;", "isOldDependencyFile", "loadLibraries", "inputLibraries", "", "Lcom/android/tools/build/jetifier/processor/FileMapping;", "mapDependency", "depNotation", "runSignatureDetectionFor", "", "scanPomFiles", "Lcom/android/tools/build/jetifier/processor/transform/pom/PomDocument;", "transform", "input", "copyUnmodifiedLibsAlso", "transform2", "Lcom/android/tools/build/jetifier/processor/TransformationResult;", "skipLibsWithAndroidXReferences", "transformLibrary", "archive", "transformPomFiles", "files", "visit", "archiveFile", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "Companion", "jetifier-processor"})
public final class Processor
implements ArchiveItemVisitor {
    private final List<Regex> oldDependenciesRegex;
    private final List<Regex> newDependenciesRegex;
    private final TransformationContext context;
    private final List<Transformer> transformers;
    private final boolean stripSignatureFiles;
    private static final String TAG = "Processor";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TransformationResult transform2(@NotNull Set<FileMapping> input, boolean copyUnmodifiedLibsAlso, boolean skipLibsWithAndroidXReferences) {
        void $this$mapTo$iv$iv;
        int n;
        File file;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Object transformer;
        Object it;
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        HashSet nonSingleFiles = new HashSet(input);
        for (FileMapping fileMapping : nonSingleFiles) {
            Object v1;
            ArchiveFile file2;
            block12: {
                Path path = fileMapping.getFrom().toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"fileMapping.from.toPath()");
                file2 = new ArchiveFile(path, FilesKt.readBytes((File)fileMapping.getFrom()));
                file2.setIsSingleFile(true);
                Iterable $this$firstOrNull$iv = this.transformers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (Transformer)element$iv;
                    boolean bl = false;
                    if (!it.canTransform(file2)) continue;
                    v1 = element$iv;
                    break block12;
                }
                v1 = null;
            }
            if ((transformer = (Transformer)v1) == null) continue;
            Path path = fileMapping.getTo().toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"fileMapping.to.toPath()");
            file2.updateRelativePath(path);
            transformer.runTransform(file2);
            nonSingleFiles.remove(fileMapping);
        }
        if (nonSingleFiles.isEmpty()) {
            return new TransformationResult(MapsKt.emptyMap(), 0);
        }
        Iterable $this$map$iv = nonSingleFiles;
        boolean $i$f$map = false;
        transformer = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (FileMapping)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            file = ((FileMapping)it).getFrom();
            collection.add(file);
        }
        Set inputLibraries = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (inputLibraries.size() != input.size()) {
            throw (Throwable)new IllegalArgumentException("Input files are duplicated!");
        }
        Set<Archive> allLibraries = this.loadLibraries((Iterable<FileMapping>)input);
        Set<Archive> librariesToProcess = skipLibsWithAndroidXReferences ? this.filterOutLibrariesWithAndroidX(allLibraries) : allLibraries;
        List<PomDocument> pomFiles = this.scanPomFiles(librariesToProcess);
        Iterable $this$forEach$iv = librariesToProcess;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Archive)element$iv;
            boolean bl = false;
            this.transformLibrary((Archive)it);
        }
        if (this.context.errorsTotal() > 0) {
            if (this.context.isInReversedMode() && this.context.getRewritingSupportLib()) {
                throw (Throwable)new IllegalArgumentException("There were " + this.context.errorsTotal() + " errors found " + "during the de-jetification. You have probably added new androidx types " + "into support library and dejetifier doesn't know where to move them. " + "Please update default.config and regenerate default.generated.config via " + "jetifier/jetifier/preprocessor/scripts/processDefaultConfig.sh");
            }
            throw (Throwable)new IllegalArgumentException("There were " + this.context.errorsTotal() + " errors found during the remapping. Check the logs for more details.");
        }
        this.transformPomFiles(pomFiles);
        this.runSignatureDetectionFor(librariesToProcess);
        Iterable $this$count$iv = librariesToProcess;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Archive it22 = (Archive)element$iv;
                boolean bl = false;
                if (!it22.getWasChanged()) continue;
                int it22 = ++count$iv;
                boolean bl2 = false;
                if (it22 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int numberOfLibsModified = n;
        Iterable $this$map$iv2 = allLibraries;
        boolean $i$f$map2 = false;
        it = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Archive archive = (Archive)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            file = it2.getWasChanged() ? TuplesKt.to((Object)it2.getRelativePath().toFile(), (Object)it2.writeSelf()) : (copyUnmodifiedLibsAlso ? TuplesKt.to((Object)it2.getRelativePath().toFile(), (Object)it2.copySelfFromOriginToTarget()) : TuplesKt.to((Object)it2.getRelativePath().toFile(), null));
            collection.add(file);
        }
        Map result = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        return new TransformationResult(result, numberOfLibsModified);
    }

    public static /* synthetic */ TransformationResult transform2$default(Processor processor, Set set, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return processor.transform2(set, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Legacy method that is missing 'skipLibsWithAndroidXReferences' attribute", replaceWith=@ReplaceWith(imports={}, expression="Processor.transform2"))
    @NotNull
    public final Set<File> transform(@NotNull Set<FileMapping> input, boolean copyUnmodifiedLibsAlso) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        Map<File, File> $this$map$iv = Processor.transform2$default(this, input, copyUnmodifiedLibsAlso, false, 4, null).getLibrariesMap();
        boolean $i$f$map = false;
        Map<File, File> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var8_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var8_8.entrySet().iterator();
        while (iterator.hasNext()) {
            File file;
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            if (it.getValue() != null) {
                Object v = it.getValue();
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                file = (File)v;
            } else {
                file = (File)it.getKey();
            }
            File file2 = file;
            collection.add(file2);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public static /* synthetic */ Set transform$default(Processor processor, Set set, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return processor.transform(set, bl);
    }

    private final Set<Archive> filterOutLibrariesWithAndroidX(Set<Archive> libraries) {
        if (this.context.isInReversedMode()) {
            return libraries;
        }
        boolean bl = false;
        Set newLibraries = new LinkedHashSet();
        Iterable $this$forEach$iv = libraries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Archive it = (Archive)element$iv;
            boolean bl2 = false;
            AndroidXRefScanner androidXScanner = new AndroidXRefScanner(it).scan();
            if (androidXScanner.getAndroidXDetected()) {
                Log.INSTANCE.i(TAG, "Library '" + it.getRelativePath() + "' contains AndroidX reference and will be " + "skipped.", new Object[0]);
                continue;
            }
            newLibraries.add(it);
        }
        return newLibraries;
    }

    /*
     * WARNING - void declaration
     */
    private final void runSignatureDetectionFor(Set<Archive> libraries) {
        boolean $i$a$-filter-Processor$runSignatureDetectionFor$22;
        Object it;
        void $this$filterTo$iv$iv;
        boolean wereSignaturesDetected = false;
        StringBuilder sb = new StringBuilder();
        Iterable $this$filter$iv = libraries;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Archive)element$iv$iv;
            $i$a$-filter-Processor$runSignatureDetectionFor$22 = false;
            if (!((Archive)it).getWasChanged()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Archive library = (Archive)element$iv;
            boolean bl = false;
            FileSearchResult foundSignatures = new FileSearchResult();
            library.findAllFiles((Function1<? super ArchiveFile, Boolean>)((Function1)runSignatureDetectionFor.2.1.INSTANCE), foundSignatures);
            it = foundSignatures.getAll();
            $i$a$-filter-Processor$runSignatureDetectionFor$22 = false;
            if (!(!it.isEmpty())) continue;
            wereSignaturesDetected = true;
            StringsKt.appendln((StringBuilder)sb);
            it = sb;
            String $i$a$-filter-Processor$runSignatureDetectionFor$22 = "Found following signature files for '" + library.getRelativePath() + "':";
            boolean bl2 = false;
            StringBuilder stringBuilder = ((StringBuilder)it).append($i$a$-filter-Processor$runSignatureDetectionFor$22);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            Iterable $this$sortedBy$iv = foundSignatures.getAll();
            boolean $i$f$sortedBy = false;
            Iterable iterable2 = $this$sortedBy$iv;
            boolean bl3 = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    ArchiveFile it = (ArchiveFile)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)((Object)it.getRelativePath()).toString());
                    it = (ArchiveFile)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = ((Object)it.getRelativePath()).toString();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            Iterable $this$forEach$iv2 = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ArchiveFile file = (ArchiveFile)element$iv2;
                boolean bl4 = false;
                StringBuilder stringBuilder2 = sb;
                String string = "- " + file.getRelativePath();
                boolean bl5 = false;
                StringBuilder stringBuilder3 = stringBuilder2.append(string);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
                file.setMarkedForRemoval(true);
            }
        }
        if (wereSignaturesDetected && !this.stripSignatureFiles) {
            throw (Throwable)new SignatureFilesFoundJetifierException("Jetifier found signature in at least one of the archives that need to be modified. However doing so would break the signatures. Please ask the library owner to provide jetpack compatible signed library. If you don't need the signatures you can re-run jetifier with 'stripSignatures' option on. Jetifier will then remove all affected signature files. Below is a list of all " + "the signatures that were discovered: " + sb + '}');
        }
    }

    @Nullable
    public final String mapDependency(@NotNull String depNotation) {
        Object v0;
        PomDependency inputDependency;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)depNotation, (String)"depNotation");
            List parts = StringsKt.split$default((CharSequence)depNotation, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            inputDependency = new PomDependency((String)parts.get(0), (String)parts.get(1), (String)parts.get(2), null, null, null, null, null, 248, null);
            Iterable $this$firstOrNull$iv = this.context.getConfig().getPomRewriteRules();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PomRewriteRule it = (PomRewriteRule)element$iv;
                boolean bl = false;
                if (!it.matches(inputDependency)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        PomRewriteRule pomRewriteRule = v0;
        if (pomRewriteRule == null) {
            return null;
        }
        PomRewriteRule resultRule = pomRewriteRule;
        return resultRule.getTo().rewrite(inputDependency, this.context.getVersions()).toStringNotation();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getDependenciesMap(boolean filterOutBaseLibrary) {
        void $this$mapTo$iv$iv;
        PomRewriteRule it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.context.getConfig().getPomRewriteRules();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PomRewriteRule)element$iv$iv;
            boolean bl = false;
            if (!(!filterOutBaseLibrary || !Intrinsics.areEqual((Object)it.getFrom().getArtifactId(), (Object)"baseLibrary") || !Intrinsics.areEqual((Object)it.getFrom().getGroupId(), (Object)"com.android.databinding"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PomRewriteRule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)this.context.getVersions().applyOnConfigPomDep(it.getFrom()).toStringNotationWithoutVersion(), (Object)this.context.getVersions().applyOnConfigPomDep(it.getTo()).toStringNotation());
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    public static /* synthetic */ Map getDependenciesMap$default(Processor processor, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return processor.getDependenciesMap(bl);
    }

    public final boolean isOldDependencyFile(@NotNull File aarOrJarFile) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)aarOrJarFile, (String)"aarOrJarFile");
            Iterable $this$any$iv = this.oldDependenciesRegex;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    String string = aarOrJarFile.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aarOrJarFile.absolutePath");
                    if (!it.matches((CharSequence)string)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isNewDependencyFile(@NotNull File aarOrJarFile) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)aarOrJarFile, (String)"aarOrJarFile");
            Iterable $this$any$iv = this.newDependenciesRegex;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    String string = aarOrJarFile.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aarOrJarFile.absolutePath");
                    if (!it.matches((CharSequence)string)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final Set<Archive> loadLibraries(Iterable<FileMapping> inputLibraries) {
        boolean bl = false;
        List libraries = new ArrayList();
        for (FileMapping library : inputLibraries) {
            if (!library.getFrom().canRead()) {
                throw (Throwable)new FileNotFoundException("Cannot open a library at '" + library + '\'');
            }
            Archive archive = Archive.Builder.extract$default(Archive.Builder.INSTANCE, library.getFrom(), false, 2, null);
            Path path = library.getTo().toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"library.to.toPath()");
            archive.setTargetPath(path);
            libraries.add(archive);
        }
        return CollectionsKt.toSet((Iterable)libraries);
    }

    private final List<PomDocument> scanPomFiles(Set<Archive> libraries) {
        PomScanner scanner = new PomScanner(this.context);
        Iterable $this$forEach$iv = libraries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Archive it = (Archive)element$iv;
            boolean bl = false;
            scanner.scanArchiveForPomFile(it);
        }
        if (scanner.wasErrorFound()) {
            throw (Throwable)new IllegalArgumentException("At least one of the libraries depends on an older version of support library. Check the logs for more details.");
        }
        return scanner.getPomFiles();
    }

    private final void transformPomFiles(List<PomDocument> files) {
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PomDocument it = (PomDocument)element$iv;
            boolean bl = false;
            it.applyRules(this.context);
            it.saveBackToFileIfNeeded();
        }
    }

    private final void transformLibrary(Archive archive) {
        Log.INSTANCE.i(TAG, "Started new transformation", new Object[0]);
        Log.INSTANCE.i(TAG, "- Input file: %s", new Object[]{archive.getRelativePath()});
        archive.accept(this);
    }

    @Override
    public void visit(@NotNull Archive archive) {
        Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
        Iterable $this$forEach$iv = archive.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArchiveItem it = (ArchiveItem)element$iv;
            boolean bl = false;
            it.accept(this);
        }
        if (this.context.isInReversedMode()) {
            AnnotationFilesMerger.INSTANCE.tryMergeFilesInArchive(archive);
        }
    }

    @Override
    public void visit(@NotNull ArchiveFile archiveFile) {
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)archiveFile, (String)"archiveFile");
            Iterable $this$firstOrNull$iv = this.transformers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Transformer it = (Transformer)element$iv;
                boolean bl = false;
                if (!it.canTransform(archiveFile)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Transformer transformer = v0;
        if (transformer == null) {
            Log.INSTANCE.v(TAG, "[Skipped] %s", new Object[]{archiveFile.getRelativePath()});
            return;
        }
        Log.INSTANCE.v(TAG, "[Applied: %s] %s", new Object[]{transformer.getClass().getSimpleName(), archiveFile.getRelativePath()});
        transformer.runTransform(archiveFile);
    }

    private Processor(TransformationContext context, List<? extends Transformer> transformers, boolean stripSignatureFiles) {
        Regex regex;
        PomRewriteRule it;
        Collection<Regex> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        this.context = context;
        this.transformers = transformers;
        this.stripSignatureFiles = stripSignatureFiles;
        Iterable iterable = this.context.getConfig().getPomRewriteRules();
        Processor processor = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PomRewriteRule pomRewriteRule = (PomRewriteRule)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append(".*");
            String string = it.getFrom().getGroupId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            regex = new Regex(stringBuilder.append(StringsKt.replace$default((String)string, (String)".", (String)"[./\\\\]", (boolean)false, (int)4, null)).append("[./\\\\]").append(it.getFrom().getArtifactId()).append("[./\\\\].*").toString());
            collection.add(regex);
        }
        collection = (List)destination$iv$iv;
        processor.oldDependenciesRegex = collection;
        $this$map$iv = this.context.getConfig().getPomRewriteRules();
        processor = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PomRewriteRule)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append(".*");
            String string = it.getTo().getGroupId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            regex = new Regex(stringBuilder.append(StringsKt.replace$default((String)string, (String)".", (String)"[./\\\\]", (boolean)false, (int)4, null)).append("[./\\\\]").append(it.getTo().getArtifactId()).append("[./\\\\].*").toString());
            collection.add(regex);
        }
        collection = (List)destination$iv$iv;
        processor.newDependenciesRegex = collection;
    }

    /* synthetic */ Processor(TransformationContext transformationContext, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(transformationContext, list, bl);
    }

    public /* synthetic */ Processor(TransformationContext context, List transformers, boolean stripSignatureFiles, DefaultConstructorMarker $constructor_marker) {
        this(context, transformers, stripSignatureFiles);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0007JD\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0007JL\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/build/jetifier/processor/Processor$Companion;", "", "()V", "TAG", "", "createProcessor", "Lcom/android/tools/build/jetifier/processor/Processor;", "config", "Lcom/android/tools/build/jetifier/core/config/Config;", "reversedMode", "", "rewritingSupportLib", "useFallbackIfTypeIsMissing", "versionSetName", "dataBindingVersion", "createProcessor2", "allowAmbiguousPackages", "createProcessor3", "stripSignatures", "createSLTransformers", "", "Lcom/android/tools/build/jetifier/processor/transform/Transformer;", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "createTransformers", "jetifier-processor"})
    public static final class Companion {
        private final List<Transformer> createTransformers(TransformationContext context) {
            return CollectionsKt.listOf((Object[])new Transformer[]{new ByteCodeTransformer(context), new XmlResourcesTransformer(context), new ProGuardTransformer(context), new JavaTransformer(context)});
        }

        private final List<Transformer> createSLTransformers(TransformationContext context) {
            return CollectionsKt.listOf((Object[])new Transformer[]{new ByteCodeTransformer(context), new XmlResourcesTransformer(context), new ProGuardTransformer(context), new MetaInfTransformer(context)});
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Processor createProcessor3(@NotNull Config config, boolean reversedMode, boolean rewritingSupportLib, boolean useFallbackIfTypeIsMissing, boolean allowAmbiguousPackages, boolean stripSignatures, @Nullable String dataBindingVersion) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            Config newConfig = config;
            DependencyVersions versionsMap = DependencyVersions.Companion.parseFromVersionSetTypeId$default((DependencyVersions.Companion)DependencyVersions.Companion, (DependencyVersionsMap)config.getVersionsMap(), null, (int)2, null).replaceVersionIfAny("newDataBindingVersion", dataBindingVersion);
            if (reversedMode) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                PomRewriteRule it;
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv;
                Iterable iterable = config.getPomRewriteRules();
                List list = config.getSlRules();
                RewriteRulesMap rewriteRulesMap = config.getRulesMap().reverse().appendRules(config.getSlRules());
                Set set = config.getRestrictToPackagePrefixes();
                Set set2 = config.getReversedRestrictToPackagePrefixes();
                boolean $i$f$filterNot = false;
                void var12_17 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it = (PomRewriteRule)element$iv$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getFrom().getArtifactId(), (Object)"uiautomator-v18")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection<PomRewriteRule> collection = (List)destination$iv$iv;
                $this$filterNot$iv = collection;
                boolean $i$f$map = false;
                $this$filterNotTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (PomRewriteRule)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    PomRewriteRule pomRewriteRule = it.getReversed();
                    collection.add(pomRewriteRule);
                }
                collection = (List)destination$iv$iv;
                TypesMap typesMap = config.getStringsMap().reverseMapOrDie();
                PackageMap packageMap = config.getPackageMap().reverse();
                DependencyVersionsMap dependencyVersionsMap = config.getVersionsMap();
                ProGuardTypesMap proGuardTypesMap = config.getProGuardMap().reverseMap();
                TypesMap typesMap2 = config.getTypesMap().reverseMapOrDie();
                Set set3 = CollectionsKt.toSet((Iterable)collection);
                List list2 = list;
                RewriteRulesMap rewriteRulesMap2 = rewriteRulesMap;
                Set set4 = set;
                Set set5 = set2;
                newConfig = new Config(set5, set4, rewriteRulesMap2, list2, set3, typesMap2, proGuardTypesMap, dependencyVersionsMap, packageMap, typesMap);
            }
            TransformationContext context = new TransformationContext(newConfig, rewritingSupportLib, reversedMode, useFallbackIfTypeIsMissing, allowAmbiguousPackages, versionsMap);
            List<Transformer> transformers = rewritingSupportLib ? this.createSLTransformers(context) : this.createTransformers(context);
            return new Processor(context, transformers, stripSignatures, null);
        }

        public static /* synthetic */ Processor createProcessor3$default(Companion companion, Config config, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                bl3 = true;
            }
            if ((n & 0x10) != 0) {
                bl4 = false;
            }
            if ((n & 0x20) != 0) {
                bl5 = false;
            }
            if ((n & 0x40) != 0) {
                string = null;
            }
            return companion.createProcessor3(config, bl, bl2, bl3, bl4, bl5, string);
        }

        @Deprecated(message="Legacy method that is missing 'throwErrorIsSignatureDetected' attribute", replaceWith=@ReplaceWith(imports={}, expression="Processor.createProcessor3"))
        @NotNull
        public final Processor createProcessor2(@NotNull Config config, boolean reversedMode, boolean rewritingSupportLib, boolean useFallbackIfTypeIsMissing, boolean allowAmbiguousPackages, @Nullable String dataBindingVersion) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            return this.createProcessor3(config, reversedMode, rewritingSupportLib, useFallbackIfTypeIsMissing, allowAmbiguousPackages, false, dataBindingVersion);
        }

        public static /* synthetic */ Processor createProcessor2$default(Companion companion, Config config, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                bl3 = true;
            }
            if ((n & 0x10) != 0) {
                bl4 = false;
            }
            if ((n & 0x20) != 0) {
                string = null;
            }
            return companion.createProcessor2(config, bl, bl2, bl3, bl4, string);
        }

        @Deprecated(message="Legacy method that is missing 'allowAmbiguousPackages' attribute and 'versionSetName' attribute is not used anymore.", replaceWith=@ReplaceWith(imports={}, expression="Processor.createProcessor3"))
        @NotNull
        public final Processor createProcessor(@NotNull Config config, boolean reversedMode, boolean rewritingSupportLib, boolean useFallbackIfTypeIsMissing, @Nullable String versionSetName, @Nullable String dataBindingVersion) {
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            return this.createProcessor2(config, reversedMode, rewritingSupportLib, useFallbackIfTypeIsMissing, false, dataBindingVersion);
        }

        public static /* synthetic */ Processor createProcessor$default(Companion companion, Config config, boolean bl, boolean bl2, boolean bl3, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                bl3 = true;
            }
            if ((n & 0x10) != 0) {
                string = null;
            }
            if ((n & 0x20) != 0) {
                string2 = null;
            }
            return companion.createProcessor(config, bl, bl2, bl3, string, string2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

