/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.transform;

import com.android.tools.build.jetifier.core.TypeRewriter;
import com.android.tools.build.jetifier.core.config.Config;
import com.android.tools.build.jetifier.core.pom.DependencyVersions;
import com.android.tools.build.jetifier.core.type.JavaType;
import com.android.tools.build.jetifier.core.utils.Log;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010*\u001a\u00020\u0013J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u001e\u00101\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u00102\u001a\u00020.2\u0006\u00103\u001a\u000204J\u0016\u00105\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0016\"\u0004\b\u0019\u0010\u001aR\u0019\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\rR\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u00066"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "", "config", "Lcom/android/tools/build/jetifier/core/config/Config;", "rewritingSupportLib", "", "isInReversedMode", "useFallbackIfTypeIsMissing", "allowAmbiguousPackages", "versions", "Lcom/android/tools/build/jetifier/core/pom/DependencyVersions;", "(Lcom/android/tools/build/jetifier/core/config/Config;ZZZZLcom/android/tools/build/jetifier/core/pom/DependencyVersions;)V", "getAllowAmbiguousPackages", "()Z", "getConfig", "()Lcom/android/tools/build/jetifier/core/config/Config;", "ignorePomVersionCheck", "getIgnorePomVersionCheck", "<set-?>", "", "mappingNotFoundFailuresCount", "getMappingNotFoundFailuresCount", "()I", "packageMappingNotFoundFailuresCounts", "getPackageMappingNotFoundFailuresCounts", "setPackageMappingNotFoundFailuresCounts", "(I)V", "packagePrefixPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getPackagePrefixPattern", "()Ljava/util/regex/Pattern;", "proGuardMappingNotFoundFailuresCount", "getProGuardMappingNotFoundFailuresCount", "getRewritingSupportLib", "typeRewriter", "Lcom/android/tools/build/jetifier/core/TypeRewriter;", "getTypeRewriter", "()Lcom/android/tools/build/jetifier/core/TypeRewriter;", "getUseFallbackIfTypeIsMissing", "getVersions", "()Lcom/android/tools/build/jetifier/core/pom/DependencyVersions;", "errorsTotal", "reportNoMappingFoundFailure", "", "tag", "", "type", "Lcom/android/tools/build/jetifier/core/type/JavaType;", "reportNoPackageMappingFoundFailure", "packageName", "filePath", "Ljava/nio/file/Path;", "reportNoProGuardMappingFoundFailure", "jetifier-processor"})
public final class TransformationContext {
    private final Pattern packagePrefixPattern;
    @NotNull
    private final TypeRewriter typeRewriter;
    private final boolean ignorePomVersionCheck = true;
    private int mappingNotFoundFailuresCount;
    private int proGuardMappingNotFoundFailuresCount;
    private int packageMappingNotFoundFailuresCounts;
    @NotNull
    private final Config config;
    private final boolean rewritingSupportLib;
    private final boolean isInReversedMode;
    private final boolean useFallbackIfTypeIsMissing;
    private final boolean allowAmbiguousPackages;
    @NotNull
    private final DependencyVersions versions;

    public final Pattern getPackagePrefixPattern() {
        return this.packagePrefixPattern;
    }

    @NotNull
    public final TypeRewriter getTypeRewriter() {
        return this.typeRewriter;
    }

    public final boolean getIgnorePomVersionCheck() {
        return this.ignorePomVersionCheck;
    }

    public final int getMappingNotFoundFailuresCount() {
        return this.mappingNotFoundFailuresCount;
    }

    public final int getProGuardMappingNotFoundFailuresCount() {
        return this.proGuardMappingNotFoundFailuresCount;
    }

    public final int getPackageMappingNotFoundFailuresCounts() {
        return this.packageMappingNotFoundFailuresCounts;
    }

    public final void setPackageMappingNotFoundFailuresCounts(int n) {
        this.packageMappingNotFoundFailuresCounts = n;
    }

    public final int errorsTotal() {
        return this.mappingNotFoundFailuresCount + this.proGuardMappingNotFoundFailuresCount + this.packageMappingNotFoundFailuresCounts;
    }

    public final void reportNoMappingFoundFailure(@NotNull String tag, @NotNull JavaType type) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (!this.useFallbackIfTypeIsMissing || this.rewritingSupportLib && this.isInReversedMode) {
            int n = this.mappingNotFoundFailuresCount;
            this.mappingNotFoundFailuresCount = n + 1;
            Log.INSTANCE.e(tag, "No mapping for: " + type, new Object[0]);
        } else {
            Log.INSTANCE.w(tag, "No mapping for: " + type, new Object[0]);
        }
    }

    public final void reportNoProGuardMappingFoundFailure(@NotNull String tag, @NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (!this.useFallbackIfTypeIsMissing || this.rewritingSupportLib && this.isInReversedMode) {
            int n = this.proGuardMappingNotFoundFailuresCount;
            this.proGuardMappingNotFoundFailuresCount = n + 1;
            Log.INSTANCE.e(tag, "No mapping for: " + type, new Object[0]);
        } else {
            Log.INSTANCE.w(tag, "No mapping for: " + type, new Object[0]);
        }
    }

    public final void reportNoPackageMappingFoundFailure(@NotNull String tag, @NotNull String packageName, @NotNull Path filePath) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        if (!this.useFallbackIfTypeIsMissing || this.rewritingSupportLib && this.isInReversedMode) {
            int n = this.packageMappingNotFoundFailuresCounts;
            this.packageMappingNotFoundFailuresCounts = n + 1;
            Log.INSTANCE.w(tag, "No mapping for package '%s' in '%s', keeping identity", new Object[]{packageName, filePath});
        } else {
            Log.INSTANCE.w(tag, "No mapping for package '%s' in '%s', keeping identity", new Object[]{packageName, filePath});
        }
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    public final boolean getRewritingSupportLib() {
        return this.rewritingSupportLib;
    }

    public final boolean isInReversedMode() {
        return this.isInReversedMode;
    }

    public final boolean getUseFallbackIfTypeIsMissing() {
        return this.useFallbackIfTypeIsMissing;
    }

    public final boolean getAllowAmbiguousPackages() {
        return this.allowAmbiguousPackages;
    }

    @NotNull
    public final DependencyVersions getVersions() {
        return this.versions;
    }

    /*
     * WARNING - void declaration
     */
    public TransformationContext(@NotNull Config config, boolean rewritingSupportLib, boolean isInReversedMode, boolean useFallbackIfTypeIsMissing, boolean allowAmbiguousPackages, @NotNull DependencyVersions versions) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)versions, (String)"versions");
        this.config = config;
        this.rewritingSupportLib = rewritingSupportLib;
        this.isInReversedMode = isInReversedMode;
        this.useFallbackIfTypeIsMissing = useFallbackIfTypeIsMissing;
        this.allowAmbiguousPackages = allowAmbiguousPackages;
        this.versions = versions;
        Iterable iterable = this.config.getRestrictToPackagePrefixes();
        StringBuilder stringBuilder = new StringBuilder().append("^(");
        TransformationContext transformationContext = this;
        boolean $i$f$map = false;
        void var9_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = '(' + (String)it + ')';
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        transformationContext.packagePrefixPattern = Pattern.compile(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null)).append(").*$").toString());
        this.typeRewriter = new TypeRewriter(this.config, this.useFallbackIfTypeIsMissing);
        this.ignorePomVersionCheck = true;
    }

    public /* synthetic */ TransformationContext(Config config, boolean bl, boolean bl2, boolean bl3, boolean bl4, DependencyVersions dependencyVersions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        if ((n & 0x20) != 0) {
            dependencyVersions = DependencyVersions.Companion.getEMPTY();
        }
        this(config, bl, bl2, bl3, bl4, dependencyVersions);
    }
}

