/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ActionRecorder {
    private final Map<XmlNode.NodeKey, Actions.DecisionTreeRecord> mRecords = new LinkedHashMap<XmlNode.NodeKey, Actions.DecisionTreeRecord>();

    synchronized void recordDefaultNodeAction(XmlElement xmlElement) {
        Actions.DecisionTreeRecord nodeDecisionTree = this.getDecisionTreeRecord(xmlElement);
        if (nodeDecisionTree.getNodeRecords().isEmpty()) {
            this.recordNodeAction(xmlElement, Actions.ActionType.ADDED);
            for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
                AttributeOperationType attributeOperation = xmlElement.getAttributeOperationType(xmlAttribute.getName());
                this.recordAttributeAction(xmlAttribute, Actions.ActionType.ADDED, attributeOperation);
            }
            for (XmlElement childNode : xmlElement.getMergeableElements()) {
                this.recordDefaultNodeAction(childNode);
            }
        }
    }

    synchronized void recordImpliedNodeAction(XmlElement xmlElement, String reason) {
        Actions.DecisionTreeRecord nodeDecisionTree = this.getDecisionTreeRecord(xmlElement);
        Actions.NodeRecord record = new Actions.NodeRecord(Actions.ActionType.IMPLIED, new SourceFilePosition(xmlElement.getDocument().getSourceFile(), xmlElement.getDocument().getRootNode().getPosition()), xmlElement.getOriginalId(), reason, xmlElement.getOperationType());
        nodeDecisionTree.addNodeRecord(record);
    }

    synchronized void recordNodeAction(XmlElement xmlElement, Actions.ActionType actionType) {
        this.recordNodeAction(xmlElement, actionType, xmlElement);
    }

    synchronized void recordNodeAction(XmlElement mergedElement, Actions.ActionType actionType, XmlElement targetElement) {
        Actions.NodeRecord record = new Actions.NodeRecord(actionType, new SourceFilePosition(targetElement.getDocument().getSourceFile(), targetElement.getPosition()), targetElement.getOriginalId(), null, mergedElement.getOperationType());
        this.recordNodeAction(mergedElement, record);
    }

    synchronized void recordNodeAction(XmlElement mergedElement, Actions.NodeRecord nodeRecord) {
        Actions.DecisionTreeRecord nodeDecisionTree = this.getDecisionTreeRecord(mergedElement);
        nodeDecisionTree.addNodeRecord(nodeRecord);
    }

    private Actions.DecisionTreeRecord getDecisionTreeRecord(XmlElement xmlElement) {
        return this.mRecords.computeIfAbsent(xmlElement.getOriginalId(), k -> new Actions.DecisionTreeRecord());
    }

    synchronized void recordAttributeAction(XmlAttribute attribute, Actions.ActionType actionType, AttributeOperationType attributeOperationType) {
        this.recordAttributeAction(attribute, attribute.getPosition(), actionType, attributeOperationType);
    }

    synchronized void recordAttributeAction(XmlAttribute attribute, SourcePosition attributePosition, Actions.ActionType actionType, AttributeOperationType attributeOperationType) {
        XmlElement originElement = attribute.getOwnerElement();
        Actions.AttributeRecord attributeRecord = new Actions.AttributeRecord(actionType, new SourceFilePosition(originElement.getDocument().getSourceFile(), attributePosition), attribute.getOriginalId(), null, attributeOperationType);
        this.recordAttributeAction(attribute, attributeRecord);
    }

    synchronized void recordAttributeAction(XmlAttribute attribute, Actions.AttributeRecord attributeRecord) {
        List<Actions.AttributeRecord> attributeRecords = this.getAttributeRecords(attribute);
        attributeRecords.add(attributeRecord);
    }

    synchronized void recordImplicitRejection(XmlAttribute attribute, XmlElement implicitAttributeOwner) {
        List<Actions.AttributeRecord> attributeRecords = this.getAttributeRecords(attribute);
        Actions.AttributeRecord attributeRecord = new Actions.AttributeRecord(Actions.ActionType.REJECTED, new SourceFilePosition(implicitAttributeOwner.getDocument().getSourceFile(), implicitAttributeOwner.getPosition()), attribute.getOriginalId(), null, AttributeOperationType.REPLACE);
        attributeRecords.add(attributeRecord);
    }

    synchronized Actions.AttributeRecord getAttributeCreationRecord(XmlAttribute attribute) {
        for (Actions.AttributeRecord attributeRecord : this.getAttributeRecords(attribute)) {
            if (attributeRecord.getActionType() != Actions.ActionType.ADDED) continue;
            return attributeRecord;
        }
        return null;
    }

    private synchronized List<Actions.AttributeRecord> getAttributeRecords(XmlAttribute attribute) {
        XmlElement originElement = attribute.getOwnerElement();
        XmlNode.NodeKey storageKey = originElement.getOriginalId();
        Actions.DecisionTreeRecord nodeDecisionTree = this.mRecords.get(storageKey);
        Preconditions.checkNotNull((Object)nodeDecisionTree, (String)"No record for key [%s]", (Object[])new Object[]{storageKey});
        List attributeRecords = nodeDecisionTree.mAttributeRecords.computeIfAbsent(attribute.getName(), k -> new ArrayList());
        return attributeRecords;
    }

    synchronized Actions build() {
        return new Actions((Map<XmlNode.NodeKey, Actions.DecisionTreeRecord>)ImmutableMap.copyOf(this.mRecords));
    }
}

