/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.Actions;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public enum ManifestSystemProperty implements ManifestMerger2.AutoAddingProperty
{
    PACKAGE{

        @Override
        public void addTo(ActionRecorder actionRecorder, XmlDocument document, String value) {
            ManifestSystemProperty.addToElement((ManifestSystemProperty)this, actionRecorder, value, document.getRootNode());
        }
    }
    ,
    VERSION_CODE{

        @Override
        public void addTo(ActionRecorder actionRecorder, XmlDocument document, String value) {
            ManifestSystemProperty.addToElementInAndroidNS((ManifestSystemProperty)this, actionRecorder, value, document.getRootNode());
        }
    }
    ,
    VERSION_NAME{

        @Override
        public void addTo(ActionRecorder actionRecorder, XmlDocument document, String value) {
            ManifestSystemProperty.addToElementInAndroidNS((ManifestSystemProperty)this, actionRecorder, value, document.getRootNode());
        }
    }
    ,
    MIN_SDK_VERSION{

        @Override
        public void addTo(ActionRecorder actionRecorder, XmlDocument document, String value) {
            ManifestSystemProperty.addToElementInAndroidNS((ManifestSystemProperty)this, actionRecorder, value, ManifestSystemProperty.createOrGetUseSdk(actionRecorder, document));
        }
    }
    ,
    TARGET_SDK_VERSION{

        @Override
        public void addTo(ActionRecorder actionRecorder, XmlDocument document, String value) {
            ManifestSystemProperty.addToElementInAndroidNS((ManifestSystemProperty)this, actionRecorder, value, ManifestSystemProperty.createOrGetUseSdk(actionRecorder, document));
        }
    }
    ,
    MAX_SDK_VERSION{

        @Override
        public void addTo(ActionRecorder actionRecorder, XmlDocument document, String value) {
            ManifestSystemProperty.addToElementInAndroidNS((ManifestSystemProperty)this, actionRecorder, value, ManifestSystemProperty.createOrGetUseSdk(actionRecorder, document));
        }
    }
    ,
    NAME{

        @Override
        public void addTo(ActionRecorder actionRecorder, XmlDocument document, String value) {
            ManifestSystemProperty.addToElementInAndroidNS((ManifestSystemProperty)this, actionRecorder, value, ManifestSystemProperty.createOrGetInstrumentation(actionRecorder, document));
        }
    }
    ,
    TARGET_PACKAGE{

        @Override
        public void addTo(ActionRecorder actionRecorder, XmlDocument document, String value) {
            ManifestSystemProperty.addToElementInAndroidNS((ManifestSystemProperty)this, actionRecorder, value, ManifestSystemProperty.createOrGetInstrumentation(actionRecorder, document));
        }
    }
    ,
    FUNCTIONAL_TEST{

        @Override
        public void addTo(ActionRecorder actionRecorder, XmlDocument document, String value) {
            ManifestSystemProperty.addToElementInAndroidNS((ManifestSystemProperty)this, actionRecorder, value, ManifestSystemProperty.createOrGetInstrumentation(actionRecorder, document));
        }
    }
    ,
    HANDLE_PROFILING{

        @Override
        public void addTo(ActionRecorder actionRecorder, XmlDocument document, String value) {
            ManifestSystemProperty.addToElementInAndroidNS((ManifestSystemProperty)this, actionRecorder, value, ManifestSystemProperty.createOrGetInstrumentation(actionRecorder, document));
        }
    }
    ,
    LABEL{

        @Override
        public void addTo(ActionRecorder actionRecorder, XmlDocument document, String value) {
            ManifestSystemProperty.addToElementInAndroidNS((ManifestSystemProperty)this, actionRecorder, value, ManifestSystemProperty.createOrGetInstrumentation(actionRecorder, document));
        }
    };


    public String toCamelCase() {
        return SdkUtils.constantNameToCamelCase((String)this.name());
    }

    private static void addToElement(ManifestSystemProperty manifestSystemProperty, ActionRecorder actionRecorder, String value, XmlElement to) {
        to.getXml().setAttribute(manifestSystemProperty.toCamelCase(), value);
        XmlAttribute xmlAttribute = new XmlAttribute(to, to.getXml().getAttributeNode(manifestSystemProperty.toCamelCase()), null);
        actionRecorder.recordNodeAction(to, Actions.ActionType.INJECTED);
        actionRecorder.recordAttributeAction(xmlAttribute, new Actions.AttributeRecord(Actions.ActionType.INJECTED, new SourceFilePosition(to.getSourceFile(), SourcePosition.UNKNOWN), xmlAttribute.getId(), null, null));
    }

    private static void addToElementInAndroidNS(ManifestSystemProperty manifestSystemProperty, ActionRecorder actionRecorder, String value, XmlElement to) {
        String toolsPrefix = ManifestSystemProperty.getAndroidPrefix(to.getXml());
        to.getXml().setAttributeNS("http://schemas.android.com/apk/res/android", toolsPrefix + ':' + manifestSystemProperty.toCamelCase(), value);
        Attr attr = to.getXml().getAttributeNodeNS("http://schemas.android.com/apk/res/android", manifestSystemProperty.toCamelCase());
        XmlAttribute xmlAttribute = new XmlAttribute(to, attr, null);
        actionRecorder.recordNodeAction(to, Actions.ActionType.INJECTED);
        actionRecorder.recordAttributeAction(xmlAttribute, new Actions.AttributeRecord(Actions.ActionType.INJECTED, new SourceFilePosition(to.getSourceFile(), SourcePosition.UNKNOWN), xmlAttribute.getId(), null, null));
    }

    private static XmlElement createOrGetUseSdk(ActionRecorder actionRecorder, XmlDocument document) {
        return ManifestSystemProperty.createOrGetElement(actionRecorder, document, ManifestModel.NodeTypes.USES_SDK, "use-sdk injection requested");
    }

    private static XmlElement createOrGetInstrumentation(ActionRecorder actionRecorder, XmlDocument document) {
        return ManifestSystemProperty.createOrGetElement(actionRecorder, document, ManifestModel.NodeTypes.INSTRUMENTATION, "instrumentation injection requested");
    }

    private static XmlElement createOrGetElement(ActionRecorder actionRecorder, XmlDocument document, ManifestModel.NodeTypes nodeType, String message) {
        Element manifest = document.getXml().getDocumentElement();
        NodeList nodes = manifest.getElementsByTagName(nodeType.toXmlName());
        if (nodes.getLength() == 0) {
            nodes = manifest.getElementsByTagNameNS("http://schemas.android.com/apk/res/android", nodeType.toXmlName());
        }
        if (nodes.getLength() == 0) {
            Element node = manifest.getOwnerDocument().createElement(nodeType.toXmlName());
            manifest.appendChild(node);
            XmlElement xmlElement = new XmlElement(node, document);
            Actions.NodeRecord nodeRecord = new Actions.NodeRecord(Actions.ActionType.INJECTED, new SourceFilePosition(xmlElement.getSourceFile(), SourcePosition.UNKNOWN), xmlElement.getId(), message, NodeOperationType.STRICT);
            actionRecorder.recordNodeAction(xmlElement, nodeRecord);
            return xmlElement;
        }
        return new XmlElement((Element)nodes.item(0), document);
    }

    private static String getAndroidPrefix(Element xml) {
        String toolsPrefix = XmlUtils.lookupNamespacePrefix((Node)xml, (String)"http://schemas.android.com/apk/res/android", (String)"android", (boolean)false);
        if (!toolsPrefix.equals("android") && xml.getOwnerDocument().getDocumentElement().getAttribute("xmlns:" + toolsPrefix) == null) {
            xml.setAttribute("xmlns:" + toolsPrefix, "http://schemas.android.com/apk/res/android");
        }
        return toolsPrefix;
    }
}

