/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.XmlNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.w3c.dom.Element;

public class OrphanXmlElement
extends XmlNode {
    private final Element mXml;
    private final ManifestModel.NodeTypes mType;

    public OrphanXmlElement(Element xml) {
        this.mXml = (Element)Preconditions.checkNotNull((Object)xml);
        String elementName = this.mXml.getNodeName();
        int indexOfColon = elementName.indexOf(58);
        ManifestModel.NodeTypes nodeType = indexOfColon != -1 ? ManifestModel.NodeTypes.fromXmlSimpleName(elementName.substring(indexOfColon + 1)) : ManifestModel.NodeTypes.fromXmlSimpleName(elementName);
        this.mType = nodeType;
    }

    public boolean isA(ManifestModel.NodeTypes type) {
        return this.mType == type;
    }

    @Override
    public Element getXml() {
        return this.mXml;
    }

    @Override
    public XmlNode.NodeKey getId() {
        return new XmlNode.NodeKey(Strings.isNullOrEmpty((String)this.getKey()) ? this.getName().toString() : this.getName().toString() + "#" + this.getKey());
    }

    @Override
    public XmlNode.NodeName getName() {
        return XmlNode.unwrapName(this.mXml);
    }

    public ManifestModel.NodeTypes getType() {
        return this.mType;
    }

    public String getKey() {
        return this.mType.getNodeKeyResolver().getKey(this.mXml);
    }

    @Override
    public SourcePosition getPosition() {
        return SourcePosition.UNKNOWN;
    }

    @Override
    public SourceFile getSourceFile() {
        return SourceFile.UNKNOWN;
    }
}

