/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.Actions;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class MergingReport {
    private final Map<MergedManifestKind, String> mergedDocuments;
    private final Map<MergedManifestKind, XmlDocument> mergedXmlDocuments;
    private final Result result;
    private final ImmutableList<Record> records;
    private final ImmutableList<String> intermediaryStages;
    private final Actions actions;
    private final String packageName;

    private MergingReport(Map<MergedManifestKind, String> mergedDocuments, Map<MergedManifestKind, XmlDocument> mergedXmlDocuments, Result result, ImmutableList<Record> records, ImmutableList<String> intermediaryStages, Actions actions, String packageName) {
        this.mergedDocuments = mergedDocuments;
        this.mergedXmlDocuments = mergedXmlDocuments;
        this.result = result;
        this.records = records;
        this.intermediaryStages = intermediaryStages;
        this.actions = actions;
        this.packageName = packageName;
    }

    public void log(ILogger logger) {
        block5: for (Record record : this.records) {
            switch (record.mSeverity) {
                case WARNING: {
                    logger.warning(record.toString(), new Object[0]);
                    continue block5;
                }
                case ERROR: {
                    logger.error(null, record.toString(), new Object[0]);
                    continue block5;
                }
                case INFO: {
                    logger.verbose(record.toString(), new Object[0]);
                    continue block5;
                }
            }
            logger.error(null, "Unhandled record type " + (Object)((Object)record.mSeverity), new Object[0]);
        }
        this.actions.log(logger);
        if (!this.result.isSuccess()) {
            logger.warning("\nSee http://g.co/androidstudio/manifest-merger for more information about the manifest merger.\n", new Object[0]);
        }
    }

    public String getMergedDocument(MergedManifestKind state) {
        return this.mergedDocuments.get((Object)state);
    }

    public XmlDocument getMergedXmlDocument(MergedManifestKind state) {
        return this.mergedXmlDocuments.get((Object)state);
    }

    public ImmutableList<String> getIntermediaryStages() {
        return this.intermediaryStages;
    }

    public Result getResult() {
        return this.result;
    }

    public ImmutableList<Record> getLoggingRecords() {
        return this.records;
    }

    public Actions getActions() {
        return this.actions;
    }

    public String getReportString() {
        switch (this.result) {
            case SUCCESS: {
                return "Manifest merger executed successfully";
            }
            case WARNING: {
                return this.records.size() > 1 ? "Manifest merger exited with warnings, see logs" : "Manifest merger warning : " + ((Record)this.records.get(0)).mLog;
            }
            case ERROR: {
                return this.records.size() > 1 ? "Manifest merger failed with multiple errors, see logs" : "Manifest merger failed : " + ((Record)this.records.get(0)).mLog;
            }
        }
        return "Manifest merger returned an invalid result " + (Object)((Object)this.result);
    }

    public String getPackageName() {
        return this.packageName;
    }

    @VisibleForTesting
    public static class Builder {
        private Map<MergedManifestKind, String> mergedDocuments = new EnumMap<MergedManifestKind, String>(MergedManifestKind.class);
        private Map<MergedManifestKind, XmlDocument> mergedXmlDocuments = new EnumMap<MergedManifestKind, XmlDocument>(MergedManifestKind.class);
        private ImmutableList.Builder<Record> mRecordBuilder = new ImmutableList.Builder();
        private ImmutableList.Builder<String> mIntermediaryStages = new ImmutableList.Builder();
        private boolean mHasWarnings = false;
        private boolean mHasErrors = false;
        private ActionRecorder mActionRecorder = new ActionRecorder();
        private final ILogger mLogger;
        private String packageName;

        Builder(ILogger logger) {
            this.mLogger = logger;
        }

        Builder setMergedDocument(MergedManifestKind mergedManifestKind, String mergedDocument) {
            this.mergedDocuments.put(mergedManifestKind, mergedDocument);
            return this;
        }

        Builder setMergedXmlDocument(MergedManifestKind mergedManifestKind, XmlDocument mergedDocument) {
            this.mergedXmlDocuments.put(mergedManifestKind, mergedDocument);
            return this;
        }

        @VisibleForTesting
        Builder addMessage(SourceFile sourceFile, int line, int column, Record.Severity severity, String message) {
            return this.addMessage(new SourceFilePosition(sourceFile, new SourcePosition(line - 1, column - 1, -1)), severity, message);
        }

        Builder addMessage(SourceFile sourceFile, Record.Severity severity, String message) {
            return this.addMessage(new SourceFilePosition(sourceFile, SourcePosition.UNKNOWN), severity, message);
        }

        void addMessage(XmlElement element, Record.Severity severity, String message) {
            this.addMessage(element.getSourceFilePosition(), severity, message);
        }

        Builder addMessage(XmlAttribute attribute, Record.Severity severity, String message) {
            return this.addMessage(attribute, attribute.getPosition(), severity, message);
        }

        Builder addMessage(XmlAttribute attribute, SourcePosition position, Record.Severity severity, String message) {
            return this.addMessage(new SourceFilePosition(attribute.getOwnerElement().getDocument().getSourceFile(), position), severity, message);
        }

        Builder addMessage(SourceFilePosition sourceFilePosition, Record.Severity severity, String message) {
            switch (severity) {
                case ERROR: {
                    this.mHasErrors = true;
                    break;
                }
                case WARNING: {
                    this.mHasWarnings = true;
                }
            }
            this.mRecordBuilder.add((Object)new Record(sourceFilePosition, severity, message));
            return this;
        }

        Builder addMergingStage(String xml) {
            this.mIntermediaryStages.add((Object)xml);
            return this;
        }

        boolean hasErrors() {
            return this.mHasErrors;
        }

        ActionRecorder getActionRecorder() {
            return this.mActionRecorder;
        }

        MergingReport build() {
            Result result = this.mHasErrors ? Result.ERROR : (this.mHasWarnings ? Result.WARNING : Result.SUCCESS);
            return new MergingReport(this.mergedDocuments, this.mergedXmlDocuments, result, this.mRecordBuilder.build(), this.mIntermediaryStages.build(), this.mActionRecorder.build(), this.packageName);
        }

        public ILogger getLogger() {
            return this.mLogger;
        }

        public String blame(XmlDocument document) throws ParserConfigurationException, SAXException, IOException {
            return this.mActionRecorder.build().blame(document);
        }

        public void setFinalPackageName(String finalPackageName) {
            this.packageName = finalPackageName;
        }
    }

    public static class Record {
        private final Severity mSeverity;
        private final String mLog;
        private final SourceFilePosition mSourceLocation;

        private Record(SourceFilePosition sourceLocation, Severity severity, String mLog) {
            this.mSourceLocation = sourceLocation;
            this.mSeverity = severity;
            this.mLog = mLog;
        }

        public Severity getSeverity() {
            return this.mSeverity;
        }

        public String getMessage() {
            return this.mLog;
        }

        public SourceFilePosition getSourceLocation() {
            return this.mSourceLocation;
        }

        public String toString() {
            return this.mSourceLocation.toString() + " " + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.mSeverity.toString()) + ":\n\t" + this.mLog;
        }

        public static enum Severity {
            WARNING,
            ERROR,
            INFO;

        }
    }

    public static enum Result {
        SUCCESS,
        WARNING,
        ERROR;


        public boolean isSuccess() {
            return this == SUCCESS || this == WARNING;
        }

        public boolean isWarning() {
            return this == WARNING;
        }

        public boolean isError() {
            return this == ERROR;
        }
    }

    public static enum MergedManifestKind {
        MERGED,
        INSTANT_RUN,
        AAPT_SAFE,
        BLAME,
        BUNDLE,
        METADATA_FEATURE,
        INSTANT_APP;

    }
}

