/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.PlaceholderHandler;
import java.util.regex.Matcher;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlaceholderEncoder {
    public static void visit(Document document) {
        PlaceholderEncoder.visit(document.getDocumentElement());
    }

    private static void visit(Element element) {
        NamedNodeMap elementAttributes = element.getAttributes();
        for (int i = 0; i < elementAttributes.getLength(); ++i) {
            Node attribute = elementAttributes.item(i);
            PlaceholderEncoder.handleAttribute((Attr)attribute);
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            PlaceholderEncoder.visit((Element)childNode);
        }
    }

    private static void handleAttribute(Attr attr) {
        Matcher matcher = PlaceholderHandler.PATTERN.matcher(attr.getValue());
        if (matcher.matches()) {
            String encodedValue = matcher.group(1) + "dollar_openBracket_" + matcher.group(2) + "_closeBracket" + matcher.group(3);
            attr.setValue(encodedValue);
        }
    }
}

