/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.SdkConstants;
import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.DocumentModel;
import com.android.manifmerger.ElementsTrimmer;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NavGraphExpander;
import com.android.manifmerger.NavigationXmlDocument;
import com.android.manifmerger.NavigationXmlDocumentData;
import com.android.manifmerger.NavigationXmlLoader;
import com.android.manifmerger.PlaceholderEncoder;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.PostValidator;
import com.android.manifmerger.PreValidator;
import com.android.manifmerger.ToolsInstructionsCleaner;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlLoader;
import com.android.manifmerger.XmlNode;
import com.android.sdklib.SdkVersionInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestMerger2 {
    public static final String COMPATIBLE_SCREENS_SUB_MANIFEST = "Compatible-Screens sub-manifest";
    public static final String WEAR_APP_SUB_MANIFEST = "Wear App sub-manifest";
    private static final String SPLIT_IN_DYNAMIC_FEATURE = "https://d.android.com/r/studio-ui/dynamic-delivery/dynamic-feature-manifest";
    private static final List<String> ALLOWED_NON_UNIQUE_PACKAGE_NAMES = ImmutableList.of((Object)"androidx.test");
    private final File mManifestFile;
    private final Map<String, Object> mPlaceHolderValues;
    private final PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> mSystemPropertyResolver;
    private final ILogger mLogger;
    private final ImmutableList<Pair<String, File>> mLibraryFiles;
    private final ImmutableList<File> mFlavorsAndBuildTypeFiles;
    private final ImmutableList<Invoker.Feature> mOptionalFeatures;
    private final MergeType mMergeType;
    private final XmlDocument.Type mDocumentType;
    private final Optional<File> mReportFile;
    private final String mFeatureName;
    private final FileStreamProvider mFileStreamProvider;
    private final ImmutableList<File> mNavigationFiles;
    private final ImmutableList<File> mNavigationJsons;
    private final DocumentModel<ManifestModel.NodeTypes> mModel;
    private final ImmutableList<String> mDependencyFeatureNames;

    private ManifestMerger2(ILogger logger, File mainManifestFile, ImmutableList<Pair<String, File>> libraryFiles, ImmutableList<File> flavorsAndBuildTypeFiles, ImmutableList<Invoker.Feature> optionalFeatures, Map<String, Object> placeHolderValues, PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> systemPropertiesResolver, MergeType mergeType, XmlDocument.Type documentType, Optional<File> reportFile, String featureName, FileStreamProvider fileStreamProvider, ImmutableList<File> navigationFiles, ImmutableList<File> navigationJsons, ImmutableList<String> dependencyFeatureNames) {
        this.mSystemPropertyResolver = systemPropertiesResolver;
        this.mPlaceHolderValues = placeHolderValues;
        this.mManifestFile = mainManifestFile;
        this.mLogger = logger;
        this.mLibraryFiles = libraryFiles;
        this.mFlavorsAndBuildTypeFiles = flavorsAndBuildTypeFiles;
        this.mOptionalFeatures = optionalFeatures;
        this.mMergeType = mergeType;
        this.mDocumentType = documentType;
        this.mReportFile = reportFile;
        this.mFeatureName = featureName;
        this.mFileStreamProvider = fileStreamProvider;
        this.mNavigationFiles = navigationFiles;
        this.mNavigationJsons = navigationJsons;
        this.mDependencyFeatureNames = dependencyFeatureNames;
        this.mModel = new ManifestModel(this.mOptionalFeatures.contains((Object)Invoker.Feature.HANDLE_VALUE_CONFLICTS_AUTOMATICALLY));
    }

    private MergingReport merge() throws MergeFailureException {
        String targetSdkVersion;
        int targetSdkApi;
        Object mainManifestPackageName;
        MergingReport.Builder mergingReportBuilder = new MergingReport.Builder(this.mLogger);
        SelectorResolver selectors = new SelectorResolver();
        LoadedManifestInfo loadedMainManifestInfo = this.load(new ManifestInfo(this.mManifestFile.getName(), this.mManifestFile, this.mDocumentType, null), selectors, mergingReportBuilder);
        Optional<XmlAttribute> mainPackageAttribute = loadedMainManifestInfo.getXmlDocument().getPackage();
        if (!this.mPlaceHolderValues.containsKey("packageName") && this.mDocumentType != XmlDocument.Type.OVERLAY && !mainPackageAttribute.isPresent()) {
            mergingReportBuilder.addMessage(loadedMainManifestInfo.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, String.format("Main AndroidManifest.xml at %1$s manifest:package attribute is not declared", loadedMainManifestInfo.getXmlDocument().getSourceFile().print(true)));
            return mergingReportBuilder.build();
        }
        if (!this.mFeatureName.isEmpty()) {
            loadedMainManifestInfo = ManifestMerger2.removeDynamicFeatureManifestSplitAttributeIfSpecified(loadedMainManifestInfo, mergingReportBuilder);
        }
        List<LoadedManifestInfo> loadedLibraryDocuments = this.loadLibraries(selectors, mergingReportBuilder, mainPackageAttribute.map(XmlAttribute::getValue).orElse(null));
        ManifestMerger2.checkUniquePackageName(loadedMainManifestInfo, loadedLibraryDocuments, mergingReportBuilder, this.mOptionalFeatures.contains((Object)Invoker.Feature.ENFORCE_UNIQUE_PACKAGE_NAME));
        this.performSystemPropertiesInjection(mergingReportBuilder, loadedMainManifestInfo.getXmlDocument());
        loadedMainManifestInfo = new LoadedManifestInfo(loadedMainManifestInfo, loadedMainManifestInfo.getOriginalPackageName(), loadedMainManifestInfo.getXmlDocument().reparse());
        XmlDocument xmlDocumentOptional = null;
        for (File inputFile : this.mFlavorsAndBuildTypeFiles) {
            this.mLogger.verbose("Merging flavors and build manifest %s \n", new Object[]{inputFile.getPath()});
            LoadedManifestInfo overlayDocument = this.load(new ManifestInfo(null, inputFile, XmlDocument.Type.OVERLAY, mainPackageAttribute.map(XmlAttribute::getValue).orElse(null)), selectors, mergingReportBuilder);
            if (!this.mFeatureName.isEmpty()) {
                overlayDocument = ManifestMerger2.removeDynamicFeatureManifestSplitAttributeIfSpecified(overlayDocument, mergingReportBuilder);
            }
            Optional<XmlAttribute> packageAttribute = overlayDocument.getXmlDocument().getPackage();
            if (loadedMainManifestInfo.getOriginalPackageName().isPresent() && packageAttribute.isPresent() && !loadedMainManifestInfo.getOriginalPackageName().get().equals(packageAttribute.get().getValue())) {
                String message = this.mMergeType == MergeType.APPLICATION ? String.format("Overlay manifest:package attribute declared at %1$s value=(%2$s)\n\thas a different value=(%3$s) declared in main manifest at %4$s\n\tSuggestion: remove the overlay declaration at %5$s \tand place it in the build.gradle:\n\t\tflavorName {\n\t\t\tapplicationId = \"%2$s\"\n\t\t}", packageAttribute.get().printPosition(), packageAttribute.get().getValue(), mainPackageAttribute.get().getValue(), mainPackageAttribute.get().printPosition(), packageAttribute.get().getSourceFile().print(true)) : String.format("Overlay manifest:package attribute declared at %1$s value=(%2$s)\n\thas a different value=(%3$s) declared in main manifest at %4$s", packageAttribute.get().printPosition(), packageAttribute.get().getValue(), mainPackageAttribute.get().getValue(), mainPackageAttribute.get().printPosition());
                mergingReportBuilder.addMessage(overlayDocument.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, message);
                return mergingReportBuilder.build();
            }
            if (mainPackageAttribute.isPresent()) {
                overlayDocument.getXmlDocument().getRootNode().getXml().setAttribute("package", mainPackageAttribute.get().getValue());
            }
            Optional<XmlDocument> newMergedDocument = this.merge(xmlDocumentOptional, overlayDocument, mergingReportBuilder);
            xmlDocumentOptional = newMergedDocument.orElse(null);
            if (newMergedDocument.isPresent()) continue;
            return mergingReportBuilder.build();
        }
        this.mLogger.verbose("Merging main manifest %s\n", new Object[]{this.mManifestFile.getPath()});
        Optional<XmlDocument> newMergedDocument = this.merge(xmlDocumentOptional, loadedMainManifestInfo, mergingReportBuilder);
        if (!newMergedDocument.isPresent()) {
            return mergingReportBuilder.build();
        }
        xmlDocumentOptional = newMergedDocument.get();
        if (this.mMergeType == MergeType.LIBRARY && !Strings.isNullOrEmpty((String)(mainManifestPackageName = loadedMainManifestInfo.getXmlDocument().getRootNode().getXml().getAttribute("package")))) {
            xmlDocumentOptional.getRootNode().getXml().setAttribute("package", (String)mainManifestPackageName);
        }
        for (LoadedManifestInfo libraryDocument : loadedLibraryDocuments) {
            this.mLogger.verbose("Merging library manifest " + libraryDocument.getLocation(), new Object[0]);
            newMergedDocument = this.merge(xmlDocumentOptional, libraryDocument, mergingReportBuilder);
            if (!newMergedDocument.isPresent()) {
                return mergingReportBuilder.build();
            }
            xmlDocumentOptional = newMergedDocument.get();
        }
        if (this.mMergeType == MergeType.APPLICATION) {
            Map<String, NavigationXmlDocument> loadedNavigationMap = this.createNavigationMap();
            xmlDocumentOptional = NavGraphExpander.INSTANCE.expandNavGraphs(xmlDocumentOptional, loadedNavigationMap, mergingReportBuilder);
        }
        if (mergingReportBuilder.hasErrors()) {
            return mergingReportBuilder.build();
        }
        ElementsTrimmer.trim(xmlDocumentOptional, mergingReportBuilder);
        if (mergingReportBuilder.hasErrors()) {
            return mergingReportBuilder.build();
        }
        if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT)) {
            MergingReport.Record.Severity severity = this.mMergeType == MergeType.LIBRARY ? MergingReport.Record.Severity.INFO : MergingReport.Record.Severity.ERROR;
            this.performPlaceHolderSubstitution(loadedMainManifestInfo, xmlDocumentOptional, mergingReportBuilder, severity);
            if (mergingReportBuilder.hasErrors()) {
                return mergingReportBuilder.build();
            }
        }
        this.performSystemPropertiesInjection(mergingReportBuilder, xmlDocumentOptional);
        XmlDocument finalMergedDocument = xmlDocumentOptional;
        Optional<XmlAttribute> packageAttr = finalMergedDocument.getPackage();
        if (this.mMergeType != MergeType.LIBRARY && packageAttr.isPresent()) {
            XmlAttribute packageNameAttribute = packageAttr.get();
            String packageName = packageNameAttribute.getValue();
            if (!(this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT) && PlaceholderHandler.isPlaceHolder(packageName) || packageName.contains("."))) {
                mergingReportBuilder.addMessage(loadedMainManifestInfo.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, String.format("Package name '%1$s' at position %2$s should contain at least one '.' (dot) character", packageName, packageNameAttribute.printPosition()));
                return mergingReportBuilder.build();
            }
        }
        int n = targetSdkApi = Character.isDigit((targetSdkVersion = finalMergedDocument.getTargetSdkVersion()).charAt(0)) ? Integer.parseInt(targetSdkVersion) : SdkVersionInfo.getApiByPreviewName((String)targetSdkVersion, (boolean)true);
        if (targetSdkApi > 30) {
            NodeList activityList = finalMergedDocument.getXml().getElementsByTagName("activity");
            this.checkIfExportedIsNeeded(activityList, mergingReportBuilder, loadedMainManifestInfo);
            if (mergingReportBuilder.hasErrors()) {
                return mergingReportBuilder.build();
            }
            NodeList serviceList = finalMergedDocument.getXml().getElementsByTagName("service");
            this.checkIfExportedIsNeeded(serviceList, mergingReportBuilder, loadedMainManifestInfo);
            if (mergingReportBuilder.hasErrors()) {
                return mergingReportBuilder.build();
            }
            NodeList receiverList = finalMergedDocument.getXml().getElementsByTagName("receiver");
            this.checkIfExportedIsNeeded(receiverList, mergingReportBuilder, loadedMainManifestInfo);
            if (mergingReportBuilder.hasErrors()) {
                return mergingReportBuilder.build();
            }
        }
        if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.REMOVE_TOOLS_DECLARATIONS)) {
            PostValidator.enforceToolsNamespaceDeclaration(finalMergedDocument);
        }
        finalMergedDocument.originalNodeOperation.forEach((k, v) -> k.setAttributeNS("http://schemas.android.com/tools", "tools:node", v.toXmlName()));
        PostValidator.validate(finalMergedDocument, mergingReportBuilder);
        if (mergingReportBuilder.hasErrors()) {
            mergingReportBuilder.addMessage(finalMergedDocument.getRootNode(), MergingReport.Record.Severity.WARNING, "Post merge validation failed");
        }
        finalMergedDocument.clearNodeNamespaces();
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.EXTRACT_FQCNS)) {
            ManifestMerger2.extractFqcns(finalMergedDocument);
        }
        this.processOptionalFeatures(finalMergedDocument.getXml(), mergingReportBuilder);
        if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.SKIP_BLAME)) {
            try {
                mergingReportBuilder.setMergedDocument(MergingReport.MergedManifestKind.BLAME, mergingReportBuilder.blame(finalMergedDocument));
            }
            catch (Exception e) {
                this.mLogger.error((Throwable)e, "Error while saving blame file, build will continue", new Object[0]);
            }
        }
        mergingReportBuilder.setFinalPackageName(finalMergedDocument.getPackageName());
        mergingReportBuilder.setMergedXmlDocument(finalMergedDocument);
        MergingReport mergingReport = mergingReportBuilder.build();
        if (this.mReportFile.isPresent()) {
            this.writeReport(mergingReport);
        }
        return mergingReport;
    }

    private Map<String, NavigationXmlDocument> createNavigationMap() throws MergeFailureException {
        HashMap<String, NavigationXmlDocument> loadedNavigationMap = new HashMap<String, NavigationXmlDocument>();
        for (File navigationFile : this.mNavigationFiles) {
            String navigationId = navigationFile.getName().replaceAll("\\.xml$", "");
            if (loadedNavigationMap.get(navigationId) != null) continue;
            try {
                InputStream inputStream = this.mFileStreamProvider.getInputStream(navigationFile);
                try {
                    loadedNavigationMap.put(navigationId, NavigationXmlLoader.INSTANCE.load(navigationId, navigationFile, inputStream));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception e) {
                throw new MergeFailureException(e);
            }
        }
        Gson gson = new GsonBuilder().create();
        for (File navigationJson : this.mNavigationJsons) {
            try {
                NavigationXmlDocumentData[] navDatas;
                String jsonText = FileUtils.loadFileWithUnixLineSeparators((File)navigationJson);
                for (NavigationXmlDocumentData navData : navDatas = (NavigationXmlDocumentData[])gson.fromJson(jsonText, NavigationXmlDocumentData[].class)) {
                    String navigationId = navData.getName();
                    if (loadedNavigationMap.get(navigationId) != null) {
                        this.mLogger.info("Navigation file %s from %s is ignored (skipped).", new Object[]{navigationId, navigationJson});
                        continue;
                    }
                    loadedNavigationMap.put(navigationId, new NavigationXmlDocument(navData));
                }
            }
            catch (IOException e) {
                throw new MergeFailureException(e);
            }
        }
        return loadedNavigationMap;
    }

    private static LoadedManifestInfo removeDynamicFeatureManifestSplitAttributeIfSpecified(LoadedManifestInfo dynamicFeatureManifest, MergingReport.Builder mergingReportBuilder) {
        Optional<XmlAttribute> splitAttribute = dynamicFeatureManifest.getXmlDocument().getRootNode().getAttribute(XmlNode.fromXmlName("split"));
        if (splitAttribute.isPresent()) {
            String message = String.format("Attribute '%1$s' was removed from %2$s.\nThe Android Gradle plugin includes it for you when building your project.\nSee %3$s for details.", "split", splitAttribute.get().printPosition(), SPLIT_IN_DYNAMIC_FEATURE);
            mergingReportBuilder.addMessage(dynamicFeatureManifest.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.WARNING, message);
            dynamicFeatureManifest.getXmlDocument().getXml().getDocumentElement().removeAttribute("split");
            return new LoadedManifestInfo(dynamicFeatureManifest, dynamicFeatureManifest.getOriginalPackageName(), dynamicFeatureManifest.getXmlDocument().reparse());
        }
        return dynamicFeatureManifest;
    }

    private void processOptionalFeatures(Document document, MergingReport.Builder mergingReport) throws MergeFailureException {
        if (document == null) {
            return;
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.REMOVE_TOOLS_DECLARATIONS)) {
            ToolsInstructionsCleaner.cleanToolsReferences(this.mMergeType, document, this.mLogger);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADVANCED_PROFILING)) {
            ManifestMerger2.addInternetPermission(document);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.TEST_ONLY)) {
            ManifestMerger2.addTestOnlyAttribute(document);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.DEBUGGABLE)) {
            ManifestMerger2.addDebuggableAttribute(document);
        }
        if (this.mMergeType == MergeType.APPLICATION) {
            ManifestMerger2.optionalAddApplicationTagIfMissing(document);
        }
        if (this.mMergeType == MergeType.APPLICATION && this.mOptionalFeatures.contains((Object)Invoker.Feature.DO_NOT_EXTRACT_NATIVE_LIBS)) {
            ManifestMerger2.maybeAddExtractNativeLibAttribute(document);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADD_ANDROIDX_MULTIDEX_APPLICATION_IF_NO_NAME)) {
            ManifestMerger2.addMultiDexApplicationIfNoName(document, SdkConstants.MULTI_DEX_APPLICATION.newName());
        } else if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADD_SUPPORT_MULTIDEX_APPLICATION_IF_NO_NAME)) {
            ManifestMerger2.addMultiDexApplicationIfNoName(document, SdkConstants.MULTI_DEX_APPLICATION.oldName());
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADD_DYNAMIC_FEATURE_ATTRIBUTES)) {
            ManifestMerger2.addFeatureSplitAttribute(document, this.mFeatureName);
            ManifestMerger2.adjustInstantAppFeatureSplitInfo(document, this.mFeatureName);
            ManifestMerger2.addUsesSplitTagsForDependencies(document, this.mDependencyFeatureNames);
        }
        mergingReport.setMergedDocument(MergingReport.MergedManifestKind.MERGED, ManifestMerger2.prettyPrint(document));
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.MAKE_AAPT_SAFE)) {
            ManifestMerger2.createAaptSafeManifest(document, mergingReport);
        }
    }

    private static void createAaptSafeManifest(Document document, MergingReport.Builder mergingReport) throws MergeFailureException {
        Document clonedDocument = ManifestMerger2.cloneDocument(document);
        PlaceholderEncoder.visit(clonedDocument);
        ManifestMerger2.removeNavGraphs(clonedDocument);
        mergingReport.setMergedDocument(MergingReport.MergedManifestKind.AAPT_SAFE, ManifestMerger2.prettyPrint(clonedDocument));
    }

    private static void addTestOnlyAttribute(Document document) {
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (!applicationElements.isEmpty()) {
            Element application = (Element)applicationElements.get(0);
            ManifestMerger2.setAndroidAttribute(application, "testOnly", "true");
        }
    }

    private static void addDebuggableAttribute(Document document) {
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (!applicationElements.isEmpty()) {
            Element application = (Element)applicationElements.get(0);
            ManifestMerger2.setAndroidAttribute(application, "debuggable", "true");
        }
    }

    private static void addMultiDexApplicationIfNoName(Document document, String multiDexApplicationName) {
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (!applicationElements.isEmpty()) {
            Element application = (Element)applicationElements.get(0);
            ManifestMerger2.setAndroidAttributeIfMissing(application, "name", multiDexApplicationName);
        }
    }

    private static void maybeAddExtractNativeLibAttribute(Document document) {
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (!applicationElements.isEmpty()) {
            Element application = (Element)applicationElements.get(0);
            ManifestMerger2.setAndroidAttributeIfMissing(application, "extractNativeLibs", "false");
        }
    }

    private static void addFeatureSplitAttribute(Document document, String featureName) {
        Element manifest = document.getDocumentElement();
        if (manifest == null) {
            return;
        }
        String attributeName = "featureSplit";
        manifest.setAttribute(attributeName, featureName);
    }

    private static void adjustInstantAppFeatureSplitInfo(Document document, String featureName) {
        Element manifest = document.getDocumentElement();
        if (manifest == null) {
            return;
        }
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (applicationElements.isEmpty()) {
            return;
        }
        Element application = (Element)applicationElements.get(0);
        List<String> elementNamesToUpdate = Arrays.asList("activity", "service", "provider");
        for (String elementName : elementNamesToUpdate) {
            for (Element elementToUpdate : ManifestMerger2.getChildElementsByName(application, elementName)) {
                ManifestMerger2.setAndroidAttribute(elementToUpdate, "splitName", featureName);
            }
        }
    }

    public static String setManifestAndroidAttribute(Document document, String attribute, String value) {
        Element manifest = document.getDocumentElement();
        if (manifest == null) {
            return null;
        }
        String previousValue = manifest.hasAttributeNS("http://schemas.android.com/apk/res/android", attribute) ? manifest.getAttributeNS("http://schemas.android.com/apk/res/android", attribute) : null;
        ManifestMerger2.setAndroidAttribute(manifest, attribute, value);
        return previousValue;
    }

    private static void addInternetPermission(Document document) {
        String permission = "android.permission.INTERNET";
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> usesPermissions = ManifestMerger2.getChildElementsByName(manifest, "uses-permission");
        for (Element usesPermission : usesPermissions) {
            if (!permission.equals(usesPermission.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return;
        }
        Element uses = document.createElement("uses-permission");
        document.getDocumentElement().appendChild(uses);
        ManifestMerger2.setAndroidAttribute(uses, "name", permission);
    }

    private static void addUsesSplitTagsForDependencies(Document document, ImmutableList<String> dependencyFeatureNames) {
        Element manifest = document.getDocumentElement();
        for (String usedSplitName : dependencyFeatureNames) {
            Element usesSplit = document.createElement("uses-split");
            ManifestMerger2.setAndroidAttribute(usesSplit, "name", usedSplitName);
            manifest.appendChild(usesSplit);
        }
    }

    private static void optionalAddApplicationTagIfMissing(Document document) {
        Element manifest = document.getDocumentElement();
        if (manifest.getElementsByTagName("application").getLength() > 0) {
            return;
        }
        Element application = document.createElement("application");
        manifest.appendChild(application);
    }

    private static void removeAndroidAttribute(Element node, String localName) {
        node.removeAttributeNS("http://schemas.android.com/apk/res/android", localName);
    }

    public static void setAndroidAttribute(Element node, String localName, String value) {
        String prefix = XmlUtils.lookupNamespacePrefix((Node)node, (String)"http://schemas.android.com/apk/res/android", (String)"android", (boolean)true);
        node.setAttributeNS("http://schemas.android.com/apk/res/android", prefix + ":" + localName, value);
    }

    private static void setAndroidAttributeIfMissing(Element node, String localName, String value) {
        if (!node.hasAttributeNS("http://schemas.android.com/apk/res/android", localName)) {
            ManifestMerger2.setAndroidAttribute(node, localName, value);
        }
    }

    public static ImmutableList<Element> getChildElementsByName(Element element, String name) {
        ImmutableList.Builder childListBuilder = ImmutableList.builder();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element) || !name.equals(childNode.getNodeName())) continue;
            childListBuilder.add((Object)((Element)childNode));
        }
        return childListBuilder.build();
    }

    private static String prettyPrint(Document document) {
        return XmlPrettyPrinter.prettyPrint((Node)document, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)document.getDocumentElement()), null, (boolean)false);
    }

    private static Document cloneDocument(Document document) throws MergeFailureException {
        try {
            DOMResult domResult = new DOMResult();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), domResult);
            return (Document)domResult.getNode();
        }
        catch (Exception e) {
            throw new MergeFailureException(e);
        }
    }

    public static void removeNavGraphs(Document document) {
        ManifestMerger2.removeNavGraphs(document.getDocumentElement());
    }

    private static void removeNavGraphs(Element element) {
        if ("nav-graph".equals(element.getTagName())) {
            element.getParentNode().removeChild(element);
            return;
        }
        NodeList childNodes = element.getChildNodes();
        ImmutableList.Builder childElements = ImmutableList.builder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            childElements.add((Object)((Element)node));
        }
        for (Element childElement : childElements.build()) {
            ManifestMerger2.removeNavGraphs(childElement);
        }
    }

    public FileStreamProvider getFileStreamProvider() {
        return this.mFileStreamProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeReport(MergingReport mergingReport) {
        OutputStreamWriter fileWriter = null;
        if (!this.mReportFile.isPresent() || !this.mReportFile.get().getParentFile().exists() && !this.mReportFile.get().getParentFile().mkdirs()) {
            this.mLogger.warning(String.format("Cannot create %1$s manifest merger report file,build will continue but merging activities will not be documented", this.mReportFile.get().getAbsolutePath()), new Object[0]);
        } else {
            fileWriter = new FileWriter(this.mReportFile.get());
            mergingReport.getActions().log((FileWriter)fileWriter);
        }
        if (fileWriter == null) return;
        try {
            fileWriter.close();
            return;
        }
        catch (IOException e) {
            this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e.getMessage()), new Object[0]);
        }
        return;
        catch (IOException e) {
            try {
                this.mLogger.warning(String.format("Error '%1$s' while writing the merger report file, build can continue but merging activities will not be documented ", e.getMessage()), new Object[0]);
                if (fileWriter == null) return;
            }
            catch (Throwable throwable) {
                if (fileWriter == null) throw throwable;
                try {
                    fileWriter.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e2.getMessage()), new Object[0]);
                }
                throw throwable;
            }
            try {
                fileWriter.close();
                return;
            }
            catch (IOException e3) {
                this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e3.getMessage()), new Object[0]);
            }
            return;
        }
    }

    private static void extractFqcns(XmlDocument finalMergedDocument) {
        ManifestMerger2.extractFqcns(finalMergedDocument.getPackageName(), finalMergedDocument.getRootNode());
    }

    private static void extractFqcns(String packageName, XmlElement xmlElement) {
        String packagePrefix = packageName + ".";
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            String value;
            if (xmlAttribute.getModel() == null || !xmlAttribute.getModel().isPackageDependent() || !(value = xmlAttribute.getValue()).startsWith(packagePrefix)) continue;
            xmlAttribute.getXml().setValue(value.substring(packageName.length()));
        }
        for (XmlElement child : xmlElement.getMergeableElements()) {
            ManifestMerger2.extractFqcns(packageName, child);
        }
    }

    private LoadedManifestInfo load(ManifestInfo manifestInfo, KeyResolver<String> selectors, MergingReport.Builder mergingReportBuilder) throws MergeFailureException {
        XmlDocument xmlDocument;
        boolean rewriteNamespaces = this.mOptionalFeatures.contains((Object)Invoker.Feature.FULLY_NAMESPACE_LOCAL_RESOURCES);
        File xmlFile = manifestInfo.mLocation;
        try {
            InputStream inputStream = this.mFileStreamProvider.getInputStream(xmlFile);
            xmlDocument = XmlLoader.load(selectors, this.mSystemPropertyResolver, manifestInfo.mName, xmlFile, inputStream, manifestInfo.getType(), manifestInfo.getMainManifestPackageName(), this.mModel, rewriteNamespaces);
        }
        catch (Exception e) {
            throw new MergeFailureException(e);
        }
        String originalPackageName = xmlDocument.getPackageName();
        MergingReport.Builder builder = manifestInfo.getType() == XmlDocument.Type.MAIN ? mergingReportBuilder : new MergingReport.Builder(mergingReportBuilder.getLogger());
        ManifestInfo updatedManifestInfo = manifestInfo.getType() == XmlDocument.Type.MAIN ? new ManifestInfo(manifestInfo.getName(), manifestInfo.getLocation(), manifestInfo.getType(), originalPackageName) : manifestInfo;
        MergingReport.Record.Severity severity = this.mMergeType == MergeType.LIBRARY ? MergingReport.Record.Severity.INFO : MergingReport.Record.Severity.ERROR;
        this.performPlaceHolderSubstitution(updatedManifestInfo, xmlDocument, builder, severity);
        builder.getActionRecorder().recordAddedNodeAction(xmlDocument.getRootNode(), false);
        return new LoadedManifestInfo(updatedManifestInfo, Optional.ofNullable(originalPackageName), xmlDocument);
    }

    private void performPlaceHolderSubstitution(ManifestInfo manifestInfo, XmlDocument xmlDocument, MergingReport.Builder mergingReportBuilder, MergingReport.Record.Severity severity) {
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT)) {
            return;
        }
        ImmutableMap finalPlaceHolderValues = this.mPlaceHolderValues;
        if (!this.mPlaceHolderValues.containsKey("applicationId") && this.mMergeType != MergeType.LIBRARY && manifestInfo.getMainManifestPackageName() != null) {
            String packageName = manifestInfo.getMainManifestPackageName();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, Object> entry : this.mPlaceHolderValues.entrySet()) {
                if (entry.getKey().equals("packageName")) continue;
                builder.put(entry);
            }
            builder.put((Object)"packageName", (Object)packageName);
            builder.put((Object)"applicationId", (Object)packageName);
            finalPlaceHolderValues = builder.build();
        }
        MapBasedKeyBasedValueResolver<String> placeHolderValueResolver = new MapBasedKeyBasedValueResolver<String>((Map<String, Object>)finalPlaceHolderValues);
        PlaceholderHandler.visit(severity, xmlDocument, placeHolderValueResolver, mergingReportBuilder);
    }

    private Optional<XmlDocument> merge(XmlDocument xmlDocument, LoadedManifestInfo lowerPriorityDocument, MergingReport.Builder mergingReportBuilder) {
        Optional<XmlDocument> result;
        MergingReport.Result validationResult = PreValidator.validate(mergingReportBuilder, lowerPriorityDocument.getXmlDocument());
        if (validationResult == MergingReport.Result.ERROR) {
            mergingReportBuilder.addMessage(lowerPriorityDocument.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, "Validation failed, exiting");
            return Optional.empty();
        }
        if (xmlDocument != null) {
            result = xmlDocument.merge(lowerPriorityDocument.getXmlDocument(), mergingReportBuilder, !this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_IMPLICIT_PERMISSION_ADDITION));
        } else {
            mergingReportBuilder.getActionRecorder().recordAddedNodeAction(lowerPriorityDocument.getXmlDocument().getRootNode(), true);
            result = Optional.of(lowerPriorityDocument.getXmlDocument());
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_INTERMEDIARY_STAGES) && result.isPresent()) {
            mergingReportBuilder.addMergingStage(result.get().prettyPrint());
        }
        return result;
    }

    private List<LoadedManifestInfo> loadLibraries(SelectorResolver selectors, MergingReport.Builder mergingReportBuilder, String mainManifestPackageName) throws MergeFailureException {
        ImmutableList.Builder loadedLibraryDocuments = ImmutableList.builder();
        for (Pair libraryFile : Sets.newLinkedHashSet(this.mLibraryFiles)) {
            XmlDocument libraryDocument;
            this.mLogger.verbose("Loading library manifest " + ((File)libraryFile.getSecond()).getPath(), new Object[0]);
            ManifestInfo manifestInfo = new ManifestInfo((String)libraryFile.getFirst(), (File)libraryFile.getSecond(), XmlDocument.Type.LIBRARY, mainManifestPackageName);
            File xmlFile = manifestInfo.mLocation;
            try {
                InputStream inputStream = this.mFileStreamProvider.getInputStream(xmlFile);
                libraryDocument = XmlLoader.load(selectors, this.mSystemPropertyResolver, manifestInfo.mName, xmlFile, inputStream, XmlDocument.Type.LIBRARY, null, this.mModel, false);
            }
            catch (Exception e) {
                throw new MergeFailureException(e);
            }
            String libraryPackage = libraryDocument.getRootNode().getXml().getAttribute("package");
            if (!Strings.isNullOrEmpty((String)libraryPackage)) {
                selectors.addSelector(libraryPackage, (String)libraryFile.getFirst());
            }
            MergingReport.Builder builder = new MergingReport.Builder(mergingReportBuilder.getLogger());
            builder.getActionRecorder().recordAddedNodeAction(libraryDocument.getRootNode(), false);
            this.performPlaceHolderSubstitution(manifestInfo, libraryDocument, builder, MergingReport.Record.Severity.INFO);
            if (builder.hasErrors()) {
                builder.build().log(this.mLogger);
            }
            LoadedManifestInfo info = new LoadedManifestInfo(manifestInfo, Optional.ofNullable(libraryDocument.getPackageName()), libraryDocument);
            loadedLibraryDocuments.add((Object)info);
        }
        return loadedLibraryDocuments.build();
    }

    private static void checkUniquePackageName(LoadedManifestInfo mainPackage, List<LoadedManifestInfo> libraries, MergingReport.Builder mergingReportBuilder, boolean strictUniquePackageNameCheck) {
        ArrayListMultimap uniquePackageNameMap = ArrayListMultimap.create();
        if (mainPackage.getOriginalPackageName().isPresent()) {
            uniquePackageNameMap.put((Object)mainPackage.getOriginalPackageName().get(), (Object)mainPackage);
        } else if (mainPackage.getMainManifestPackageName() != null) {
            uniquePackageNameMap.put((Object)mainPackage.getMainManifestPackageName(), (Object)mainPackage);
        }
        libraries.stream().filter(l -> l.getOriginalPackageName().isPresent()).forEach(arg_0 -> ManifestMerger2.lambda$checkUniquePackageName$2((Multimap)uniquePackageNameMap, arg_0));
        uniquePackageNameMap.asMap().entrySet().stream().filter(e -> ((Collection)e.getValue()).size() > 1).forEach(e -> {
            Collection offendingTargets = ((Collection)e.getValue()).stream().map(ManifestInfo::getName).collect(Collectors.toList());
            String repeatedPackageErrors = "Package name '" + (String)e.getKey() + "' used in: " + Joiner.on((String)", ").join((Iterable)offendingTargets) + ".";
            LoadedManifestInfo info = (LoadedManifestInfo)((Collection)e.getValue()).stream().findFirst().get();
            mergingReportBuilder.addMessage(info.getXmlDocument().getSourceFile(), ManifestMerger2.getNonUniquePackageSeverity((String)e.getKey(), strictUniquePackageNameCheck), repeatedPackageErrors);
        });
    }

    private static MergingReport.Record.Severity getNonUniquePackageSeverity(String packageName, boolean strictMode) {
        if (ALLOWED_NON_UNIQUE_PACKAGE_NAMES.contains(packageName)) {
            return MergingReport.Record.Severity.INFO;
        }
        return strictMode ? MergingReport.Record.Severity.ERROR : MergingReport.Record.Severity.WARNING;
    }

    public static Invoker newMerger(File mainManifestFile, ILogger logger, MergeType mergeType) {
        return new Invoker(mainManifestFile, logger, mergeType, XmlDocument.Type.MAIN);
    }

    protected void performSystemPropertiesInjection(MergingReport.Builder mergingReport, XmlDocument xmlDocument) {
        for (ManifestSystemProperty manifestSystemProperty : ManifestSystemProperty.values()) {
            String propertyOverride = this.mSystemPropertyResolver.getValue(manifestSystemProperty);
            if (propertyOverride == null) continue;
            manifestSystemProperty.addTo(mergingReport.getActionRecorder(), xmlDocument, propertyOverride);
        }
    }

    private void checkIfExportedIsNeeded(NodeList list, MergingReport.Builder mergingReportBuilder, LoadedManifestInfo loadedMainManifestInfo) {
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            if (element.getElementsByTagName("intent-filter").getLength() <= 0 || element.getAttributes().getNamedItemNS("http://schemas.android.com/apk/res/android", "exported") != null) continue;
            mergingReportBuilder.addMessage(loadedMainManifestInfo.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, String.format("android:exported needs to be explicitly specified for <%s>. Apps targeting Android 12 and higher are required to specify an explicit value for `android:exported` when the corresponding component has an intent filter defined. See https://developer.android.com/guide/topics/manifest/activity-element#exported for details.", element.getTagName()));
        }
    }

    private static /* synthetic */ void lambda$checkUniquePackageName$2(Multimap uniquePackageNameMap, LoadedManifestInfo l) {
        uniquePackageNameMap.put((Object)l.getOriginalPackageName().get(), (Object)l);
    }

    public static class MergeFailureException
    extends Exception {
        protected MergeFailureException(Exception cause) {
            super(cause);
        }
    }

    public static class SelectorResolver
    implements KeyResolver<String> {
        private final Map<String, String> mSelectors = new HashMap<String, String>();

        protected void addSelector(String key, String value) {
            this.mSelectors.put(key, value);
        }

        @Override
        public String resolve(String key) {
            return this.mSelectors.get(key);
        }

        @Override
        public Iterable<String> getKeys() {
            return this.mSelectors.keySet();
        }
    }

    private static class LoadedManifestInfo
    extends ManifestInfo {
        private final XmlDocument mXmlDocument;
        private final Optional<String> mOriginalPackageName;

        private LoadedManifestInfo(ManifestInfo manifestInfo, Optional<String> originalPackageName, XmlDocument xmlDocument) {
            super(manifestInfo.mName, manifestInfo.mLocation, manifestInfo.mType, manifestInfo.getMainManifestPackageName());
            this.mXmlDocument = xmlDocument;
            this.mOriginalPackageName = originalPackageName;
        }

        public XmlDocument getXmlDocument() {
            return this.mXmlDocument;
        }

        public Optional<String> getOriginalPackageName() {
            return this.mOriginalPackageName;
        }
    }

    private static class ManifestInfo {
        private final String mName;
        private final File mLocation;
        private final XmlDocument.Type mType;
        private final String mMainManifestPackageName;

        private ManifestInfo(String name, File location, XmlDocument.Type type, String mainManifestPackageName) {
            this.mName = name;
            this.mLocation = location;
            this.mType = type;
            this.mMainManifestPackageName = mainManifestPackageName;
        }

        String getName() {
            return this.mName;
        }

        File getLocation() {
            return this.mLocation;
        }

        XmlDocument.Type getType() {
            return this.mType;
        }

        String getMainManifestPackageName() {
            return this.mMainManifestPackageName;
        }
    }

    public static class MapBasedKeyBasedValueResolver<T>
    implements PlaceholderHandler.KeyBasedValueResolver<T> {
        private final ImmutableMap<T, Object> keyValues;

        public MapBasedKeyBasedValueResolver(Map<T, Object> keyValues) {
            this.keyValues = ImmutableMap.copyOf(keyValues);
        }

        @Override
        public String getValue(T key) {
            Object value = this.keyValues.get(key);
            return value == null ? null : value.toString();
        }
    }

    public static class Invoker {
        protected final File mMainManifestFile;
        protected final ImmutableMap.Builder<ManifestSystemProperty, Object> mSystemProperties = new ImmutableMap.Builder();
        protected final ILogger mLogger;
        protected final ImmutableMap.Builder<String, Object> mPlaceholders = new ImmutableMap.Builder();
        private final ImmutableList.Builder<Pair<String, File>> mLibraryFilesBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<File> mFlavorsAndBuildTypeFiles = new ImmutableList.Builder();
        private final ImmutableList.Builder<Feature> mFeaturesBuilder = new ImmutableList.Builder();
        private final MergeType mMergeType;
        private XmlDocument.Type mDocumentType;
        private File mReportFile;
        private FileStreamProvider mFileStreamProvider;
        private String mFeatureName;
        private final ImmutableList.Builder<File> mNavigationFilesBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<File> mNavigationJsonsBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<String> mDependencyFetureNamesBuilder = new ImmutableList.Builder();
        private static final Pattern FEATURE_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9_]*");

        public Invoker setOverride(ManifestSystemProperty override, String value) {
            this.mSystemProperties.put((Object)override, (Object)value);
            return this;
        }

        public Invoker setPlaceHolderValues(Map<String, Object> keyValuePairs) {
            this.mPlaceholders.putAll(keyValuePairs);
            return this;
        }

        public Invoker setPlaceHolderValue(String placeHolderName, String value) {
            this.mPlaceholders.put((Object)placeHolderName, (Object)value);
            return this;
        }

        private Invoker(File mainManifestFile, ILogger logger, MergeType mergeType, XmlDocument.Type documentType) {
            this.mMainManifestFile = (File)Preconditions.checkNotNull((Object)mainManifestFile);
            this.mLogger = logger;
            this.mMergeType = mergeType;
            this.mDocumentType = documentType;
            this.mFeatureName = "";
        }

        public Invoker setMergeReportFile(File mergeReport) {
            this.mReportFile = mergeReport;
            return this;
        }

        public Invoker addLibraryManifest(File file) {
            this.addLibraryManifest(file.getName(), file);
            return this;
        }

        public Invoker addLibraryManifest(String name, File file) {
            if (this.mMergeType == MergeType.LIBRARY) {
                throw new IllegalStateException("Cannot add library dependencies manifests when creating a library");
            }
            this.mLibraryFilesBuilder.add((Object)Pair.of((Object)name, (Object)file));
            return this;
        }

        @Deprecated
        public Invoker addBundleManifests(List<Pair<String, File>> namesAndFiles) {
            if (this.mMergeType == MergeType.LIBRARY && !namesAndFiles.isEmpty()) {
                throw new IllegalStateException("Cannot add library dependencies manifests when creating a library");
            }
            this.mLibraryFilesBuilder.addAll(namesAndFiles);
            return this;
        }

        public Invoker addManifestProviders(Iterable<? extends ManifestProvider> providers) {
            for (ManifestProvider manifestProvider : providers) {
                this.mLibraryFilesBuilder.add((Object)Pair.of((Object)manifestProvider.getName(), (Object)manifestProvider.getManifest()));
            }
            return this;
        }

        public Invoker addLibraryManifests(File ... files) {
            for (File file : files) {
                this.addLibraryManifest(file);
            }
            return this;
        }

        public Invoker addFlavorAndBuildTypeManifest(File file) {
            this.mFlavorsAndBuildTypeFiles.add((Object)file);
            return this;
        }

        public Invoker addFlavorAndBuildTypeManifests(File ... files) {
            this.mFlavorsAndBuildTypeFiles.add((Object[])files);
            return this;
        }

        public Invoker withFeatures(Feature ... features) {
            this.mFeaturesBuilder.add((Object[])features);
            return this;
        }

        public Invoker withFileStreamProvider(FileStreamProvider provider) {
            assert (this.mFileStreamProvider == null || provider == null);
            this.mFileStreamProvider = provider;
            return this;
        }

        public Invoker setFeatureName(String featureName) {
            if (featureName != null) {
                this.mFeatureName = featureName;
                if (!FEATURE_NAME_PATTERN.matcher(this.mFeatureName).matches()) {
                    throw new IllegalArgumentException("FeatureName must follow " + FEATURE_NAME_PATTERN.pattern() + " regex, found " + featureName);
                }
            }
            return this;
        }

        public Invoker addNavigationFiles(Iterable<File> files) {
            this.mNavigationFilesBuilder.addAll(files);
            return this;
        }

        public Invoker addNavigationJsons(Iterable<File> files) {
            this.mNavigationJsonsBuilder.addAll(files);
            return this;
        }

        public Invoker asType(XmlDocument.Type type) {
            this.mDocumentType = type;
            return this;
        }

        public Invoker addDependencyFeatureNames(Iterable<String> names) {
            this.mDependencyFetureNamesBuilder.addAll(names);
            return this;
        }

        public MergingReport merge() throws MergeFailureException {
            ImmutableMap systemProperties = this.mSystemProperties.build();
            if (systemProperties.containsKey((Object)ManifestSystemProperty.PACKAGE)) {
                this.mPlaceholders.put((Object)"packageName", systemProperties.get((Object)ManifestSystemProperty.PACKAGE));
                if (this.mMergeType != MergeType.LIBRARY) {
                    this.mPlaceholders.put((Object)"applicationId", systemProperties.get((Object)ManifestSystemProperty.PACKAGE));
                }
            }
            FileStreamProvider fileStreamProvider = this.mFileStreamProvider != null ? this.mFileStreamProvider : new FileStreamProvider();
            ManifestMerger2 manifestMerger = new ManifestMerger2(this.mLogger, this.mMainManifestFile, this.mLibraryFilesBuilder.build(), this.mFlavorsAndBuildTypeFiles.build(), this.mFeaturesBuilder.build(), (Map)this.mPlaceholders.build(), new MapBasedKeyBasedValueResolver(systemProperties), this.mMergeType, this.mDocumentType, Optional.ofNullable(this.mReportFile), this.mFeatureName, fileStreamProvider, this.mNavigationFilesBuilder.build(), this.mNavigationJsonsBuilder.build(), this.mDependencyFetureNamesBuilder.build());
            return manifestMerger.merge();
        }

        public static enum Feature {
            KEEP_INTERMEDIARY_STAGES,
            PRINT_SIMPLE_FILENAMES,
            EXTRACT_FQCNS,
            REMOVE_TOOLS_DECLARATIONS,
            NO_PLACEHOLDER_REPLACEMENT,
            MAKE_AAPT_SAFE,
            SKIP_BLAME,
            SKIP_XML_STRING,
            TEST_ONLY,
            NO_IMPLICIT_PERMISSION_ADDITION,
            ADVANCED_PROFILING,
            ADD_DYNAMIC_FEATURE_ATTRIBUTES,
            DEBUGGABLE,
            HANDLE_VALUE_CONFLICTS_AUTOMATICALLY,
            ADD_ANDROIDX_MULTIDEX_APPLICATION_IF_NO_NAME,
            ADD_SUPPORT_MULTIDEX_APPLICATION_IF_NO_NAME,
            FULLY_NAMESPACE_LOCAL_RESOURCES,
            ENFORCE_UNIQUE_PACKAGE_NAME,
            DO_NOT_EXTRACT_NATIVE_LIBS;

        }
    }

    public static class FileStreamProvider {
        protected InputStream getInputStream(File file) throws IOException {
            return new BufferedInputStream(new FileInputStream(file));
        }
    }

    public static interface AutoAddingProperty {
        public void addTo(ActionRecorder var1, XmlDocument var2, String var3);
    }

    public static enum MergeType {
        APPLICATION,
        LIBRARY;

    }
}

