/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.AndroidXConstants;
import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.DocumentModel;
import com.android.manifmerger.ElementsTrimmer;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NavGraphExpander;
import com.android.manifmerger.NavigationXmlDocument;
import com.android.manifmerger.NavigationXmlDocumentData;
import com.android.manifmerger.NavigationXmlLoader;
import com.android.manifmerger.PlaceholderEncoder;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.PostValidator;
import com.android.manifmerger.PreValidator;
import com.android.manifmerger.ToolsInstructionsCleaner;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlLoader;
import com.android.manifmerger.XmlNode;
import com.android.sdklib.SdkVersionInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestMerger2 {
    public static final String COMPATIBLE_SCREENS_SUB_MANIFEST = "Compatible-Screens sub-manifest";
    public static final String WEAR_APP_SUB_MANIFEST = "Wear App sub-manifest";
    private static final String SPLIT_IN_DYNAMIC_FEATURE = "https://d.android.com/r/studio-ui/dynamic-delivery/dynamic-feature-manifest";
    private final File mManifestFile;
    private final Map<String, Object> mPlaceHolderValues;
    private final PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> mSystemPropertyResolver;
    private final ILogger mLogger;
    private final ImmutableList<Pair<String, File>> mLibraryFiles;
    private final ImmutableList<File> mFlavorsAndBuildTypeFiles;
    private final ImmutableList<Invoker.Feature> mOptionalFeatures;
    private final MergeType mMergeType;
    private final XmlDocument.Type mDocumentType;
    private final Optional<File> mReportFile;
    private final String mFeatureName;
    private final String mNamespace;
    private final FileStreamProvider mFileStreamProvider;
    private final ManifestDocumentProvider mManifestDocumentProvider;
    private final ProcessCancellationChecker mProcessCancellationChecker;
    private final ImmutableList<File> mNavigationFiles;
    private final ImmutableList<File> mNavigationJsons;
    private final DocumentModel<ManifestModel.NodeTypes> mModel;
    private final ImmutableList<String> mDependencyFeatureNames;
    private final ImmutableList<String> mAllowedNonUniqueNamespaces;
    private final String mGeneratedLocaleConfigAttribute;

    private ManifestMerger2(ILogger logger, File mainManifestFile, ImmutableList<Pair<String, File>> libraryFiles, ImmutableList<File> flavorsAndBuildTypeFiles, ImmutableList<Invoker.Feature> optionalFeatures, Map<String, Object> placeHolderValues, PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> systemPropertiesResolver, MergeType mergeType, XmlDocument.Type documentType, Optional<File> reportFile, String featureName, String namespace, FileStreamProvider fileStreamProvider, ManifestDocumentProvider manifestDocumentProvider, ProcessCancellationChecker processCancellationChecker, ImmutableList<File> navigationFiles, ImmutableList<File> navigationJsons, ImmutableList<String> dependencyFeatureNames, ImmutableList<String> allowedNonUniqueNamespaces, String generatedLocaleConfigAttribute) {
        this.mSystemPropertyResolver = systemPropertiesResolver;
        this.mPlaceHolderValues = placeHolderValues;
        this.mManifestFile = mainManifestFile;
        this.mLogger = logger;
        this.mLibraryFiles = libraryFiles;
        this.mFlavorsAndBuildTypeFiles = flavorsAndBuildTypeFiles;
        this.mOptionalFeatures = optionalFeatures;
        this.mMergeType = mergeType;
        this.mDocumentType = documentType;
        this.mReportFile = reportFile;
        this.mFeatureName = featureName;
        this.mNamespace = namespace;
        this.mFileStreamProvider = fileStreamProvider;
        this.mManifestDocumentProvider = manifestDocumentProvider;
        this.mProcessCancellationChecker = processCancellationChecker;
        this.mNavigationFiles = navigationFiles;
        this.mNavigationJsons = navigationJsons;
        this.mDependencyFeatureNames = dependencyFeatureNames;
        this.mModel = new ManifestModel(this.mOptionalFeatures.contains((Object)Invoker.Feature.HANDLE_VALUE_CONFLICTS_AUTOMATICALLY));
        this.mAllowedNonUniqueNamespaces = allowedNonUniqueNamespaces;
        this.mGeneratedLocaleConfigAttribute = generatedLocaleConfigAttribute;
    }

    private MergingReport merge() throws MergeFailureException {
        Object mainManifestPackageName;
        MergingReport.Builder mergingReportBuilder = new MergingReport.Builder(this.mLogger);
        SelectorResolver selectors = new SelectorResolver();
        LoadedManifestInfo loadedMainManifestInfo = this.load(new ManifestInfo(this.mManifestFile.getName(), this.mManifestFile, this.mDocumentType), selectors, mergingReportBuilder, this.mNamespace);
        this.mProcessCancellationChecker.check();
        if (!loadedMainManifestInfo.getXmlDocument().checkTopLevelDeclarations(this.mPlaceHolderValues, mergingReportBuilder, this.mDocumentType) && !this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_GOING_AFTER_ERRORS)) {
            return mergingReportBuilder.build();
        }
        if (!this.mFeatureName.isEmpty()) {
            loadedMainManifestInfo = ManifestMerger2.removeDynamicFeatureManifestSplitAttributeIfSpecified(loadedMainManifestInfo, mergingReportBuilder);
        }
        Optional<XmlAttribute> mainPackageAttribute = loadedMainManifestInfo.getXmlDocument().getPackage();
        String originalMainManifestPackageName = mainPackageAttribute.map(XmlAttribute::getValue).orElse(null);
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.CHECK_IF_PACKAGE_IN_MAIN_MANIFEST) && originalMainManifestPackageName != null) {
            if (originalMainManifestPackageName.equals(this.mNamespace)) {
                if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.SUPPRESS_MANIFEST_PACKAGE_WARNING)) {
                    String message = String.format("package=\"%1$s\" found in source AndroidManifest.xml: %2$s.\nSetting the namespace via the package attribute in the source AndroidManifest.xml is no longer supported, and the value is ignored.\nRecommendation: remove package=\"%1$s\" from the source AndroidManifest.xml: %2$s.", originalMainManifestPackageName, loadedMainManifestInfo.getLocation().getAbsolutePath());
                    this.mLogger.warning(message, new Object[0]);
                }
            } else {
                String message = String.format("Incorrect package=\"%1$s\" found in source AndroidManifest.xml: %2$s.\nSetting the namespace via the package attribute in the source AndroidManifest.xml is no longer supported.\nRecommendation: remove package=\"%1$s\" from the source AndroidManifest.xml: %2$s.", originalMainManifestPackageName, loadedMainManifestInfo.getLocation().getAbsolutePath());
                this.mLogger.error(null, message, new Object[0]);
                throw new RuntimeException(message);
            }
        }
        this.mProcessCancellationChecker.check();
        List<LoadedManifestInfo> loadedLibraryDocuments = this.loadLibraries(selectors, mergingReportBuilder, originalMainManifestPackageName);
        boolean enforceUniquePackageName = this.mOptionalFeatures.contains((Object)Invoker.Feature.ENFORCE_UNIQUE_PACKAGE_NAME);
        boolean disablePackageUniquenessCheck = this.mOptionalFeatures.contains((Object)Invoker.Feature.DISABLE_PACKAGE_NAME_UNIQUENESS_CHECK);
        if (enforceUniquePackageName && disablePackageUniquenessCheck) {
            this.mLogger.warning("Both flags ENFORCE_UNIQUE_PACKAGE_NAME and DISABLE_PACKAGE_NAME_UNIQUENESS_CHECK are found to be true. Flag ENFORCE_UNIQUE_PACKAGE_NAME will be ignored because package name uniqueness check is disabled.", new Object[0]);
        }
        if (!disablePackageUniquenessCheck) {
            ManifestMerger2.checkUniqueNamespaces(loadedMainManifestInfo, loadedLibraryDocuments, this.mAllowedNonUniqueNamespaces, mergingReportBuilder, enforceUniquePackageName);
        }
        XmlDocument xmlDocumentOptional = null;
        for (File inputFile : this.mFlavorsAndBuildTypeFiles) {
            this.mProcessCancellationChecker.check();
            this.mLogger.verbose("Merging flavors and build manifest %s \n", new Object[]{inputFile.getPath()});
            LoadedManifestInfo overlayDocument = this.load(new ManifestInfo(null, inputFile, XmlDocument.Type.OVERLAY), selectors, mergingReportBuilder, this.mNamespace);
            if (!this.mFeatureName.isEmpty()) {
                overlayDocument = ManifestMerger2.removeDynamicFeatureManifestSplitAttributeIfSpecified(overlayDocument, mergingReportBuilder);
            }
            Optional<XmlAttribute> packageAttribute = overlayDocument.getXmlDocument().getPackage();
            if (!Strings.isNullOrEmpty((String)loadedMainManifestInfo.getNamespace()) && packageAttribute.isPresent() && !loadedMainManifestInfo.getNamespace().equals(packageAttribute.get().getValue())) {
                String message = this.mMergeType == MergeType.APPLICATION ? String.format("Overlay manifest:package attribute declared at %1$s value=(%2$s)\n\tdoes not match the module's namespace (%3$s).\n\tSuggestion: remove the package=\"%2$s\" declaration at %4$s.\n\tIf you want to customize the applicationId for a buildType or productFlavor, consider setting applicationIdSuffix or using the Variant API.\n\tFor more information, see https://developer.android.com/studio/build/build-variants", packageAttribute.get().printPosition(), packageAttribute.get().getValue(), loadedMainManifestInfo.getNamespace(), packageAttribute.get().getSourceFile().print(false)) : String.format("Overlay manifest:package attribute declared at %1$s value=(%2$s)\n\tdoes not match the module's namespace (%3$s).\n\tSuggestion: remove the package=\"%2$s\" declaration at %4$s.", packageAttribute.get().printPosition(), packageAttribute.get().getValue(), loadedMainManifestInfo.getNamespace(), packageAttribute.get().getSourceFile().print(false));
                mergingReportBuilder.addMessage(overlayDocument.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, message);
                if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_GOING_AFTER_ERRORS)) {
                    return mergingReportBuilder.build();
                }
            }
            if (mainPackageAttribute.isPresent()) {
                overlayDocument.getXmlDocument().getRootNode().setAttribute("package", mainPackageAttribute.get().getValue());
            }
            Optional<XmlDocument> newMergedDocument = this.merge(xmlDocumentOptional, overlayDocument, mergingReportBuilder);
            xmlDocumentOptional = newMergedDocument.orElse(null);
            if (newMergedDocument.isPresent() || this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_GOING_AFTER_ERRORS)) continue;
            return mergingReportBuilder.build();
        }
        this.mProcessCancellationChecker.check();
        this.mLogger.verbose("Merging main manifest %s\n", new Object[]{this.mManifestFile.getPath()});
        Optional<XmlDocument> newMergedDocument = this.merge(xmlDocumentOptional, loadedMainManifestInfo, mergingReportBuilder);
        if (!newMergedDocument.isPresent() && !this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_GOING_AFTER_ERRORS)) {
            return mergingReportBuilder.build();
        }
        xmlDocumentOptional = newMergedDocument.get();
        this.performSystemPropertiesInjection(mergingReportBuilder, xmlDocumentOptional);
        if (this.mMergeType == MergeType.LIBRARY && !Strings.isNullOrEmpty((String)(mainManifestPackageName = loadedMainManifestInfo.getXmlDocument().getRootNode().getXml().getAttribute("package")))) {
            xmlDocumentOptional.getRootNode().setAttribute("package", (String)mainManifestPackageName);
        }
        for (LoadedManifestInfo libraryDocument : loadedLibraryDocuments) {
            this.mLogger.verbose("Merging library manifest " + libraryDocument.getLocation(), new Object[0]);
            newMergedDocument = this.merge(xmlDocumentOptional, libraryDocument, mergingReportBuilder);
            if (!newMergedDocument.isPresent() && !this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_GOING_AFTER_ERRORS)) {
                return mergingReportBuilder.build();
            }
            xmlDocumentOptional = newMergedDocument.get();
            this.mProcessCancellationChecker.check();
        }
        if (this.mMergeType == MergeType.APPLICATION) {
            Map<String, NavigationXmlDocument> loadedNavigationMap = this.createNavigationMap();
            xmlDocumentOptional = NavGraphExpander.INSTANCE.expandNavGraphs(xmlDocumentOptional, loadedNavigationMap, mergingReportBuilder);
        }
        if (mergingReportBuilder.hasErrors() && !this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_GOING_AFTER_ERRORS)) {
            return mergingReportBuilder.build();
        }
        ElementsTrimmer.trim(xmlDocumentOptional, mergingReportBuilder);
        if (mergingReportBuilder.hasErrors() && !this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_GOING_AFTER_ERRORS)) {
            return mergingReportBuilder.build();
        }
        if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT)) {
            MergingReport.Record.Severity severity = !this.mMergeType.isFullPlaceholderSubstitutionRequired() ? MergingReport.Record.Severity.INFO : MergingReport.Record.Severity.ERROR;
            this.performPlaceHolderSubstitution(xmlDocumentOptional, originalMainManifestPackageName, mergingReportBuilder, severity);
            if (mergingReportBuilder.hasErrors() && !this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_GOING_AFTER_ERRORS)) {
                return mergingReportBuilder.build();
            }
        }
        this.mProcessCancellationChecker.check();
        if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.DISABLE_STRIP_LIBRARY_TARGET_SDK) && this.mMergeType != MergeType.APPLICATION) {
            this.stripTargetSdk(xmlDocumentOptional);
        }
        XmlDocument finalMergedDocument = xmlDocumentOptional;
        Optional<XmlAttribute> packageAttr = finalMergedDocument.getPackage();
        if (this.mMergeType == MergeType.APPLICATION && packageAttr.isPresent()) {
            XmlAttribute packageNameAttribute = packageAttr.get();
            String packageName = packageNameAttribute.getValue();
            if (!(this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT) && PlaceholderHandler.isPlaceHolder(packageName) || packageName.contains("."))) {
                mergingReportBuilder.addMessage(loadedMainManifestInfo.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, String.format("Package name '%1$s' at position %2$s should contain at least one '.' (dot) character", packageName, packageNameAttribute.printPosition()));
                if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_GOING_AFTER_ERRORS)) {
                    return mergingReportBuilder.build();
                }
            }
        }
        PostValidator.enforceToolsNamespaceDeclaration(finalMergedDocument);
        this.mProcessCancellationChecker.check();
        finalMergedDocument.originalNodeOperation.forEach((k, v) -> k.setAttributeNS("http://schemas.android.com/tools", "tools:node", v.toXmlName()));
        PostValidator.validate(finalMergedDocument, mergingReportBuilder);
        if (mergingReportBuilder.hasErrors() && !this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_GOING_AFTER_ERRORS)) {
            mergingReportBuilder.addMessage(finalMergedDocument.getRootNode(), MergingReport.Record.Severity.WARNING, "Post merge validation failed");
        }
        finalMergedDocument.clearNodeNamespaces();
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.EXTRACT_FQCNS)) {
            String namespace = this.mNamespace != null ? this.mNamespace : (originalMainManifestPackageName != null ? originalMainManifestPackageName : "");
            ManifestMerger2.extractFqcns(namespace, finalMergedDocument.getRootNode());
        }
        this.mProcessCancellationChecker.check();
        this.processOptionalFeatures(finalMergedDocument, mergingReportBuilder);
        this.checkExportedDeclaration(finalMergedDocument, mergingReportBuilder);
        if (mergingReportBuilder.hasErrors() && !this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_GOING_AFTER_ERRORS)) {
            return mergingReportBuilder.build();
        }
        mergingReportBuilder.setMergedDocument(MergingReport.MergedManifestKind.MERGED, ManifestMerger2.prettyPrint(finalMergedDocument.getXml()));
        this.mProcessCancellationChecker.check();
        if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.SKIP_BLAME)) {
            try {
                mergingReportBuilder.setMergedDocument(MergingReport.MergedManifestKind.BLAME, mergingReportBuilder.blame(finalMergedDocument));
            }
            catch (Exception e) {
                this.mLogger.error((Throwable)e, "Error while saving blame file, build will continue", new Object[0]);
            }
        }
        mergingReportBuilder.setMergedXmlDocument(finalMergedDocument);
        MergingReport mergingReport = mergingReportBuilder.build();
        if (this.mReportFile.isPresent()) {
            this.writeReport(mergingReport);
        }
        return mergingReport;
    }

    private Map<String, NavigationXmlDocument> createNavigationMap() throws MergeFailureException {
        HashMap<String, NavigationXmlDocument> loadedNavigationMap = new HashMap<String, NavigationXmlDocument>();
        for (File navigationFile : this.mNavigationFiles) {
            String navigationId = navigationFile.getName().replaceAll("\\.xml$", "");
            if (loadedNavigationMap.get(navigationId) != null) continue;
            try {
                InputStream inputStream = this.mFileStreamProvider.getInputStream(navigationFile);
                try {
                    loadedNavigationMap.put(navigationId, NavigationXmlLoader.INSTANCE.load(navigationId, navigationFile, inputStream));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception e) {
                throw new MergeFailureException(e);
            }
        }
        Gson gson = new GsonBuilder().create();
        for (File navigationJson : this.mNavigationJsons) {
            try {
                NavigationXmlDocumentData[] navDatas;
                String jsonText = FileUtils.loadFileWithUnixLineSeparators((File)navigationJson);
                for (NavigationXmlDocumentData navData : navDatas = (NavigationXmlDocumentData[])gson.fromJson(jsonText, NavigationXmlDocumentData[].class)) {
                    String navigationId = navData.getName();
                    if (loadedNavigationMap.get(navigationId) != null) {
                        this.mLogger.info("Navigation file %s from %s is ignored (skipped).", new Object[]{navigationId, navigationJson});
                        continue;
                    }
                    loadedNavigationMap.put(navigationId, new NavigationXmlDocument(navData));
                }
            }
            catch (IOException e) {
                throw new MergeFailureException(e);
            }
        }
        return loadedNavigationMap;
    }

    private static LoadedManifestInfo removeDynamicFeatureManifestSplitAttributeIfSpecified(LoadedManifestInfo dynamicFeatureManifest, MergingReport.Builder mergingReportBuilder) {
        Optional<XmlAttribute> splitAttribute = dynamicFeatureManifest.getXmlDocument().getRootNode().getAttribute(XmlNode.fromXmlName("split"));
        if (splitAttribute.isPresent()) {
            String message = String.format("Attribute '%1$s' was removed from %2$s.\nThe Android Gradle plugin includes it for you when building your project.\nSee %3$s for details.", "split", splitAttribute.get().printPosition(), SPLIT_IN_DYNAMIC_FEATURE);
            mergingReportBuilder.addMessage(dynamicFeatureManifest.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.WARNING, message);
            dynamicFeatureManifest.getXmlDocument().getRootNode().removeAttribute("split");
            return new LoadedManifestInfo(dynamicFeatureManifest, dynamicFeatureManifest.getXmlDocument());
        }
        return dynamicFeatureManifest;
    }

    private void processOptionalFeatures(XmlDocument xmlDocument, MergingReport.Builder mergingReport) throws MergeFailureException {
        Document document = Optional.ofNullable(xmlDocument).map(XmlDocument::getXml).orElse(null);
        if (document == null) {
            return;
        }
        if (this.mMergeType != MergeType.FUSED_LIBRARY && this.mOptionalFeatures.contains((Object)Invoker.Feature.REMOVE_TOOLS_DECLARATIONS)) {
            ToolsInstructionsCleaner.cleanToolsReferences(this.mMergeType, xmlDocument, this.mLogger);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADVANCED_PROFILING)) {
            ManifestMerger2.addInternetPermission(xmlDocument);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.TEST_ONLY)) {
            ManifestMerger2.addTestOnlyAttribute(xmlDocument);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.DEBUGGABLE)) {
            ManifestMerger2.addDebuggableAttribute(xmlDocument);
        }
        if (this.mMergeType == MergeType.APPLICATION) {
            ManifestMerger2.optionalAddApplicationTagIfMissing(xmlDocument);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADD_ANDROIDX_MULTIDEX_APPLICATION_IF_NO_NAME)) {
            ManifestMerger2.addMultiDexApplicationIfNoName(xmlDocument, AndroidXConstants.MULTI_DEX_APPLICATION.newName());
        } else if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADD_SUPPORT_MULTIDEX_APPLICATION_IF_NO_NAME)) {
            ManifestMerger2.addMultiDexApplicationIfNoName(xmlDocument, AndroidXConstants.MULTI_DEX_APPLICATION.oldName());
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADD_DYNAMIC_FEATURE_ATTRIBUTES)) {
            ManifestMerger2.addFeatureSplitAttribute(xmlDocument, this.mFeatureName);
            ManifestMerger2.adjustInstantAppFeatureSplitInfo(xmlDocument, this.mFeatureName);
            ManifestMerger2.addUsesSplitTagsForDependencies(xmlDocument, this.mDependencyFeatureNames);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.MAKE_AAPT_SAFE)) {
            ManifestMerger2.createAaptSafeManifest(xmlDocument, mergingReport);
        }
        if (this.mMergeType == MergeType.APPLICATION && this.mGeneratedLocaleConfigAttribute != null) {
            this.addLocaleConfig(xmlDocument, this.mGeneratedLocaleConfigAttribute);
        }
    }

    @VisibleForTesting
    static void createAaptSafeManifest(XmlDocument document, MergingReport.Builder mergingReport) throws MergeFailureException {
        Pair<Document, Boolean> clonedDocument = document.cloneAndTransform((Predicate<Node>)((Predicate)node -> ManifestMerger2.ensurePackageHasADot(node) || PlaceholderEncoder.encode(node)), (Predicate<Node>)((Predicate)ManifestMerger2::isNavGraphs));
        boolean isUpdated = (Boolean)clonedDocument.getSecond();
        mergingReport.setAaptSafeManifestUnchanged(!isUpdated);
        if (isUpdated) {
            mergingReport.setMergedDocument(MergingReport.MergedManifestKind.AAPT_SAFE, ManifestMerger2.prettyPrint((Document)clonedDocument.getFirst()));
        }
    }

    private static boolean ensurePackageHasADot(Node node) {
        if (node.getParentNode() != null || !node.getNodeName().equals("manifest") || !(node instanceof Element)) {
            return false;
        }
        Element element = (Element)node;
        String manifestPackage = element.getAttribute("package");
        if (manifestPackage.contains(".")) {
            return false;
        }
        element.setAttribute("package", manifestPackage + ".for.verification");
        return true;
    }

    private static boolean isNavGraphs(Node node) {
        return node instanceof Element && "nav-graph".equals(((Element)node).getTagName());
    }

    private static void addTestOnlyAttribute(XmlDocument document) {
        XmlElement manifest = document.getRootNode();
        manifest.applyToFirstChildElementOfType(ManifestModel.NodeTypes.APPLICATION, application -> ManifestMerger2.setAndroidAttribute(application, "testOnly", "true"));
    }

    private static void addDebuggableAttribute(XmlDocument document) {
        XmlElement manifest = document.getRootNode();
        manifest.applyToFirstChildElementOfType(ManifestModel.NodeTypes.APPLICATION, application -> ManifestMerger2.setAndroidAttribute(application, "debuggable", "true"));
    }

    private static void addMultiDexApplicationIfNoName(XmlDocument document, String multiDexApplicationName) {
        XmlElement manifest = document.getRootNode();
        manifest.applyToFirstChildElementOfType(ManifestModel.NodeTypes.APPLICATION, application -> ManifestMerger2.setAndroidAttributeIfMissing(application, "name", multiDexApplicationName));
    }

    private static void addFeatureSplitAttribute(XmlDocument document, String featureName) {
        XmlElement manifest = document.getRootNode();
        if (manifest == null) {
            return;
        }
        String attributeName = "featureSplit";
        manifest.setAttribute(attributeName, featureName);
    }

    private void addLocaleConfig(XmlDocument document, String configLocation) {
        XmlElement manifest = document.getRootNode();
        manifest.applyToFirstChildElementOfType(ManifestModel.NodeTypes.APPLICATION, application -> {
            if (application.getXml().hasAttributeNS("http://schemas.android.com/apk/res/android", "localeConfig")) {
                String message = "Locale config generation was requested but user locale config is present in manifest. See https://developer.android.com/r/studio-ui/build/automatic-per-app-languages";
                this.mLogger.error(null, message, new Object[0]);
                throw new RuntimeException(message);
            }
            ManifestMerger2.setAndroidAttribute(application, "localeConfig", configLocation);
        });
    }

    private static void adjustInstantAppFeatureSplitInfo(XmlDocument document, String featureName) {
        XmlElement manifest = document.getRootNode();
        if (manifest == null) {
            return;
        }
        manifest.applyToFirstChildElementOfType(ManifestModel.NodeTypes.APPLICATION, application -> {
            List<ManifestModel.NodeTypes> elementNamesToUpdate = Arrays.asList(ManifestModel.NodeTypes.ACTIVITY, ManifestModel.NodeTypes.SERVICE, ManifestModel.NodeTypes.PROVIDER);
            for (ManifestModel.NodeTypes nodeType : elementNamesToUpdate) {
                for (XmlElement elementToUpdate : application.getAllNodesByType(nodeType)) {
                    ManifestMerger2.setAndroidAttribute(elementToUpdate, "splitName", featureName);
                }
            }
        });
    }

    public static String setManifestAndroidAttribute(XmlDocument document, String attribute, String value) {
        XmlElement manifest = document.getRootNode();
        if (manifest == null) {
            return null;
        }
        String previousValue = manifest.getXml().hasAttributeNS("http://schemas.android.com/apk/res/android", attribute) ? manifest.getXml().getAttributeNS("http://schemas.android.com/apk/res/android", attribute) : null;
        ManifestMerger2.setAndroidAttribute(manifest, attribute, value);
        return previousValue;
    }

    private static void addInternetPermission(XmlDocument document) {
        String permission = "android.permission.INTERNET";
        XmlElement manifest = document.getRootNode();
        ImmutableList<Element> usesPermissions = ManifestMerger2.getChildElementsByName(manifest.getXml(), "uses-permission");
        for (Element usesPermission : usesPermissions) {
            if (!permission.equals(usesPermission.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return;
        }
        XmlElement uses = new XmlElement(document.getXml().createElement("uses-permission"), document);
        document.getRootNode().appendChild(uses);
        ManifestMerger2.setAndroidAttribute(uses, "name", permission);
    }

    private static void addUsesSplitTagsForDependencies(XmlDocument document, ImmutableList<String> dependencyFeatureNames) {
        XmlElement manifest = document.getRootNode();
        for (String usedSplitName : dependencyFeatureNames) {
            XmlElement usesSplit = new XmlElement(document.getXml().createElement("uses-split"), document);
            ManifestMerger2.setAndroidAttribute(usesSplit, "name", usedSplitName);
            manifest.appendChild(usesSplit.getXml());
        }
    }

    private static void optionalAddApplicationTagIfMissing(XmlDocument document) {
        XmlElement manifest = document.getRootNode();
        if (manifest.getXml().getElementsByTagName("application").getLength() > 0) {
            return;
        }
        Element application = document.getXml().createElement("application");
        manifest.appendChild(application);
    }

    public static void setAndroidAttribute(XmlElement node, String localName, String value) {
        String prefix = XmlUtils.lookupNamespacePrefix((Node)node.getXml(), (String)"http://schemas.android.com/apk/res/android", (String)"android", (boolean)true);
        node.setAttributeNS("http://schemas.android.com/apk/res/android", prefix + ":" + localName, value);
    }

    static boolean setAndroidAttributeIfMissing(XmlElement node, String localName, String value) {
        if (!node.getXml().hasAttributeNS("http://schemas.android.com/apk/res/android", localName)) {
            ManifestMerger2.setAndroidAttribute(node, localName, value);
            return true;
        }
        return false;
    }

    public static ImmutableList<Element> getChildElementsByName(Element element, String name) {
        ImmutableList.Builder childListBuilder = ImmutableList.builder();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element) || !name.equals(childNode.getNodeName())) continue;
            childListBuilder.add((Object)((Element)childNode));
        }
        return childListBuilder.build();
    }

    private static String prettyPrint(Document document) {
        return XmlPrettyPrinter.prettyPrint((Node)document, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)document.getDocumentElement()), null, (boolean)false);
    }

    public FileStreamProvider getFileStreamProvider() {
        return this.mFileStreamProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeReport(MergingReport mergingReport) {
        OutputStreamWriter fileWriter = null;
        if (!this.mReportFile.isPresent() || !this.mReportFile.get().getParentFile().exists() && !this.mReportFile.get().getParentFile().mkdirs()) {
            this.mLogger.warning(String.format("Cannot create %1$s manifest merger report file,build will continue but merging activities will not be documented", this.mReportFile.get().getAbsolutePath()), new Object[0]);
        } else {
            fileWriter = new FileWriter(this.mReportFile.get());
            mergingReport.getActions().log((FileWriter)fileWriter);
        }
        if (fileWriter == null) return;
        try {
            fileWriter.close();
            return;
        }
        catch (IOException e) {
            this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e.getMessage()), new Object[0]);
        }
        return;
        catch (IOException e) {
            try {
                this.mLogger.warning(String.format("Error '%1$s' while writing the merger report file, build can continue but merging activities will not be documented ", e.getMessage()), new Object[0]);
                if (fileWriter == null) return;
            }
            catch (Throwable throwable) {
                if (fileWriter == null) throw throwable;
                try {
                    fileWriter.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e2.getMessage()), new Object[0]);
                }
                throw throwable;
            }
            try {
                fileWriter.close();
                return;
            }
            catch (IOException e3) {
                this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e3.getMessage()), new Object[0]);
            }
            return;
        }
    }

    private static void extractFqcns(String namespace, XmlElement xmlElement) {
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            String value;
            if (xmlAttribute.getModel() == null || !xmlAttribute.getModel().isPackageDependent() || !(value = xmlAttribute.getValue()).startsWith(namespace + ".")) continue;
            xmlAttribute.setValue(value.substring(namespace.length()));
        }
        for (XmlElement child : xmlElement.getMergeableElements()) {
            ManifestMerger2.extractFqcns(namespace, child);
        }
    }

    private LoadedManifestInfo load(ManifestInfo manifestInfo, KeyResolver<String> selectors, MergingReport.Builder mergingReportBuilder, String namespace) throws MergeFailureException {
        XmlDocument xmlDocument;
        boolean rewriteNamespaces = this.mOptionalFeatures.contains((Object)Invoker.Feature.FULLY_NAMESPACE_LOCAL_RESOURCES);
        File xmlFile = manifestInfo.mLocation;
        try {
            InputStream inputStream = this.mFileStreamProvider.getInputStream(xmlFile);
            xmlDocument = XmlLoader.load(selectors, this.mSystemPropertyResolver, manifestInfo.mName, xmlFile, inputStream, manifestInfo.getType(), namespace, this.mModel, rewriteNamespaces);
        }
        catch (Exception e) {
            throw new MergeFailureException("Error parsing " + xmlFile.getAbsolutePath(), e);
        }
        MergingReport.Builder builder = manifestInfo.getType() == XmlDocument.Type.MAIN ? mergingReportBuilder : new MergingReport.Builder(mergingReportBuilder.getLogger());
        MergingReport.Record.Severity severity = !this.mMergeType.isFullPlaceholderSubstitutionRequired() ? MergingReport.Record.Severity.INFO : MergingReport.Record.Severity.ERROR;
        this.performPlaceHolderSubstitution(xmlDocument, xmlDocument.getPackage().map(XmlAttribute::getValue).orElse(null), builder, severity);
        builder.getActionRecorder().recordAddedNodeAction(xmlDocument.getRootNode(), false);
        this.mProcessCancellationChecker.check();
        return new LoadedManifestInfo(manifestInfo, xmlDocument);
    }

    private void performPlaceHolderSubstitution(XmlDocument xmlDocument, String originalMainManifestPackageName, MergingReport.Builder mergingReportBuilder, MergingReport.Record.Severity severity) {
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT)) {
            return;
        }
        ImmutableMap finalPlaceHolderValues = this.mPlaceHolderValues;
        if (!this.mPlaceHolderValues.containsKey("applicationId") && this.mMergeType != MergeType.LIBRARY && originalMainManifestPackageName != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, Object> entry : this.mPlaceHolderValues.entrySet()) {
                if (entry.getKey().equals("packageName")) continue;
                builder.put(entry);
            }
            builder.put((Object)"packageName", (Object)originalMainManifestPackageName);
            builder.put((Object)"applicationId", (Object)originalMainManifestPackageName);
            finalPlaceHolderValues = builder.build();
        }
        MapBasedKeyBasedValueResolver<String> placeHolderValueResolver = new MapBasedKeyBasedValueResolver<String>((Map<String, Object>)finalPlaceHolderValues);
        PlaceholderHandler.visit(severity, xmlDocument, placeHolderValueResolver, mergingReportBuilder);
    }

    private Optional<XmlDocument> merge(XmlDocument xmlDocument, LoadedManifestInfo lowerPriorityDocument, MergingReport.Builder mergingReportBuilder) {
        Optional<XmlDocument> result;
        boolean validateExtractNativeLibsFromSources = this.mSystemPropertyResolver.getValue(ManifestSystemProperty.Application.EXTRACT_NATIVE_LIBS) != null;
        Boolean higherPriorityExtractNativeLibsValue = PreValidator.getExtractNativeLibsValue(xmlDocument);
        boolean validateExtractNativeLibsFromDependencies = this.mOptionalFeatures.contains((Object)Invoker.Feature.VALIDATE_EXTRACT_NATIVE_LIBS_FROM_DEPENDENCIES) && !Boolean.TRUE.equals(higherPriorityExtractNativeLibsValue);
        MergingReport.Result validationResult = PreValidator.validate(mergingReportBuilder, lowerPriorityDocument.getXmlDocument(), validateExtractNativeLibsFromSources, validateExtractNativeLibsFromDependencies);
        if (validationResult == MergingReport.Result.ERROR && !this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_GOING_AFTER_ERRORS)) {
            mergingReportBuilder.addMessage(lowerPriorityDocument.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, "Validation failed, exiting");
            return Optional.empty();
        }
        if (xmlDocument != null) {
            result = xmlDocument.merge(lowerPriorityDocument.getXmlDocument(), mergingReportBuilder, !this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_IMPLICIT_PERMISSION_ADDITION), this.mOptionalFeatures.contains((Object)Invoker.Feature.DISABLE_MINSDKLIBRARY_CHECK), this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_GOING_AFTER_ERRORS), this.mProcessCancellationChecker);
        } else {
            mergingReportBuilder.getActionRecorder().recordAddedNodeAction(lowerPriorityDocument.getXmlDocument().getRootNode(), true);
            result = Optional.of(lowerPriorityDocument.getXmlDocument());
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_INTERMEDIARY_STAGES) && result.isPresent()) {
            mergingReportBuilder.addMergingStage(result.get().prettyPrint());
        }
        return result;
    }

    private List<LoadedManifestInfo> loadLibraries(SelectorResolver selectors, MergingReport.Builder mergingReportBuilder, String originalMainManifestPackageName) throws MergeFailureException {
        ImmutableList.Builder loadedLibraryDocuments = ImmutableList.builder();
        for (Pair libraryFile : Sets.newLinkedHashSet(this.mLibraryFiles)) {
            XmlDocument libraryDocument;
            this.mLogger.verbose("Loading library manifest " + ((File)libraryFile.getSecond()).getPath(), new Object[0]);
            ManifestInfo manifestInfo = new ManifestInfo((String)libraryFile.getFirst(), (File)libraryFile.getSecond(), XmlDocument.Type.LIBRARY);
            File xmlFile = manifestInfo.mLocation;
            try {
                Optional document = Optional.ofNullable(this.mManifestDocumentProvider).flatMap(provider -> provider.getManifestDocument(xmlFile));
                libraryDocument = document.isPresent() ? XmlLoader.load((Document)document.get(), selectors, this.mSystemPropertyResolver, manifestInfo.mName, xmlFile, XmlDocument.Type.LIBRARY, null, this.mModel, false) : XmlLoader.load(selectors, this.mSystemPropertyResolver, manifestInfo.mName, xmlFile, this.mFileStreamProvider.getInputStream(xmlFile), XmlDocument.Type.LIBRARY, null, this.mModel, false);
            }
            catch (Exception e) {
                throw new MergeFailureException(e);
            }
            String libraryNamespace = libraryDocument.getNamespace();
            if (!Strings.isNullOrEmpty((String)libraryNamespace)) {
                selectors.addSelector(libraryNamespace, (String)libraryFile.getFirst());
            }
            MergingReport.Builder builder = new MergingReport.Builder(mergingReportBuilder.getLogger());
            builder.getActionRecorder().recordAddedNodeAction(libraryDocument.getRootNode(), false);
            this.performPlaceHolderSubstitution(libraryDocument, originalMainManifestPackageName, builder, MergingReport.Record.Severity.INFO);
            if (builder.hasErrors()) {
                builder.build().log(this.mLogger);
            }
            LoadedManifestInfo info = new LoadedManifestInfo(manifestInfo, libraryDocument);
            loadedLibraryDocuments.add((Object)info);
            this.mProcessCancellationChecker.check();
        }
        return loadedLibraryDocuments.build();
    }

    private static void checkUniqueNamespaces(LoadedManifestInfo loadedMainManifestInfo, List<LoadedManifestInfo> libraries, List<String> allowedNonUniqueNamespaces, MergingReport.Builder mergingReportBuilder, boolean strictUniqueNamespaceCheck) {
        ArrayListMultimap uniqueNamespaceMap = ArrayListMultimap.create();
        if (!Strings.isNullOrEmpty((String)loadedMainManifestInfo.getNamespace())) {
            uniqueNamespaceMap.put((Object)loadedMainManifestInfo.getNamespace(), (Object)loadedMainManifestInfo);
        }
        libraries.stream().filter(l -> !Strings.isNullOrEmpty((String)l.getNamespace())).forEach(arg_0 -> ManifestMerger2.lambda$checkUniqueNamespaces$9((Multimap)uniqueNamespaceMap, arg_0));
        uniqueNamespaceMap.asMap().entrySet().stream().filter(e -> ((Collection)e.getValue()).size() > 1).forEach(e -> {
            Collection offendingTargets = ((Collection)e.getValue()).stream().map(ManifestInfo::getName).collect(Collectors.toList());
            String repeatedNamespaceMessage = "Namespace '" + (String)e.getKey() + "' is used in multiple modules and/or libraries: " + Joiner.on((String)", ").join((Iterable)offendingTargets) + ". Please ensure that all modules and libraries have a unique namespace. For more information, See https://developer.android.com/studio/build/configure-app-module#set-namespace";
            LoadedManifestInfo info = (LoadedManifestInfo)((Collection)e.getValue()).stream().findFirst().get();
            mergingReportBuilder.addMessage(info.getXmlDocument().getSourceFile(), ManifestMerger2.getNonUniqueNamespaceSeverity(allowedNonUniqueNamespaces, (String)e.getKey(), strictUniqueNamespaceCheck), repeatedNamespaceMessage);
        });
    }

    private static MergingReport.Record.Severity getNonUniqueNamespaceSeverity(List<String> allowedNonUniqueNamespaces, String namespace, boolean strictMode) {
        if (allowedNonUniqueNamespaces.contains(namespace)) {
            return MergingReport.Record.Severity.INFO;
        }
        return strictMode ? MergingReport.Record.Severity.ERROR : MergingReport.Record.Severity.WARNING;
    }

    public static Invoker newMerger(File mainManifestFile, ILogger logger, MergeType mergeType) {
        return new Invoker(mainManifestFile, logger, mergeType, XmlDocument.Type.MAIN);
    }

    protected void performSystemPropertiesInjection(MergingReport.Builder mergingReport, XmlDocument xmlDocument) {
        for (ManifestSystemProperty manifestSystemProperty : ManifestSystemProperty.getValues()) {
            String propertyOverride = this.mSystemPropertyResolver.getValue(manifestSystemProperty);
            if (propertyOverride == null) continue;
            manifestSystemProperty.addTo(mergingReport.getActionRecorder(), xmlDocument, propertyOverride);
        }
    }

    private void checkExportedDeclaration(XmlDocument finalMergedDocument, MergingReport.Builder mergingReportBuilder) {
        int targetSdkApi;
        String targetSdkVersion = finalMergedDocument.getTargetSdkVersion(mergingReportBuilder);
        int n = targetSdkApi = Character.isDigit(targetSdkVersion.charAt(0)) ? Integer.parseInt(targetSdkVersion) : SdkVersionInfo.getApiByPreviewName((String)targetSdkVersion, (boolean)true);
        if (targetSdkApi > 30) {
            Optional<XmlElement> element = finalMergedDocument.getRootNode().getNodeByTypeAndKey(ManifestModel.NodeTypes.APPLICATION, null);
            if (element.isEmpty()) {
                return;
            }
            XmlElement applicationElement = element.get();
            this.checkIfExportedIsNeeded((List<XmlElement>)applicationElement.getAllNodesByType(ManifestModel.NodeTypes.ACTIVITY), mergingReportBuilder);
            this.checkIfExportedIsNeeded((List<XmlElement>)applicationElement.getAllNodesByType(ManifestModel.NodeTypes.ACTIVITY_ALIAS), mergingReportBuilder);
            this.checkIfExportedIsNeeded((List<XmlElement>)applicationElement.getAllNodesByType(ManifestModel.NodeTypes.SERVICE), mergingReportBuilder);
            this.checkIfExportedIsNeeded((List<XmlElement>)applicationElement.getAllNodesByType(ManifestModel.NodeTypes.RECEIVER), mergingReportBuilder);
        }
    }

    private void checkIfExportedIsNeeded(List<XmlElement> list, MergingReport.Builder mergingReportBuilder) {
        for (XmlElement element : list) {
            if (element.getAllNodesByType(ManifestModel.NodeTypes.INTENT_FILTER).size() <= 0 || element.getXml().hasAttributeNS("http://schemas.android.com/apk/res/android", "exported")) continue;
            mergingReportBuilder.addMessage(element, MergingReport.Record.Severity.ERROR, String.format("android:exported needs to be explicitly specified for element <%s>. Apps targeting Android 12 and higher are required to specify an explicit value for `android:exported` when the corresponding component has an intent filter defined. See https://developer.android.com/guide/topics/manifest/activity-element#exported for details.", element.getId()));
        }
    }

    private void stripTargetSdk(XmlDocument xmlDocument) {
        Optional<XmlElement> usesSdk = xmlDocument.getByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
        usesSdk.ifPresent(xmlElement -> xmlElement.removeAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion"));
    }

    private static /* synthetic */ void lambda$checkUniqueNamespaces$9(Multimap uniqueNamespaceMap, LoadedManifestInfo l) {
        uniqueNamespaceMap.put((Object)l.getNamespace(), (Object)l);
    }

    public static enum MergeType {
        APPLICATION(true, true),
        LIBRARY(false, false),
        FUSED_LIBRARY(false, false),
        PRIVACY_SANDBOX_LIBRARY(true, true);

        private final boolean isKeepToolsAttributeRequired;
        private final boolean isFullPlaceholderSubstitutionRequired;

        public boolean isKeepToolsAttributeRequired(String localName, String value) {
            return this.isKeepToolsAttributeRequired && (!"requiredByPrivacySandboxSdk".equals(localName) || !value.equals("true"));
        }

        public boolean isFullPlaceholderSubstitutionRequired() {
            return this.isFullPlaceholderSubstitutionRequired;
        }

        private MergeType(boolean isKeepToolsAttributeRequired, boolean isFullPlaceholderSubstitutionRequired) {
            this.isKeepToolsAttributeRequired = isKeepToolsAttributeRequired;
            this.isFullPlaceholderSubstitutionRequired = isFullPlaceholderSubstitutionRequired;
        }
    }

    public static class FileStreamProvider {
        protected InputStream getInputStream(File file) throws IOException {
            return new BufferedInputStream(new FileInputStream(file));
        }
    }

    public static interface ManifestDocumentProvider {
        public Optional<Document> getManifestDocument(File var1);
    }

    public static interface ProcessCancellationChecker {
        public void check();
    }

    public static class Invoker {
        protected final File mMainManifestFile;
        protected final ImmutableMap.Builder<ManifestSystemProperty, Object> mSystemProperties = new ImmutableMap.Builder();
        protected final ILogger mLogger;
        protected final ImmutableMap.Builder<String, Object> mPlaceholders = new ImmutableMap.Builder();
        private final ImmutableList.Builder<Pair<String, File>> mLibraryFilesBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<File> mFlavorsAndBuildTypeFiles = new ImmutableList.Builder();
        private final ImmutableList.Builder<Feature> mFeaturesBuilder = new ImmutableList.Builder();
        private final MergeType mMergeType;
        private XmlDocument.Type mDocumentType;
        private File mReportFile;
        private FileStreamProvider mFileStreamProvider;
        private ManifestDocumentProvider mManifestDocumentProvider;
        private ProcessCancellationChecker mProcessCancellationChecker;
        private String mFeatureName;
        private String mNamespace;
        private final ImmutableList.Builder<File> mNavigationFilesBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<File> mNavigationJsonsBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<String> mDependencyFetureNamesBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<String> mAllowedNonUniqueNamespaces = new ImmutableList.Builder();
        private String mGeneratedLocaleConfigAttribute = null;
        private static final Pattern FEATURE_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9_]*");

        public Invoker setOverride(ManifestSystemProperty override, String value) {
            this.mSystemProperties.put((Object)override, (Object)value);
            return this;
        }

        public Invoker setPlaceHolderValues(Map<String, Object> keyValuePairs) {
            this.mPlaceholders.putAll(keyValuePairs);
            return this;
        }

        public Invoker setPlaceHolderValue(String placeHolderName, String value) {
            this.mPlaceholders.put((Object)placeHolderName, (Object)value);
            return this;
        }

        private Invoker(File mainManifestFile, ILogger logger, MergeType mergeType, XmlDocument.Type documentType) {
            this.mMainManifestFile = (File)Preconditions.checkNotNull((Object)mainManifestFile);
            this.mLogger = logger;
            this.mMergeType = mergeType;
            this.mDocumentType = documentType;
            this.mFeatureName = "";
        }

        public Invoker setMergeReportFile(File mergeReport) {
            this.mReportFile = mergeReport;
            return this;
        }

        public Invoker addLibraryManifest(File file) {
            return this.addLibraryManifest(file.getName(), file);
        }

        public Invoker addLibraryManifest(String name, File file) {
            if (this.mMergeType == MergeType.LIBRARY) {
                throw new IllegalStateException("Cannot add library dependencies manifests when creating a library");
            }
            this.mLibraryFilesBuilder.add((Object)Pair.of((Object)name, (Object)file));
            return this;
        }

        public Invoker addManifestProviders(Iterable<? extends ManifestProvider> providers) {
            for (ManifestProvider manifestProvider : providers) {
                this.mLibraryFilesBuilder.add((Object)Pair.of((Object)manifestProvider.getName(), (Object)manifestProvider.getManifest()));
            }
            return this;
        }

        public Invoker addLibraryManifests(File ... files) {
            for (File file : files) {
                this.addLibraryManifest(file);
            }
            return this;
        }

        public Invoker addFlavorAndBuildTypeManifest(File file) {
            this.mFlavorsAndBuildTypeFiles.add((Object)file);
            return this;
        }

        public Invoker addFlavorAndBuildTypeManifests(File ... files) {
            this.mFlavorsAndBuildTypeFiles.add((Object[])files);
            return this;
        }

        public Invoker withFeatures(Feature ... features) {
            this.mFeaturesBuilder.add((Object[])features);
            return this;
        }

        public Invoker withFileStreamProvider(FileStreamProvider provider) {
            assert (this.mFileStreamProvider == null || provider == null);
            this.mFileStreamProvider = provider;
            return this;
        }

        public Invoker withManifestDocumentProvider(ManifestDocumentProvider provider) {
            assert (this.mManifestDocumentProvider == null || provider == null);
            this.mManifestDocumentProvider = provider;
            return this;
        }

        public Invoker withProcessCancellationChecker(ProcessCancellationChecker checker) {
            assert (this.mProcessCancellationChecker == null);
            this.mProcessCancellationChecker = checker;
            return this;
        }

        public Invoker setFeatureName(String featureName) {
            if (featureName != null) {
                this.mFeatureName = featureName;
                if (!FEATURE_NAME_PATTERN.matcher(this.mFeatureName).matches()) {
                    throw new IllegalArgumentException("FeatureName must follow " + FEATURE_NAME_PATTERN.pattern() + " regex, found " + featureName);
                }
            }
            return this;
        }

        public Invoker setNamespace(String namespace) {
            this.mNamespace = namespace;
            return this;
        }

        public Invoker addNavigationFiles(Iterable<File> files) {
            this.mNavigationFilesBuilder.addAll(files);
            return this;
        }

        public Invoker addNavigationJsons(Iterable<File> files) {
            this.mNavigationJsonsBuilder.addAll(files);
            return this;
        }

        public Invoker asType(XmlDocument.Type type) {
            this.mDocumentType = type;
            return this;
        }

        public Invoker addDependencyFeatureNames(Iterable<String> names) {
            this.mDependencyFetureNamesBuilder.addAll(names);
            return this;
        }

        public Invoker addAllowedNonUniqueNamespace(String namespace) {
            this.mAllowedNonUniqueNamespaces.add((Object)namespace);
            return this;
        }

        public Invoker setGeneratedLocaleConfigAttribute(String generatedLocaleConfigAttribute) {
            this.mGeneratedLocaleConfigAttribute = generatedLocaleConfigAttribute;
            return this;
        }

        public MergingReport merge() throws MergeFailureException {
            ImmutableMap systemProperties = this.mSystemProperties.build();
            if (systemProperties.containsKey((Object)ManifestSystemProperty.Document.PACKAGE)) {
                this.mPlaceholders.put((Object)"packageName", systemProperties.get((Object)ManifestSystemProperty.Document.PACKAGE));
                if (this.mMergeType != MergeType.LIBRARY) {
                    this.mPlaceholders.put((Object)"applicationId", systemProperties.get((Object)ManifestSystemProperty.Document.PACKAGE));
                }
            }
            FileStreamProvider fileStreamProvider = this.mFileStreamProvider != null ? this.mFileStreamProvider : new FileStreamProvider();
            ProcessCancellationChecker processCancellationChecker = this.mProcessCancellationChecker != null ? this.mProcessCancellationChecker : () -> {};
            this.addAllowedNonUniqueNamespace("androidx.test");
            ManifestMerger2 manifestMerger = new ManifestMerger2(this.mLogger, this.mMainManifestFile, (ImmutableList<Pair<String, File>>)this.mLibraryFilesBuilder.build(), (ImmutableList<File>)this.mFlavorsAndBuildTypeFiles.build(), (ImmutableList<Feature>)this.mFeaturesBuilder.build(), (Map<String, Object>)this.mPlaceholders.build(), new MapBasedKeyBasedValueResolver<ManifestSystemProperty>((Map<ManifestSystemProperty, Object>)systemProperties), this.mMergeType, this.mDocumentType, Optional.ofNullable(this.mReportFile), this.mFeatureName, this.mNamespace, fileStreamProvider, this.mManifestDocumentProvider, processCancellationChecker, (ImmutableList<File>)this.mNavigationFilesBuilder.build(), (ImmutableList<File>)this.mNavigationJsonsBuilder.build(), (ImmutableList<String>)this.mDependencyFetureNamesBuilder.build(), (ImmutableList<String>)this.mAllowedNonUniqueNamespaces.build(), this.mGeneratedLocaleConfigAttribute);
            return manifestMerger.merge();
        }

        public static enum Feature {
            KEEP_INTERMEDIARY_STAGES,
            PRINT_SIMPLE_FILENAMES,
            EXTRACT_FQCNS,
            REMOVE_TOOLS_DECLARATIONS,
            NO_PLACEHOLDER_REPLACEMENT,
            MAKE_AAPT_SAFE,
            SKIP_BLAME,
            SKIP_XML_STRING,
            TEST_ONLY,
            NO_IMPLICIT_PERMISSION_ADDITION,
            ADVANCED_PROFILING,
            ADD_DYNAMIC_FEATURE_ATTRIBUTES,
            DEBUGGABLE,
            HANDLE_VALUE_CONFLICTS_AUTOMATICALLY,
            ADD_ANDROIDX_MULTIDEX_APPLICATION_IF_NO_NAME,
            ADD_SUPPORT_MULTIDEX_APPLICATION_IF_NO_NAME,
            FULLY_NAMESPACE_LOCAL_RESOURCES,
            DISABLE_PACKAGE_NAME_UNIQUENESS_CHECK,
            ENFORCE_UNIQUE_PACKAGE_NAME,
            DISABLE_MINSDKLIBRARY_CHECK,
            CHECK_IF_PACKAGE_IN_MAIN_MANIFEST,
            DISABLE_STRIP_LIBRARY_TARGET_SDK,
            KEEP_GOING_AFTER_ERRORS,
            VALIDATE_EXTRACT_NATIVE_LIBS_FROM_DEPENDENCIES,
            SUPPRESS_MANIFEST_PACKAGE_WARNING;

        }
    }

    public static class SelectorResolver
    implements KeyResolver<String> {
        private final Map<String, String> mSelectors = new HashMap<String, String>();

        protected void addSelector(String key, String value) {
            this.mSelectors.put(key, value);
        }

        @Override
        public String resolve(String key) {
            return this.mSelectors.get(key);
        }

        @Override
        public Iterable<String> getKeys() {
            return this.mSelectors.keySet();
        }
    }

    private static class ManifestInfo {
        private final String mName;
        private final File mLocation;
        private final XmlDocument.Type mType;

        private ManifestInfo(String name, File location, XmlDocument.Type type) {
            this.mName = name;
            this.mLocation = location;
            this.mType = type;
        }

        String getName() {
            return this.mName;
        }

        File getLocation() {
            return this.mLocation;
        }

        XmlDocument.Type getType() {
            return this.mType;
        }
    }

    private static class LoadedManifestInfo
    extends ManifestInfo {
        private final XmlDocument mXmlDocument;

        private LoadedManifestInfo(ManifestInfo manifestInfo, XmlDocument xmlDocument) {
            super(manifestInfo.mName, manifestInfo.mLocation, manifestInfo.mType);
            this.mXmlDocument = xmlDocument;
        }

        public XmlDocument getXmlDocument() {
            return this.mXmlDocument;
        }

        public String getNamespace() {
            return this.mXmlDocument.getNamespace();
        }
    }

    public static class MergeFailureException
    extends Exception {
        protected MergeFailureException(String msg, Exception cause) {
            super(msg, cause);
        }

        protected MergeFailureException(Exception cause) {
            super(cause);
        }
    }

    public static class MapBasedKeyBasedValueResolver<T>
    implements PlaceholderHandler.KeyBasedValueResolver<T> {
        private final ImmutableMap<T, Object> keyValues;

        public MapBasedKeyBasedValueResolver(Map<T, Object> keyValues) {
            this.keyValues = ImmutableMap.copyOf(keyValues);
        }

        @Override
        public String getValue(T key) {
            Object value = this.keyValues.get(key);
            return value == null ? null : value.toString();
        }
    }

    public static interface AutoAddingProperty {
        public void addTo(ActionRecorder var1, XmlDocument var2, String var3);
    }
}

