/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.concurrency;

import com.android.utils.JvmWideVariable;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ReadWriteThreadLock {
    private static final ConcurrentMap<Object, ReentrantReadWriteLock> lockMap = new JvmWideVariable<ConcurrentMap>(ReadWriteThreadLock.class, "lockMap", new TypeToken<ConcurrentMap<Object, ReentrantReadWriteLock>>(){}, ConcurrentHashMap::new).get();
    private static final ConcurrentMap<String, Class> lockOjectClassMap = new JvmWideVariable<ConcurrentMap>(ReadWriteThreadLock.class, "lockOjectClassMap", new TypeToken<ConcurrentMap<String, Class>>(){}, ConcurrentHashMap::new).get();
    private final Lock readLock = new ReadLock();
    private final Lock writeLock = new WriteLock();
    private final Object lockObject;
    private final ReentrantReadWriteLock lock;

    public ReadWriteThreadLock(Object lockObject) {
        lockOjectClassMap.putIfAbsent(lockObject.getClass().getName(), lockObject.getClass());
        Preconditions.checkArgument((lockObject.getClass() == lockOjectClassMap.get(lockObject.getClass().getName()) ? 1 : 0) != 0, (Object)String.format("Lock object's class %1$s must be loaded once but is loaded twice", lockObject.getClass().getName()));
        this.lockObject = lockObject;
        this.lock = lockMap.computeIfAbsent(lockObject, any -> new ReentrantReadWriteLock());
    }

    public Lock readLock() {
        return this.readLock;
    }

    public Lock writeLock() {
        return this.writeLock;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("lockObject", this.lockObject).toString();
    }

    private final class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() {
            ReadWriteThreadLock.this.lock.writeLock().lock();
        }

        @Override
        public void unlock() {
            ReadWriteThreadLock.this.lock.writeLock().unlock();
        }
    }

    private final class ReadLock
    implements Lock {
        private ReadLock() {
        }

        @Override
        public void lock() {
            ReadWriteThreadLock.this.lock.readLock().lock();
        }

        @Override
        public void unlock() {
            ReadWriteThreadLock.this.lock.readLock().unlock();
        }
    }

    public static interface Lock {
        public void lock();

        public void unlock();
    }
}

