/*
 * Decompiled with CFR 0.152.
 */
package com.android.support;

import com.android.support.AndroidxName;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Comparator;
import java.util.logging.Logger;

public class AndroidxNameUtils {
    static final String ANDROID_SUPPORT_PKG = "android.support.";
    static final ImmutableMap<String, String> ANDROIDX_PKG_MAPPING = ImmutableMap.builder().put((Object)"android.support.design.", (Object)"androidx.").put((Object)"android.support.v17.", (Object)"androidx.").put((Object)"android.support.v14.", (Object)"androidx.").put((Object)"android.support.v13.", (Object)"androidx.").put((Object)"android.support.v8.", (Object)"androidx.").put((Object)"android.support.v7.", (Object)"androidx.").put((Object)"android.support.v4.", (Object)"androidx.").put((Object)"android.support.customtabs.", (Object)"androidx.browser.customtabs.").put((Object)"android.support.percent.", (Object)"androidx.widget.").put((Object)"android.support.", (Object)"androidx.").build();
    static final ImmutableMap<String, String> ANDROIDX_FULL_CLASS_MAPPING = ImmutableMap.builder().put((Object)"android.support.v4.view.ViewPager", (Object)"androidx.widget.ViewPager").put((Object)"android.support.v4.view.PagerAdapter", (Object)"androidx.widget.PagerAdapter").put((Object)"android.support.v4.view.PagerTabStrip", (Object)"androidx.widget.PagerTabStrip").put((Object)"android.support.v4.view.PagerTitleStrip", (Object)"androidx.widget.PagerTitleStrip").put((Object)"android.support.v7.graphics.ColorCutQuantizer", (Object)"androidx.graphics.palette.ColorCutQuantizer").put((Object)"android.support.v7.graphics.Palette", (Object)"androidx.graphics.palette.Palette").put((Object)"android.support.v7.graphics.Target", (Object)"androidx.graphics.palette.Target").build();
    private static final ImmutableBiMap<String, String> ANDROIDX_COORDINATES_MAPPING = ImmutableBiMap.builder().put((Object)"com.android.support:animated-vector-drawable", (Object)"androidx:animatedvectordrawable").put((Object)"com.android.support:multidex-instrumentation", (Object)"androidx.multidex:instrumentation").put((Object)"com.android.support:preference-leanback-v17", (Object)"androidx.leanback:preference").put((Object)"com.android.support:appcompat", (Object)"androidx:appcompat").put((Object)"com.android.support:design", (Object)"androidx:design").put((Object)"com.android.support:recyclerview-v7", (Object)"androidx:recyclerview").build();
    static final ImmutableList<String> ANDROIDX_OLD_PKGS = ImmutableList.sortedCopyOf((Comparator)new Ordering<String>(){

        public int compare(String left, String right) {
            return Ints.compare((int)right.length(), (int)left.length());
        }
    }, (Iterable)ANDROIDX_PKG_MAPPING.keySet());

    static String getPackageMapping(String oldPkgName, boolean strictChecking) {
        int n = ANDROIDX_OLD_PKGS.size();
        for (int i = 0; i < n; ++i) {
            String prefix = (String)ANDROIDX_OLD_PKGS.get(i);
            if (!oldPkgName.startsWith(prefix)) continue;
            return (String)ANDROIDX_PKG_MAPPING.get((Object)prefix) + oldPkgName.substring(prefix.length());
        }
        if (strictChecking) {
            assert (false) : "support library package not found" + oldPkgName;
            Logger.getLogger(AndroidxName.class.getName()).warning("support library package not found");
        }
        return oldPkgName;
    }

    public static Collection<String> getAllAndroidxCoordinates() {
        return ANDROIDX_COORDINATES_MAPPING.values();
    }

    public static String getCoordinateMapping(String coordinate) {
        return (String)ANDROIDX_COORDINATES_MAPPING.getOrDefault((Object)coordinate, (Object)coordinate);
    }

    public static String getCoordinateReverseMapping(String coordinate) {
        return (String)ANDROIDX_COORDINATES_MAPPING.inverse().getOrDefault((Object)coordinate, (Object)coordinate);
    }

    public static String getNewName(String oldName) {
        String newName = (String)ANDROIDX_FULL_CLASS_MAPPING.get((Object)oldName);
        if (newName != null) {
            return newName;
        }
        int lastDot = oldName.lastIndexOf(46);
        return AndroidxNameUtils.getPackageMapping(oldName.substring(0, lastDot + 1), false) + oldName.substring(lastDot + 1);
    }
}

