/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.CharSequences;

public class OffsetTrackingDecodedXmlValue {
    private static final char[] DECODED = new char[]{'<', '>', '&', '\'', '\"'};
    private static final String[] ENCODED = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;"};
    private final CharSequence myDecodedCharacters;
    private final int[] myOffsetMap;

    public OffsetTrackingDecodedXmlValue(CharSequence encodedValue) {
        StringBuilder decodedValue = null;
        int[] offsetMap = null;
        int escapedLength = encodedValue.length();
        int i = 0;
        block0: while (i < escapedLength) {
            for (int j = 0; j < ENCODED.length; ++j) {
                String toReplace = ENCODED[j];
                if (i + toReplace.length() > escapedLength || !CharSequences.regionMatches(encodedValue, i, toReplace, 0, toReplace.length())) continue;
                if (decodedValue == null) {
                    decodedValue = new StringBuilder(escapedLength);
                    offsetMap = new int[escapedLength];
                    for (int k = 0; k < i; ++k) {
                        offsetMap[k] = k;
                        decodedValue.append(encodedValue.charAt(k));
                    }
                }
                decodedValue.append(DECODED[j]);
                offsetMap[decodedValue.length() - 1] = i += toReplace.length();
                continue block0;
            }
            if (decodedValue != null) {
                decodedValue.append(encodedValue.charAt(i));
                offsetMap[decodedValue.length() - 1] = i;
            }
            ++i;
        }
        this.myOffsetMap = offsetMap;
        this.myDecodedCharacters = decodedValue == null ? encodedValue : decodedValue.toString();
    }

    public CharSequence getDecodedCharacters() {
        return this.myDecodedCharacters;
    }

    public int getEncodedOffset(int decodedOffset) {
        if (this.myOffsetMap == null || decodedOffset <= 0) {
            return decodedOffset;
        }
        if (decodedOffset <= this.myDecodedCharacters.length()) {
            return this.myOffsetMap[decodedOffset - 1];
        }
        return this.myOffsetMap[this.myDecodedCharacters.length() - 1] + decodedOffset - this.myDecodedCharacters.length();
    }
}

