/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.SdkConstants;
import com.android.utils.TokenizedCommandLineKt;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0007J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0007J\u000e\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0003J\u0006\u0010%\u001a\u00020\u0007J\u0010\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020\u0007J6\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00072\b\b\u0002\u0010+\u001a\u00020\u00052\b\b\u0002\u0010,\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020\u0005J\b\u0010.\u001a\u00020\u0003H\u0016J\u000e\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000301J*\u00102\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020\u0005H\u0007J\u0010\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0007H\u0002J\u0010\u00105\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u00106\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/utils/TokenizedCommandLine;", "", "commandLine", "", "raw", "", "platform", "", "indexes", "", "(Ljava/lang/String;ZI[I)V", "getCommandLine", "()Ljava/lang/String;", "generation", "getPlatform", "()I", "getRaw", "()Z", "toStringValue", "bothSlash", "c1", "", "c2", "charAt", "i", "(I)Ljava/lang/Character;", "checkGeneration", "", "computeNormalizedCommandLineHashCode", "invalidate", "isEndOfCommand", "isEndOfToken", "isStartOfToken", "nextTokenAfter", "offset", "normalizedCommandLineEquals", "other", "normalizedCommandLineLength", "removeNth", "n", "removeTokenGroup", "token", "extra", "matchPrefix", "returnFirstExtra", "filePathSlashAgnostic", "toString", "separator", "toTokenList", "", "tokenMatches", "tokenStartingAt", "start", "zeroAllocTokenizePOSIX", "zeroAllocTokenizeWindows", "common"})
public final class TokenizedCommandLine {
    @NotNull
    private final String commandLine;
    private final boolean raw;
    private final int platform;
    @NotNull
    private int[] indexes;
    private final int generation;
    @Nullable
    private String toStringValue;

    public TokenizedCommandLine(@NotNull String commandLine, boolean raw, int platform, @NotNull int[] indexes) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)indexes, (String)"indexes");
        this.commandLine = commandLine;
        this.raw = raw;
        this.platform = platform;
        int[] nArray = this.indexes = indexes;
        nArray[0] = nArray[0] + 1;
        this.generation = nArray[0];
        this.checkGeneration();
        if (this.platform == 2) {
            this.zeroAllocTokenizeWindows(this.raw);
        } else {
            this.zeroAllocTokenizePOSIX(this.raw);
        }
    }

    public /* synthetic */ TokenizedCommandLine(String string, boolean bl, int n, int[] nArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = SdkConstants.currentPlatform();
        }
        if ((n2 & 8) != 0) {
            nArray = TokenizedCommandLineKt.allocateTokenizeCommandLineBuffer(string);
        }
        this(string, bl, n, nArray);
    }

    @NotNull
    public final String getCommandLine() {
        return this.commandLine;
    }

    public final boolean getRaw() {
        return this.raw;
    }

    public final int getPlatform() {
        return this.platform;
    }

    @Nullable
    public final String removeTokenGroup(@NotNull String token, int extra, boolean matchPrefix, boolean returnFirstExtra, boolean filePathSlashAgnostic) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.checkGeneration();
        this.invalidate();
        int read = 1;
        int write = 1;
        String firstExtra = null;
        do {
            int n;
            int n2 = n = read >= write ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n = this.isStartOfToken(read);
            if (_Assertions.ENABLED && n == 0) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n = this.isStartOfToken(write);
            if (_Assertions.ENABLED && n == 0) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (this.tokenMatches(token, read, matchPrefix, filePathSlashAgnostic)) {
                if (returnFirstExtra) {
                    firstExtra = matchPrefix ? this.tokenStartingAt(read + token.length()) : this.tokenStartingAt(this.nextTokenAfter(read));
                }
                for (int count = 0; count != extra + 1 && !this.isEndOfCommand(read); ++count) {
                    read = this.nextTokenAfter(read);
                }
            } else {
                if (this.isEndOfCommand(read) || this.isEndOfCommand(write)) continue;
                do {
                    n = write;
                    write = n + 1;
                    int n3 = n;
                    n = read;
                    read = n + 1;
                    this.indexes[n3] = this.indexes[n];
                } while (!this.isEndOfToken(read - 1));
            }
        } while (!this.isEndOfCommand(read));
        this.indexes[write] = Integer.MIN_VALUE;
        return firstExtra;
    }

    public static /* synthetic */ String removeTokenGroup$default(TokenizedCommandLine tokenizedCommandLine, String string, int n, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = false;
        }
        return tokenizedCommandLine.removeTokenGroup(string, n, bl, bl2, bl3);
    }

    private final String tokenStartingAt(int start) {
        this.checkGeneration();
        StringBuilder token = new StringBuilder();
        int n = start;
        int n2 = this.indexes.length;
        block4: while (n < n2) {
            int read = n++;
            int offset = this.indexes[read];
            switch (offset) {
                case -2147483648: {
                    break block4;
                }
                case 0x7FFFFFFF: {
                    break block4;
                }
                default: {
                    token.append(this.commandLine.charAt(offset));
                    continue block4;
                }
            }
        }
        return ((Object)StringsKt.trim((CharSequence)token)).toString();
    }

    @Nullable
    public final String removeNth(int n) {
        this.checkGeneration();
        this.invalidate();
        StringBuilder token = new StringBuilder();
        int tokenNumber = 0;
        int write = 1;
        int n2 = 1;
        int n3 = this.indexes.length;
        block4: while (n2 < n3) {
            int read = n2++;
            if (tokenNumber != n) {
                int n4 = write;
                write = n4 + 1;
                this.indexes[n4] = this.indexes[read];
            }
            int offset = this.indexes[read];
            switch (offset) {
                case -2147483648: {
                    if (((CharSequence)token).length() == 0) {
                        return null;
                    }
                    return token.toString();
                }
                case 0x7FFFFFFF: {
                    int n5 = tokenNumber;
                    tokenNumber = n5 + 1;
                    continue block4;
                }
            }
            if (tokenNumber != n) continue;
            token.append(this.commandLine.charAt(offset));
        }
        return null;
    }

    @NotNull
    public final List<String> toTokenList() {
        this.checkGeneration();
        List result = new ArrayList();
        StringBuilder token = new StringBuilder();
        int i = 1;
        while (!this.isEndOfCommand(i)) {
            Character c = this.charAt(i);
            if (c == null) {
                if (((CharSequence)token).length() > 0) {
                    String string = token.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"token.toString()");
                    result.add(string);
                    token.setLength(0);
                }
            } else {
                token.append(c.charValue());
            }
            ++i;
        }
        return result;
    }

    private final TokenizedCommandLine zeroAllocTokenizeWindows(boolean raw) {
        int n;
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        int i = 0;
        int length = this.commandLine.length();
        Character c = null;
        int offset = 0;
        offset = 1;
        while (i < length && Character.isWhitespace(this.commandLine.charAt(i))) {
            n = i;
            i = n + 1;
        }
        block1: while (i < length) {
            c = Character.valueOf(this.commandLine.charAt(i));
            n = 34;
            if (c.charValue() == n) {
                if (raw) {
                    n = offset;
                    offset = n + 1;
                    this.indexes[n] = i;
                }
                quoting = !quoting;
                ++i;
                continue;
            }
            n = 92;
            if (c.charValue() == n) {
                boolean quote;
                int forward = i + 1;
                int slashCount = 1;
                c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)forward);
                while (true) {
                    Character c2 = c;
                    char c3 = '\\';
                    if (c2 == null || c2.charValue() != c3) break;
                    ++slashCount;
                    c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++forward));
                }
                boolean odd = slashCount % 2 == 1;
                Character c4 = c;
                int n2 = 34;
                boolean bl = quote = c4 != null && c4.charValue() == n2;
                if (!raw && quote) {
                    slashCount /= 2;
                }
                n2 = 0;
                int n3 = slashCount;
                while (n2 < n3) {
                    int j = n2++;
                    boolean bl2 = false;
                    int n4 = offset;
                    offset = n4 + 1;
                    this.indexes[n4] = i + j;
                }
                if (odd && quote) {
                    n2 = offset;
                    offset = n2 + 1;
                    int n5 = n2;
                    n2 = forward;
                    forward = n2 + 1;
                    this.indexes[n5] = n2;
                }
                i = forward;
                continue;
            }
            if (!quoting) {
                n = 94;
                if (c.charValue() == n) {
                    c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i));
                    if (raw || c == null) {
                        n = offset;
                        offset = n + 1;
                        this.indexes[n] = i - 1;
                    }
                    Character c5 = c;
                    n = 94;
                    if (c5 != null && c5.charValue() == n) {
                        n = offset;
                        offset = n + 1;
                        int n6 = n;
                        n = i;
                        i = n + 1;
                        this.indexes[n6] = n;
                    }
                    while (true) {
                        Character c6 = c;
                        n = 13;
                        if (c6 == null || c6.charValue() != n) {
                            Character c7 = c;
                            n = 10;
                            if (c7 == null || c7.charValue() != n) continue block1;
                        }
                        c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i));
                    }
                }
            }
            if (!quoting && Character.isWhitespace(c.charValue())) {
                n = offset;
                offset = n + 1;
                this.indexes[n] = Integer.MAX_VALUE;
                c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i));
                while (c != null && Character.isWhitespace(c.charValue())) {
                    c = StringsKt.getOrNull((CharSequence)this.commandLine, (int)(++i));
                }
                continue;
            }
            n = offset;
            offset = n + 1;
            int n7 = n;
            n = i;
            i = n + 1;
            this.indexes[n7] = n;
        }
        if (!this.isEndOfToken(offset - 1)) {
            n = offset;
            offset = n + 1;
            this.indexes[n] = Integer.MAX_VALUE;
        }
        n = offset;
        offset = n + 1;
        this.indexes[n] = Integer.MIN_VALUE;
        return this;
    }

    private final TokenizedCommandLine zeroAllocTokenizePOSIX(boolean raw) {
        int n;
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        boolean skipping = true;
        int i = 0;
        char c = '\u0000';
        int length = this.commandLine.length();
        int offset = 1;
        while (i < length) {
            n = i;
            i = n + 1;
            c = this.commandLine.charAt(n);
            if (skipping) {
                if (Character.isWhitespace(c)) continue;
                skipping = false;
            }
            if ((quoting || !Character.isWhitespace(c)) && raw) {
                n = offset;
                offset = n + 1;
                this.indexes[n] = i - 1;
            }
            if (escaping) {
                escaping = false;
                if (c == '\n' || raw) continue;
                n = offset;
                offset = n + 1;
                this.indexes[n] = i - 1;
                continue;
            }
            if (!(c != '\\' || quoting && quote != '\"')) {
                escaping = true;
                continue;
            }
            if (!(quoting || c != '\"' && c != '\'')) {
                quoting = true;
                quote = c;
                continue;
            }
            if (quoting && c == quote) {
                quoting = false;
                quote = '\u0000';
                continue;
            }
            if (!quoting && Character.isWhitespace(c)) {
                skipping = true;
                n = offset;
                offset = n + 1;
                this.indexes[n] = Integer.MAX_VALUE;
                continue;
            }
            if (raw) continue;
            n = offset;
            offset = n + 1;
            this.indexes[n] = i - 1;
        }
        if (!this.isEndOfToken(offset - 1)) {
            n = offset;
            offset = n + 1;
            this.indexes[n] = Integer.MAX_VALUE;
        }
        this.indexes[offset] = Integer.MIN_VALUE;
        return this;
    }

    @VisibleForTesting
    public final boolean tokenMatches(@NotNull String token, int offset, boolean matchPrefix, boolean filePathSlashAgnostic) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.checkGeneration();
        int i = 0;
        int index = this.indexes[offset];
        while (index != Integer.MIN_VALUE) {
            char c2;
            boolean endOfToken;
            boolean bl = endOfToken = index == Integer.MAX_VALUE;
            if (i == token.length()) {
                return endOfToken || matchPrefix;
            }
            if (endOfToken) {
                return false;
            }
            char c1 = token.charAt(i);
            if (!(c1 == (c2 = this.commandLine.charAt(index)) || filePathSlashAgnostic && this.bothSlash(c1, c2))) {
                return false;
            }
            index = this.indexes[offset + ++i];
        }
        return false;
    }

    public static /* synthetic */ boolean tokenMatches$default(TokenizedCommandLine tokenizedCommandLine, String string, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return tokenizedCommandLine.tokenMatches(string, n, bl, bl2);
    }

    private final boolean bothSlash(char c1, char c2) {
        if (c1 != '\\' && c1 != '/') {
            return false;
        }
        return c2 == '\\' || c2 == '/';
    }

    @VisibleForTesting
    public final int nextTokenAfter(int offset) {
        this.checkGeneration();
        int result = offset;
        while (!this.isEndOfToken(result) && !this.isEndOfCommand(result)) {
            ++result;
        }
        return result + 1;
    }

    private final boolean isEndOfToken(int i) {
        return i < this.indexes.length && this.indexes[i] == Integer.MAX_VALUE;
    }

    private final boolean isEndOfCommand(int i) {
        return i >= this.indexes.length || this.indexes[i] == Integer.MIN_VALUE;
    }

    private final boolean isStartOfToken(int i) {
        return i == 1 || this.isEndOfToken(i - 1);
    }

    private final Character charAt(int i) {
        return this.isEndOfToken(i) ? null : Character.valueOf(this.commandLine.charAt(this.indexes[i]));
    }

    public final int normalizedCommandLineLength() {
        int n;
        if (this.isEndOfCommand(1)) {
            n = 0;
        } else {
            int i = 1;
            while (!this.isEndOfCommand(i + 1)) {
                ++i;
            }
            n = i - 1;
        }
        return n;
    }

    public final int computeNormalizedCommandLineHashCode() {
        this.checkGeneration();
        long hash = 1469598103934665603L;
        int i = 1;
        while (!this.isEndOfCommand(i) && !this.isEndOfCommand(i + 1)) {
            Character c = this.charAt(i);
            hash ^= (long)(c == null ? 32 : c.charValue());
            hash *= 1099511628211L;
            ++i;
        }
        return (int)hash;
    }

    public final boolean normalizedCommandLineEquals(@NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int length1 = this.normalizedCommandLineLength();
        int length2 = other.length();
        if (length1 == 0 && length2 == 0) {
            return true;
        }
        if (length1 != length2) {
            return false;
        }
        int n = 1;
        while (n < length1) {
            int i = n++;
            Character c = this.charAt(i);
            if ((c == null ? (char)' ' : c.charValue()) == other.charAt(i - 1)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final String toString(@NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        this.checkGeneration();
        int i = 1;
        if (this.isEndOfCommand(i)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (!this.isEndOfCommand(i + 1)) {
            Object object = this.charAt(i);
            if (object == null) {
                object = separator;
            }
            sb.append(object);
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        if (this.toStringValue != null) {
            String string = this.toStringValue;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        String string = this.toStringValue = this.toString(" ");
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final void invalidate() {
        this.toStringValue = null;
    }

    private final void checkGeneration() {
        if (this.generation != Math.abs(this.indexes[0])) {
            throw new Exception("Buffer indexes was shared with another TokenizedCommandLine after this one");
        }
    }
}

