/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.google.common.base.Objects;
import java.io.Serializable;

public final class SourcePosition
implements Serializable {
    public static final SourcePosition UNKNOWN = new SourcePosition();
    private final int mStartLine;
    private final int mStartColumn;
    private final int mStartOffset;
    private final int mEndLine;
    private final int mEndColumn;
    private final int mEndOffset;

    public SourcePosition(int startLine, int startColumn, int startOffset, int endLine, int endColumn, int endOffset) {
        this.mStartLine = startLine;
        this.mStartColumn = startColumn;
        this.mStartOffset = startOffset;
        this.mEndLine = endLine;
        this.mEndColumn = endColumn;
        this.mEndOffset = endOffset;
    }

    public SourcePosition(int lineNumber, int column, int offset) {
        this.mStartLine = this.mEndLine = lineNumber;
        this.mStartColumn = this.mEndColumn = column;
        this.mStartOffset = this.mEndOffset = offset;
    }

    private SourcePosition() {
        this.mEndOffset = -1;
        this.mEndColumn = -1;
        this.mEndLine = -1;
        this.mStartOffset = -1;
        this.mStartColumn = -1;
        this.mStartLine = -1;
    }

    protected SourcePosition(SourcePosition copy) {
        this.mStartLine = copy.getStartLine();
        this.mStartColumn = copy.getStartColumn();
        this.mStartOffset = copy.getStartOffset();
        this.mEndLine = copy.getEndLine();
        this.mEndColumn = copy.getEndColumn();
        this.mEndOffset = copy.getEndOffset();
    }

    public String toString() {
        if (this.mStartLine == -1) {
            return "?";
        }
        StringBuilder sB = new StringBuilder(15);
        sB.append(this.mStartLine + 1);
        if (this.mStartColumn != -1) {
            sB.append(':');
            sB.append(this.mStartColumn + 1);
        }
        if (this.mEndLine != -1) {
            if (this.mEndLine == this.mStartLine) {
                if (this.mEndColumn != -1 && this.mEndColumn != this.mStartColumn) {
                    sB.append('-');
                    sB.append(this.mEndColumn + 1);
                }
            } else {
                sB.append('-');
                sB.append(this.mEndLine + 1);
                if (this.mEndColumn != -1) {
                    sB.append(':');
                    sB.append(this.mEndColumn + 1);
                } else if (this.mStartColumn != -1) {
                    sB.append(":?");
                }
            }
        }
        return sB.toString();
    }

    private static int parseString(String string) {
        if (string.equals("?")) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static SourcePosition fromString(String string) {
        int startLine;
        if (string.equals("?")) {
            return UNKNOWN;
        }
        int endLine = 0;
        int startColumn = 0;
        int endColumn = 0;
        if (string.contains("-")) {
            String[] startAndEndPositions = string.split("-");
            if (startAndEndPositions[0].contains(":")) {
                String[] startPosition = startAndEndPositions[0].split(":");
                startLine = SourcePosition.parseString(startPosition[0]);
                startColumn = SourcePosition.parseString(startPosition[1]);
            } else {
                startLine = SourcePosition.parseString(startAndEndPositions[0]);
            }
            if (startAndEndPositions[1].contains(":")) {
                String[] endPosition = startAndEndPositions[1].split(":");
                endLine = SourcePosition.parseString(endPosition[0]);
                endColumn = SourcePosition.parseString(endPosition[1]);
            } else if (startColumn != 0) {
                endLine = startLine;
                endColumn = SourcePosition.parseString(startAndEndPositions[1]);
            } else {
                endLine = SourcePosition.parseString(startAndEndPositions[1]);
            }
        } else if (string.contains(":")) {
            String[] pos = string.split(":");
            startLine = SourcePosition.parseString(pos[0]);
            startColumn = SourcePosition.parseString(pos[1]);
        } else {
            startLine = SourcePosition.parseString(string);
        }
        return new SourcePosition(startLine - 1, startColumn - 1, -1, endLine - 1, endColumn - 1, -1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SourcePosition)) {
            return false;
        }
        SourcePosition other = (SourcePosition)obj;
        return other.mStartLine == this.mStartLine && other.mStartColumn == this.mStartColumn && other.mStartOffset == this.mStartOffset && other.mEndLine == this.mEndLine && other.mEndColumn == this.mEndColumn && other.mEndOffset == this.mEndOffset;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mStartLine, this.mStartColumn, this.mStartOffset, this.mEndLine, this.mEndColumn, this.mEndOffset});
    }

    public int getStartLine() {
        return this.mStartLine;
    }

    public int getStartColumn() {
        return this.mStartColumn;
    }

    public int getStartOffset() {
        return this.mStartOffset;
    }

    public int getEndLine() {
        return this.mEndLine;
    }

    public int getEndColumn() {
        return this.mEndColumn;
    }

    public int getEndOffset() {
        return this.mEndOffset;
    }

    public int compareStart(SourcePosition other) {
        if (this.mStartOffset != -1 && other.mStartOffset != -1) {
            return this.mStartOffset - other.mStartOffset;
        }
        if (this.mStartLine == other.mStartLine && this.mStartColumn != -1 && other.mStartColumn != -1) {
            return this.mStartColumn - other.mStartColumn;
        }
        return this.mStartLine - other.mStartLine;
    }

    public int compareEnd(SourcePosition other) {
        if (this.mEndOffset != -1 && other.mEndOffset != -1) {
            return this.mEndOffset - other.mEndOffset;
        }
        if (this.mEndLine == other.mEndLine && this.mEndColumn != -1 && other.mEndColumn != -1) {
            return this.mEndColumn - other.mEndColumn;
        }
        return this.mEndLine - other.mEndLine;
    }
}

