/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.cxx;

import com.android.utils.cxx.CompileCommandsCodecKt;
import com.android.utils.cxx.Sections;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\fJ\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010#\u001a\u00020\u0019J\b\u0010$\u001a\u0004\u0018\u00010\u0019J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cJ\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001cJ\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020*H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n \t*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u001c\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001c0\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015\u00a8\u0006+"}, d2={"Lcom/android/utils/cxx/CompileCommandsInputStream;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "fileChannel", "Ljava/nio/channels/FileChannel;", "kotlin.jvm.PlatformType", "Ljava/nio/channels/FileChannel;", "size", "", "map", "Ljava/nio/ByteBuffer;", "Ljava/nio/ByteBuffer;", "internedFiles", "", "start", "version", "getVersion", "()I", "positionAfterLastMessage", "strings", "", "", "[Ljava/lang/String;", "stringLists", "", "[Ljava/util/List;", "sourceMessagesCount", "getSourceMessagesCount", "byte", "", "int", "string", "stringOrNull", "stringList", "stringListOrNull", "isEndOfMessages", "", "close", "", "common"})
final class CompileCommandsInputStream
implements AutoCloseable {
    @NotNull
    private final File file;
    private final FileChannel fileChannel;
    private final int size;
    private final ByteBuffer map;
    @NotNull
    private final Map<Integer, File> internedFiles;
    private final int start;
    private final int version;
    private final int positionAfterLastMessage;
    @NotNull
    private final String[] strings;
    @NotNull
    private final List<String>[] stringLists;
    private final int sourceMessagesCount;

    public CompileCommandsInputStream(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.file = file2;
        this.fileChannel = FileChannel.open(this.file.toPath(), new OpenOption[0]);
        this.size = (int)this.file.length();
        this.map = ByteBuffer.allocate(this.size);
        this.internedFiles = new LinkedHashMap();
        this.fileChannel.read(this.map);
        ByteBuffer byteBuffer = this.map;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"map");
        Pair startAndVersion = CompileCommandsCodecKt.access$positionAfterMagicAndVersion(byteBuffer);
        this.start = ((Number)startAndVersion.getFirst()).intValue();
        this.version = ((Number)startAndVersion.getSecond()).intValue();
        if (this.start == 0 || this.version == 0) {
            throw new IllegalStateException((this.file + " is not a valid C/C++ Build Metadata file").toString());
        }
        ByteBuffer byteBuffer2 = this.map;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"map");
        CompileCommandsCodecKt.access$seekSection(byteBuffer2, this.start, Sections.StringTable);
        this.positionAfterLastMessage = this.map.position();
        ByteBuffer byteBuffer3 = this.map;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"map");
        this.strings = CompileCommandsCodecKt.access$readStringTable(byteBuffer3, this.start);
        ByteBuffer byteBuffer4 = this.map;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer4, (String)"map");
        this.stringLists = CompileCommandsCodecKt.access$readStringListsTable(byteBuffer4, this.start, this.strings);
        ByteBuffer byteBuffer5 = this.map;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer5, (String)"map");
        CompileCommandsCodecKt.access$seekSection(byteBuffer5, this.start, Sections.CompileCommands);
        this.sourceMessagesCount = this.int();
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getSourceMessagesCount() {
        return this.sourceMessagesCount;
    }

    public final byte byte() {
        return this.map.get();
    }

    public final int int() {
        return this.map.getInt();
    }

    @NotNull
    public final File file() {
        int index = this.map.getInt();
        if (index == 0) {
            throw new IllegalStateException(("Null file name seen in '" + this.file + "'").toString());
        }
        Function1 function1 = (Function1)new Function1<Integer, File>(this, index){
            final /* synthetic */ CompileCommandsInputStream this$0;
            final /* synthetic */ int $index;
            {
                this.this$0 = $receiver;
                this.$index = $index;
                super(1);
            }

            public final File invoke(Integer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = CompileCommandsInputStream.access$getStrings$p(this.this$0)[this.$index];
                Intrinsics.checkNotNull((Object)string);
                return new File(string);
            }
        };
        File file2 = this.internedFiles.computeIfAbsent(index, new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"computeIfAbsent(...)");
        return file2;
    }

    @NotNull
    public final String string() {
        String string = this.strings[this.map.getInt()];
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Nullable
    public final String stringOrNull() {
        int index = this.map.getInt();
        if (index == 0) {
            return null;
        }
        if (index > this.strings.length) {
            return null;
        }
        return this.strings[index];
    }

    @NotNull
    public final List<String> stringList() {
        return this.stringLists[this.map.getInt()];
    }

    @Nullable
    public final List<String> stringListOrNull() {
        int index = this.map.getInt();
        if (index > this.stringLists.length) {
            return null;
        }
        return this.stringLists[index];
    }

    public final boolean isEndOfMessages() {
        int current = this.map.position();
        return current == this.positionAfterLastMessage;
    }

    @Override
    public void close() {
        this.fileChannel.close();
    }

    public static final /* synthetic */ String[] access$getStrings$p(CompileCommandsInputStream $this) {
        return $this.strings;
    }
}

