/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatHeaderParserKt;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/ddmlib/logcat/LogCatHeaderParser;", "", "defaultYear", "", "defaultZoneId", "Ljava/time/ZoneId;", "(ILjava/time/ZoneId;)V", "getPackageName", "", "device", "Lcom/android/ddmlib/IDevice;", "pid", "parseEpochSeconds", "", "string", "parseHeader", "Lcom/android/ddmlib/logcat/LogCatHeader;", "line", "parsePid", "parsePriority", "Lcom/android/ddmlib/Log$LogLevel;", "parseThreadId", "ddmlib"})
public final class LogCatHeaderParser {
    private final int defaultYear;
    @NotNull
    private final ZoneId defaultZoneId;

    public LogCatHeaderParser(int defaultYear, @NotNull ZoneId defaultZoneId) {
        Intrinsics.checkNotNullParameter((Object)defaultZoneId, (String)"defaultZoneId");
        this.defaultYear = defaultYear;
        this.defaultZoneId = defaultZoneId;
    }

    public /* synthetic */ LogCatHeaderParser(int n, ZoneId zoneId, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = ZonedDateTime.now().getYear();
        }
        if ((n2 & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"systemDefault()");
            zoneId = zoneId2;
        }
        this(n, zoneId);
    }

    @Nullable
    public final LogCatHeader parseHeader(@NotNull String line, @Nullable IDevice device) {
        Instant instant;
        String string;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Matcher m = LogCatHeaderParserKt.access$getHEADER$p().matcher(line);
        if (!m.matches()) {
            return null;
        }
        String epoch = m.group("epoch");
        Instant timestamp = null;
        if (epoch != null) {
            string = m.group("epochSec");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(\"epochSec\")");
            long l = this.parseEpochSeconds(string);
            string = m.group("epochMilli");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(\"epochMilli\")");
            boolean bl = false;
            instant = Instant.ofEpochSecond(l, TimeUnit.MILLISECONDS.toNanos(Long.parseLong(string)));
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(\n         \u2026).toLong())\n            )");
            timestamp = instant;
        } else {
            string = m.group("month");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(\"month\")");
            boolean bl = false;
            int n = Integer.parseInt(string);
            string = m.group("day");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(\"day\")");
            bl = false;
            int n2 = Integer.parseInt(string);
            string = m.group("hour");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(\"hour\")");
            bl = false;
            int n3 = Integer.parseInt(string);
            string = m.group("min");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(\"min\")");
            bl = false;
            int n4 = Integer.parseInt(string);
            string = m.group("sec");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(\"sec\")");
            bl = false;
            int n5 = Integer.parseInt(string);
            string = m.group("milli");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(\"milli\")");
            bl = false;
            instant = Instant.from(ZonedDateTime.of(this.defaultYear, n, n2, n3, n4, n5, (int)TimeUnit.MILLISECONDS.toNanos(Long.parseLong(string)), this.defaultZoneId));
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"from(\n                Zo\u2026          )\n            )");
            timestamp = instant;
        }
        string = m.group("pid");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(\"pid\")");
        int pid = this.parsePid(string);
        string = m.group("priority");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(\"priority\")");
        Log.LogLevel logLevel = this.parsePriority(string);
        string = m.group("tid");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(\"tid\")");
        int n = this.parseThreadId(string);
        String string2 = this.getPackageName(device, pid);
        string = m.group("tag");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(\"tag\")");
        return new LogCatHeader(logLevel, pid, n, string2, string, timestamp);
    }

    private final Log.LogLevel parsePriority(String string) {
        Log.LogLevel priority = Log.LogLevel.getByLetterString(string);
        if (priority != null) {
            return priority;
        }
        if (!Intrinsics.areEqual((Object)string, (Object)"F")) {
            return Log.LogLevel.WARN;
        }
        return Log.LogLevel.ASSERT;
    }

    private final int parseThreadId(String string) {
        int n;
        try {
            Integer n2 = Integer.decode(string);
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"{\n            Integer.decode(string)\n        }");
            n = ((Number)n2).intValue();
        }
        catch (NumberFormatException exception) {
            n = -1;
        }
        return n;
    }

    private final int parsePid(String string) {
        int n;
        try {
            String string2 = string;
            boolean bl = false;
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException exception) {
            n = -1;
        }
        return n;
    }

    private final long parseEpochSeconds(String string) {
        long l;
        try {
            String string2 = string;
            boolean bl = false;
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException exception) {
            l = 0L;
        }
        return l;
    }

    private final String getPackageName(IDevice device, int pid) {
        Object object = device;
        String clientName = object == null ? null : object.getClientName(pid);
        object = clientName;
        boolean bl = false;
        boolean bl2 = false;
        return object == null || object.length() == 0 ? "?" : clientName;
    }

    public LogCatHeaderParser() {
        this(0, null, 3, null);
    }
}

