/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbDevice;
import com.android.ddmlib.AdbInitOptions;
import com.android.ddmlib.AdbVersion;
import com.android.ddmlib.AndroidDebugBridgeDelegate;
import com.android.ddmlib.AndroidDebugBridgeImpl;
import com.android.ddmlib.Client;
import com.android.ddmlib.DDMLibJdwpTracer;
import com.android.ddmlib.DefaultJdwpTracerFactory;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IDeviceUsageTracker;
import com.android.ddmlib.JdwpProcessor;
import com.android.ddmlib.JdwpProcessorFactory;
import com.android.ddmlib.JdwpTracerFactory;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.clientmanager.ClientManager;
import com.android.ddmlib.internal.DefaultJdwpProcessorFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class AndroidDebugBridge {
    private static volatile boolean delegateIsUsed = false;
    private static volatile AndroidDebugBridgeDelegate delegate = new AndroidDebugBridgeImpl();
    public static final AdbVersion MIN_ADB_VERSION = AdbVersion.parseFrom("1.0.20");
    public static final int DEFAULT_START_ADB_TIMEOUT_MILLIS = 20000;
    private static JdwpTracerFactory sJdwpTracerFactory = new DefaultJdwpTracerFactory();
    private static JdwpProcessorFactory sJdwpProcessorFactory = new DefaultJdwpProcessorFactory();

    public static void preInit(AndroidDebugBridgeDelegate delegate) {
        if (delegateIsUsed) {
            Log.w("ddmlib", "AndroidDebugBridgeDelegate assignment after its use");
        }
        if (AndroidDebugBridge.delegate.getBridge() != null) {
            throw new IllegalStateException("preInit() called after `AndroidDebugBridge` instance was created");
        }
        AndroidDebugBridge.delegate = delegate;
    }

    @VisibleForTesting
    public static void resetForTests() {
        delegateIsUsed = false;
        delegate = new AndroidDebugBridgeImpl();
    }

    @Deprecated
    public static void initIfNeeded(boolean clientSupport) {
        delegateIsUsed = true;
        delegate.initIfNeeded(clientSupport);
    }

    public static void init(boolean clientSupport) {
        delegateIsUsed = true;
        delegate.init(clientSupport);
    }

    public static void init(boolean clientSupport, boolean useLibusb, Map<String, String> env) {
        delegateIsUsed = true;
        delegate.init(AdbInitOptions.builder().withEnv(env).setClientSupportEnabled(clientSupport).withEnv("ADB_LIBUSB", useLibusb ? "1" : "0").build());
    }

    public static void init(AdbInitOptions options) {
        delegateIsUsed = true;
        delegate.init(options);
    }

    public static boolean optionsChanged(AdbInitOptions options, String osLocation, boolean forceNewBridge, long terminateTimeout, long initTimeout, TimeUnit unit) {
        delegateIsUsed = true;
        return delegate.optionsChanged(options, osLocation, forceNewBridge, terminateTimeout, initTimeout, unit);
    }

    @VisibleForTesting
    public static void enableFakeAdbServerMode(int port) {
        delegateIsUsed = true;
        delegate.enableFakeAdbServerMode(port);
    }

    @VisibleForTesting
    public static void disableFakeAdbServerMode() {
        delegateIsUsed = true;
        delegate.disableFakeAdbServerMode();
    }

    public static void terminate() {
        delegateIsUsed = true;
        delegate.terminate();
    }

    public static boolean getClientSupport() {
        delegateIsUsed = true;
        return delegate.getClientSupport();
    }

    public ClientManager getClientManager() {
        delegateIsUsed = true;
        return delegate.getClientManager();
    }

    @Deprecated
    public static InetSocketAddress getSocketAddress() {
        delegateIsUsed = true;
        return delegate.getSocketAddress();
    }

    public static SocketChannel openConnection() throws IOException {
        delegateIsUsed = true;
        return delegate.openConnection();
    }

    @Deprecated
    public static AndroidDebugBridge createBridge() {
        delegateIsUsed = true;
        return delegate.createBridge();
    }

    public static AndroidDebugBridge createBridge(long timeout, TimeUnit unit) {
        delegateIsUsed = true;
        return delegate.createBridge(timeout, unit);
    }

    @Deprecated
    public static AndroidDebugBridge createBridge(String osLocation, boolean forceNewBridge) {
        delegateIsUsed = true;
        return delegate.createBridge(osLocation, forceNewBridge);
    }

    public static AndroidDebugBridge createBridge(String osLocation, boolean forceNewBridge, long timeout, TimeUnit unit) {
        delegateIsUsed = true;
        return delegate.createBridge(osLocation, forceNewBridge, timeout, unit);
    }

    public static AndroidDebugBridge getBridge() {
        delegateIsUsed = true;
        return delegate.getBridge();
    }

    @Deprecated
    public static void disconnectBridge() {
        delegateIsUsed = true;
        delegate.disconnectBridge();
    }

    public static boolean disconnectBridge(long timeout, TimeUnit unit) {
        delegateIsUsed = true;
        return delegate.disconnectBridge(timeout, unit);
    }

    public static void addDebugBridgeChangeListener(IDebugBridgeChangeListener listener) {
        delegateIsUsed = true;
        delegate.addDebugBridgeChangeListener(listener);
    }

    public static void removeDebugBridgeChangeListener(IDebugBridgeChangeListener listener) {
        delegateIsUsed = true;
        delegate.removeDebugBridgeChangeListener(listener);
    }

    @VisibleForTesting
    public static int getDebugBridgeChangeListenerCount() {
        delegateIsUsed = true;
        return delegate.getDebugBridgeChangeListenerCount();
    }

    public static void addDeviceChangeListener(IDeviceChangeListener listener) {
        delegate.addDeviceChangeListener(listener);
    }

    public static void removeDeviceChangeListener(IDeviceChangeListener listener) {
        delegate.removeDeviceChangeListener(listener);
    }

    @VisibleForTesting
    public static int getDeviceChangeListenerCount() {
        delegateIsUsed = true;
        return delegate.getDeviceChangeListenerCount();
    }

    public static void addClientChangeListener(IClientChangeListener listener) {
        delegate.addClientChangeListener(listener);
    }

    public static void removeClientChangeListener(IClientChangeListener listener) {
        delegate.removeClientChangeListener(listener);
    }

    public AdbVersion getCurrentAdbVersion() {
        delegateIsUsed = true;
        return delegate.getCurrentAdbVersion();
    }

    public IDevice[] getDevices() {
        delegateIsUsed = true;
        return delegate.getDevices();
    }

    public boolean hasInitialDeviceList() {
        delegateIsUsed = true;
        return delegate.hasInitialDeviceList();
    }

    public boolean isConnected() {
        delegateIsUsed = true;
        return delegate.isConnected();
    }

    public IDeviceUsageTracker getiDeviceUsageTracker() {
        delegateIsUsed = true;
        return delegate.getiDeviceUsageTracker();
    }

    public static ListenableFuture<AdbVersion> getAdbVersion(File adb) {
        delegateIsUsed = true;
        return delegate.getAdbVersion(adb);
    }

    public static ListenableFuture<String> getVirtualDeviceId(ListeningExecutorService service, File adb, IDevice device) {
        delegateIsUsed = true;
        return delegate.getVirtualDeviceId(service, adb, device);
    }

    public ListenableFuture<List<AdbDevice>> getRawDeviceList() {
        delegateIsUsed = true;
        return delegate.getRawDeviceList();
    }

    @Deprecated
    public boolean restart() {
        delegateIsUsed = true;
        return delegate.restart();
    }

    public boolean restart(long timeout, TimeUnit unit) {
        delegateIsUsed = true;
        return delegate.restart(timeout, unit);
    }

    public static void deviceConnected(IDevice device) {
        delegateIsUsed = true;
        delegate.deviceConnected(device);
    }

    public static void deviceDisconnected(IDevice device) {
        delegateIsUsed = true;
        delegate.deviceDisconnected(device);
    }

    public static void deviceChanged(IDevice device, int changeMask) {
        delegateIsUsed = true;
        delegate.deviceChanged(device, changeMask);
    }

    public static void clientChanged(Client client, int changeMask) {
        delegateIsUsed = true;
        delegate.clientChanged(client, changeMask);
    }

    public static boolean isUserManagedAdbMode() {
        delegateIsUsed = true;
        return delegate.isUserManagedAdbMode();
    }

    public boolean startAdb(long timeout, TimeUnit unit) {
        delegateIsUsed = true;
        return delegate.startAdb(timeout, unit);
    }

    static String queryFeatures(String adbFeaturesRequest) throws TimeoutException, AdbCommandRejectedException, IOException {
        delegateIsUsed = true;
        return delegate.queryFeatures(adbFeaturesRequest);
    }

    public static void setJdwpTracerFactory(JdwpTracerFactory factory) {
        sJdwpTracerFactory = factory;
    }

    public static DDMLibJdwpTracer newJdwpTracer() {
        return sJdwpTracerFactory.newJwpTracer();
    }

    public static void setJdwpProcessorFactory(JdwpProcessorFactory factory) {
        sJdwpProcessorFactory = factory;
    }

    public static JdwpProcessor newProcessor() {
        return sJdwpProcessorFactory.newProcessor();
    }

    public static interface IDebugBridgeChangeListener {
        public void bridgeChanged(AndroidDebugBridge var1);

        default public void restartInitiated() {
        }

        default public void restartCompleted(boolean isSuccessful) {
        }

        default public void initializationError(Exception exception) {
        }
    }

    public static interface IDeviceChangeListener {
        public void deviceConnected(IDevice var1);

        public void deviceDisconnected(IDevice var1);

        public void deviceChanged(IDevice var1, int var2);
    }

    public static interface IClientChangeListener {
        public void clientChanged(Client var1, int var2);
    }

    static interface AdbOutputProcessor<T> {
        public T process(Process var1, BufferedReader var2) throws IOException;
    }
}

