/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ServiceInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServiceReceiver
extends MultiLineReceiver {
    private static final String LOG_TAG = "ServiceReceiver";
    private static final Pattern serviceLinePattern = Pattern.compile("[\\d+]\\s+(\\S+):\\s+\\[(.*?)]");
    private static final String FOUND_SERVICES_HEADER = "Found \\d+ services:";
    private final LinkedHashMap<String, ServiceInfo> runningServices = new LinkedHashMap();

    public Map<String, ServiceInfo> getRunningServices() {
        return this.runningServices;
    }

    @Override
    public void processNewLines(String[] lines) {
        for (String line : lines) {
            if (line.matches(FOUND_SERVICES_HEADER) || line.trim().isEmpty()) continue;
            Matcher matcher = serviceLinePattern.matcher(line);
            if (!matcher.find()) {
                throw new RuntimeException("Unable to parse service information from: " + line);
            }
            String serviceName = matcher.group(1);
            String servicePackage = matcher.group(2);
            ServiceInfo serviceInfo = new ServiceInfo(serviceName, servicePackage);
            this.runningServices.put(serviceName, serviceInfo);
        }
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    public void clear() {
        this.runningServices.clear();
    }
}

