/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.idevicemanager;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.idevicemanager.IDeviceManagerListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IDeviceManagerUtils {
    public static IDeviceManagerListener createIDeviceManagerListener() {
        return new IDeviceManagerListener(){

            @Override
            @WorkerThread
            public void addedDevices(List<IDevice> deviceList) {
                for (IDevice device : deviceList) {
                    AndroidDebugBridge.deviceConnected(device);
                }
            }

            @Override
            @WorkerThread
            public void removedDevices(@NotNull List<IDevice> deviceList) {
                for (IDevice device : deviceList) {
                    AndroidDebugBridge.deviceDisconnected(device);
                }
            }

            @Override
            @WorkerThread
            public void deviceStateChanged(@NotNull IDevice device) {
                AndroidDebugBridge.deviceChanged(device, 1);
            }
        };
    }
}

