/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.DesugarTimeZone;
import java.util.GregorianCalendar;

public class DesugarGregorianCalendar {
    private DesugarGregorianCalendar() {
    }

    public static ZonedDateTime toZonedDateTime(GregorianCalendar instance) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(instance.getTimeInMillis()), DesugarTimeZone.toZoneId(instance.getTimeZone()));
    }

    public static GregorianCalendar from(ZonedDateTime zdt) {
        GregorianCalendar cal = new GregorianCalendar(DesugarTimeZone.getTimeZone(zdt.getZone()));
        cal.setGregorianChange(new Date(Long.MIN_VALUE));
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        try {
            cal.setTimeInMillis(Math.addExact(Math.multiplyExact(zdt.toEpochSecond(), 1000L), (long)zdt.get(ChronoField.MILLI_OF_SECOND)));
        }
        catch (ArithmeticException ex) {
            throw new IllegalArgumentException(ex);
        }
        return cal;
    }
}

