/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.DesugarArrays;
import java.util.LongSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSpliterators;
import java.util.stream.StreamSupport;
import java.util.stream.Streams;

public interface LongStream
extends BaseStream<Long, LongStream> {
    public LongStream filter(LongPredicate var1);

    public LongStream map(LongUnaryOperator var1);

    public <U> Stream<U> mapToObj(LongFunction<? extends U> var1);

    public IntStream mapToInt(LongToIntFunction var1);

    public DoubleStream mapToDouble(LongToDoubleFunction var1);

    public LongStream flatMap(LongFunction<? extends LongStream> var1);

    public LongStream distinct();

    public LongStream sorted();

    public LongStream peek(LongConsumer var1);

    public LongStream limit(long var1);

    public LongStream skip(long var1);

    public void forEach(LongConsumer var1);

    public void forEachOrdered(LongConsumer var1);

    public long[] toArray();

    public long reduce(long var1, LongBinaryOperator var3);

    public OptionalLong reduce(LongBinaryOperator var1);

    public <R> R collect(Supplier<R> var1, ObjLongConsumer<R> var2, BiConsumer<R, R> var3);

    public long sum();

    public OptionalLong min();

    public OptionalLong max();

    public long count();

    public OptionalDouble average();

    public LongSummaryStatistics summaryStatistics();

    public boolean anyMatch(LongPredicate var1);

    public boolean allMatch(LongPredicate var1);

    public boolean noneMatch(LongPredicate var1);

    public OptionalLong findFirst();

    public OptionalLong findAny();

    public DoubleStream asDoubleStream();

    public Stream<Long> boxed();

    @Override
    public LongStream sequential();

    @Override
    public LongStream parallel();

    public PrimitiveIterator.OfLong iterator();

    public Spliterator.OfLong spliterator();

    public static Builder builder() {
        return new Streams.LongStreamBuilderImpl();
    }

    public static LongStream empty() {
        return StreamSupport.longStream(Spliterators.emptyLongSpliterator(), false);
    }

    public static LongStream of(long t) {
        return StreamSupport.longStream(new Streams.LongStreamBuilderImpl(t), false);
    }

    public static LongStream of(long ... values) {
        return DesugarArrays.stream(values);
    }

    public static LongStream iterate(final long seed, final LongUnaryOperator f) {
        Objects.requireNonNull(f);
        PrimitiveIterator.OfLong iterator = new PrimitiveIterator.OfLong(){
            long t;
            {
                this.t = seed;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public long nextLong() {
                long v = this.t;
                this.t = f.applyAsLong(this.t);
                return v;
            }
        };
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize(iterator, 1296), false);
    }

    public static LongStream generate(LongSupplier s) {
        Objects.requireNonNull(s);
        return StreamSupport.longStream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfLong(Long.MAX_VALUE, s), false);
    }

    public static LongStream range(long startInclusive, long endExclusive) {
        if (startInclusive >= endExclusive) {
            return LongStream.empty();
        }
        if (endExclusive - startInclusive < 0L) {
            long m = startInclusive + Long.divideUnsigned(endExclusive - startInclusive, 2L) + 1L;
            return LongStream.concat(LongStream.range(startInclusive, m), LongStream.range(m, endExclusive));
        }
        return StreamSupport.longStream(new Streams.RangeLongSpliterator(startInclusive, endExclusive, false), false);
    }

    public static LongStream rangeClosed(long startInclusive, long endInclusive) {
        if (startInclusive > endInclusive) {
            return LongStream.empty();
        }
        if (endInclusive - startInclusive + 1L <= 0L) {
            long m = startInclusive + Long.divideUnsigned(endInclusive - startInclusive, 2L) + 1L;
            return LongStream.concat(LongStream.range(startInclusive, m), LongStream.rangeClosed(m, endInclusive));
        }
        return StreamSupport.longStream(new Streams.RangeLongSpliterator(startInclusive, endInclusive, true), false);
    }

    public static LongStream concat(LongStream a, LongStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Streams.ConcatSpliterator.OfLong split = new Streams.ConcatSpliterator.OfLong(a.spliterator(), b.spliterator());
        LongStream stream = StreamSupport.longStream(split, a.isParallel() || b.isParallel());
        return (LongStream)stream.onClose(Streams.composedClose(a, b));
    }

    public static interface Builder
    extends LongConsumer {
        @Override
        public void accept(long var1);

        default public Builder add(long t) {
            this.accept(t);
            return this;
        }

        public LongStream build();
    }
}

