/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class Parsed
implements TemporalAccessor {
    final Map<TemporalField, Long> fieldValues = new HashMap<TemporalField, Long>();
    ZoneId zone;
    Chronology chrono;
    boolean leapSecond;
    private ResolverStyle resolverStyle;
    private ChronoLocalDate date;
    private LocalTime time;
    Period excessDays = Period.ZERO;

    Parsed() {
    }

    Parsed copy() {
        Parsed cloned = new Parsed();
        cloned.fieldValues.putAll(this.fieldValues);
        cloned.zone = this.zone;
        cloned.chrono = this.chrono;
        cloned.leapSecond = this.leapSecond;
        return cloned;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (this.fieldValues.containsKey(field) || this.date != null && this.date.isSupported(field) || this.time != null && this.time.isSupported(field)) {
            return true;
        }
        return field != null && !(field instanceof ChronoField) && field.isSupportedBy(this);
    }

    @Override
    public long getLong(TemporalField field) {
        Objects.requireNonNull(field, "field");
        Long value = this.fieldValues.get(field);
        if (value != null) {
            return value;
        }
        if (this.date != null && this.date.isSupported(field)) {
            return this.date.getLong(field);
        }
        if (this.time != null && this.time.isSupported(field)) {
            return this.time.getLong(field);
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.zoneId()) {
            return (R)this.zone;
        }
        if (query == TemporalQueries.chronology()) {
            return (R)this.chrono;
        }
        if (query == TemporalQueries.localDate()) {
            return (R)(this.date != null ? LocalDate.from(this.date) : null);
        }
        if (query == TemporalQueries.localTime()) {
            return (R)this.time;
        }
        if (query == TemporalQueries.zone() || query == TemporalQueries.offset()) {
            return query.queryFrom(this);
        }
        if (query == TemporalQueries.precision()) {
            return null;
        }
        return query.queryFrom(this);
    }

    TemporalAccessor resolve(ResolverStyle resolverStyle, Set<TemporalField> resolverFields) {
        if (resolverFields != null) {
            this.fieldValues.keySet().retainAll(resolverFields);
        }
        this.resolverStyle = resolverStyle;
        this.resolveFields();
        this.resolveTimeLenient();
        this.crossCheck();
        this.resolvePeriod();
        this.resolveFractional();
        this.resolveInstant();
        return this;
    }

    private void resolveFields() {
        this.resolveInstantFields();
        this.resolveDateFields();
        this.resolveTimeFields();
        if (this.fieldValues.size() > 0) {
            int changedCount = 0;
            block0: while (changedCount < 50) {
                for (Map.Entry<TemporalField, Long> entry : this.fieldValues.entrySet()) {
                    TemporalField targetField = entry.getKey();
                    ChronoLocalDateTime resolvedObject = targetField.resolve(this.fieldValues, this, this.resolverStyle);
                    if (resolvedObject != null) {
                        if (resolvedObject instanceof ChronoZonedDateTime) {
                            ChronoZonedDateTime czdt = (ChronoZonedDateTime)((Object)resolvedObject);
                            if (this.zone == null) {
                                this.zone = czdt.getZone();
                            } else if (!this.zone.equals(czdt.getZone())) {
                                throw new DateTimeException("ChronoZonedDateTime must use the effective parsed zone: " + this.zone);
                            }
                            resolvedObject = czdt.toLocalDateTime();
                        }
                        if (resolvedObject instanceof ChronoLocalDateTime) {
                            ChronoLocalDateTime cldt = resolvedObject;
                            this.updateCheckConflict(cldt.toLocalTime(), Period.ZERO);
                            this.updateCheckConflict((ChronoLocalDate)cldt.toLocalDate());
                            ++changedCount;
                            continue block0;
                        }
                        if (resolvedObject instanceof ChronoLocalDate) {
                            this.updateCheckConflict((ChronoLocalDate)((Object)resolvedObject));
                            ++changedCount;
                            continue block0;
                        }
                        if (resolvedObject instanceof LocalTime) {
                            this.updateCheckConflict((LocalTime)((Object)resolvedObject), Period.ZERO);
                            ++changedCount;
                            continue block0;
                        }
                        throw new DateTimeException("Method resolve() can only return ChronoZonedDateTime, ChronoLocalDateTime, ChronoLocalDate or LocalTime");
                    }
                    if (this.fieldValues.containsKey(targetField)) continue;
                    ++changedCount;
                    continue block0;
                }
            }
            if (changedCount == 50) {
                throw new DateTimeException("One of the parsed fields has an incorrectly implemented resolve method");
            }
            if (changedCount > 0) {
                this.resolveInstantFields();
                this.resolveDateFields();
                this.resolveTimeFields();
            }
        }
    }

    private void updateCheckConflict(TemporalField targetField, TemporalField changeField, Long changeValue) {
        Long old = this.fieldValues.put(changeField, changeValue);
        if (old != null && old.longValue() != changeValue.longValue()) {
            throw new DateTimeException("Conflict found: " + changeField + " " + old + " differs from " + changeField + " " + changeValue + " while resolving  " + targetField);
        }
    }

    private void resolveInstantFields() {
        if (this.fieldValues.containsKey(ChronoField.INSTANT_SECONDS)) {
            if (this.zone != null) {
                this.resolveInstantFields0(this.zone);
            } else {
                Long offsetSecs = this.fieldValues.get(ChronoField.OFFSET_SECONDS);
                if (offsetSecs != null) {
                    ZoneOffset offset = ZoneOffset.ofTotalSeconds(offsetSecs.intValue());
                    this.resolveInstantFields0(offset);
                }
            }
        }
    }

    private void resolveInstantFields0(ZoneId selectedZone) {
        Instant instant = Instant.ofEpochSecond(this.fieldValues.remove(ChronoField.INSTANT_SECONDS));
        ChronoZonedDateTime<? extends ChronoLocalDate> zdt = this.chrono.zonedDateTime(instant, selectedZone);
        this.updateCheckConflict(zdt.toLocalDate());
        this.updateCheckConflict(ChronoField.INSTANT_SECONDS, ChronoField.SECOND_OF_DAY, Long.valueOf(zdt.toLocalTime().toSecondOfDay()));
    }

    private void resolveDateFields() {
        this.updateCheckConflict(this.chrono.resolveDate(this.fieldValues, this.resolverStyle));
    }

    private void updateCheckConflict(ChronoLocalDate cld) {
        if (this.date != null) {
            if (cld != null && !this.date.equals(cld)) {
                throw new DateTimeException("Conflict found: Fields resolved to two different dates: " + this.date + " " + cld);
            }
        } else if (cld != null) {
            if (!this.chrono.equals(cld.getChronology())) {
                throw new DateTimeException("ChronoLocalDate must use the effective parsed chronology: " + this.chrono);
            }
            this.date = cld;
        }
    }

    private void resolveTimeFields() {
        long ch;
        if (this.fieldValues.containsKey(ChronoField.CLOCK_HOUR_OF_DAY)) {
            ch = this.fieldValues.remove(ChronoField.CLOCK_HOUR_OF_DAY);
            if (this.resolverStyle == ResolverStyle.STRICT || this.resolverStyle == ResolverStyle.SMART && ch != 0L) {
                ChronoField.CLOCK_HOUR_OF_DAY.checkValidValue(ch);
            }
            this.updateCheckConflict(ChronoField.CLOCK_HOUR_OF_DAY, ChronoField.HOUR_OF_DAY, ch == 24L ? 0L : ch);
        }
        if (this.fieldValues.containsKey(ChronoField.CLOCK_HOUR_OF_AMPM)) {
            ch = this.fieldValues.remove(ChronoField.CLOCK_HOUR_OF_AMPM);
            if (this.resolverStyle == ResolverStyle.STRICT || this.resolverStyle == ResolverStyle.SMART && ch != 0L) {
                ChronoField.CLOCK_HOUR_OF_AMPM.checkValidValue(ch);
            }
            this.updateCheckConflict(ChronoField.CLOCK_HOUR_OF_AMPM, ChronoField.HOUR_OF_AMPM, ch == 12L ? 0L : ch);
        }
        if (this.fieldValues.containsKey(ChronoField.AMPM_OF_DAY) && this.fieldValues.containsKey(ChronoField.HOUR_OF_AMPM)) {
            long ap = this.fieldValues.remove(ChronoField.AMPM_OF_DAY);
            long hap = this.fieldValues.remove(ChronoField.HOUR_OF_AMPM);
            if (this.resolverStyle == ResolverStyle.LENIENT) {
                this.updateCheckConflict(ChronoField.AMPM_OF_DAY, ChronoField.HOUR_OF_DAY, Math.addExact(Math.multiplyExact(ap, 12), hap));
            } else {
                ChronoField.AMPM_OF_DAY.checkValidValue(ap);
                ChronoField.HOUR_OF_AMPM.checkValidValue(ap);
                this.updateCheckConflict(ChronoField.AMPM_OF_DAY, ChronoField.HOUR_OF_DAY, ap * 12L + hap);
            }
        }
        if (this.fieldValues.containsKey(ChronoField.NANO_OF_DAY)) {
            long nod = this.fieldValues.remove(ChronoField.NANO_OF_DAY);
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.NANO_OF_DAY.checkValidValue(nod);
            }
            this.updateCheckConflict(ChronoField.NANO_OF_DAY, ChronoField.HOUR_OF_DAY, nod / 3600000000000L);
            this.updateCheckConflict(ChronoField.NANO_OF_DAY, ChronoField.MINUTE_OF_HOUR, nod / 60000000000L % 60L);
            this.updateCheckConflict(ChronoField.NANO_OF_DAY, ChronoField.SECOND_OF_MINUTE, nod / 1000000000L % 60L);
            this.updateCheckConflict(ChronoField.NANO_OF_DAY, ChronoField.NANO_OF_SECOND, nod % 1000000000L);
        }
        if (this.fieldValues.containsKey(ChronoField.MICRO_OF_DAY)) {
            long cod = this.fieldValues.remove(ChronoField.MICRO_OF_DAY);
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.MICRO_OF_DAY.checkValidValue(cod);
            }
            this.updateCheckConflict(ChronoField.MICRO_OF_DAY, ChronoField.SECOND_OF_DAY, cod / 1000000L);
            this.updateCheckConflict(ChronoField.MICRO_OF_DAY, ChronoField.MICRO_OF_SECOND, cod % 1000000L);
        }
        if (this.fieldValues.containsKey(ChronoField.MILLI_OF_DAY)) {
            long lod = this.fieldValues.remove(ChronoField.MILLI_OF_DAY);
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.MILLI_OF_DAY.checkValidValue(lod);
            }
            this.updateCheckConflict(ChronoField.MILLI_OF_DAY, ChronoField.SECOND_OF_DAY, lod / 1000L);
            this.updateCheckConflict(ChronoField.MILLI_OF_DAY, ChronoField.MILLI_OF_SECOND, lod % 1000L);
        }
        if (this.fieldValues.containsKey(ChronoField.SECOND_OF_DAY)) {
            long sod = this.fieldValues.remove(ChronoField.SECOND_OF_DAY);
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.SECOND_OF_DAY.checkValidValue(sod);
            }
            this.updateCheckConflict(ChronoField.SECOND_OF_DAY, ChronoField.HOUR_OF_DAY, sod / 3600L);
            this.updateCheckConflict(ChronoField.SECOND_OF_DAY, ChronoField.MINUTE_OF_HOUR, sod / 60L % 60L);
            this.updateCheckConflict(ChronoField.SECOND_OF_DAY, ChronoField.SECOND_OF_MINUTE, sod % 60L);
        }
        if (this.fieldValues.containsKey(ChronoField.MINUTE_OF_DAY)) {
            long mod = this.fieldValues.remove(ChronoField.MINUTE_OF_DAY);
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.MINUTE_OF_DAY.checkValidValue(mod);
            }
            this.updateCheckConflict(ChronoField.MINUTE_OF_DAY, ChronoField.HOUR_OF_DAY, mod / 60L);
            this.updateCheckConflict(ChronoField.MINUTE_OF_DAY, ChronoField.MINUTE_OF_HOUR, mod % 60L);
        }
        if (this.fieldValues.containsKey(ChronoField.NANO_OF_SECOND)) {
            long nos = this.fieldValues.get(ChronoField.NANO_OF_SECOND);
            if (this.resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.NANO_OF_SECOND.checkValidValue(nos);
            }
            if (this.fieldValues.containsKey(ChronoField.MICRO_OF_SECOND)) {
                long cos = this.fieldValues.remove(ChronoField.MICRO_OF_SECOND);
                if (this.resolverStyle != ResolverStyle.LENIENT) {
                    ChronoField.MICRO_OF_SECOND.checkValidValue(cos);
                }
                nos = cos * 1000L + nos % 1000L;
                this.updateCheckConflict(ChronoField.MICRO_OF_SECOND, ChronoField.NANO_OF_SECOND, nos);
            }
            if (this.fieldValues.containsKey(ChronoField.MILLI_OF_SECOND)) {
                long los = this.fieldValues.remove(ChronoField.MILLI_OF_SECOND);
                if (this.resolverStyle != ResolverStyle.LENIENT) {
                    ChronoField.MILLI_OF_SECOND.checkValidValue(los);
                }
                this.updateCheckConflict(ChronoField.MILLI_OF_SECOND, ChronoField.NANO_OF_SECOND, los * 1000000L + nos % 1000000L);
            }
        }
        if (this.fieldValues.containsKey(ChronoField.HOUR_OF_DAY) && this.fieldValues.containsKey(ChronoField.MINUTE_OF_HOUR) && this.fieldValues.containsKey(ChronoField.SECOND_OF_MINUTE) && this.fieldValues.containsKey(ChronoField.NANO_OF_SECOND)) {
            long hod = this.fieldValues.remove(ChronoField.HOUR_OF_DAY);
            long moh = this.fieldValues.remove(ChronoField.MINUTE_OF_HOUR);
            long som = this.fieldValues.remove(ChronoField.SECOND_OF_MINUTE);
            long nos = this.fieldValues.remove(ChronoField.NANO_OF_SECOND);
            this.resolveTime(hod, moh, som, nos);
        }
    }

    private void resolveTimeLenient() {
        if (this.time == null) {
            if (this.fieldValues.containsKey(ChronoField.MILLI_OF_SECOND)) {
                long los = this.fieldValues.remove(ChronoField.MILLI_OF_SECOND);
                if (this.fieldValues.containsKey(ChronoField.MICRO_OF_SECOND)) {
                    long cos = los * 1000L + this.fieldValues.get(ChronoField.MICRO_OF_SECOND) % 1000L;
                    this.updateCheckConflict(ChronoField.MILLI_OF_SECOND, ChronoField.MICRO_OF_SECOND, cos);
                    this.fieldValues.remove(ChronoField.MICRO_OF_SECOND);
                    this.fieldValues.put(ChronoField.NANO_OF_SECOND, cos * 1000L);
                } else {
                    this.fieldValues.put(ChronoField.NANO_OF_SECOND, los * 1000000L);
                }
            } else if (this.fieldValues.containsKey(ChronoField.MICRO_OF_SECOND)) {
                long cos = this.fieldValues.remove(ChronoField.MICRO_OF_SECOND);
                this.fieldValues.put(ChronoField.NANO_OF_SECOND, cos * 1000L);
            }
            Long hod = this.fieldValues.get(ChronoField.HOUR_OF_DAY);
            if (hod != null) {
                Long moh = this.fieldValues.get(ChronoField.MINUTE_OF_HOUR);
                Long som = this.fieldValues.get(ChronoField.SECOND_OF_MINUTE);
                Long nos = this.fieldValues.get(ChronoField.NANO_OF_SECOND);
                if (moh == null && (som != null || nos != null) || moh != null && som == null && nos != null) {
                    return;
                }
                long mohVal = moh != null ? moh : 0L;
                long somVal = som != null ? som : 0L;
                long nosVal = nos != null ? nos : 0L;
                this.resolveTime(hod, mohVal, somVal, nosVal);
                this.fieldValues.remove(ChronoField.HOUR_OF_DAY);
                this.fieldValues.remove(ChronoField.MINUTE_OF_HOUR);
                this.fieldValues.remove(ChronoField.SECOND_OF_MINUTE);
                this.fieldValues.remove(ChronoField.NANO_OF_SECOND);
            }
        }
        if (this.resolverStyle != ResolverStyle.LENIENT && this.fieldValues.size() > 0) {
            for (Map.Entry<TemporalField, Long> entry : this.fieldValues.entrySet()) {
                TemporalField field = entry.getKey();
                if (!(field instanceof ChronoField) || !field.isTimeBased()) continue;
                ((ChronoField)field).checkValidValue(entry.getValue());
            }
        }
    }

    private void resolveTime(long hod, long moh, long som, long nos) {
        if (this.resolverStyle == ResolverStyle.LENIENT) {
            long totalNanos = Math.multiplyExact(hod, 3600000000000L);
            totalNanos = Math.addExact(totalNanos, Math.multiplyExact(moh, 60000000000L));
            totalNanos = Math.addExact(totalNanos, Math.multiplyExact(som, 1000000000L));
            totalNanos = Math.addExact(totalNanos, nos);
            int excessDays = (int)Math.floorDiv(totalNanos, 86400000000000L);
            long nod = Math.floorMod(totalNanos, 86400000000000L);
            this.updateCheckConflict(LocalTime.ofNanoOfDay(nod), Period.ofDays(excessDays));
        } else {
            int mohVal = ChronoField.MINUTE_OF_HOUR.checkValidIntValue(moh);
            int nosVal = ChronoField.NANO_OF_SECOND.checkValidIntValue(nos);
            if (this.resolverStyle == ResolverStyle.SMART && hod == 24L && mohVal == 0 && som == 0L && nosVal == 0) {
                this.updateCheckConflict(LocalTime.MIDNIGHT, Period.ofDays(1));
            } else {
                int hodVal = ChronoField.HOUR_OF_DAY.checkValidIntValue(hod);
                int somVal = ChronoField.SECOND_OF_MINUTE.checkValidIntValue(som);
                this.updateCheckConflict(LocalTime.of(hodVal, mohVal, somVal, nosVal), Period.ZERO);
            }
        }
    }

    private void resolvePeriod() {
        if (this.date != null && this.time != null && !this.excessDays.isZero()) {
            this.date = this.date.plus(this.excessDays);
            this.excessDays = Period.ZERO;
        }
    }

    private void resolveFractional() {
        if (this.time == null && (this.fieldValues.containsKey(ChronoField.INSTANT_SECONDS) || this.fieldValues.containsKey(ChronoField.SECOND_OF_DAY) || this.fieldValues.containsKey(ChronoField.SECOND_OF_MINUTE))) {
            if (this.fieldValues.containsKey(ChronoField.NANO_OF_SECOND)) {
                long nos = this.fieldValues.get(ChronoField.NANO_OF_SECOND);
                this.fieldValues.put(ChronoField.MICRO_OF_SECOND, nos / 1000L);
                this.fieldValues.put(ChronoField.MILLI_OF_SECOND, nos / 1000000L);
            } else {
                this.fieldValues.put(ChronoField.NANO_OF_SECOND, 0L);
                this.fieldValues.put(ChronoField.MICRO_OF_SECOND, 0L);
                this.fieldValues.put(ChronoField.MILLI_OF_SECOND, 0L);
            }
        }
    }

    private void resolveInstant() {
        if (this.date != null && this.time != null) {
            if (this.zone != null) {
                long instant = this.date.atTime(this.time).atZone(this.zone).getLong(ChronoField.INSTANT_SECONDS);
                this.fieldValues.put(ChronoField.INSTANT_SECONDS, instant);
            } else {
                Long offsetSecs = this.fieldValues.get(ChronoField.OFFSET_SECONDS);
                if (offsetSecs != null) {
                    ZoneOffset offset = ZoneOffset.ofTotalSeconds(offsetSecs.intValue());
                    long instant = this.date.atTime(this.time).atZone(offset).getLong(ChronoField.INSTANT_SECONDS);
                    this.fieldValues.put(ChronoField.INSTANT_SECONDS, instant);
                }
            }
        }
    }

    private void updateCheckConflict(LocalTime timeToSet, Period periodToSet) {
        if (this.time != null) {
            if (!this.time.equals(timeToSet)) {
                throw new DateTimeException("Conflict found: Fields resolved to different times: " + this.time + " " + timeToSet);
            }
            if (!(this.excessDays.isZero() || periodToSet.isZero() || this.excessDays.equals(periodToSet))) {
                throw new DateTimeException("Conflict found: Fields resolved to different excess periods: " + this.excessDays + " " + periodToSet);
            }
            this.excessDays = periodToSet;
        } else {
            this.time = timeToSet;
            this.excessDays = periodToSet;
        }
    }

    private void crossCheck() {
        if (this.date != null) {
            this.crossCheck(this.date);
        }
        if (this.time != null) {
            this.crossCheck(this.time);
            if (this.date != null && this.fieldValues.size() > 0) {
                this.crossCheck(this.date.atTime(this.time));
            }
        }
    }

    private void crossCheck(TemporalAccessor target) {
        Iterator<Map.Entry<TemporalField, Long>> it = this.fieldValues.entrySet().iterator();
        while (it.hasNext()) {
            long val1;
            Map.Entry<TemporalField, Long> entry = it.next();
            TemporalField field = entry.getKey();
            if (!target.isSupported(field)) continue;
            try {
                val1 = target.getLong(field);
            }
            catch (RuntimeException ex) {
                continue;
            }
            long val2 = entry.getValue();
            if (val1 != val2) {
                throw new DateTimeException("Conflict found: Field " + field + " " + val1 + " differs from " + field + " " + val2 + " derived from " + target);
            }
            it.remove();
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(this.fieldValues).append(',').append(this.chrono);
        if (this.zone != null) {
            buf.append(',').append(this.zone);
        }
        if (this.date != null || this.time != null) {
            buf.append(" resolved to ");
            if (this.date != null) {
                buf.append(this.date);
                if (this.time != null) {
                    buf.append('T').append(this.time);
                }
            } else {
                buf.append(this.time);
            }
        }
        return buf.toString();
    }
}

