/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.zone.Ser;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ZoneRules
implements Serializable {
    private static final long serialVersionUID = 3044319355680032515L;
    private static final int LAST_CACHED_YEAR = 2100;
    private final long[] standardTransitions;
    private final ZoneOffset[] standardOffsets;
    private final long[] savingsInstantTransitions;
    private final LocalDateTime[] savingsLocalTransitions;
    private final ZoneOffset[] wallOffsets;
    private final ZoneOffsetTransitionRule[] lastRules;
    private final TimeZone timeZone;
    private final transient ConcurrentMap<Integer, ZoneOffsetTransition[]> lastRulesCache = new ConcurrentHashMap<Integer, ZoneOffsetTransition[]>();
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final ZoneOffsetTransitionRule[] EMPTY_LASTRULES = new ZoneOffsetTransitionRule[0];
    private static final LocalDateTime[] EMPTY_LDT_ARRAY = new LocalDateTime[0];
    private static final ZoneOffsetTransition[] NO_TRANSITIONS = new ZoneOffsetTransition[0];

    public static ZoneRules of(ZoneOffset baseStandardOffset, ZoneOffset baseWallOffset, List<ZoneOffsetTransition> standardOffsetTransitionList, List<ZoneOffsetTransition> transitionList, List<ZoneOffsetTransitionRule> lastRules) {
        Objects.requireNonNull(baseStandardOffset, "baseStandardOffset");
        Objects.requireNonNull(baseWallOffset, "baseWallOffset");
        Objects.requireNonNull(standardOffsetTransitionList, "standardOffsetTransitionList");
        Objects.requireNonNull(transitionList, "transitionList");
        Objects.requireNonNull(lastRules, "lastRules");
        return new ZoneRules(baseStandardOffset, baseWallOffset, standardOffsetTransitionList, transitionList, lastRules);
    }

    public static ZoneRules of(ZoneOffset offset) {
        Objects.requireNonNull(offset, "offset");
        return new ZoneRules(offset);
    }

    ZoneRules(ZoneOffset baseStandardOffset, ZoneOffset baseWallOffset, List<ZoneOffsetTransition> standardOffsetTransitionList, List<ZoneOffsetTransition> transitionList, List<ZoneOffsetTransitionRule> lastRules) {
        this.standardTransitions = new long[standardOffsetTransitionList.size()];
        this.standardOffsets = new ZoneOffset[standardOffsetTransitionList.size() + 1];
        this.standardOffsets[0] = baseStandardOffset;
        for (int i = 0; i < standardOffsetTransitionList.size(); ++i) {
            this.standardTransitions[i] = standardOffsetTransitionList.get(i).toEpochSecond();
            this.standardOffsets[i + 1] = standardOffsetTransitionList.get(i).getOffsetAfter();
        }
        ArrayList<LocalDateTime> localTransitionList = new ArrayList<LocalDateTime>();
        ArrayList<ZoneOffset> localTransitionOffsetList = new ArrayList<ZoneOffset>();
        localTransitionOffsetList.add(baseWallOffset);
        for (ZoneOffsetTransition trans : transitionList) {
            if (trans.isGap()) {
                localTransitionList.add(trans.getDateTimeBefore());
                localTransitionList.add(trans.getDateTimeAfter());
            } else {
                localTransitionList.add(trans.getDateTimeAfter());
                localTransitionList.add(trans.getDateTimeBefore());
            }
            localTransitionOffsetList.add(trans.getOffsetAfter());
        }
        this.savingsLocalTransitions = localTransitionList.toArray(new LocalDateTime[localTransitionList.size()]);
        this.wallOffsets = localTransitionOffsetList.toArray(new ZoneOffset[localTransitionOffsetList.size()]);
        this.savingsInstantTransitions = new long[transitionList.size()];
        for (int i = 0; i < transitionList.size(); ++i) {
            this.savingsInstantTransitions[i] = transitionList.get(i).toEpochSecond();
        }
        if (lastRules.size() > 16) {
            throw new IllegalArgumentException("Too many transition rules");
        }
        this.lastRules = lastRules.toArray(new ZoneOffsetTransitionRule[lastRules.size()]);
        this.timeZone = null;
    }

    private ZoneRules(long[] standardTransitions, ZoneOffset[] standardOffsets, long[] savingsInstantTransitions, ZoneOffset[] wallOffsets, ZoneOffsetTransitionRule[] lastRules) {
        this.standardTransitions = standardTransitions;
        this.standardOffsets = standardOffsets;
        this.savingsInstantTransitions = savingsInstantTransitions;
        this.wallOffsets = wallOffsets;
        this.lastRules = lastRules;
        if (savingsInstantTransitions.length == 0) {
            this.savingsLocalTransitions = EMPTY_LDT_ARRAY;
        } else {
            ArrayList<LocalDateTime> localTransitionList = new ArrayList<LocalDateTime>();
            for (int i = 0; i < savingsInstantTransitions.length; ++i) {
                ZoneOffset before = wallOffsets[i];
                ZoneOffset after = wallOffsets[i + 1];
                ZoneOffsetTransition trans = new ZoneOffsetTransition(savingsInstantTransitions[i], before, after);
                if (trans.isGap()) {
                    localTransitionList.add(trans.getDateTimeBefore());
                    localTransitionList.add(trans.getDateTimeAfter());
                    continue;
                }
                localTransitionList.add(trans.getDateTimeAfter());
                localTransitionList.add(trans.getDateTimeBefore());
            }
            this.savingsLocalTransitions = localTransitionList.toArray(new LocalDateTime[localTransitionList.size()]);
        }
        this.timeZone = null;
    }

    private ZoneRules(ZoneOffset offset) {
        this.standardOffsets = new ZoneOffset[1];
        this.standardOffsets[0] = offset;
        this.standardTransitions = EMPTY_LONG_ARRAY;
        this.savingsInstantTransitions = EMPTY_LONG_ARRAY;
        this.savingsLocalTransitions = EMPTY_LDT_ARRAY;
        this.wallOffsets = this.standardOffsets;
        this.lastRules = EMPTY_LASTRULES;
        this.timeZone = null;
    }

    ZoneRules(TimeZone tz) {
        this.standardOffsets = new ZoneOffset[1];
        this.standardOffsets[0] = ZoneRules.offsetFromMillis(tz.getRawOffset());
        this.standardTransitions = EMPTY_LONG_ARRAY;
        this.savingsInstantTransitions = EMPTY_LONG_ARRAY;
        this.savingsLocalTransitions = EMPTY_LDT_ARRAY;
        this.wallOffsets = this.standardOffsets;
        this.lastRules = EMPTY_LASTRULES;
        this.timeZone = tz;
    }

    private static ZoneOffset offsetFromMillis(int offsetMillis) {
        return ZoneOffset.ofTotalSeconds(offsetMillis / 1000);
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(this.timeZone != null ? (byte)100 : 1, this);
    }

    void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.standardTransitions.length);
        for (long trans : this.standardTransitions) {
            Ser.writeEpochSec(trans, out);
        }
        for (ZoneOffset offset : this.standardOffsets) {
            Ser.writeOffset(offset, out);
        }
        out.writeInt(this.savingsInstantTransitions.length);
        for (long trans : this.savingsInstantTransitions) {
            Ser.writeEpochSec(trans, out);
        }
        for (ZoneOffset offset : this.wallOffsets) {
            Ser.writeOffset(offset, out);
        }
        out.writeByte(this.lastRules.length);
        for (ZoneOffsetTransitionRule rule : this.lastRules) {
            rule.writeExternal(out);
        }
    }

    void writeExternalTimeZone(DataOutput out) throws IOException {
        out.writeUTF(this.timeZone.getID());
    }

    static ZoneRules readExternal(DataInput in) throws IOException, ClassNotFoundException {
        int stdSize = in.readInt();
        long[] stdTrans = stdSize == 0 ? EMPTY_LONG_ARRAY : new long[stdSize];
        for (int i = 0; i < stdSize; ++i) {
            stdTrans[i] = Ser.readEpochSec(in);
        }
        ZoneOffset[] stdOffsets = new ZoneOffset[stdSize + 1];
        for (int i = 0; i < stdOffsets.length; ++i) {
            stdOffsets[i] = Ser.readOffset(in);
        }
        int savSize = in.readInt();
        long[] savTrans = savSize == 0 ? EMPTY_LONG_ARRAY : new long[savSize];
        for (int i = 0; i < savSize; ++i) {
            savTrans[i] = Ser.readEpochSec(in);
        }
        ZoneOffset[] savOffsets = new ZoneOffset[savSize + 1];
        for (int i = 0; i < savOffsets.length; ++i) {
            savOffsets[i] = Ser.readOffset(in);
        }
        int ruleSize = in.readByte();
        ZoneOffsetTransitionRule[] rules = ruleSize == 0 ? EMPTY_LASTRULES : new ZoneOffsetTransitionRule[ruleSize];
        for (int i = 0; i < ruleSize; ++i) {
            rules[i] = ZoneOffsetTransitionRule.readExternal(in);
        }
        return new ZoneRules(stdTrans, stdOffsets, savTrans, savOffsets, rules);
    }

    static ZoneRules readExternalTimeZone(DataInput in) throws IOException {
        TimeZone timeZone = TimeZone.getTimeZone(in.readUTF());
        return new ZoneRules(timeZone);
    }

    public boolean isFixedOffset() {
        if (this.timeZone != null) {
            if (this.timeZone.useDaylightTime() || this.timeZone.getDSTSavings() != 0) {
                return false;
            }
            return this.previousTransition(Instant.now()) == null;
        }
        return this.savingsInstantTransitions.length == 0;
    }

    public ZoneOffset getOffset(Instant instant) {
        if (this.timeZone != null) {
            return ZoneRules.offsetFromMillis(this.timeZone.getOffset(instant.toEpochMilli()));
        }
        if (this.savingsInstantTransitions.length == 0) {
            return this.standardOffsets[0];
        }
        long epochSec = instant.getEpochSecond();
        if (this.lastRules.length > 0 && epochSec > this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1]) {
            int year = this.findYear(epochSec, this.wallOffsets[this.wallOffsets.length - 1]);
            ZoneOffsetTransition[] transArray = this.findTransitionArray(year);
            ZoneOffsetTransition trans = null;
            for (int i = 0; i < transArray.length; ++i) {
                trans = transArray[i];
                if (epochSec >= trans.toEpochSecond()) continue;
                return trans.getOffsetBefore();
            }
            return trans.getOffsetAfter();
        }
        int index = Arrays.binarySearch(this.savingsInstantTransitions, epochSec);
        if (index < 0) {
            index = -index - 2;
        }
        return this.wallOffsets[index + 1];
    }

    public ZoneOffset getOffset(LocalDateTime localDateTime) {
        Object info = this.getOffsetInfo(localDateTime);
        if (info instanceof ZoneOffsetTransition) {
            return ((ZoneOffsetTransition)info).getOffsetBefore();
        }
        return (ZoneOffset)info;
    }

    public List<ZoneOffset> getValidOffsets(LocalDateTime localDateTime) {
        Object info = this.getOffsetInfo(localDateTime);
        if (info instanceof ZoneOffsetTransition) {
            return ((ZoneOffsetTransition)info).getValidOffsets();
        }
        return Collections.singletonList((ZoneOffset)info);
    }

    public ZoneOffsetTransition getTransition(LocalDateTime localDateTime) {
        Object info = this.getOffsetInfo(localDateTime);
        return info instanceof ZoneOffsetTransition ? (ZoneOffsetTransition)info : null;
    }

    private Object getOffsetInfo(LocalDateTime dt) {
        if (this.timeZone != null) {
            ZoneOffsetTransition[] transArray = this.findTransitionArray(dt.getYear());
            if (transArray.length == 0) {
                return ZoneRules.offsetFromMillis(this.timeZone.getOffset(dt.toEpochSecond(this.standardOffsets[0]) * 1000L));
            }
            Object info = null;
            for (ZoneOffsetTransition trans : transArray) {
                info = this.findOffsetInfo(dt, trans);
                if (!(info instanceof ZoneOffsetTransition) && !info.equals(trans.getOffsetBefore())) continue;
                return info;
            }
            return info;
        }
        if (this.savingsInstantTransitions.length == 0) {
            return this.standardOffsets[0];
        }
        if (this.lastRules.length > 0 && dt.isAfter(this.savingsLocalTransitions[this.savingsLocalTransitions.length - 1])) {
            ZoneOffsetTransition[] transArray = this.findTransitionArray(dt.getYear());
            Object info = null;
            for (ZoneOffsetTransition trans : transArray) {
                info = this.findOffsetInfo(dt, trans);
                if (!(info instanceof ZoneOffsetTransition) && !info.equals(trans.getOffsetBefore())) continue;
                return info;
            }
            return info;
        }
        int index = Arrays.binarySearch(this.savingsLocalTransitions, dt);
        if (index == -1) {
            return this.wallOffsets[0];
        }
        if (index < 0) {
            index = -index - 2;
        } else if (index < this.savingsLocalTransitions.length - 1 && this.savingsLocalTransitions[index].equals(this.savingsLocalTransitions[index + 1])) {
            ++index;
        }
        if ((index & 1) == 0) {
            LocalDateTime dtBefore = this.savingsLocalTransitions[index];
            LocalDateTime dtAfter = this.savingsLocalTransitions[index + 1];
            ZoneOffset offsetBefore = this.wallOffsets[index / 2];
            ZoneOffset offsetAfter = this.wallOffsets[index / 2 + 1];
            if (offsetAfter.getTotalSeconds() > offsetBefore.getTotalSeconds()) {
                return new ZoneOffsetTransition(dtBefore, offsetBefore, offsetAfter);
            }
            return new ZoneOffsetTransition(dtAfter, offsetBefore, offsetAfter);
        }
        return this.wallOffsets[index / 2 + 1];
    }

    private Object findOffsetInfo(LocalDateTime dt, ZoneOffsetTransition trans) {
        LocalDateTime localTransition = trans.getDateTimeBefore();
        if (trans.isGap()) {
            if (dt.isBefore(localTransition)) {
                return trans.getOffsetBefore();
            }
            if (dt.isBefore(trans.getDateTimeAfter())) {
                return trans;
            }
            return trans.getOffsetAfter();
        }
        if (!dt.isBefore(localTransition)) {
            return trans.getOffsetAfter();
        }
        if (dt.isBefore(trans.getDateTimeAfter())) {
            return trans.getOffsetBefore();
        }
        return trans;
    }

    private ZoneOffsetTransition[] findTransitionArray(int year) {
        Integer yearObj = year;
        ZoneOffsetTransition[] transArray = (ZoneOffsetTransition[])this.lastRulesCache.get(yearObj);
        if (transArray != null) {
            return transArray;
        }
        if (this.timeZone != null) {
            if (year < 1800) {
                return NO_TRANSITIONS;
            }
            LocalDateTime newYearsEve = LocalDateTime.of(year - 1, 12, 31, 0, 0);
            long lower = newYearsEve.toEpochSecond(this.standardOffsets[0]);
            int curOffsetMillis = this.timeZone.getOffset(lower * 1000L);
            long max = lower + 31968000L;
            transArray = NO_TRANSITIONS;
            while (lower < max) {
                long upper = lower + 7776000L;
                if (curOffsetMillis != this.timeZone.getOffset(upper * 1000L)) {
                    while (upper - lower > 1L) {
                        long middle = Math.floorDiv(upper + lower, 2L);
                        if (this.timeZone.getOffset(middle * 1000L) == curOffsetMillis) {
                            lower = middle;
                            continue;
                        }
                        upper = middle;
                    }
                    if (this.timeZone.getOffset(lower * 1000L) != curOffsetMillis) {
                        upper = lower;
                    }
                    ZoneOffset old = ZoneRules.offsetFromMillis(curOffsetMillis);
                    curOffsetMillis = this.timeZone.getOffset(upper * 1000L);
                    ZoneOffset next = ZoneRules.offsetFromMillis(curOffsetMillis);
                    if (this.findYear(upper, next) == year) {
                        transArray = Arrays.copyOf(transArray, transArray.length + 1);
                        transArray[transArray.length - 1] = new ZoneOffsetTransition(upper, old, next);
                    }
                }
                lower = upper;
            }
            if (1916 <= year && year < 2100) {
                this.lastRulesCache.putIfAbsent(yearObj, transArray);
            }
            return transArray;
        }
        ZoneOffsetTransitionRule[] ruleArray = this.lastRules;
        transArray = new ZoneOffsetTransition[ruleArray.length];
        for (int i = 0; i < ruleArray.length; ++i) {
            transArray[i] = ruleArray[i].createTransition(year);
        }
        if (year < 2100) {
            this.lastRulesCache.putIfAbsent(yearObj, transArray);
        }
        return transArray;
    }

    public ZoneOffset getStandardOffset(Instant instant) {
        if (this.timeZone != null) {
            return ZoneRules.offsetFromMillis(this.timeZone.getRawOffset());
        }
        if (this.savingsInstantTransitions.length == 0) {
            return this.standardOffsets[0];
        }
        long epochSec = instant.getEpochSecond();
        int index = Arrays.binarySearch(this.standardTransitions, epochSec);
        if (index < 0) {
            index = -index - 2;
        }
        return this.standardOffsets[index + 1];
    }

    public Duration getDaylightSavings(Instant instant) {
        if (this.timeZone != null) {
            int offset = this.timeZone.getOffset(instant.toEpochMilli());
            return Duration.ofMillis(offset - this.timeZone.getRawOffset());
        }
        if (this.savingsInstantTransitions.length == 0) {
            return Duration.ZERO;
        }
        ZoneOffset standardOffset = this.getStandardOffset(instant);
        ZoneOffset actualOffset = this.getOffset(instant);
        return Duration.ofSeconds(actualOffset.getTotalSeconds() - standardOffset.getTotalSeconds());
    }

    public boolean isDaylightSavings(Instant instant) {
        return !this.getStandardOffset(instant).equals(this.getOffset(instant));
    }

    public boolean isValidOffset(LocalDateTime localDateTime, ZoneOffset offset) {
        return this.getValidOffsets(localDateTime).contains(offset);
    }

    public ZoneOffsetTransition nextTransition(Instant instant) {
        if (this.timeZone != null) {
            ZoneOffsetTransition[] transArray;
            long epochSec = instant.getEpochSecond();
            int year = this.findYear(epochSec, this.getOffset(instant));
            for (ZoneOffsetTransition trans : transArray = this.findTransitionArray(year)) {
                if (epochSec >= trans.toEpochSecond()) continue;
                return trans;
            }
            if (year < 999999999) {
                for (ZoneOffsetTransition trans : transArray = this.findTransitionArray(year + 1)) {
                    if (epochSec >= trans.toEpochSecond()) continue;
                    return trans;
                }
            }
            int curOffsetMillis = this.timeZone.getOffset((epochSec + 1L) * 1000L);
            long max = Clock.systemUTC().millis() / 1000L + 31968000L;
            for (long probeSec = epochSec + 31104000L; probeSec <= max; probeSec += 7776000L) {
                int probeOffsetMillis = this.timeZone.getOffset(probeSec * 1000L);
                if (curOffsetMillis == probeOffsetMillis) continue;
                year = this.findYear(probeSec, ZoneRules.offsetFromMillis(probeOffsetMillis));
                for (ZoneOffsetTransition trans : transArray = this.findTransitionArray(year - 1)) {
                    if (epochSec >= trans.toEpochSecond()) continue;
                    return trans;
                }
                transArray = this.findTransitionArray(year);
                return transArray[0];
            }
            return null;
        }
        if (this.savingsInstantTransitions.length == 0) {
            return null;
        }
        long epochSec = instant.getEpochSecond();
        if (epochSec >= this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1]) {
            ZoneOffsetTransition[] transArray;
            if (this.lastRules.length == 0) {
                return null;
            }
            int year = this.findYear(epochSec, this.wallOffsets[this.wallOffsets.length - 1]);
            for (ZoneOffsetTransition trans : transArray = this.findTransitionArray(year)) {
                if (epochSec >= trans.toEpochSecond()) continue;
                return trans;
            }
            if (year < 999999999) {
                transArray = this.findTransitionArray(year + 1);
                return transArray[0];
            }
            return null;
        }
        int index = Arrays.binarySearch(this.savingsInstantTransitions, epochSec);
        index = index < 0 ? -index - 1 : ++index;
        return new ZoneOffsetTransition(this.savingsInstantTransitions[index], this.wallOffsets[index], this.wallOffsets[index + 1]);
    }

    public ZoneOffsetTransition previousTransition(Instant instant) {
        int index;
        if (this.timeZone != null) {
            int i;
            long epochSec = instant.getEpochSecond();
            if (instant.getNano() > 0 && epochSec < Long.MAX_VALUE) {
                ++epochSec;
            }
            int year = this.findYear(epochSec, this.getOffset(instant));
            ZoneOffsetTransition[] transArray = this.findTransitionArray(year);
            for (i = transArray.length - 1; i >= 0; --i) {
                if (epochSec <= transArray[i].toEpochSecond()) continue;
                return transArray[i];
            }
            if (year > 1800) {
                transArray = this.findTransitionArray(year - 1);
                for (i = transArray.length - 1; i >= 0; --i) {
                    if (epochSec <= transArray[i].toEpochSecond()) continue;
                    return transArray[i];
                }
            } else {
                return null;
            }
            int curOffsetMillis = this.timeZone.getOffset((epochSec - 1L) * 1000L);
            long min = LocalDate.of(1800, 1, 1).toEpochDay() * 86400L;
            for (long probeSec = Math.min(epochSec - 31104000L, Clock.systemUTC().millis() / 1000L + 31968000L); min <= probeSec; probeSec -= 7776000L) {
                int probeOffsetMillis = this.timeZone.getOffset(probeSec * 1000L);
                if (curOffsetMillis == probeOffsetMillis) continue;
                year = this.findYear(probeSec, ZoneRules.offsetFromMillis(probeOffsetMillis));
                transArray = this.findTransitionArray(year + 1);
                for (int i2 = transArray.length - 1; i2 >= 0; --i2) {
                    if (epochSec <= transArray[i2].toEpochSecond()) continue;
                    return transArray[i2];
                }
                transArray = this.findTransitionArray(year);
                return transArray[transArray.length - 1];
            }
            return null;
        }
        if (this.savingsInstantTransitions.length == 0) {
            return null;
        }
        long epochSec = instant.getEpochSecond();
        if (instant.getNano() > 0 && epochSec < Long.MAX_VALUE) {
            ++epochSec;
        }
        long lastHistoric = this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1];
        if (this.lastRules.length > 0 && epochSec > lastHistoric) {
            ZoneOffset lastHistoricOffset = this.wallOffsets[this.wallOffsets.length - 1];
            int year = this.findYear(epochSec, lastHistoricOffset);
            ZoneOffsetTransition[] transArray = this.findTransitionArray(year);
            for (int i = transArray.length - 1; i >= 0; --i) {
                if (epochSec <= transArray[i].toEpochSecond()) continue;
                return transArray[i];
            }
            int lastHistoricYear = this.findYear(lastHistoric, lastHistoricOffset);
            if (--year > lastHistoricYear) {
                transArray = this.findTransitionArray(year);
                return transArray[transArray.length - 1];
            }
        }
        if ((index = Arrays.binarySearch(this.savingsInstantTransitions, epochSec)) < 0) {
            index = -index - 1;
        }
        if (index <= 0) {
            return null;
        }
        return new ZoneOffsetTransition(this.savingsInstantTransitions[index - 1], this.wallOffsets[index - 1], this.wallOffsets[index]);
    }

    private int findYear(long epochSecond, ZoneOffset offset) {
        long localSecond = epochSecond + (long)offset.getTotalSeconds();
        long localEpochDay = Math.floorDiv(localSecond, 86400);
        return LocalDate.ofEpochDay(localEpochDay).getYear();
    }

    public List<ZoneOffsetTransition> getTransitions() {
        ArrayList<ZoneOffsetTransition> list = new ArrayList<ZoneOffsetTransition>();
        for (int i = 0; i < this.savingsInstantTransitions.length; ++i) {
            list.add(new ZoneOffsetTransition(this.savingsInstantTransitions[i], this.wallOffsets[i], this.wallOffsets[i + 1]));
        }
        return Collections.unmodifiableList(list);
    }

    public List<ZoneOffsetTransitionRule> getTransitionRules() {
        return Collections.unmodifiableList(Arrays.asList(this.lastRules));
    }

    public boolean equals(Object otherRules) {
        if (this == otherRules) {
            return true;
        }
        if (otherRules instanceof ZoneRules) {
            ZoneRules other = (ZoneRules)otherRules;
            return Objects.equals(this.timeZone, other.timeZone) && Arrays.equals(this.standardTransitions, other.standardTransitions) && Arrays.equals(this.standardOffsets, other.standardOffsets) && Arrays.equals(this.savingsInstantTransitions, other.savingsInstantTransitions) && Arrays.equals(this.wallOffsets, other.wallOffsets) && Arrays.equals(this.lastRules, other.lastRules);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.timeZone) ^ Arrays.hashCode(this.standardTransitions) ^ Arrays.hashCode(this.standardOffsets) ^ Arrays.hashCode(this.savingsInstantTransitions) ^ Arrays.hashCode(this.wallOffsets) ^ Arrays.hashCode(this.lastRules);
    }

    public String toString() {
        if (this.timeZone != null) {
            return "ZoneRules[timeZone=" + this.timeZone.getID() + "]";
        }
        return "ZoneRules[currentStandardOffset=" + this.standardOffsets[this.standardOffsets.length - 1] + "]";
    }
}

