/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import jdk.internal.math.FloatingDecimal;

abstract class AbstractStringBuilder
implements Appendable,
CharSequence {
    byte[] value;
    byte coder;
    int count;
    private static final byte[] EMPTYVALUE = new byte[0];
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    AbstractStringBuilder() {
        this.value = EMPTYVALUE;
    }

    AbstractStringBuilder(int capacity) {
        if (String.COMPACT_STRINGS) {
            this.value = new byte[capacity];
            this.coder = 0;
        } else {
            this.value = StringUTF16.newBytesFor(capacity);
            this.coder = 1;
        }
    }

    int compareTo(AbstractStringBuilder another) {
        if (this == another) {
            return 0;
        }
        byte[] val1 = this.value;
        byte[] val2 = another.value;
        int count1 = this.count;
        int count2 = another.count;
        if (this.coder == another.coder) {
            return this.isLatin1() ? StringLatin1.compareTo(val1, val2, count1, count2) : StringUTF16.compareTo(val1, val2, count1, count2);
        }
        return this.isLatin1() ? StringLatin1.compareToUTF16(val1, val2, count1, count2) : StringUTF16.compareToLatin1(val1, val2, count1, count2);
    }

    @Override
    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length >> this.coder;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > 0) {
            this.ensureCapacityInternal(minimumCapacity);
        }
    }

    private void ensureCapacityInternal(int minimumCapacity) {
        int oldCapacity = this.value.length >> this.coder;
        if (minimumCapacity - oldCapacity > 0) {
            this.value = Arrays.copyOf(this.value, this.newCapacity(minimumCapacity) << this.coder);
        }
    }

    private int newCapacity(int minCapacity) {
        int oldCapacity = this.value.length >> this.coder;
        int newCapacity = (oldCapacity << 1) + 2;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        int SAFE_BOUND = 0x7FFFFFF7 >> this.coder;
        return newCapacity <= 0 || SAFE_BOUND - newCapacity < 0 ? this.hugeCapacity(minCapacity) : newCapacity;
    }

    private int hugeCapacity(int minCapacity) {
        int SAFE_BOUND = 0x7FFFFFF7 >> this.coder;
        int UNSAFE_BOUND = Integer.MAX_VALUE >> this.coder;
        if (UNSAFE_BOUND - minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > SAFE_BOUND ? minCapacity : SAFE_BOUND;
    }

    private void inflate() {
        if (!this.isLatin1()) {
            return;
        }
        byte[] buf = StringUTF16.newBytesFor(this.value.length);
        StringLatin1.inflate(this.value, 0, buf, 0, this.count);
        this.value = buf;
        this.coder = 1;
    }

    public void trimToSize() {
        int length = this.count << this.coder;
        if (length < this.value.length) {
            this.value = Arrays.copyOf(this.value, length);
        }
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        this.ensureCapacityInternal(newLength);
        if (this.count < newLength) {
            if (this.isLatin1()) {
                StringLatin1.fillNull(this.value, this.count, newLength);
            } else {
                StringUTF16.fillNull(this.value, this.count, newLength);
            }
        }
        this.count = newLength;
    }

    @Override
    public char charAt(int index) {
        String.checkIndex(index, this.count);
        if (this.isLatin1()) {
            return (char)(this.value[index] & 0xFF);
        }
        return StringUTF16.charAt(this.value, index);
    }

    public int codePointAt(int index) {
        int count = this.count;
        byte[] value = this.value;
        String.checkIndex(index, count);
        if (this.isLatin1()) {
            return value[index] & 0xFF;
        }
        return StringUTF16.codePointAtSB(value, index, count);
    }

    public int codePointBefore(int index) {
        int i = index - 1;
        if (i < 0 || i >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (this.isLatin1()) {
            return this.value[i] & 0xFF;
        }
        return StringUTF16.codePointBeforeSB(this.value, index);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.count || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isLatin1()) {
            return endIndex - beginIndex;
        }
        return StringUTF16.codePointCountSB(this.value, beginIndex, endIndex);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        if (index < 0 || index > this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePoints(this, index, codePointOffset);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        AbstractStringBuilder.checkRangeSIOOBE(srcBegin, srcEnd, this.count);
        int n = srcEnd - srcBegin;
        AbstractStringBuilder.checkRange(dstBegin, dstBegin + n, dst.length);
        if (this.isLatin1()) {
            StringLatin1.getChars(this.value, srcBegin, srcEnd, dst, dstBegin);
        } else {
            StringUTF16.getChars(this.value, srcBegin, srcEnd, dst, dstBegin);
        }
    }

    public void setCharAt(int index, char ch) {
        String.checkIndex(index, this.count);
        if (this.isLatin1() && StringLatin1.canEncode(ch)) {
            this.value[index] = (byte)ch;
        } else {
            if (this.isLatin1()) {
                this.inflate();
            }
            StringUTF16.putCharSB(this.value, index, ch);
        }
    }

    public AbstractStringBuilder append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public AbstractStringBuilder append(String str) {
        if (str == null) {
            return this.appendNull();
        }
        int len = str.length();
        this.ensureCapacityInternal(this.count + len);
        this.putStringAt(this.count, str);
        this.count += len;
        return this;
    }

    public AbstractStringBuilder append(StringBuffer sb) {
        return this.append((AbstractStringBuilder)sb);
    }

    AbstractStringBuilder append(AbstractStringBuilder asb) {
        if (asb == null) {
            return this.appendNull();
        }
        int len = asb.length();
        this.ensureCapacityInternal(this.count + len);
        if (this.getCoder() != asb.getCoder()) {
            this.inflate();
        }
        asb.getBytes(this.value, this.count, this.coder);
        this.count += len;
        return this;
    }

    @Override
    public AbstractStringBuilder append(CharSequence s) {
        if (s == null) {
            return this.appendNull();
        }
        if (s instanceof String) {
            return this.append((String)s);
        }
        if (s instanceof AbstractStringBuilder) {
            return this.append((AbstractStringBuilder)s);
        }
        return this.append(s, 0, s.length());
    }

    private AbstractStringBuilder appendNull() {
        this.ensureCapacityInternal(this.count + 4);
        int count = this.count;
        byte[] val = this.value;
        if (this.isLatin1()) {
            val[count++] = 110;
            val[count++] = 117;
            val[count++] = 108;
            val[count++] = 108;
        } else {
            count = StringUTF16.putCharsAt(val, count, 'n', 'u', 'l', 'l');
        }
        this.count = count;
        return this;
    }

    @Override
    public AbstractStringBuilder append(CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        AbstractStringBuilder.checkRange(start, end, s.length());
        int len = end - start;
        this.ensureCapacityInternal(this.count + len);
        this.appendChars(s, start, end);
        return this;
    }

    public AbstractStringBuilder append(char[] str) {
        int len = str.length;
        this.ensureCapacityInternal(this.count + len);
        this.appendChars(str, 0, len);
        return this;
    }

    public AbstractStringBuilder append(char[] str, int offset, int len) {
        int end = offset + len;
        AbstractStringBuilder.checkRange(offset, end, str.length);
        this.ensureCapacityInternal(this.count + len);
        this.appendChars(str, offset, end);
        return this;
    }

    public AbstractStringBuilder append(boolean b) {
        this.ensureCapacityInternal(this.count + (b ? 4 : 5));
        int count = this.count;
        byte[] val = this.value;
        if (this.isLatin1()) {
            if (b) {
                val[count++] = 116;
                val[count++] = 114;
                val[count++] = 117;
                val[count++] = 101;
            } else {
                val[count++] = 102;
                val[count++] = 97;
                val[count++] = 108;
                val[count++] = 115;
                val[count++] = 101;
            }
        } else {
            count = b ? StringUTF16.putCharsAt(val, count, 't', 'r', 'u', 'e') : StringUTF16.putCharsAt(val, count, 'f', 'a', 'l', 's', 'e');
        }
        this.count = count;
        return this;
    }

    @Override
    public AbstractStringBuilder append(char c) {
        this.ensureCapacityInternal(this.count + 1);
        if (this.isLatin1() && StringLatin1.canEncode(c)) {
            this.value[this.count++] = (byte)c;
        } else {
            if (this.isLatin1()) {
                this.inflate();
            }
            StringUTF16.putCharSB(this.value, this.count++, c);
        }
        return this;
    }

    public AbstractStringBuilder append(int i) {
        int count = this.count;
        int spaceNeeded = count + Integer.stringSize(i);
        this.ensureCapacityInternal(spaceNeeded);
        if (this.isLatin1()) {
            Integer.getChars(i, spaceNeeded, this.value);
        } else {
            StringUTF16.getChars(i, count, spaceNeeded, this.value);
        }
        this.count = spaceNeeded;
        return this;
    }

    public AbstractStringBuilder append(long l) {
        int count = this.count;
        int spaceNeeded = count + Long.stringSize(l);
        this.ensureCapacityInternal(spaceNeeded);
        if (this.isLatin1()) {
            Long.getChars(l, spaceNeeded, this.value);
        } else {
            StringUTF16.getChars(l, count, spaceNeeded, this.value);
        }
        this.count = spaceNeeded;
        return this;
    }

    public AbstractStringBuilder append(float f) {
        FloatingDecimal.appendTo(f, (Appendable)this);
        return this;
    }

    public AbstractStringBuilder append(double d) {
        FloatingDecimal.appendTo(d, (Appendable)this);
        return this;
    }

    public AbstractStringBuilder delete(int start, int end) {
        int count = this.count;
        if (end > count) {
            end = count;
        }
        AbstractStringBuilder.checkRangeSIOOBE(start, end, count);
        int len = end - start;
        if (len > 0) {
            this.shift(end, -len);
            this.count = count - len;
        }
        return this;
    }

    public AbstractStringBuilder appendCodePoint(int codePoint) {
        if (DesugarCharacter.isBmpCodePoint(codePoint)) {
            return this.append((char)codePoint);
        }
        return this.append(Character.toChars(codePoint));
    }

    public AbstractStringBuilder deleteCharAt(int index) {
        String.checkIndex(index, this.count);
        this.shift(index + 1, -1);
        --this.count;
        return this;
    }

    public AbstractStringBuilder replace(int start, int end, String str) {
        int count = this.count;
        if (end > count) {
            end = count;
        }
        AbstractStringBuilder.checkRangeSIOOBE(start, end, count);
        int len = str.length();
        int newCount = count + len - (end - start);
        this.ensureCapacityInternal(newCount);
        this.shift(end, newCount - count);
        this.count = newCount;
        this.putStringAt(start, str);
        return this;
    }

    public String substring(int start) {
        return this.substring(start, this.count);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public String substring(int start, int end) {
        AbstractStringBuilder.checkRangeSIOOBE(start, end, this.count);
        if (this.isLatin1()) {
            return StringLatin1.newString(this.value, start, end - start);
        }
        return StringUTF16.newString(this.value, start, end - start);
    }

    private void shift(int offset, int n) {
        System.arraycopy(this.value, offset << this.coder, this.value, offset + n << this.coder, this.count - offset << this.coder);
    }

    public AbstractStringBuilder insert(int index, char[] str, int offset, int len) {
        DesugarString.checkOffset(index, this.count);
        AbstractStringBuilder.checkRangeSIOOBE(offset, offset + len, str.length);
        this.ensureCapacityInternal(this.count + len);
        this.shift(index, len);
        this.count += len;
        this.putCharsAt(index, str, offset, offset + len);
        return this;
    }

    public AbstractStringBuilder insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public AbstractStringBuilder insert(int offset, String str) {
        DesugarString.checkOffset(offset, this.count);
        if (str == null) {
            str = "null";
        }
        int len = str.length();
        this.ensureCapacityInternal(this.count + len);
        this.shift(offset, len);
        this.count += len;
        this.putStringAt(offset, str);
        return this;
    }

    public AbstractStringBuilder insert(int offset, char[] str) {
        DesugarString.checkOffset(offset, this.count);
        int len = str.length;
        this.ensureCapacityInternal(this.count + len);
        this.shift(offset, len);
        this.count += len;
        this.putCharsAt(offset, str, 0, len);
        return this;
    }

    public AbstractStringBuilder insert(int dstOffset, CharSequence s) {
        if (s == null) {
            s = "null";
        }
        if (s instanceof String) {
            return this.insert(dstOffset, (String)s);
        }
        return this.insert(dstOffset, s, 0, s.length());
    }

    public AbstractStringBuilder insert(int dstOffset, CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        DesugarString.checkOffset(dstOffset, this.count);
        AbstractStringBuilder.checkRange(start, end, s.length());
        int len = end - start;
        this.ensureCapacityInternal(this.count + len);
        this.shift(dstOffset, len);
        this.count += len;
        this.putCharsAt(dstOffset, s, start, end);
        return this;
    }

    public AbstractStringBuilder insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public AbstractStringBuilder insert(int offset, char c) {
        DesugarString.checkOffset(offset, this.count);
        this.ensureCapacityInternal(this.count + 1);
        this.shift(offset, 1);
        ++this.count;
        if (this.isLatin1() && StringLatin1.canEncode(c)) {
            this.value[offset] = (byte)c;
        } else {
            if (this.isLatin1()) {
                this.inflate();
            }
            StringUTF16.putCharSB(this.value, offset, c);
        }
        return this;
    }

    public AbstractStringBuilder insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public AbstractStringBuilder insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public AbstractStringBuilder insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public AbstractStringBuilder insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        return String.indexOf(this.value, this.coder, this.count, str, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return String.lastIndexOf(this.value, this.coder, this.count, str, fromIndex);
    }

    public AbstractStringBuilder reverse() {
        byte[] val = this.value;
        int count = this.count;
        byte coder = this.coder;
        int n = count - 1;
        if (String.COMPACT_STRINGS && coder == 0) {
            for (int j = n - 1 >> 1; j >= 0; --j) {
                int k = n - j;
                byte cj = val[j];
                val[j] = val[k];
                val[k] = cj;
            }
        } else {
            StringUTF16.reverse(val, count);
        }
        return this;
    }

    @Override
    public abstract String toString();

    @Override
    public IntStream chars() {
        return StreamSupport.intStream(() -> {
            byte[] val = this.value;
            int count = this.count;
            byte coder = this.coder;
            return coder == 0 ? new StringLatin1.CharsSpliterator(val, 0, count, 0) : new StringUTF16.CharsSpliterator(val, 0, count, 0);
        }, 16464, false);
    }

    @Override
    public IntStream codePoints() {
        return StreamSupport.intStream(() -> {
            byte[] val = this.value;
            int count = this.count;
            byte coder = this.coder;
            return coder == 0 ? new StringLatin1.CharsSpliterator(val, 0, count, 0) : new StringUTF16.CodePointsSpliterator(val, 0, count, 0);
        }, 16, false);
    }

    final byte[] getValue() {
        return this.value;
    }

    void getBytes(byte[] dst, int dstBegin, byte coder) {
        if (this.coder == coder) {
            System.arraycopy(this.value, 0, dst, dstBegin << coder, this.count << coder);
        } else {
            StringLatin1.inflate(this.value, 0, dst, dstBegin, this.count);
        }
    }

    void initBytes(char[] value, int off, int len) {
        if (String.COMPACT_STRINGS) {
            this.value = StringUTF16.compress(value, off, len);
            if (this.value != null) {
                this.coder = 0;
                return;
            }
        }
        this.coder = 1;
        this.value = StringUTF16.toBytes(value, off, len);
    }

    final byte getCoder() {
        return String.COMPACT_STRINGS ? this.coder : (byte)1;
    }

    final boolean isLatin1() {
        return String.COMPACT_STRINGS && this.coder == 0;
    }

    private final void putCharsAt(int index, char[] s, int off, int end) {
        if (this.isLatin1()) {
            byte[] val = this.value;
            int j = index;
            for (int i = off; i < end; ++i) {
                char c = s[i];
                if (!StringLatin1.canEncode(c)) {
                    this.inflate();
                    StringUTF16.putCharsSB(this.value, j, s, i, end);
                    return;
                }
                val[j++] = (byte)c;
            }
        } else {
            StringUTF16.putCharsSB(this.value, index, s, off, end);
        }
    }

    private final void putCharsAt(int index, CharSequence s, int off, int end) {
        if (this.isLatin1()) {
            byte[] val = this.value;
            int j = index;
            for (int i = off; i < end; ++i) {
                char c = s.charAt(i);
                if (!StringLatin1.canEncode(c)) {
                    this.inflate();
                    StringUTF16.putCharsSB(this.value, j, s, i, end);
                    return;
                }
                val[j++] = (byte)c;
            }
        } else {
            StringUTF16.putCharsSB(this.value, index, s, off, end);
        }
    }

    private final void putStringAt(int index, String str) {
        if (this.getCoder() != str.coder()) {
            this.inflate();
        }
        str.getBytes(this.value, index, this.coder);
    }

    private final void appendChars(char[] s, int off, int end) {
        int count = this.count;
        if (this.isLatin1()) {
            byte[] val = this.value;
            int j = count;
            for (int i = off; i < end; ++i) {
                char c = s[i];
                if (!StringLatin1.canEncode(c)) {
                    this.count = count = j;
                    this.inflate();
                    StringUTF16.putCharsSB(this.value, j, s, i, end);
                    this.count = count + end - i;
                    return;
                }
                val[j++] = (byte)c;
            }
        } else {
            StringUTF16.putCharsSB(this.value, count, s, off, end);
        }
        this.count = count + end - off;
    }

    private final void appendChars(CharSequence s, int off, int end) {
        if (this.isLatin1()) {
            byte[] val = this.value;
            int j = this.count;
            for (int i = off; i < end; ++i) {
                char c = s.charAt(i);
                if (!StringLatin1.canEncode(c)) {
                    this.count = j;
                    this.inflate();
                    StringUTF16.putCharsSB(this.value, j, s, i, end);
                    this.count += end - i;
                    return;
                }
                val[j++] = (byte)c;
            }
        } else {
            StringUTF16.putCharsSB(this.value, this.count, s, off, end);
        }
        this.count += end - off;
    }

    private static void checkRange(int start, int end, int len) {
        if (start < 0 || start > end || end > len) {
            throw new IndexOutOfBoundsException("start " + start + ", end " + end + ", length " + len);
        }
    }

    private static void checkRangeSIOOBE(int start, int end, int len) {
        if (start < 0 || start > end || end > len) {
            throw new StringIndexOutOfBoundsException("start " + start + ", end " + end + ", length " + len);
        }
    }
}

