/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.text.DateFormatSymbols;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class DateTimeTextProvider {
    private static final ConcurrentMap<Map.Entry<TemporalField, Locale>, Object> CACHE = new ConcurrentHashMap<Map.Entry<TemporalField, Locale>, Object>(16, 0.75f, 2);
    private static final Comparator<Map.Entry<String, Long>> COMPARATOR = new Comparator<Map.Entry<String, Long>>(){

        @Override
        public int compare(Map.Entry<String, Long> obj1, Map.Entry<String, Long> obj2) {
            return obj2.getKey().length() - obj1.getKey().length();
        }
    };
    private static final DateTimeTextProvider INSTANCE = new DateTimeTextProvider();

    DateTimeTextProvider() {
    }

    static DateTimeTextProvider getInstance() {
        return INSTANCE;
    }

    public String getText(TemporalField field, long value, TextStyle style, Locale locale) {
        Object store = this.findStore(field, locale);
        if (store instanceof LocaleStore) {
            return ((LocaleStore)store).getText(value, style);
        }
        return null;
    }

    public String getText(Chronology chrono, TemporalField field, long value, TextStyle style, Locale locale) {
        if (chrono == IsoChronology.INSTANCE || !(field instanceof ChronoField)) {
            return this.getText(field, value, style, locale);
        }
        return null;
    }

    public Iterator<Map.Entry<String, Long>> getTextIterator(TemporalField field, TextStyle style, Locale locale) {
        Object store = this.findStore(field, locale);
        if (store instanceof LocaleStore) {
            return ((LocaleStore)store).getTextIterator(style);
        }
        return null;
    }

    public Iterator<Map.Entry<String, Long>> getTextIterator(Chronology chrono, TemporalField field, TextStyle style, Locale locale) {
        if (chrono == IsoChronology.INSTANCE || !(field instanceof ChronoField)) {
            return this.getTextIterator(field, style, locale);
        }
        return null;
    }

    private Object findStore(TemporalField field, Locale locale) {
        Map.Entry<TemporalField, Locale> key = DateTimeTextProvider.createEntry(field, locale);
        Object store = CACHE.get(key);
        if (store == null) {
            store = this.createStore(field, locale);
            CACHE.putIfAbsent(key, store);
            store = CACHE.get(key);
        }
        return store;
    }

    private static int toWeekDay(int calWeekDay) {
        if (calWeekDay == 1) {
            return 7;
        }
        return calWeekDay - 1;
    }

    private Object createStore(TemporalField field, Locale locale) {
        HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
        if (field == ChronoField.ERA) {
            DateFormatSymbols symbols = DateFormatSymbols.getInstance(locale);
            HashMap<Long, String> fullMap = new HashMap<Long, String>();
            HashMap<Long, String> narrowMap = new HashMap<Long, String>();
            String[] eraSymbols = symbols.getEras();
            for (int i = 0; i < eraSymbols.length; ++i) {
                if (eraSymbols[i].isEmpty()) continue;
                fullMap.put(Long.valueOf(i), eraSymbols[i]);
                narrowMap.put(Long.valueOf(i), DateTimeTextProvider.firstCodePoint(eraSymbols[i]));
            }
            if (!fullMap.isEmpty()) {
                styleMap.put(TextStyle.FULL, fullMap);
                styleMap.put(TextStyle.SHORT, fullMap);
                styleMap.put(TextStyle.NARROW, narrowMap);
            }
            return new LocaleStore(styleMap);
        }
        if (field == ChronoField.MONTH_OF_YEAR) {
            DateFormatSymbols symbols = DateFormatSymbols.getInstance(locale);
            HashMap<Long, String> longMap = new HashMap<Long, String>();
            HashMap<Long, String> narrowMap = new HashMap<Long, String>();
            String[] longMonths = symbols.getMonths();
            for (int i = 0; i < longMonths.length; ++i) {
                if (longMonths[i].isEmpty()) continue;
                longMap.put((long)i + 1L, longMonths[i]);
                narrowMap.put((long)i + 1L, DateTimeTextProvider.firstCodePoint(longMonths[i]));
            }
            if (!longMap.isEmpty()) {
                styleMap.put(TextStyle.FULL, longMap);
                styleMap.put(TextStyle.NARROW, narrowMap);
            }
            HashMap<Long, String> shortMap = new HashMap<Long, String>();
            String[] shortMonths = symbols.getShortMonths();
            for (int i = 0; i < shortMonths.length; ++i) {
                if (shortMonths[i].isEmpty()) continue;
                shortMap.put((long)i + 1L, shortMonths[i]);
            }
            if (!shortMap.isEmpty()) {
                styleMap.put(TextStyle.SHORT, shortMap);
            }
            return new LocaleStore(styleMap);
        }
        if (field == ChronoField.DAY_OF_WEEK) {
            DateFormatSymbols symbols = DateFormatSymbols.getInstance(locale);
            HashMap<Long, String> longMap = new HashMap<Long, String>();
            String[] longSymbols = symbols.getWeekdays();
            longMap.put(1L, longSymbols[2]);
            longMap.put(2L, longSymbols[3]);
            longMap.put(3L, longSymbols[4]);
            longMap.put(4L, longSymbols[5]);
            longMap.put(5L, longSymbols[6]);
            longMap.put(6L, longSymbols[7]);
            longMap.put(7L, longSymbols[1]);
            styleMap.put(TextStyle.FULL, longMap);
            HashMap<Long, String> narrowMap = new HashMap<Long, String>();
            narrowMap.put(1L, DateTimeTextProvider.firstCodePoint(longSymbols[2]));
            narrowMap.put(2L, DateTimeTextProvider.firstCodePoint(longSymbols[3]));
            narrowMap.put(3L, DateTimeTextProvider.firstCodePoint(longSymbols[4]));
            narrowMap.put(4L, DateTimeTextProvider.firstCodePoint(longSymbols[5]));
            narrowMap.put(5L, DateTimeTextProvider.firstCodePoint(longSymbols[6]));
            narrowMap.put(6L, DateTimeTextProvider.firstCodePoint(longSymbols[7]));
            narrowMap.put(7L, DateTimeTextProvider.firstCodePoint(longSymbols[1]));
            styleMap.put(TextStyle.NARROW, narrowMap);
            HashMap<Long, String> shortMap = new HashMap<Long, String>();
            String[] shortSymbols = symbols.getShortWeekdays();
            shortMap.put(1L, shortSymbols[2]);
            shortMap.put(2L, shortSymbols[3]);
            shortMap.put(3L, shortSymbols[4]);
            shortMap.put(4L, shortSymbols[5]);
            shortMap.put(5L, shortSymbols[6]);
            shortMap.put(6L, shortSymbols[7]);
            shortMap.put(7L, shortSymbols[1]);
            styleMap.put(TextStyle.SHORT, shortMap);
            return new LocaleStore(styleMap);
        }
        if (field == ChronoField.AMPM_OF_DAY) {
            DateFormatSymbols symbols = DateFormatSymbols.getInstance(locale);
            HashMap<Long, String> fullMap = new HashMap<Long, String>();
            HashMap<Long, String> narrowMap = new HashMap<Long, String>();
            String[] amPmSymbols = symbols.getAmPmStrings();
            for (int i = 0; i < amPmSymbols.length; ++i) {
                if (amPmSymbols[i].isEmpty()) continue;
                fullMap.put(Long.valueOf(i), amPmSymbols[i]);
                narrowMap.put(Long.valueOf(i), DateTimeTextProvider.firstCodePoint(amPmSymbols[i]));
            }
            if (!fullMap.isEmpty()) {
                styleMap.put(TextStyle.FULL, fullMap);
                styleMap.put(TextStyle.SHORT, fullMap);
                styleMap.put(TextStyle.NARROW, narrowMap);
            }
            return new LocaleStore(styleMap);
        }
        return "";
    }

    private static String firstCodePoint(String string) {
        return string.substring(0, Character.charCount(string.codePointAt(0)));
    }

    private static <A, B> Map.Entry<A, B> createEntry(A text, B field) {
        return new AbstractMap.SimpleImmutableEntry<A, B>(text, field);
    }

    static final class LocaleStore {
        private final Map<TextStyle, Map<Long, String>> valueTextMap;
        private final Map<TextStyle, List<Map.Entry<String, Long>>> parsable;

        LocaleStore(Map<TextStyle, Map<Long, String>> valueTextMap) {
            this.valueTextMap = valueTextMap;
            HashMap<TextStyle, List<Map.Entry<String, Long>>> map = new HashMap<TextStyle, List<Map.Entry<String, Long>>>();
            ArrayList allList = new ArrayList();
            for (Map.Entry<TextStyle, Map<Long, String>> vtmEntry : valueTextMap.entrySet()) {
                HashMap<String, Map.Entry<String, Long>> reverse = new HashMap<String, Map.Entry<String, Long>>();
                for (Map.Entry<Long, String> entry : vtmEntry.getValue().entrySet()) {
                    if (reverse.put(entry.getValue(), DateTimeTextProvider.createEntry(entry.getValue(), entry.getKey())) == null) continue;
                }
                ArrayList list = new ArrayList(reverse.values());
                Collections.sort(list, COMPARATOR);
                map.put(vtmEntry.getKey(), list);
                allList.addAll(list);
                map.put(null, allList);
            }
            Collections.sort(allList, COMPARATOR);
            this.parsable = map;
        }

        String getText(long value, TextStyle style) {
            Map<Long, String> map = this.valueTextMap.get((Object)style);
            return map != null ? map.get(value) : null;
        }

        Iterator<Map.Entry<String, Long>> getTextIterator(TextStyle style) {
            List<Map.Entry<String, Long>> list = this.parsable.get((Object)style);
            return list != null ? list.iterator() : null;
        }
    }
}

