/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.ByteOrder;
import sun.misc.DesugarUnsafe;

class NativeObject {
    protected static final DesugarUnsafe unsafe = DesugarUnsafe.getUnsafe();
    protected long allocationAddress;
    private final long address;
    private static ByteOrder byteOrder = null;
    private static int pageSize = -1;

    NativeObject(long address) {
        this.allocationAddress = address;
        this.address = address;
    }

    NativeObject(long address, long offset) {
        this.allocationAddress = address;
        this.address = address + offset;
    }

    protected NativeObject(int size, boolean pageAligned) {
        if (!pageAligned) {
            this.address = this.allocationAddress = unsafe.allocateMemory(size);
        } else {
            long a;
            int ps = NativeObject.pageSize();
            this.allocationAddress = a = unsafe.allocateMemory(size + ps);
            this.address = a + (long)ps - (a & (long)(ps - 1));
        }
    }

    long address() {
        return this.address;
    }

    long allocationAddress() {
        return this.allocationAddress;
    }

    NativeObject subObject(int offset) {
        return new NativeObject((long)offset + this.address);
    }

    NativeObject getObject(int offset) {
        long newAddress = 0L;
        switch (NativeObject.addressSize()) {
            case 8: {
                newAddress = unsafe.getLong((long)offset + this.address);
                break;
            }
            case 4: {
                newAddress = unsafe.getInt((long)offset + this.address) & 0xFFFFFFFF;
                break;
            }
            default: {
                throw new InternalError("Address size not supported");
            }
        }
        return new NativeObject(newAddress);
    }

    void putObject(int offset, NativeObject ob) {
        switch (NativeObject.addressSize()) {
            case 8: {
                this.putLong(offset, ob.address);
                break;
            }
            case 4: {
                this.putInt(offset, (int)(ob.address & 0xFFFFFFFFFFFFFFFFL));
                break;
            }
            default: {
                throw new InternalError("Address size not supported");
            }
        }
    }

    final byte getByte(int offset) {
        return unsafe.getByte((long)offset + this.address);
    }

    final void putByte(int offset, byte value) {
        unsafe.putByte((long)offset + this.address, value);
    }

    final short getShort(int offset) {
        return unsafe.getShort((long)offset + this.address);
    }

    final void putShort(int offset, short value) {
        unsafe.putShort((long)offset + this.address, value);
    }

    final char getChar(int offset) {
        return unsafe.getChar((long)offset + this.address);
    }

    final void putChar(int offset, char value) {
        unsafe.putChar((long)offset + this.address, value);
    }

    final int getInt(int offset) {
        return unsafe.getInt((long)offset + this.address);
    }

    final void putInt(int offset, int value) {
        unsafe.putInt((long)offset + this.address, value);
    }

    final long getLong(int offset) {
        return unsafe.getLong((long)offset + this.address);
    }

    final void putLong(int offset, long value) {
        unsafe.putLong((long)offset + this.address, value);
    }

    final float getFloat(int offset) {
        return unsafe.getFloat((long)offset + this.address);
    }

    final void putFloat(int offset, float value) {
        unsafe.putFloat((long)offset + this.address, value);
    }

    final double getDouble(int offset) {
        return unsafe.getDouble((long)offset + this.address);
    }

    final void putDouble(int offset, double value) {
        unsafe.putDouble((long)offset + this.address, value);
    }

    static int addressSize() {
        return unsafe.addressSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ByteOrder byteOrder() {
        if (byteOrder != null) {
            return byteOrder;
        }
        long a = unsafe.allocateMemory(8L);
        try {
            unsafe.putLong(a, 72623859790382856L);
            byte b = unsafe.getByte(a);
            switch (b) {
                case 1: {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                    return byteOrder;
                }
                case 8: {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                    return byteOrder;
                }
                default: {
                    assert (false);
                    return byteOrder;
                }
            }
        }
        finally {
            unsafe.freeMemory(a);
        }
    }

    static int pageSize() {
        int value = pageSize;
        if (value == -1) {
            pageSize = value = unsafe.pageSize();
        }
        return value;
    }
}

