/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Objects;

public final class DesugarInteger {
    private DesugarInteger() {
    }

    public static String toUnsignedString(int i, int radix) {
        return Long.toUnsignedString(Integer.toUnsignedLong(i), radix);
    }

    public static String toUnsignedString(int i) {
        return Long.toString(Integer.toUnsignedLong(i));
    }

    public static int parseInt(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        s = Objects.requireNonNull(s);
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        boolean negative = false;
        int i = beginIndex;
        int limit = -2147483647;
        if (i < endIndex) {
            char firstChar = s.charAt(i);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw DesugarNumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
                if (++i == endIndex) {
                    throw DesugarNumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
            }
            int multmin = limit / radix;
            int result = 0;
            while (i < endIndex) {
                int digit = Character.digit(s.charAt(i), radix);
                if (digit < 0 || result < multmin) {
                    throw DesugarNumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
                if ((result *= radix) < limit + digit) {
                    throw DesugarNumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
                ++i;
                result -= digit;
            }
            return negative ? result : -result;
        }
        throw DesugarNumberFormatException.forInputString("");
    }

    public static int parseUnsignedInt(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 5 || radix == 10 && len <= 9) {
                return Integer.parseInt(s, radix);
            }
            long ell = Long.parseLong(s, radix);
            if ((ell & 0xFFFFFFFF00000000L) == 0L) {
                return (int)ell;
            }
            throw new NumberFormatException(String.format("String value %s exceeds range of unsigned int.", s));
        }
        throw DesugarNumberFormatException.forInputString(s);
    }

    public static int parseUnsignedInt(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        s = Objects.requireNonNull(s);
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        int start = beginIndex;
        int len = endIndex - beginIndex;
        if (len > 0) {
            char firstChar = s.charAt(start);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 5 || radix == 10 && len <= 9) {
                return Integer.parseInt(s, start, start + len, radix);
            }
            long ell = Long.parseLong(s, start, start + len, radix);
            if ((ell & 0xFFFFFFFF00000000L) == 0L) {
                return (int)ell;
            }
            throw new NumberFormatException(String.format("String value %s exceeds range of unsigned int.", s));
        }
        throw new NumberFormatException("");
    }

    public static int parseUnsignedInt(String s) throws NumberFormatException {
        return Integer.parseUnsignedInt(s, 10);
    }

    public static int hashCode(int value) {
        return value;
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compareUnsigned(int x, int y) {
        return Integer.compare(x + Integer.MIN_VALUE, y + Integer.MIN_VALUE);
    }

    public static long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static int divideUnsigned(int dividend, int divisor) {
        return (int)(Integer.toUnsignedLong(dividend) / Integer.toUnsignedLong(divisor));
    }

    public static int remainderUnsigned(int dividend, int divisor) {
        return (int)(Integer.toUnsignedLong(dividend) % Integer.toUnsignedLong(divisor));
    }

    public static int sum(int a, int b) {
        return a + b;
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }
}

