/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ImmutableCollections;
import java.util.List;
import java.util.Set;

final class CollSer
implements Serializable {
    private static final long serialVersionUID = 6309168927139932177L;
    static final int IMM_LIST = 1;
    static final int IMM_SET = 2;
    static final int IMM_MAP = 3;
    private final int tag;
    private transient Object[] array;

    CollSer(int t, Object ... a) {
        this.tag = t;
        this.array = a;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        int len = ois.readInt();
        if (len < 0) {
            throw new InvalidObjectException("negative length " + len);
        }
        Object[] a = new Object[len];
        for (int i = 0; i < len; ++i) {
            a[i] = ois.readObject();
        }
        this.array = a;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.array.length);
        for (int i = 0; i < this.array.length; ++i) {
            oos.writeObject(this.array[i]);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            if (this.array == null) {
                throw new InvalidObjectException("null array");
            }
            switch (this.tag & 0xFF) {
                case 1: {
                    return List.of(this.array);
                }
                case 2: {
                    return Set.of(this.array);
                }
                case 3: {
                    if (this.array.length == 0) {
                        return ImmutableCollections.emptyMap();
                    }
                    if (this.array.length == 2) {
                        return new ImmutableCollections.Map1<Object, Object>(this.array[0], this.array[1]);
                    }
                    return new ImmutableCollections.MapN(this.array);
                }
            }
            throw new InvalidObjectException(String.format("invalid flags 0x%x", this.tag));
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            InvalidObjectException ioe = new InvalidObjectException("invalid object");
            ioe.initCause(ex);
            throw ioe;
        }
    }
}

