/*
 * Decompiled with CFR 0.152.
 */
package desugar.sun.nio.fs;

import desugar.sun.nio.fs.DesugarAbstractBasicFileAttributeView;
import desugar.sun.nio.fs.DesugarBasicFileAttributes;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;

class DesugarBasicFileAttributeView
extends DesugarAbstractBasicFileAttributeView {
    private final Path path;

    public DesugarBasicFileAttributeView(Path path) {
        this.path = path;
    }

    @Override
    public BasicFileAttributes readAttributes() throws IOException {
        this.path.getFileSystem().provider().checkAccess(this.path, new AccessMode[0]);
        return DesugarBasicFileAttributes.create(this.path.toFile());
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        File file = this.path.toFile();
        file.setLastModified(lastModifiedTime.to(TimeUnit.MILLISECONDS));
    }
}

