/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.zone.ZoneRules;
import java.util.Objects;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class DesugarLocalDate {
    public static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);
    private static final int SECONDS_PER_DAY = 86400;

    private DesugarLocalDate() {
    }

    public static Stream<LocalDate> datesUntil(LocalDate receiver, LocalDate endExclusive) {
        long start;
        long end = endExclusive.toEpochDay();
        if (end < (start = receiver.toEpochDay())) {
            throw new IllegalArgumentException(endExclusive + " < " + receiver);
        }
        return LongStream.range(start, end).mapToObj(LocalDate::ofEpochDay);
    }

    public static Stream<LocalDate> datesUntil(LocalDate receiver, LocalDate endExclusive, Period step) {
        long maxAddMonths;
        if (step.isZero()) {
            throw new IllegalArgumentException("step is zero");
        }
        long end = endExclusive.toEpochDay();
        long start = receiver.toEpochDay();
        long until = end - start;
        long months = step.toTotalMonths();
        long days = step.getDays();
        if (months < 0L && days > 0L || months > 0L && days < 0L) {
            throw new IllegalArgumentException("period months and days are of opposite sign");
        }
        if (until == 0L) {
            return Stream.empty();
        }
        int sign = months > 0L || days > 0L ? 1 : -1;
        if (sign < 0 ^ until < 0L) {
            throw new IllegalArgumentException(endExclusive + (sign < 0 ? " > " : " < ") + receiver);
        }
        if (months == 0L) {
            long steps = (until - (long)sign) / days;
            return LongStream.rangeClosed(0L, steps).mapToObj(n -> LocalDate.ofEpochDay(start + n * days));
        }
        long steps = until * 1600L / (months * 48699L + days * 1600L) + 1L;
        long addMonths = months * steps;
        long addDays = days * steps;
        long l = maxAddMonths = months > 0L ? DesugarLocalDate.getProlepticMonth(LocalDate.MAX) - DesugarLocalDate.getProlepticMonth(receiver) : DesugarLocalDate.getProlepticMonth(receiver) - DesugarLocalDate.getProlepticMonth(LocalDate.MIN);
        if (addMonths * (long)sign > maxAddMonths || (receiver.plusMonths(addMonths).toEpochDay() + addDays) * (long)sign >= end * (long)sign) {
            --steps;
            if ((addMonths -= months) * (long)sign > maxAddMonths || (receiver.plusMonths(addMonths).toEpochDay() + (addDays -= days)) * (long)sign >= end * (long)sign) {
                --steps;
            }
        }
        return LongStream.rangeClosed(0L, steps).mapToObj(n -> receiver.plusMonths(months * n).plusDays(days * n));
    }

    public static long toEpochSecond(LocalDate receiver, LocalTime time, ZoneOffset offset) {
        Objects.requireNonNull(time, "time");
        Objects.requireNonNull(offset, "offset");
        long secs = receiver.toEpochDay() * 86400L + (long)time.toSecondOfDay();
        return secs -= (long)offset.getTotalSeconds();
    }

    public static LocalDate ofInstant(Instant instant, ZoneId zone) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zone, "zone");
        ZoneRules rules = zone.getRules();
        ZoneOffset offset = rules.getOffset(instant);
        long localSecond = instant.getEpochSecond() + (long)offset.getTotalSeconds();
        long localEpochDay = Math.floorDiv(localSecond, 86400);
        return LocalDate.ofEpochDay(localEpochDay);
    }

    private static long getProlepticMonth(LocalDate receiver) {
        int year = receiver.getYear();
        int month = receiver.getMonthValue();
        return (long)year * 12L + (long)month - 1L;
    }
}

