/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;

public final class DesugarLocalTime {
    static final long NANOS_PER_SECOND = 1000000000L;
    static final int SECONDS_PER_DAY = 86400;

    private DesugarLocalTime() {
    }

    public static long toEpochSecond(LocalTime receiver, LocalDate date, ZoneOffset offset) {
        Objects.requireNonNull(date, "date");
        Objects.requireNonNull(offset, "offset");
        long epochDay = date.toEpochDay();
        long secs = epochDay * 86400L + (long)receiver.toSecondOfDay();
        return secs -= (long)offset.getTotalSeconds();
    }

    public static LocalTime ofInstant(Instant instant, ZoneId zone) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zone, "zone");
        ZoneOffset offset = zone.getRules().getOffset(instant);
        long localSecond = instant.getEpochSecond() + (long)offset.getTotalSeconds();
        int secsOfDay = Math.floorMod(localSecond, 86400);
        return LocalTime.ofNanoOfDay((long)secsOfDay * 1000000000L + (long)instant.getNano());
    }
}

