/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.DoubleByte;
import sun.nio.cs.EUC_JP;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.JIS_X_0201;
import sun.nio.cs.JIS_X_0208_Solaris;
import sun.nio.cs.JIS_X_0212_Solaris;
import sun.nio.cs.StandardCharsets;

public class EUC_JP_Open
extends Charset
implements HistoricallyNamedCharset {
    public EUC_JP_Open() {
        super("x-eucJP-Open", StandardCharsets.aliases_EUC_JP_Open());
    }

    @Override
    public String historicalName() {
        return "EUC_JP_Solaris";
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof JIS_X_0201 || cs instanceof EUC_JP;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends EUC_JP.Encoder {
        private static DoubleByte.Encoder ENC0208_Solaris = (DoubleByte.Encoder)new JIS_X_0208_Solaris().newEncoder();
        private static DoubleByte.Encoder ENC0212_Solaris = (DoubleByte.Encoder)new JIS_X_0212_Solaris().newEncoder();

        private Encoder(Charset cs) {
            super(cs);
        }

        @Override
        protected int encodeDouble(char ch) {
            int b = super.encodeDouble(ch);
            if (b != 65533) {
                return b;
            }
            b = ENC0208_Solaris.encodeChar(ch);
            if (b != 65533 && b > 29952) {
                return 0x8F8080 + ENC0212_Solaris.encodeChar(ch);
            }
            return b == 65533 ? b : b + 32896;
        }
    }

    private static class Decoder
    extends EUC_JP.Decoder {
        private static DoubleByte.Decoder DEC0208_Solaris = (DoubleByte.Decoder)new JIS_X_0208_Solaris().newDecoder();
        private static DoubleByte.Decoder DEC0212_Solaris = (DoubleByte.Decoder)new JIS_X_0212_Solaris().newDecoder();

        private Decoder(Charset cs) {
            super(cs, 0.5f, 1.0f, DEC0201, DEC0208, DEC0212_Solaris);
        }

        @Override
        protected char decodeDouble(int byte1, int byte2) {
            char c = super.decodeDouble(byte1, byte2);
            if (c == '\ufffd') {
                return DEC0208_Solaris.decodeDouble(byte1 - 128, byte2 - 128);
            }
            return c;
        }
    }
}

