/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.CopyOption;
import java.nio.file.OpenOption;
import java.nio.file.WatchEvent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ExtendedOptions {
    private static final Map<InternalOption<?>, Wrapper<?>> internalToExternal = new ConcurrentHashMap();
    public static final InternalOption<Void> INTERRUPTIBLE = new InternalOption();
    public static final InternalOption<Void> NOSHARE_READ = new InternalOption();
    public static final InternalOption<Void> NOSHARE_WRITE = new InternalOption();
    public static final InternalOption<Void> NOSHARE_DELETE = new InternalOption();
    public static final InternalOption<Void> FILE_TREE = new InternalOption();
    public static final InternalOption<Void> DIRECT = new InternalOption();
    public static final InternalOption<Integer> SENSITIVITY_HIGH = new InternalOption();
    public static final InternalOption<Integer> SENSITIVITY_MEDIUM = new InternalOption();
    public static final InternalOption<Integer> SENSITIVITY_LOW = new InternalOption();

    public static final class InternalOption<T> {
        InternalOption() {
        }

        private void registerInternal(Object option, T param) {
            Wrapper<T> wrapper = new Wrapper<T>(option, param);
            internalToExternal.put(this, wrapper);
        }

        public void register(OpenOption option) {
            this.registerInternal(option, null);
        }

        public void register(CopyOption option) {
            this.registerInternal(option, null);
        }

        public void register(WatchEvent.Modifier option) {
            this.registerInternal(option, null);
        }

        public void register(WatchEvent.Modifier option, T param) {
            this.registerInternal(option, param);
        }

        public boolean matches(Object option) {
            Wrapper<?> wrapper = internalToExternal.get(this);
            if (wrapper == null) {
                return false;
            }
            return option == wrapper.option;
        }

        public T parameter() {
            Wrapper<?> wrapper = internalToExternal.get(this);
            if (wrapper == null) {
                return null;
            }
            return (T)wrapper.parameter();
        }
    }

    private static final class Wrapper<T> {
        private final Object option;
        private final T param;

        Wrapper(Object option, T param) {
            this.option = option;
            this.param = param;
        }

        T parameter() {
            return this.param;
        }
    }
}

