/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.Usage;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PlainTextMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.config.Services;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 #*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0006J'\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r\u00a2\u0006\u0002\u0010\u000eJ5\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0004\u00a2\u0006\u0002\u0010\u0013J#\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J%\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0019\u001a\u00020\rH&J#\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ'\u0010\u001d\u001a\u00020\u001b\"\b\b\u0001\u0010\u0001*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u0001H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/cli/common/CLITool;", "A", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;", "", "()V", "createArguments", "()Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;", "exec", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "errStream", "Ljava/io/PrintStream;", "args", "", "", "(Ljava/io/PrintStream;[Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "services", "Lorg/jetbrains/kotlin/config/Services;", "messageRenderer", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "(Ljava/io/PrintStream;Lorg/jetbrains/kotlin/config/Services;Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;[Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "arguments", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/config/Services;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "execImpl", "executableScriptFileName", "parseArguments", "", "([Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)V", "printVersionIfNeeded", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)V", "reportArgumentParseProblems", "collector", "errors", "Lorg/jetbrains/kotlin/cli/common/arguments/ArgumentParseErrors;", "Companion", "cli"})
public abstract class CLITool<A extends CommonToolArguments> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ExitCode exec(@NotNull PrintStream errStream, String ... args) {
        Intrinsics.checkParameterIsNotNull((Object)errStream, (String)"errStream");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        MessageRenderer messageRenderer = MessageRenderer.PLAIN_RELATIVE_PATHS;
        Intrinsics.checkExpressionValueIsNotNull((Object)messageRenderer, (String)"MessageRenderer.PLAIN_RELATIVE_PATHS");
        return this.exec(errStream, Services.EMPTY, messageRenderer, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final ExitCode exec(@NotNull PrintStream errStream, @NotNull Services services, @NotNull MessageRenderer messageRenderer, @NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)errStream, (String)"errStream");
        Intrinsics.checkParameterIsNotNull((Object)services, (String)"services");
        Intrinsics.checkParameterIsNotNull((Object)messageRenderer, (String)"messageRenderer");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        K2JVMCompiler.Companion.resetInitStartTime();
        A arguments2 = this.createArguments();
        ParseCommandLineArgumentsKt.parseCommandLineArguments(ArraysKt.asList((Object[])args), arguments2);
        PrintingMessageCollector collector2 = new PrintingMessageCollector(errStream, messageRenderer, ((CommonToolArguments)arguments2).getVerbose());
        try {
            if (PlainTextMessageRenderer.COLOR_ENABLED) {
                AnsiConsole.systemInstall();
            }
            errStream.print(messageRenderer.renderPreamble());
            String errorMessage = ParseCommandLineArgumentsKt.validateArguments(((CommonToolArguments)arguments2).getErrors());
            if (errorMessage != null) {
                collector2.report(CompilerMessageSeverity.ERROR, errorMessage, null);
                collector2.report(CompilerMessageSeverity.INFO, "Use -help for more information", null);
                ExitCode exitCode2 = ExitCode.COMPILATION_ERROR;
                return exitCode2;
            }
            if (((CommonToolArguments)arguments2).getHelp() || ((CommonToolArguments)arguments2).getExtraHelp()) {
                errStream.print(messageRenderer.renderUsage(Usage.render(this, arguments2)));
                ExitCode exitCode3 = ExitCode.OK;
                return exitCode3;
            }
            ExitCode exitCode4 = this.exec(collector2, services, arguments2);
            return exitCode4;
        }
        finally {
            errStream.print(messageRenderer.renderConclusion());
            if (PlainTextMessageRenderer.COLOR_ENABLED) {
                AnsiConsole.systemUninstall();
            }
        }
    }

    @NotNull
    public final ExitCode exec(@NotNull MessageCollector messageCollector2, @NotNull Services services, @NotNull A arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)messageCollector2, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)services, (String)"services");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        this.printVersionIfNeeded(messageCollector2, arguments2);
        MessageCollector fixedMessageCollector = ((CommonToolArguments)arguments2).getSuppressWarnings() && !((CommonToolArguments)arguments2).getAllWarningsAsErrors() ? (MessageCollector)new FilteringMessageCollector(messageCollector2, Predicate.isEqual((Object)CompilerMessageSeverity.WARNING)) : messageCollector2;
        this.reportArgumentParseProblems(fixedMessageCollector, ((CommonToolArguments)arguments2).getErrors());
        return this.execImpl(fixedMessageCollector, services, arguments2);
    }

    @NotNull
    protected abstract ExitCode execImpl(@NotNull MessageCollector var1, @NotNull Services var2, @NotNull A var3);

    @NotNull
    public abstract A createArguments();

    public final void parseArguments(@NotNull String[] args, @NotNull A arguments2) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        ParseCommandLineArgumentsKt.parseCommandLineArguments(ArraysKt.asList((Object[])args), arguments2);
        String message = ParseCommandLineArgumentsKt.validateArguments(((CommonToolArguments)arguments2).getErrors());
        if (message != null) {
            throw (Throwable)new IllegalArgumentException(message);
        }
    }

    private final void reportArgumentParseProblems(MessageCollector collector2, ArgumentParseErrors errors) {
        Object key;
        Map.Entry entry;
        Map.Entry entry2;
        for (String flag : errors.getUnknownExtraFlags()) {
            MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.STRONG_WARNING, "Flag is not supported by this version of the compiler: " + flag, null, 4, null);
        }
        for (String argument : errors.getExtraArgumentsPassedInObsoleteForm()) {
            MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.STRONG_WARNING, "Advanced option value is passed in an obsolete form. Please use the '=' character " + "to specify the value: " + argument + "=...", null, 4, null);
        }
        Map<String, String> map2 = errors.getDuplicateArguments();
        Iterator<Object> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = entry2 = (Map.Entry)iterator2.next();
            key = (String)entry.getKey();
            entry = entry2;
            String value = (String)entry.getValue();
            MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.STRONG_WARNING, "Argument " + (String)key + " is passed multiple times. Only the last value will be used: " + value, null, 4, null);
        }
        key = errors.getDeprecatedArguments();
        iterator2 = key.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = entry2 = (Map.Entry)iterator2.next();
            String deprecatedName = (String)entry.getKey();
            entry = entry2;
            String newName2 = (String)entry.getValue();
            MessageCollector.DefaultImpls.report$default(collector2, CompilerMessageSeverity.STRONG_WARNING, "Argument " + deprecatedName + " is deprecated. Please use " + newName2 + " instead", null, 4, null);
        }
    }

    private final <A extends CommonToolArguments> void printVersionIfNeeded(MessageCollector messageCollector2, A arguments2) {
        if (arguments2.getVersion()) {
            String jreVersion = System.getProperty("java.runtime.version");
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "" + this.executableScriptFileName() + " @snapshot@ (JRE " + jreVersion + ')', null, 4, null);
        }
    }

    @NotNull
    public abstract String executableScriptFileName();

    @JvmStatic
    public static final void doMain(@NotNull CLITool<?> compiler, @NotNull String[] args) {
        Companion.doMain(compiler, args);
    }

    @JvmStatic
    @NotNull
    public static final ExitCode doMainNoExit(@NotNull CLITool<?> compiler, @NotNull String[] args) {
        return Companion.doMainNoExit(compiler, args);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u0010\nJ'\u0010\u000b\u001a\u00020\f2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/cli/common/CLITool$Companion;", "", "()V", "doMain", "", "compiler", "Lorg/jetbrains/kotlin/cli/common/CLITool;", "args", "", "", "(Lorg/jetbrains/kotlin/cli/common/CLITool;[Ljava/lang/String;)V", "doMainNoExit", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "(Lorg/jetbrains/kotlin/cli/common/CLITool;[Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "cli"})
    public static final class Companion {
        @JvmStatic
        public final void doMain(@NotNull CLITool<?> compiler, @NotNull String[] args) {
            ExitCode exitCode2;
            Intrinsics.checkParameterIsNotNull(compiler, (String)"compiler");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            if (System.getProperty("java.awt.headless") == null) {
                System.setProperty("java.awt.headless", "true");
            }
            if (System.getProperty("kotlin.colors.enabled") == null) {
                System.setProperty("kotlin.colors.enabled", "true");
            }
            if (Intrinsics.areEqual((Object)((Object)(exitCode2 = this.doMainNoExit(compiler, args))), (Object)((Object)ExitCode.OK)) ^ true) {
                System.exit(exitCode2.getCode());
            }
        }

        @JvmStatic
        @NotNull
        public final ExitCode doMainNoExit(@NotNull CLITool<?> compiler, @NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull(compiler, (String)"compiler");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            try {
                PrintStream printStream = System.err;
                Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.err");
                return compiler.exec(printStream, Arrays.copyOf(args, args.length));
            }
            catch (CompileEnvironmentException e) {
                System.err.println(e.getMessage());
                return ExitCode.INTERNAL_ERROR;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

