/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.utils.Jsr305State;
import org.jetbrains.kotlin.utils.ReportLevel;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/cli/common/arguments/Jsr305Parser;", "", "collector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "parse", "Lorg/jetbrains/kotlin/utils/Jsr305State;", "value", "", "", "([Ljava/lang/String;)Lorg/jetbrains/kotlin/utils/Jsr305State;", "parseJsr305UserDefined", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/utils/ReportLevel;", "item", "reportDuplicateJsr305", "", "first", "second", "reportUnrecognizedJsr305", "cli-common"})
public final class Jsr305Parser {
    private final MessageCollector collector;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Jsr305State parse(@Nullable String[] value) {
        ReportLevel reportLevel;
        ReportLevel global = null;
        ReportLevel migration = null;
        Map userDefined = new LinkedHashMap();
        Function1<String, ReportLevel> parseJsr305UnderMigration$ = new Function1<String, ReportLevel>(this){
            final /* synthetic */ Jsr305Parser this$0;

            @Nullable
            public final ReportLevel invoke(@NotNull String item) {
                List<E> list2;
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                List<E> it = list2 = StringsKt.split$default((CharSequence)item, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                List<E> list3 = it.size() == 2 ? list2 : null;
                String rawState = list3 != null ? (String)list3.get(1) : null;
                ReportLevel reportLevel = ReportLevel.Companion.findByDescription(rawState);
                if (reportLevel == null) {
                    Jsr305Parser.access$reportUnrecognizedJsr305(this.this$0, item);
                    it = list2 = Unit.INSTANCE;
                    reportLevel = null;
                }
                return reportLevel;
            }
            {
                this.this$0 = jsr305Parser;
                super(1);
            }
        };
        if (value != null) {
            for (Object element$iv : (Object[])value) {
                String item = (String)element$iv;
                if (StringsKt.startsWith$default((String)item, (String)"@", (boolean)false, (int)2, null)) {
                    void name;
                    Pair<String, ReportLevel> pair;
                    if (this.parseJsr305UserDefined(item) == null) {
                        continue;
                    }
                    String string = (String)pair.component1();
                    ReportLevel state2 = (ReportLevel)((Object)pair.component2());
                    ReportLevel current = (ReportLevel)((Object)userDefined.get(name));
                    if (current != null) {
                        this.reportDuplicateJsr305('@' + (String)name + ':' + current.getDescription(), item);
                        continue;
                    }
                    Map map2 = userDefined;
                    ReportLevel reportLevel2 = state2;
                    map2.put(name, reportLevel2);
                    continue;
                }
                if (StringsKt.startsWith$default((String)item, (String)"under-migration", (boolean)false, (int)2, null)) {
                    if (migration != null) {
                        ReportLevel reportLevel3 = migration;
                        this.reportDuplicateJsr305("under-migration:" + (reportLevel3 != null ? reportLevel3.getDescription() : null), item);
                        continue;
                    }
                    migration = parseJsr305UnderMigration$.invoke(item);
                    continue;
                }
                if (Intrinsics.areEqual((Object)item, (Object)"enable")) {
                    MessageCollector.DefaultImpls.report$default(this.collector, CompilerMessageSeverity.STRONG_WARNING, "Option 'enable' for -Xjsr305 flag is deprecated. Please use 'strict' instead", null, 4, null);
                    if (global != null) continue;
                    global = ReportLevel.STRICT;
                    continue;
                }
                if (global != null) {
                    ReportLevel reportLevel4 = global;
                    if (reportLevel4 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.reportDuplicateJsr305(reportLevel4.getDescription(), item);
                    continue;
                }
                global = ReportLevel.Companion.findByDescription(item);
            }
        }
        if ((reportLevel = global) == null) {
            reportLevel = ReportLevel.WARN;
        }
        Jsr305State state3 = new Jsr305State(reportLevel, migration, userDefined);
        return Intrinsics.areEqual((Object)state3, (Object)Jsr305State.DISABLED) ? Jsr305State.DISABLED : state3;
    }

    private final void reportUnrecognizedJsr305(String item) {
        MessageCollector.DefaultImpls.report$default(this.collector, CompilerMessageSeverity.ERROR, "Unrecognized -Xjsr305 value: " + item, null, 4, null);
    }

    private final void reportDuplicateJsr305(String first, String second) {
        MessageCollector.DefaultImpls.report$default(this.collector, CompilerMessageSeverity.ERROR, "Conflict duplicating -Xjsr305 value: " + first + ", " + second, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, ReportLevel> parseJsr305UserDefined(String item) {
        void name;
        Object object;
        Jsr305Parser $receiver;
        Object object2 = item;
        int n = 1;
        String string = object2;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        Object it = object2 = StringsKt.split$default((CharSequence)string2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        Object object3 = it.size() == 2 ? object2 : null;
        if (object3 == null) {
            object2 = this;
            $receiver = (Jsr305Parser)object2;
            $receiver.reportUnrecognizedJsr305(item);
            return null;
        }
        object2 = object = object3;
        String string3 = (String)object2.get(0);
        object2 = object;
        String rawState = (String)object2.get(1);
        ReportLevel reportLevel = ReportLevel.Companion.findByDescription(rawState);
        if (reportLevel == null) {
            object2 = this;
            $receiver = (Jsr305Parser)object2;
            $receiver.reportUnrecognizedJsr305(item);
            return null;
        }
        ReportLevel state2 = reportLevel;
        return TuplesKt.to((Object)name, (Object)((Object)state2));
    }

    public Jsr305Parser(@NotNull MessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        this.collector = collector2;
    }

    public static final /* synthetic */ void access$reportUnrecognizedJsr305(Jsr305Parser $this, @NotNull String item) {
        $this.reportUnrecognizedJsr305(item);
    }
}

